/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.Utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Scanner;

public class Preferences {
	public static String readImgPath = ".";
	public static String writeImgPath = ".";
	public static String writeNewickPath = ".";
	public static String writeSnapshotPath = ".";
	public static String readSnapshotPath = ".";
	public static String programPath;
	public static String tempPath;
	public static String protocolPath;
	public static String snapshotPath;
	public static URL prefsURL, fontURL;
	public static final String prefsFileName = "tsPrefs.txt";
	public static File fontFile;
	private static File prefs;

	public Preferences() throws IOException {
		programPath = new File(".").getAbsolutePath();
		protocolPath = programPath + File.separator + "protocol";
		snapshotPath = programPath + File.separator + "snapshot";

		fontURL = Preferences.class.getResource("/Helvetica.dfont");
		fontFile = new File(fontURL.getFile());
		System.out
				.println("File " + fontFile + " exists: " + fontFile.exists());

		boolean fileCreated = createPrefs();
		if (!fileCreated) {
			// Read preferences file
			boolean success = readPrefs();
			if (success)
				System.out.println("Successfully read the preferences file");
			else
				System.out.println("Could not read the Preferences text file");
		} else
			System.out.println("Preferences file created");

		// If directory "/protocol" does not exist, create it
		if (!new File(protocolPath).exists()) {
			// Create one directory
			try {
				new File(protocolPath).mkdir();
				System.out.println("Created directory /protocol");
			} catch (Exception e) {
				System.out.println("Could not create directory /protocol");
			}
		} else
			System.out.println("Directory /protocol exists");

		// If directory "/snapshot" does not exist, create it
		if (!new File(snapshotPath).exists()) {
			// Create one directory
			try {
				new File(snapshotPath).mkdir();
				System.out.println("Created directory /snapshot");
			} catch (Exception e) {
				System.out.println("Could not create directory /snapshot");
			}
		} else
			System.out.println("Directory /snapshot exists");
	}

	private static boolean createPrefs() {
		prefs = new File(programPath + File.separator + prefsFileName);
		if (prefs.exists()) {
			return false;
		} else // Create Preferences file
		{
			try {
				boolean success = writePrefs();
				if (!success) {
					System.out
							.println("Could not write the Preferences text file");
					return false;
				} else
					return true;
			} catch (Exception e) {
				System.out.println("Could not write the Preferences text file");
				return false;
			}
		}
	}

	public static boolean readPrefs() {
		String readImgPathLine;
		String writeImgPathLine;
		String writeNewickPathLine;
		String readSnapshotPathLine;
		String writeSnapshotPathLine;
		String temp;

		try {
			BufferedReader input = new BufferedReader(new FileReader(prefs));
			input.readLine(); // Skip the first line
			readImgPathLine = input.readLine();
			readSnapshotPathLine = input.readLine();
			writeImgPathLine = input.readLine();
			writeNewickPathLine = input.readLine();
			writeSnapshotPathLine = input.readLine();
			input.close();

			// Consume the text
			Scanner s = new Scanner(readImgPathLine).useDelimiter("\\s*#\\s*");
			s.next();
			temp = s.next();
			if (new File(temp).exists())
				readImgPath = temp; // Does temp represent a valid directory?

			s = new Scanner(readSnapshotPathLine).useDelimiter("\\s*#\\s*");
			s.next();
			temp = s.next();
			if (new File(temp).exists())
				readSnapshotPath = temp; // Does temp represent a valid
			// directory?

			s = new Scanner(writeImgPathLine).useDelimiter("\\s*#\\s*");
			s.next();
			temp = s.next();
			if (new File(temp).exists())
				writeImgPath = temp;

			s = new Scanner(writeNewickPathLine).useDelimiter("\\s*#\\s*");
			s.next();
			temp = s.next();

			s = new Scanner(writeNewickPathLine).useDelimiter("\\s*#\\s*");
			if (new File(temp).exists())
				writeNewickPath = temp;
			s.next();
			temp = s.next();

			s = new Scanner(writeSnapshotPathLine).useDelimiter("\\s*#\\s*");
			if (new File(temp).exists())
				writeSnapshotPath = temp;
			s.close();
		} catch (FileNotFoundException e) {
			return false;
		} catch (IOException e) {
			return false;
		}
		return true;
	}

	public static boolean writePrefs() {

		try {
			BufferedWriter output = new BufferedWriter(new FileWriter(prefs));
			output.write("TreeSnatcher Preferences");
			output.newLine();
			output.write("ReadImagePath" + " # " + readImgPath);
			output.newLine();
			output.write("ReadSnapshotPath" + " # " + readSnapshotPath);
			output.newLine();
			output.write("WriteImagePath" + " # " + writeImgPath);
			output.newLine();
			output.write("WriteNewickPath" + " # " + writeNewickPath);
			output.newLine();
			output.write("WriteSnapshotPath" + " # " + writeSnapshotPath);
			output.close();
		} catch (FileNotFoundException e) {
			return false;
		} catch (IOException e) {
			return false;
		}
		return true;
	}
}
