/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.Utils;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

import TreeSnatcher.Core.Branch;

public class NumberUtility {
	private static NumberFormat numberFormat;

	public NumberUtility() {
		numberFormat = NumberFormat.getInstance(Locale.US);
		numberFormat.setMaximumFractionDigits(0);
		numberFormat.setMinimumFractionDigits(0);
		numberFormat.setGroupingUsed(false);
	}

	public static int getNumFractionDigits(double number) {
		String s = ((Double) number).toString();
		if (Math.rint(number) == number)
			return 0;
		else
			return s.substring(
					s.lastIndexOf(DecimalFormatSymbols.getInstance()
							.getDecimalSeparator()) + 1).length();
	}

	public static void setNumFractionDigits(double number) {
		int n = getNumFractionDigits(number);
		setNumFractionDigits(n);
	}

	// Get the maximum number of fractional digits needed to represent all
	// branch lengths
	// in Collection br
	// Set it as the current number of fractional digits for all numbers
	public static void setNumFractionDigits(Vector<Branch> br) {
		Iterator<Branch> it = br.iterator();
		int maxNumFractionDigits = Integer.MIN_VALUE;

		while (it.hasNext()) {
			Branch b = it.next();
			double l = b.getLength();

			int numFractionDigits = getNumFractionDigits(l);
			if (numFractionDigits > maxNumFractionDigits) {
				maxNumFractionDigits = numFractionDigits;
			}
		}
		setNumFractionDigits(maxNumFractionDigits);
	}

	public static void setNumFractionDigits(int n) {
		numberFormat.setMinimumFractionDigits(n);
		numberFormat.setMaximumFractionDigits(n);
	}

	public static void setMaxNumFractionDigits(int n) {
		numberFormat.setMaximumFractionDigits(n);
	}

	public static NumberFormat getCurrentNumberFormat() {
		return numberFormat;
	}

	public static void setDefaultNumberFormat() {
		if (numberFormat != null) {
			numberFormat.setMaximumFractionDigits(0);
			numberFormat.setMinimumFractionDigits(0);
		}
	}
}
