/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.Utils;

// Class ImageSaver// Stores a BufferedImage

import javax.swing.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;

import TreeSnatcher.GUI.Wizard;

class ImageSaver {
	public ImageSaver(BufferedImage image, File output) {
		try {
			ImageIO.write(image, "PNG", output);
			Wizard.undoHistoryEmptyAfterLastSave = true;
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null,
					"An error occurred while writing the image file.\nError: "
							+ e.getMessage());
		} finally {
		}
	}
}