/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.Utils;

// Class ImageLoader
// Enables loading of image files in various formats

import javax.swing.*;

import TreeSnatcher.GUI.Wizard;

import java.awt.*;
import java.awt.image.*;

public class ImageLoader {
	private static int imageType = BufferedImage.TYPE_INT_RGB;
	private static int id;
	private static final Component sComponent = new Component() {
		private static final long serialVersionUID = 1L;
	};
	private static final MediaTracker sTracker = new MediaTracker(sComponent);
	private static int sID = 0;

	public static BufferedImage getImage(String path) {
		try {
			Image image = new ImageIcon(path).getImage();
			synchronized (sComponent) {
				id = sID++;
			}
			sTracker.addImage(image, id);
			try {
				sTracker.waitForID(id);
			} catch (InterruptedException ie) {
			}
			if (sTracker.isErrorID(id))
				image = null;
			BufferedImage bufferedImage = new BufferedImage(image
					.getWidth(null), image.getHeight(null), imageType);
			Graphics2D g2 = bufferedImage.createGraphics();
			g2.drawImage(image, null, null);
			image = null;
			path = null;

			Wizard.undoHistoryEmptyAfterLastSave = true;

			return bufferedImage;
		} catch (Exception e) {

		}

		return null;
	}
}