package TreeSnatcher.Utils;

// from the German book "JAVA ist auch eine Insel"

import java.io.File;
import javax.swing.filechooser.*;

public class ImageFilter extends FileFilter {

	// Accept all directories and all gif, jpg, tiff, or png files.
	public boolean accept(File f) {
		if (f.isDirectory()) {
			return true;
		}

		String extension = getExtension(f);
		if (extension != null) {
			if (extension.equals("tiff") || extension.equals("tif")
					|| extension.equals("gif") || extension.equals("jpeg")
					|| extension.equals("jpg") || extension.equals("png")) {
				return true;
			} else {
				return false;
			}
		}

		return false;
	}

	// The description of this filter
	public String getDescription() {
		return "Image types TIF, GIF, JPG, PNG";
	}

	/*
	 * Get the extension of a file.
	 */
	public String getExtension(File f) {
		String ext = null;
		String s = f.getName();
		int i = s.lastIndexOf('.');

		if (i > 0 && i < s.length() - 1) {
			ext = s.substring(i + 1).toLowerCase();
		}
		return ext;
	}
}