package TreeSnatcher.Utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

/* 
 Taken from the book "Swing Hacks by Chris Adamson, Joshua Marinacci
 Publisher: O'Reilly
 Pub Date: June 2005
 ISBN: 0-596-00907-0
 Pages: 542
 */

public class ImageFileChooser extends JPanel implements PropertyChangeListener {
	private static final long serialVersionUID = 1L;
	private JFileChooser jfc;
	private Image img;

	public ImageFileChooser(JFileChooser jfc) {
		this.jfc = jfc;
		Dimension sz = new Dimension(200, 200);
		setPreferredSize(sz);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		try {
			File file = jfc.getSelectedFile();
			updateImage(file);
		} catch (IOException ex) {
			// System.out.println(ex.getMessage());
			// ex.printStackTrace();
		}
	}

	public void updateImage(File file) throws IOException {
		if (file == null) {
			return;
		}
		img = ImageLoader.getImage(file.getPath());
		repaint();
	}

	public void paintComponent(Graphics g) {
		// fill the background
		g.setColor(Color.gray);
		g.fillRect(0, 0, getWidth(), getHeight());

		if (img != null) {
			// calculate the scaling factor
			int w = img.getWidth(null);
			int h = img.getHeight(null);
			int side = Math.max(w, h);
			double scale = 200.0 / (double) side;
			w = (int) (scale * (double) w);
			h = (int) (scale * (double) h);
			// draw the image
			g.drawImage(img, 0, 0, w, h, null);

			// draw the image dimensions
			String dim = w + " x " + h;
			g.setColor(Color.black);
			g.drawString(dim, 31, 196);
			g.setColor(Color.white);
			g.drawString(dim, 30, 195);
		} else {
			// print a message
			g.setColor(Color.black);
			g.drawString("Not an image", 30, 100);
		}
	}

	public static void main(String[] args) {
		JFileChooser jfc = new JFileChooser();
		ImageFileChooser preview = new ImageFileChooser(jfc);
		jfc.addPropertyChangeListener(preview);
		jfc.setAccessory(preview);
		jfc.showOpenDialog(null);
	}

}
