/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Shape;

import java.util.HashSet;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import TreeSnatcher.Core.Constants;
import TreeSnatcher.Core.MainWindow;

// Wizard guides the user through a defined number of program steps
// and activates or deactivates the controls for any program step
public class Wizard implements Constants {
	private static final long serialVersionUID = 1L;
	private JPanel panel;
	private JTextArea textArea;
	protected JPanel textPane;
	protected JLabel imageLabel;
	protected JFrame owner;
	protected JScrollPane scrollPane;
	protected GUIActions guiActions;

	public String programPath = null;
	public String imagePath = "";

	public boolean useWizard = false;
	public boolean markFloodSeed = false;
	public boolean smallMarks = false;
	public boolean imageLoaded = false;
	public boolean isBinarized = false;
	public boolean isSkeletonized = false;
	public boolean autoSkeletonize = true;
	public boolean autoFlood = true;
	public boolean autoClean = false;
	public boolean showSourceImageInMagnifier = false;
	public boolean imageCropped = false;
	public boolean floodedRegionExists = false; // Yes if at least one pixel is
	// colored in treeFloodColor
	public boolean highlightFGColorInMagnifier = false;
	public boolean floodFillPerformed = false;
	public boolean useFancyCursors = true;
	public boolean showAllBranches = true;
	public boolean useOneNodeMode = false;
	public boolean showTracedPaths = false;
	public boolean suppressTinyBranches = true;
	public boolean nodesStickToTree = true;
	public boolean floodedAreaExtracted = false;
	public boolean mayDiscardUserGeneratedObjects = true;
	public boolean blankImage = false; // Gets true as soon as the user selects
	// "New Image"; gets false as soon as
	// the user draws something
	public boolean drawBranchLength = false; // Draw the branch length onto each
	// branch
	public boolean drawTaxonName = true; // Draw the taxon name for each tip
	public boolean highlightBranchesWithoutLength = false;
	public boolean highlightTipsWithoutName = false;
	public boolean showResultFrame = false; // If true, the program displays the
	// Newick expression frame
	public boolean treeIsBifurcating = true;
	public boolean nodesCollected = false;
	public boolean branchesCollecting = false; // True during ongoing branch
	// collection
	public boolean selectionTrimmedToBoundaries = true;
	public boolean showColorBeneathMouse = false;
	public boolean topologyDeterminationFinished = false;
	public boolean allowNodesAnywhere = false;
	public boolean includeBranchLengths = true;
	public boolean ratioSliderEnabled = true;
	public boolean colorNewickString = true;
	public boolean useElaboratePathFinding = true; // Recommended: The path
	// finding algorithm is more
	// tolerant but consumes
	// more time
	public static boolean useUserAssignedLengths = false;
	public static boolean useCalculatedLengths = true;
	public static boolean useMixedLengths = false;
	public static boolean undoHistoryEmptyAfterLastSave = true;

	// Flags and variables for the color range manipulation dialog
	public boolean colReplace = true;
	public boolean colKeep = false;
	public boolean colExactColor = true;
	public boolean colSelectionColors = false;
	public int colNumSelectionColors;

	public float transparencyRatio = 1.0f;
	public int lookaheadDistance = defaultLookaheadDistance;
	public int userLookaheadDistance = lookaheadDistance;
	public int fgColorMagnifier = new Color(240, 220, 40).getRGB();
	public int treeFloodColor = new Color(0, 40, 200).getRGB();
	public int lastColorPicked = Color.white.getRGB();
	public int fromColor = Color.white.getRGB();
	public int toColor = Color.black.getRGB();
	public int localFillColor = Color.gray.getRGB();
	public Color pathColor;
	public int transparentShade = defaultTransparencyShade;
	public int threshold = defaultThreshold;
	public int kernelWidth = defaultKernelWidth;
	public int medianRectWidth = defaultMedianRectWidth;
	public int minMaxRectWidth = defaultMinMaxRectWidth;
	public int drawingStrokeWidth = defaultDrawingStrokeWidth;
	public int eraserStrokeWidth = defaultEraserStrokeWidth;
	public int usmKernelWidth = defaultUSMKernelWidth;
	public int brightnessOffset = defaultBrightnessOffset;
	public int autoCleanWidth = defaultAutoCleanWidth;
	public int ratioSliderValue = 10;
	public double contrastFactor = defaultContrastFactor;
	public double usmFactor = defaultUSMFactor;
	public double[] greyscaleFactors = defaultGreyscaleFactors;
	public int minRegionSize = defaultMinRegionSize;
	public int treePixels = 0; // Counts the number of pixels colored using
	// treeFloodColor
	public int topologyType = FREE;

	public static int scaleBarLengthInPixels = 0;
	public int referenceNodeId = -1;
	public int colorDistance = defaultColorDistance;
	public int quantNumColors = 16; // Number of different colors after color
	// quantization
	public int mostRecentTopologyError;
	public int tinyBranchLength = defaultTinyBranchLength;
	public static double manualScaleBarLength = 0.0d;
	public Point floodSeed; // The position from which the last flood fill was
	// initiated
	public Point latestTreeLocation; // A location on the tree that the user has
	// visited recently
	public Shape wholeImage;
	public HashSet<Integer> colorSet;
	public int floodedPixels = 0;
	public static int smallNodeRadius = defaultSmallNodeRadius;
	public static int referenceNodeRadius = defaultReferenceNodeRadius;

	public Wizard(MainWindow owner, JPanel panel, JScrollPane scrollPane) {
		this.owner = owner;
		this.panel = panel;
		panel.setBorder(BorderFactory.createLoweredBevelBorder());
		panel.setPreferredSize(new Dimension(800, 180));
		panel.setMinimumSize(this.getPreferredSize());
		panel.setMaximumSize(this.getPreferredSize());
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

		textArea = new JTextArea();
		textArea.setBorder(BorderFactory.createRaisedBevelBorder());
		textArea.setLineWrap(true);
		textArea.setWrapStyleWord(true);
		textArea.setEditable(false);
		textArea.setFont(new Font("Sans Serif", Font.PLAIN, 16));
		textArea.append("Welcome to the TreeSnatcher Wizard Dialog!\n\n");
		textArea
				.append("The Wizard protocols the actions you perform on the image.\n");
		textArea.append("It will guide you through the program on demand.");

		JPanel textPanel = new JPanel(new BorderLayout());
		JPanel buttonPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT, 4, 2));
		buttonPanel.setPreferredSize(new Dimension(800, 16));
		textArea.setPreferredSize(new Dimension(800, 200));
		JScrollPane textScrollPane = new JScrollPane(textArea);
		textScrollPane.setPreferredSize(new Dimension(800, 144));
		textPanel.add(textScrollPane, BorderLayout.NORTH);
		JButton next = new JButton("Next");
		JButton previous = new JButton("Tour");
		next.setMaximumSize(new Dimension(80, 12));
		previous.setMaximumSize(new Dimension(80, 12));

		textPanel.add(buttonPanel, BorderLayout.CENTER);
		panel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
		panel.add(textPanel);
		textScrollPane.setCursor(new Cursor(Cursor.HAND_CURSOR));
		panel.invalidate();

	}

	public void respondToUser(int action, int mode) {
	}

	// --------------------------------------------------------------------------------------------------

	public void inactivate() {
		panel.setVisible(false);
	}

	public void reactivate() {
		panel.setVisible(true);
	}

	public JPanel getPanel() {
		return this.panel;
	};

	public void setGUIActions(GUIActions guiActions) {
		this.guiActions = guiActions;
	};

	public Dimension getPreferredSize() {
		return new Dimension(800, 180);
	}

	public void reset() {
		useWizard = false;
		showAllBranches = true;
		showTracedPaths = false;
		useOneNodeMode = false;
		isBinarized = false;
		isSkeletonized = false;
		imageCropped = false;
		floodedRegionExists = false;
		floodFillPerformed = false;
		imageCropped = false;
		floodedRegionExists = false;
		floodFillPerformed = false;
		floodedAreaExtracted = false;
		topologyDeterminationFinished = false;
		highlightBranchesWithoutLength = false;
		highlightTipsWithoutName = false;
		treePixels = 0;
		topologyType = FREE;
		referenceNodeId = -1;
		floodSeed = null;
		latestTreeLocation = null;
		lookaheadDistance = defaultLookaheadDistance;
		userLookaheadDistance = lookaheadDistance;
	}

	public void setObjectReferences(GUIActions ga) {
		this.guiActions = ga;
	}
}
