/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.image.BufferedImage;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusBar {
	private JLabel messageLabel, coordsLabel;
	private String formerMessage = "";

	public StatusBar(JFrame owner, JPanel panel) {
		coordsLabel = new JLabel("");
		coordsLabel.setFont(new Font("Arial", Font.PLAIN, 12));
		coordsLabel.setForeground(Color.black);
		coordsLabel.setVerticalTextPosition(JLabel.BOTTOM);
		coordsLabel.setHorizontalTextPosition(JLabel.LEADING);
		coordsLabel.setMinimumSize(new Dimension(285, 20));
		coordsLabel.setMaximumSize(new Dimension(285, 20));
		coordsLabel.setBorder(BorderFactory.createEtchedBorder());

		messageLabel = new JLabel("Ready");
		messageLabel.setForeground(Color.red.darker());
		messageLabel.setVerticalTextPosition(JLabel.BOTTOM);
		messageLabel.setHorizontalTextPosition(JLabel.LEADING);
		messageLabel.setMinimumSize(new Dimension(panel.getWidth()
				- coordsLabel.getWidth() - 5, 20));
		messageLabel.setSize(new Dimension(panel.getWidth()
				- coordsLabel.getWidth() - 5, 20));
		messageLabel.setMinimumSize(new Dimension(panel.getWidth()
				- coordsLabel.getWidth() - 5, 20));
		messageLabel.setPreferredSize(new Dimension(panel.getWidth()
				- coordsLabel.getWidth() - 5, 20));
		messageLabel.setBorder(BorderFactory.createEtchedBorder());
		messageLabel.setFont(new Font("Arial", Font.PLAIN, 12));

		panel.setBorder(BorderFactory.createLoweredBevelBorder());
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

		panel.add(coordsLabel);
		panel.add(Box.createRigidArea(new Dimension(5, 0)));
		panel.add(messageLabel);

		panel.setMinimumSize(new Dimension(panel.getWidth(), 24));
		panel.setPreferredSize(panel.getMinimumSize());
	}

	public void showMessage(String message, BufferedImage image, Point mc) {
		// Display first the component coordinates and the color in the image
		// that is beneath the mouse location
		// Then append the message
		String locStr = new String();
		if (image != null) {
			locStr = "Point (" + mc.x + ", " + mc.y + ")";
			Color c = null;
			try {
				c = new Color(image.getRGB(mc.x, mc.y));
			} catch (ArrayIndexOutOfBoundsException ea) {
			}
			;

			if (c != null)
				locStr += " has RGB-Color (" + c.getRed() + ", " + c.getGreen()
						+ ", " + c.getBlue() + ")";
			else
				locStr += " is outside the image";
		}

		if (locStr != null)
			coordsLabel.setText(locStr);
		if (message != "")
			messageLabel.setText(message);
		formerMessage = message;
	}

	public void reset() {
		showMessage("", null, null);
	}
}
