/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import TreeSnatcher.Utils.Preferences;

public class ReadMePanel extends JFrame {
	private static final long serialVersionUID = 1L;

	public ReadMePanel() {
		BufferedReader in = null;
		Vector<String> text = new Vector<String>();
		;
		String path = Preferences.programPath + File.separator + "tsReadme.txt";
		String s = "";

		File manualFile = new File(path);
		if (manualFile.exists()) {
			try // Stream the content of the text file into Vector text
			{
				in = new BufferedReader(new InputStreamReader(
						new FileInputStream(manualFile)));
				while (null != (s = in.readLine()))
					text.add(s);
			} catch (FileNotFoundException ex) {
			} catch (IOException ix) {
			}
			;
		}

		JTextArea textArea = new JTextArea();
		textArea.setEditable(false);
		textArea.setFont(new Font("Serif", Font.PLAIN, 16));
		textArea.setLineWrap(true);
		textArea.setWrapStyleWord(true);

		if (text.size() < 2)
			textArea.append("Could not open file " + path);
		else {
			Iterator<String> textIt = text.iterator();
			while (textIt.hasNext())
				textArea.append(textIt.next() + "\n");
		}
		JScrollPane scrollPane = new JScrollPane(textArea);

		scrollPane.doLayout();
		this.setLayout(new BorderLayout(15, 15));
		this.add(scrollPane);
		this.setPreferredSize(new Dimension(800, 600));
		this.setSize(800, 600);
		this.setVisible(true);
		this.setAlwaysOnTop(true);
	}
}
