/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.Color;
import java.awt.Point;

public class Pixel {
	Point location;
	Color col;

	public Pixel(Point p, Color c) {
		this.location = p;
		this.col = c;
	}

	public Pixel(int x, int y, Color c) {
		this.location = new Point(x, y);
		this.col = c;
	}

	public Pixel(int x, int y, int color) {
		this.location = new Point(x, y);
		this.col = new Color(color);
	}

	public Pixel(int x, int y) {
		new Pixel(x, y, null);
	}

	public Pixel(Point p) {
		new Pixel(p, null);
	}

	public Point getLocation() {
		return location;
	};

	public int getX() {
		return location.x;
	};

	public int getY() {
		return location.y;
	};

	public Color getColor() {
		return col;
	};

	public int getRGB() {
		return col.getRGB();
	};

	public String toString() {
		String s = "\nPixel at (" + location.x + ", " + location.y + ")";
		if (col != null)
			s = s + " with RGB color (" + col.getRed() + ", " + col.getGreen()
					+ ", " + col.getBlue() + ")";
		return s;
	}
}
