/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.BorderLayout;
import java.awt.Dimension;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JEditorPane;
import javax.swing.JFrame;

import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LinksPanel extends JFrame implements HyperlinkListener {
	private static final long serialVersionUID = 1L;
	protected JEditorPane htmlPane = new JEditorPane();
	private URL linksURL;

	public LinksPanel() {
		try {
			linksURL = URL.class.getResource("/tutorialLinks.html");
			htmlPane.setPage(linksURL);
		} catch (MalformedURLException e) {
		} catch (IOException e) {
		}

		htmlPane.setEditable(false);
		htmlPane.setPreferredSize(new Dimension(1000, 800));
		htmlPane.addHyperlinkListener(this);

		JScrollPane scrollPane = new JScrollPane(htmlPane);
		scrollPane.getVerticalScrollBar().setUnitIncrement(4);
		this.add(scrollPane, BorderLayout.CENTER);
		this.pack();
		this.setVisible(true);
		this.setAlwaysOnTop(true);
	}

	public void hyperlinkUpdate(HyperlinkEvent e) {
		if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
			try {

				String readPDF = "open -a Preview " + e.getURL().toString();
				Runtime.getRuntime().exec(readPDF);

			} catch (IOException ioe) {
			}
		}

	}
}
