/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

import TreeSnatcher.Core.Activity;
import TreeSnatcher.Core.Branch;
import TreeSnatcher.Core.Constants;
import TreeSnatcher.Core.ImageOperations;
import TreeSnatcher.Core.InnerNode;
import TreeSnatcher.Core.MainWindow;
import TreeSnatcher.Core.Tip;
import TreeSnatcher.Core.TreeNode;
import TreeSnatcher.Core.TreeTopology;
import TreeSnatcher.Core.ActivityProtocol;
import TreeSnatcher.Utils.FileOperations;
import TreeSnatcher.Utils.NumberUtility;
import TreeSnatcher.Utils.Preferences;
import TreeSnatcher.GUI.DataFrame;

// In German...
// TODO: Dialogbox zur Eingabe der Artnamen erscheint nicht mehr mittig, sobald man...ja, man was tut?
// TODO: Aus PDF importieren
// TODO: Unterbume im Newick String anklicken und in der Topologie anzeigen und umgekehrt
// TODO: Vernderte Stift- und Radiergummibreiten in der Lupe kenntlich machen
// TODO: Auch einen runden Stift anbieten
// TODO: Freihandauswahl
// TODO: TreeSnatcher-Icon fr modale Dialoge, AboutBox, Iconified-Zustand etc.
// TODO: Fill, ColorRangeManipulation und QuantizeColors sollten auch lokal funktionieren
// TODO: Manuelles Skelettieren ist am Rand nicht mglich
// TODO: In OneNodeMode: Den ganzen von einem Knoten aus erreichbaren Pfad hervorheben
// TODO: SuppressTinyBranches validieren
// TODO: Tastenabfrage global verfgbar machen
// TODO: Beim Skalieren stimmen Bildgre und Auswahlbox nicht genau berein
// TODO: Mu das Binrbild bei Undo ebenfalls verndert werden?
// TODO: Texterkennung: Fr rot markiertes Blatt entweder Auswahlbox um horizontale Schrift oder eine diagonale Linie
// 		 um nicht horizontale Schrift legen, dann OCR (Aus dem Start- und Endpunkt der Linie lt sich die Grundlinie
//       des Schriftzugs rekonstruieren - stimmt nicht!)
// TODO: Alle Artnamen alphabetisch auf Platte speichern und ggf. wieder zum Einfgen anbieten
// TODO: Eingabedialog mu die Mglichkeit bieten, vorherige Eintrge zu editieren bzw. zu lschen
// TODO: Bei jedem Fehler whrend einer Aktion/eines Modus mu ProgressPane beendet werden
// TODO: Bei das ganze Bild betreffenden Operationen darauf hinweisen, da diese unabhngig von der Auswahlbox wirken
// TODO: OutOfMemoryError bei Bildoperationen: ntigen Speicherplatz ermitteln und Aktion ggf. nicht erst beginnen, sondern Benutzer informieren
// TODO: Benutzergenerierte Knoten drfen gelscht werden; dabei mu aber die "Dicke" der lokalen Umgebung beachtet werden:
//       Nur Knoten innerhalb dieser engen Nachbarschaft drfen gelscht werden
// TODO: Schnheitsoperation: Grafische Operationen sollten fr den Benutzer unsichtbar durchgefhrt werden (in einem Hintergrundpuffer)
// TODO: Bei einem Fehler in der Topologie sollte sofort das NewickString-Fenster erscheinen
// TODO: Nach einer Unterbrechung mit Escape wird ProgressPane nicht mehr benutzt (tritt nur sporadisch auf)
// TODO: Manuelles Skelettieren wird nicht immer korrekt von Undo rckgngig gemacht
// TODO: Der Gebrauch des Mastabs mu rckgngig gemacht werden knnen
// TODO: Nach Abbruch mittels ESC bei Operationen mit Dialog klappt restoreSnapshot nicht zuverlssig
// TODO: RemoveNode/RemoveNodes -> DetectBranches mu automatisch aufgerufen werden
// TODO: Wendepunkte in den sten mittels Splines ermitteln
// TODO: repaint() berall - wenn mglich - durch repaint(x, y, w, h) ersetzen
// TODO: Parameter an Methoden sollten immer kopiert werden
// TODO: Spezial-Speichermodus "Demonstration", speichert alle Aktivitten mit und kann sie rekonstruieren
// TODO: Winkelbestimmung an die Astlnge anpassen (krzere ste = weniger Winkel zu bestimmen = akkurater)
// TODO: Bei Elaborate path finding knnen Knoten nahe dem Bildrand nicht verbunden werden
// TODO: Die File-Dialoge verhalten sich unschn: Sie behandeln alle Dateien gleichen Namens mit beliebiger Endung .* gleich
// TODO: GEHT NICHT, da Zielknoten unbekannt: Bei der Wegfindung sollte sich der Pfad bevorzugt auf den Zielknoten zubewegen
//       Daher in einem Tutorium darauf hinweisen, wie wichtig eindeutige Wege sind
// TODO: Paarweise Distanzen auf Abruf berechnen und anzeigen
// TODO: Bei Undo von setUserBranchLength wird zwar die Zahl zurckgesetzt, nicht aber der Status (der Ast bleibt grn, mu aber wieder orange werden)
// TODO: Datei-Historie von fnf Dateien
// TODO: Mechanismus funktioniert nicht: In Preferences Font SansSerif als Ressource aus JAR laden
// TODO: Wurzel setzen (ein Branch-Objekt wird in der Mitte geteilt)
// TODO: Bilder generell von Festplatte streamen, damit auch echte Biester verarbeitet werden knnen

// Done:
//TODO: Lokales Skelettieren klappt nur ein Mal
//TODO: Ausduennen funktioniert nicht nach Vergrerung des Bildes (hat zu tun mit den modifizierten Offsets 1 auf 0)
//TODO: Teilbume mit nur einem Unterbaum entdecken (z.B. nur ein Blatt an einem inneren Knoten)
//TODO: Die Kantenerkennung bricht bisweilen ab mit einem angeblich isolierten inneren Knoten: Solche Problemkandidaten anzeigen
//TODO: ColorRangeManipulation: Replace exact color von Schwarz auf Wei funktioniert nicht (doch, nur mu eine Selection aktiv sein)
//TODO: Knoten drfen nur automatisch generiert werden, falls sich kein benutzergenerierter in nchster Nhe befindet
//TODO: Analog Kanten(?)
//TODO: Selbstgenerierte Knoten werden von "Delete selected nodes" gelscht (klar, so soll es auch sein!)
//TODO: Selbstgenerierte Objekte werden nicht in die Topologie eingebunden
//TODO: Fill kann noch nicht per Undo rckgngig gemacht werden
//TODO: Nach ColorRangeManipulation wird das vorherige Werkzeug nicht reaktiviert, sondern es bleibt die Pipette
//TODO: Bei Quit mu ggf. nachgefragt werden, ob nderungen gespeichert werden sollen
//TODO: Auswahlbox mu beim Scrollen mit vergrert werden
//TODO: Maus-Icon fr Eimer bedarf einer berarbeitung
//TODO: Letztes benutztes Verzeichnis merken
//TODO: Gelschte ste zwischen dann fehlenden Teilbume bleiben offenbar in der Topologie enthalten und werden nicht bemerkt
//TODO: Eckpunkte im Vordergrund werden vor der Knotenerkennung direkt nach der Skelettierung entfernt
//TODO: Eckpunkte nicht als Knotenpositionen werten
//TODO: Box-Auswahlwerkzeug an die Bildschirmgrenzen anpassen, falls es darber hinaus gezogen wird
//TODO: Ignore Tiny Branches ausprogrammieren mit Angabe, ste welcher Lnge ignoriert werden sollen
//TODO: Wird ein eigener innerer Knoten generiert, wird der innere Knoten des ersten Blattes nicht angeschlossen (oder hnlich)
//TODO: Knoten und Kanten in der Lupe anzeigen
//TODO: Erste und letzte Zeilen und Spalten eines Bildes werden nicht skelettiert (Offsets 1 auf 0 in imageOperations.thin())
//TODO: !! Nach Lschen von Knotenmarkierungen und vor Start einer neuen Knotenerkennung werden die Farbmarkierungen im Baum nicht gelscht
//TODO: Ast- und Knotenbeschriftungen ggf. in der Schriftgre etc. variieren, mit Highlighting arbeiten...
//TODO: In der Lupe Farbnderungen durch Auswahl von Knoten und Kanten kenntlich machen
//TODO: Hohe Zahlen als Taxon-Namen vermeiden (bisher werden sie der ID angeglichen, was unntig ist)
//TODO: Zurzeit knnen nur schwierig Branches zwischen ganz eng benachbarten Knoten gezogen werden
//TODO: Nach Zyklen im Graphen und Konnektivitt erst fahnden, nachdem die Kantenerkennung abgeschlossen ist
//TODO: UniqueColorSource.getUniqueColor() verhindert, da immer gleiche Knoten-Ids immer gleiche Farben erhalten
//TODO: PathColor in imageOperations modifiziert: zu wizard.pathColor = UniqueColorSource.getUniqueColor()
//TODO: Bei komplex.png werden Branches gezogen, die einen "unsichtbaren" InnerNode besitzen (segregateTinyBranches ist schuld, wurde deaktiviert)
//TODO: AddInnerNode/AddTip sind in der rechten Werkzeugleiste unntig, da der Benutzer keinen Hinweis darauf erhlt,
//      wo das Objekt eingefgt wird
//TODO: Cursors verndern: Links oben kleines Quadrat bei Box, eine Linie bei Line, Kurve bei Curve etc.
//TODO: Nicht automatisch nach RemoveNodes/Branches/Add zu GrabObject umschalten, 
//TODO: Stencil (Stempel-Werkzeug), um immer wieder einen kopierten Bereich an beliebiger Stelle einzufgen
//TODO: Farbdialog erweitern um: Farbmengen-Auswahl, Button "Select Whole Image"
//TODO: Kenntlich machen, an welcher Position das nchste TreeNode-Objekt eingefgt wird bzw. von wo aus geflutet wird
//TODO: ColorRangeManipulation: Pipette sollte sofort angezeigt werden, sobald die Maus ber dem Bild ist
//TODO: Newick Panel sollte sofort bei Fehler in der Topologie angezeigt werden
//TODO: Activities: Bilder speichern und laden fr Undo/Redo
//TODO: Nach Local Threshold z. B. ist das Ausgangsbild nicht mehr da beim berblenden
//TODO: ProgessPanel bricht nicht ab bei Topologie-Fehler
//TODO: Bei Dialogbox-Eingaben mu das ProgressPanel deaktiviert bleiben
//TODO: Bei Beendung des Programms ber das Men werden die Protokolldateien nicht gelscht, jedoch bei Beendigung ber
//      den Schlieen-Button
//TODO: Ab Java SDK 1.6 verschwindet das Men zeitweise und erscheint erst nach Rechtsklick wieder
//TODO: Undo fr Stift und Radiergummi: Fr Punkte klappt es noch nicht, teilweise Dateifehler beim Schreiben (Linie)
//TODO: Undo bei Linien: Dicke Linienenden werden nicht immer beseitigt
//TODO: UNDO/STORE STATE replaced everywhere - undo is not functional
//TODO: Nach Trim ist der Rahmen wei, nicht grau
//TODO: Bei Mausklick und leerer Aktivitt wird ein Undo-Image angelegt
//TODO: Verhalten von ProgressPane ist noch nicht wie erwnscht: soll verschwinden bei Anzeige einer Dialogbox, erscheinen whrend
//      einer Aktion etc.
//TODO: Nach Scale2X, Scale05X und Subimage(CROP) ist die Menzeile nicht sichtbar
//TODO: Quadcurve und Fill knnen nicht rckgngig gemacht werden
//TODO: Dialoge: Undo funktioniert, aber die Zahl der danach verfgbaren Undo-Schritte ist zu hoch
//TODO: Eine Linie, die ber den Rand hinausgeht und doch nicht gezeichnet wird, wird trotzdem protokolliert
//TODO: Lupenanzeige friert ein, sobald die Maus auerhalb des Fensters ist.
//TODO: ColorQuantizationDialog hinterlt bei Cancel einen Undo-Schritt
//TODO: Undo fr AS_REFERENCE_NODE
//TODO: Das Originalbild geht in bestimmten Fllen als berblendbild verloren (welche sind das?) 
//      Sollte behoben sein: in ImageBuffer.copyFromSnapshot wird nicht srcImage, sondern dessen Kopie zurckgegeben
//TODO: Stencil sollte ein Geisterbild anzeigen
//TODO: Motiv hngt bei Mauswheel-Scrolling nicht kontinuierlich an der Maus; Update erfolgt erst nach Mausbewegung,
//      repaint() in mouseWheelScrolled produziert Artefakte und betrifft auerdem das gesamte Bild
//TODO: Bei allen Dialogen nimmt Accept eine Aktivitt auf, auch wenn gar keine stattgefunden hat: Verhindern mit einem Flag,
//      das angibt, ob Preview eine Manipulation vorgenommen hat
//TODO: Schlieen-Button bei Dialogen inaktivieren, am besten beseitigen
//TODO: Fill-Dialog: nach Wahl einer Farbe aus dem Bild hinterlt er ein leeres Protokoll und Undo-Schritte
//TODO: Undo-Historie nach Crop und Scale lschen
//TODO: Bild bewegt sich nach Crop sehr langsam
//TODO: Nach abgebrochenem Beenden des Programms ist die Menleiste nicht sichtbar
//TODO: Beim Aufzeichnen einer Linie whrend eines Scrollvorgangs wird das Linienende falsch erfat, da die Koordinaten nicht
//      erhht werden
//TODO: Nach Skalierungen steht das Originalbild zum Einblenden nicht mehr zur Verfgung
//TODO: Nach Scale05x und Local Threshold wird das verkleinerte Bild in das grere binarisierte gesetzt 
//      (wahrschnl. behoben, in AUTO_BINARIZE() getSnapshot() durch image ersetzt
//TODO: Skalieren und Crop mssen auch das ggf. vorhandene Binrbild lschen
//TODO: Das Scrolling nach mouseReleased verhindert ein 100%iges Protokollieren von LINE
//TODO: Ist bei Farbquantisierung eine Box vorhanden, wird die Operation nur fr das Gebiet innerhalb der Box rckgngig gemacht
//TODO: Bei Dialogen mu bei "Accept" ebenfalls progressPanel angezeigt werden
//TODO: Snapshot: ReadSnapshotDir wird noch nicht richtig gesetzt
//TODO: Processing-Werkzeuge von S/W auf RGB umstellen
//TODO: Undo fr die Topologie-Aktivitten: Sie mssen noch mit einer ActivityID versehen werden, damit sie rckgngig
//      gemacht werden knnen.
//TODO: Nach Laden eines Snapshots funktioniert Undo mindestens von BranchLength nicht.
//TODO: FindBranches setzt nach Ablauf den gesamten Vordergrund auf schwarz: betrifft jetzt nur die aktuelle Auswahlbox
//TODO: Nach einem Topologie-Undo sind Knoten und Kanten nicht mehr verbunden
//TODO: AddNode darf nur ausgefhrt werden, nachdem die Topologie zum ersten Mal berechnet worden ist
//TODO: Manuell hinzugefgte Knoten werden nicht mit sten verbunden (UniqueColorSource wurde fr sie nicht aufgerufen)
//TODO: Ast-Erkennung funktioniert nicht fr Tips, die am Rand einer binrisierten Region liegen, die von einer "bunten" umgeben ist
//TODO: Nach Knotenerkennung werden blau gefrbte Bereiche nicht mehr schwarz eingefrbt (Tritt nur nach Fehlern in imageOp auf)
//TODO: DetectBranches mu auch funktionieren ohne vorheriges DetectNodes, falls vom Benutzer erzeugte Knoten vorhanden sind
//TODO: Manuell gesetzte innere Knoten mit ID=0 werden bei der Astverfolgung ignoriert (ab jetzt beginnt TreeNode.num bei 1)
//TODO: Bei prepared.png werden Knoten ausgelassen (liegt an segregateTinyBranches)
//TODO: Schalter "Include Branch Lengths" ergnzen
//TODO: Bei InspectBranchingNodewise: Bei Snapshot sind die Branches grau anstatt rot dargestellt
//TODO: Kommazahlen fr Astlngen durch Punktzahlen ersetzen
//TODO: Das Format des eingegebenen Lngen-Wertes mu als Grundlage fr alle anderen genommen werden
//TODO: Nach Eingabe einer Astlnge mu der Newick Ausdruck sofort angepat werden
//TODO: Branch.maxFractionDigits mu ggf. bei Lschung eines Branch-Objekts vermindert werden
//TODO: Nach DragBranch mu der Newick-Ausdruck sofort angepat werden (nach Snapshot war wizard.branchesCollecting auf true)
//TODO: Nach DragBranch mu die Topologie sofort neu berechnet werden (dto.)
//TODO: Nach Eingabe einer Astlnge mu sofort die maximal ntige Nachkommastellenzahl ermittelt werden (in Action.BRANCH_LENGTH)
//TODO: Nachkommastellen-Strategie klappt nicht mehr, sobald die Anzahl von hoch auf 0 gegangen ist. (action == Activity.BRANCH_LENGTH)
//TODO: Branch-Objekte sind nach Snapshot-Wiederherstellung nicht vorhanden?!
//TODO: Nach Undo von Branch-Lschungen mu Branch.maxNumFractionDigits wiederhergestellt werden
//TODO: Anzahl Nachkommastellen mu angepat werden, wann immer zwischen userAssignedLengths und calculatedLengths gewechselt wird
//TODO: Seltsamer Fehler: 3.5 bei userAssignedLength wird als 3.500 dargestellt (Grund: Double.NaN induziert drei Nachkommastellen)
//TODO: Branch.toString() sollte die Lngenangaben in der ntigen Genauigkeit anzeigen
//TODO: Wird ein neues Bild erstellt, wird Blend deaktiviertt
//TODO: Sobald Astlngen eingegeben worden sind, mssen alle ste, fr die das noch nicht geschehen ist, kenntlich gemacht werden
//TODO: Undo fr Astlngen-Eingabe implementieren
//TODO: Fr alle Undo-Aktionen, die sich auf Branch-Objekte beziehen, mu anschlieend das Zahlenformat berechnet werden
//TODO: Wird wizard.colorNewickString richtig gesichert und wiederhergestellt?
//TODO: Topologie von njPlot scheint bezogen auf die Wurzel anders zu sein (nein, ist gleich, vergleiche Bild mit Plot)
//TODO: RemoveBranchesInSelection produziert manchmal eine fehlerhafte Topologie (redoTopology in Schleife gessetzt)
//TODO: Nach Wiederherstellung eines Snapshots zeigt die Lupe nicht das berblendete Originalbild
//TODO: Nach Wiederherstellung eines Snapshots funktionieren ClearImage, FillBlack/White, Fill nicht mehr
//TODO: Nach Wiederherstellung eines Snapshots und nach Fill und Undo zeigt die Lupe das modifizierte Bild
// 		gendert fr die beiden letzten Punkte: issueSnapshot ruft jetzt image.createGraphics() auf
//TODO: detectBranches auf Buntbild fhrte zu einem schwarzen Bild, da alle bunten Pixel schwarz wurden
//      gendert in treeTopology: if (wizard.isBinarized) imageOperations.blackenFGPixels(BIN0, wizard.wholeImage);
//TODO: BlendRatio etc. mssen fr Snapshot gespeichert und rekonstruiert werden
//TODO: Diverse Flags, z. B. highlightBranchesWithoutLength, mssen bei Laden eines Bildes zurckgesetzt werden
//TODO: GUI-Elemente fr Stiftdicken mssen nach Snapshot auf die richtige Position gebracht werden
//TODO: Wizard darf nach Snapshot nicht da sein, falls er deaktiviert wurde
//TODO: In bestimmten Fllen kann ein Snapshot nicht geladen werden (hat mit GUIActions.adjustControls() zu tun)
//		Notlsung: mit try...catch() umschlossen
//TODO: Einstellung HighlightBranchesWithoutLength stimmt nicht immer mit Schalter berein
//TODO: Nach Lschung aller Objekte und erneuter Knoten- und Kantendetektion erhlt man keinen Newick String,
//      Fehler ist in newickCalculator.buildNewickStringFromTree(); dort ist startNode = null
//      Gelst: Wird das Branch-Objekt gelscht, dessen TreeNodes eine id = wizard.referenceNodeId besitzen, wir diese auf -1 gesetzt
//TODO: Undo fr Branch Length und Species name mu sofort den Newick String ndern (zugefgt: updateResultFrame())
//TODO: Markierte TreeNode-Objekte flackern, wenn sie zum selektierten Branch-Objekt gehren
//TODO: Festlegen, wann Branch.getLength bzw.Branch.getUserAssignedLength verwendet wird
//TODO: Schalter im Spezial-Men fr die Einbeziehung der Astlngen in den Newick-String
//TODO: Bei smallNodes wird der gewhlte Knoten nicht durch Blinken hervorgehoben
//TODO: calculatePathLengths einbinden, vor jedem Aufruf alten Pfad schwrzen, mitzhlen/krzen(?)
//TODO: Branch.toString() gibt bei benutzergenerierten Astlngen den gleichen Wert fr calculatedLength zurck
//TODO: Zwei getrennte Bereiche in StatusBar: einer fr Koordinaten+Farbe, ein anderer fr die Nachricht
//TODO: Branch.useCalculatedLength zeigt zu viele Nachkommastellen
//TODO: Branch zeigt in seinem String fr Branch mit pixelLength = 0 eine calculatedLength = 0
//TODO: Sobald lengthInPixels bekannt ist, mu der Wert als Branch.length behandelt werden
//TODO: Es darf kein Tausender-Trennzeichen verwendet werden
//TODO: Pfade fr die Lngenberechnung stimmen noch nicht bzw. sind teilweise viel zu lang (vgl. Bild)
//TODO: TreeOfLife-Bild: Branches(Tip->Tip) und mehrfache Branches an Tips treten auf
//TODO: Nach Abbruch mittels Cancel wird das Lupenbild nicht zurckgesetzt
//TODO: In bestimmten Fllen sind die Knotenpositionen nach der Knotensetzung noch dunkelblau markiert
//		Vermutung (bei Fehler whrend der Berechnung der Topologie)
//TODO: Nachdem alle Knoten ber DeleteAllNodes gelscht wurden, mssen Nodes wieder verschoben werden drfen
//TODO: Pfade bei der Lngenermittelung speichern und zusammen mit den sten anzeigen (im Ein-Knoten-Modus)
//TODO: Als Option: Die Lnge eines Astes als Skalierungswert nehmen (die Astlnge wird 1.0)
//TODO: ShowRealBranches von OneNodeMode trennen
//TODO: ImagePanel: removeNode/removeNodesInSelection: guiActions.toggleDrawingTools(true), falls topology.nodes.size = 0
//TODO: Nach Laden eines Snapshots nach Topologie-Erstellung sind alle Funktionen aktiviert
//TODO: Arbeitsablauf restriktiver machen: Keine Bildmanipulationen mehr nach Topologie-Ermittlung
//      (vielleicht lediglich Malwerkzeuge erlauben?)
//TODO: Bei einem Snapshot klappt die Knotenerkennung nicht
//TODO: Festlegen, wie measureScaleBar zu verwenden ist
//TODO: Zwischenstadien der Topologie und Bild abspeichern und wieder laden knnen (Snapshot/Checkpointing)
//TODO: Die Astlngen mssen zuletzt dargestellt werden, da sie sonst von Knoten berdeckt werden
//TODO: Astbestimmung dahingehend ndern, da der Algorithmus lokal von Knoten angezogen wird, also nicht mehr an ihnen vorbeiluft
//TODO: Eingefgt in imageOperations.buildPath(): path.add(current) zu Beginn
//TODO: Irrelevant: Der Sonderfall "Outer Branch" ohne Wendepunkt ist lngenirrelevant (otididae) mu manuell anwhlbar sein
//TODO: Fr rechteckige Topologien mu die Berechnung der Segmentlngen je Branch angepat werden
//TODO: Snap kritisch: nachdem alle Knoten gelscht wurden, skelettiert wurde, Knoten neu erkannt wurden und dann detectBranches versucht wurde,
//		geschieht nichts (Vermutung: Branch-Objekte werden nicht richtig erstellt, da Knoten an unsinnigen Positionen)
//TODO: Beim Umschalten der drei Ansichten verschwindet der Bildvordergrund bisweilen
//TODO: ScaleBarLength verursacht Programmaussetzer: Scheint nur selten aufzutreten
//TODO: AboutBox sinnvoll erweitern
//TODO: Kosmetische Verbesserungen an der Oberflche
//TODO: Snapshots speichern die Lage des Bildes in der ScrollPane mit
//TODO: Mglichkeit, das Bild inkl. Topologie usw. abzuspeichern
//TODO: In FileOperations mu ggf. immer der canonicalPath genommen werden zwecks Plattform-Unabhngigkeit
//TODO: Wahrscheinlich behoben: Nachfrage bei Schlieen darf nur erscheinen, falls die Bearbeitungshistorie nach dem letzten Speichern verndert wurde
//TODO: Wahrscheinlich behoben: Oft findet der Pathfinding-Algorithmus einen Zyklus, wo keiner ist und beharrt dann darauf
//TODO: Lupe an jede der drei Sichten anpassen
//TODO: Wird direkt zu Beginn auf das Default-Bild gemalt und es dann gespeichert, erscheint nach Laden ein weiterer Rand um das Bild
//TODO: Wurde kein Bild geladen, werden die selbsterstellten Cursors nicht angezeigt
//TODO: SaveImageDialog und SaveSnapshotDialog sollen einen eingegebenen Namen automatisch um .ser ergnzen, damit vorhandene Dateien nicht ber-
//TODO: Namen der Datei anzeigen, die gerade bearbeitet wird
//TODO: Zieht man einen Branch zwischen zwei Tips, wird Undo aktiviert, obwohl die Aktivitt ungltig war
//TODO: Neighborship-size als programm-parameter oder dynamisch anpassen (z.B. Abstand zwischen zwei Knoten, Liniendicke etc.)
//TODO: Als Branch length bei snap10 wird bei einigen sten 1 angezeigt, rechnerisch ist sie aber 0 (defaultBranchLength)
//TODO: "Small nodes and branches" und "lookahead dist" knnten automatisch gewhlt werden, abhngig vom krzesten Abstand zwischen zwei TreeNode-Objekten
//TODO: Bei Rectangular Topology: Sind bei der Astorientierung uere ste dabei, die eine andere Orientierung haben als der
//		dominierende Rest, werden die Segmente genau umgedreht bewertet
//TODO: lookahead automatisch setzen wie bisher, aber nach detectNodes und vor detectBranches
//		genauer: falls Benutzer selbst einen Wert eingibt, diesen nehmen, ansonsten den errechneten
//TODO: Automatisch den ersten inneren Knoten mit nur zwei sten als Referenz-TreeNode nehmen

//schrieben werden (offenbar ein seltsamer FileDialog-Fehler; gewhlte Namen mit Endung werden ihrer Endung beraubt)
//Im Augenblick verwendet TreeSnatcher bei Warnen bzgl. berschreiben einer Datei einmal die System-Dialogbox und einmal
//eine Java-Dialogbox

//Anmerkung:	Bild 142010-Chordate: Binarisieren, despeckle maximal, Ausdnnen ergibt schne Kanten
//Anmerkung: 	041209: Const.Modes and Actions auf Activity.* umgestellt, Fehler bei Zuordnung mglich
//Anmerkung: 	FloodFill ist von der Undo-Funktionalitt ausgenommen
//Anmerkung:	in mouseReleased.drawBranch wurde eine Kontrolle eingebaut, die verhindert, da ste zwischen
// 				Knoten gezogen werden knnen, die nicht ber einen VG-Pfad verbunden sind. Dadurch knnen keine Schleifen
// 				mehr im Baum entstehen, falls es sich beim Bild um einen phylogenetischen Baum handelt
//Anmerkung: 	Nach Ermittelung der Topologie knnen Knoten nunmehr nicht mehr verschoben werden. Desweiteren
//  			wurde in FileOperations ergnzt: wizard.mayDiscardUserGeneratedObjects, die Option wurde vllig entfernt
// 				wegen Probleme mit topology.wipeOutDoublettes
// 				Dies dient unter anderem dem Zweck deutlich zu machen, da die Topologie von der Grafik abhngig ist
// 
//Anmerkung:	Nachkommastellen:
//				double zahl = 12.1;
//				nachkomma = (zahl * 10.0) % 10;
//				damit bekommst du die erste kommastelle
//				wenn du noch mehr haben willst einfach *100)%100 fr 2 stellen *1000)%1000 fr 3 stellen usw. 
//				oder mit Strings:

// Punkt setzen: g.fillRect(x0, y0, 1, 1);

//Windows -	Abfrage linke Maustaste:  if (e.isMetaDown() == false)	{}  // Left mouse button
//Windows -	Abfrage rechte Maustaste: if (e.isMetaDown() == true)	{}	// Right mouse button

//MacOSX -	Abfrage linke Maustaste:  if (e.getButton() == Button1) {}	// Left mouse button
//MacOSX -	Abfrage rechte Maustaste: if (e.getButton() == Button3) {}	// Right mouse button
//MacOSX - Die Windows-Lsung funktioniert aber auch

public class ImagePanel extends JPanel implements Constants, PopupMenuListener,
MouseInputListener, MouseWheelListener, KeyListener {
	private static final long serialVersionUID = 1L;
	protected ImagePanel ip = this;
	BufferedImage image;
	BufferedImage floodedImage;
	JScrollPane scrollPane;
	JViewport viewport;
	ImageIcon imageIcon;
	Magnifier magnifier;
	ImageOperations imageOperations;
	ResultFrame resultPanel;
	StatusBar statusBar;
	Wizard wizard;
	FileOperations fileOperations;
	InfiniteProgressPanel progressPane;
	TreeTopology topology;
	ActivityProtocol protocol;
	Graphics2D g2;
	Point lineStart;
	Point upperLeft;
	Point branchStartPosition;
	Point branchEndPosition;
	Point oldMouseCoords;
	Point lowerRight;
	Point popupMenuLocation;
	Point curveStart;
	Point curveEnd;
	Path2D drawingPath;
	Point2D pointLocation;
	Ellipse2D circle;
	Shape selection;
	Shape emptySelection = new Rectangle2D.Float(0, 0, 0, 0);
	Shape branch;
	Shape curveHandle;
	Shape userDrawing;
	BufferedImage motif;
	GUIActions guiActions;
	MainWindow mainWindow;
	FancyCursors cursors;
	ImageBuffer imageBuffer;
	DataFrame dataFrame;
	Color fgColor;
	protected int mode;
	protected int recentMode;
	protected int action;
	protected int recentAction;
	Stroke customStroke;
	Stroke defaultStroke;
	Stroke dashedStroke;
	Stroke eraserStroke;
	Vector<TreeNode> nodes;
	Vector<Branch> branches;
	TreeNode selectedNode;
	TreeNode branchStartNode;
	TreeNode branchEndNode;
	Branch selectedBranch, prevSelectedBranch;
	JPopupMenu popupMenu;
	JFrame parent;
	boolean curveDrawn;
	boolean curveHandleDragging;
	boolean branchDrawn;
	boolean useProgressPane = true;
	int[] offset = { 1, 2, 3, 4, 5, 4, 3, 2 }; // Auxiliary variable for Branch
	// accentuation
	int oi = 1;
	protected int lastActionId = 0;
	NumberFormat df;
	FontRenderContext frc;
	TextLayout textLayout;
	Thread actionPerformer;
	int scrWidth, scrHeight;

	public ImagePanel(JFrame parent, BufferedImage image,
			JScrollPane scrollPane, StatusBar statusBar, Magnifier magnifier,
			Wizard wizard, ResultFrame resultPanel, ImageBuffer imageBuffer,
			ImageOperations imageOperations,
			InfiniteProgressPanel progressPane, FancyCursors cursors,
			FileOperations fileOperations) {
		super();
		this.parent = parent;
		this.image = image;
		this.magnifier = magnifier;
		this.imageBuffer = imageBuffer;
		this.imageOperations = imageOperations;
		this.scrollPane = scrollPane;
		this.viewport = scrollPane.getViewport();
		this.statusBar = statusBar;
		this.wizard = wizard;
		this.resultPanel = resultPanel;
		this.progressPane = progressPane;
		this.cursors = cursors;
		this.mode = Activity.IDLE;
		this.action = Activity.IDLE;
		this.curveDrawn = false;
		this.curveHandleDragging = false;
		this.branchDrawn = false;
		this.curveStart = new Point();
		this.curveEnd = new Point();
		this.nodes = new Vector<TreeNode>();

		this.setDoubleBuffered(true);
		this.motif = null;
		this.drawingPath = new Path2D.Float();

		addMouseListener(this);
		addMouseMotionListener(this);
		addMouseWheelListener(this);
		addKeyListener(this);
		setAutoscrolls(true);
		setBackground(new Color(defaultTransparencyShade));
		setCursor(cursors.getPanelCursor());

		if (image == null) {
			Toolkit toolkit = Toolkit.getDefaultToolkit();
			Dimension screenSize = toolkit.getScreenSize();
			image = new BufferedImage(screenSize.width, screenSize.height,
					BufferedImage.TYPE_INT_ARGB);
			Graphics2D g2 = (Graphics2D) image.getGraphics();
			g2.setColor(Color.white);
			g2.fillRect(0, 0, screenSize.width, screenSize.height);
		}
		setImage(image);
	}

	protected void paintComponent(Graphics g) throws NullPointerException {
		if (g == null)
			return;
		if (image != null)
			g2.setClip(wizard.wholeImage);
		else
			g2.setClip(scrollPane.getViewport().getViewRect());
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;

		// Necessary for images with alpha channel
		g2.setColor(new Color(wizard.transparentShade));
		if (image != null) {
			g2.fillRect(0, 0, image.getWidth(), image.getHeight());

			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
					RenderingHints.VALUE_ANTIALIAS_ON);
			g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING,
					RenderingHints.VALUE_COLOR_RENDER_QUALITY);
			g2.setRenderingHint(RenderingHints.KEY_RENDERING,
					RenderingHints.VALUE_RENDER_QUALITY);
			g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS,
					RenderingHints.VALUE_FRACTIONALMETRICS_ON);

			// Draw current image and the source image in the desired blend
			// ratio
			g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
					wizard.transparencyRatio));
			g2.drawImage(image, 0, 0, this);
			g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
					1 - wizard.transparencyRatio));
			// Add the border width to the origin if the image's sizes differ
			// (that means the image has been cropped before)
			g2.drawImage(imageBuffer.getBlendImage(), 0, 0, this);
		}
	}

	// Draws the user selection and all markings
	public void paintChildren(Graphics g) throws NullPointerException {
		if (g == null)
			return;
		int firstId = -1, secondId = -1; // The ids of the highlighted branch's
		// nodes
		if (image != null)
			g2.setClip(wizard.wholeImage);
		else
			g2.setClip(scrollPane.getViewport().getViewRect());
		super.paintChildren(g);
		Graphics2D g2 = (Graphics2D) g;
		g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
				1.0f));

		// Draw the line or curve that the user is currently drawing
		if (userDrawing != null) {
			g2.setStroke(customStroke);
			if (mode == Activity.BLACK_LINE)
				g2.setColor(new Color(BIN1));
			else if (mode == Activity.WHITE_LINE)
				g2.setColor(Color.gray.brighter());
			g2.draw(userDrawing);
		}

		// For the stencil operation, display a ghost motif at the mouse
		// location
		if (mode == Activity.STENCIL) {
			Point p = getMousePosition();
			if ((p != null) && (wizard != null)
					&& (wizard.wholeImage.contains(p) && (this.contains(p)))) {

				if (motif != null) {
					g2.setComposite(AlphaComposite.getInstance(
							AlphaComposite.SRC_OVER, 0.7f));
					g2.drawImage(motif, p.x, p.y, null);
					g2.setComposite(AlphaComposite.getInstance(
							AlphaComposite.SRC_OVER, 1.0f));
				}
			}
		}

		// Draw the curve handles and auxiliary lines
		if (curveHandle != null) {
			g2.setStroke(dashedStroke);
			g2.setColor(Color.red);
			g2.fill(curveHandle);
			int hx = (int) curveHandle.getBounds2D().getX() + 2;
			int hy = (int) curveHandle.getBounds2D().getY() + 2;

			g2.drawLine(hx, hy, curveStart.x, curveStart.y);

			g2.drawLine(hx, hy, curveEnd.x, curveEnd.y);
			g2.setStroke(defaultStroke);
		}

		// Draw the branch the user is dragging
		if (branch != null) {
			g2.setStroke(new BasicStroke(2, BasicStroke.CAP_BUTT,
					BasicStroke.JOIN_BEVEL));
			g2.setColor(Color.orange);
			g2.draw(branch);
		}

		// Draw the user selection
		if (selection != null) {
			g2.setStroke(dashedStroke);
			g2.setColor(Color.red);
			g2.draw(selection);
		}

		// Draw branches
		branches = topology.getBranches();
		g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
				1.0f));
		if (wizard.smallMarks) {
			g2.setStroke(new BasicStroke(1, BasicStroke.CAP_BUTT,
					BasicStroke.JOIN_BEVEL));

		} else
			g2.setStroke(new BasicStroke(2, BasicStroke.CAP_BUTT,
					BasicStroke.JOIN_BEVEL));

		g2.setFont(MainWindow.standardFont10);

		if (branches != null) {
			if (wizard.useOneNodeMode) // Draw the "logical" branches emerging
				// from the selected node
			{
				int psize = 1;
				if (wizard.smallMarks) {
					psize = 1;
					g2.setStroke(new BasicStroke(1, BasicStroke.CAP_BUTT,
							BasicStroke.JOIN_BEVEL));
				} else {
					psize = 2;
					g2.setStroke(new BasicStroke(2, BasicStroke.CAP_BUTT,
							BasicStroke.JOIN_BEVEL));
				}

				for (int i = 0; i < branches.size(); i++) {
					Branch branch = (Branch) branches.elementAt(i);
					if (branch != null) {
						TreeNode firstNode = branch.getFirstNode();
						TreeNode secondNode = branch.getSecondNode();

						if ((firstNode == selectedNode)
								|| (secondNode == selectedNode)) {
							g2.setColor(Color.orange);
							Vector<Point> path = branch.getPath();
							if (path != null) {
								Iterator<Point> it = path.iterator();
								while (it.hasNext()) {
									Point p = (Point) it.next();
									g2.fillRect(p.x, p.y, psize, psize);
								}
							}
						}
					}
				}
			} else if (wizard.showTracedPaths) // Draw the path segments along
				// for each branch
			{
				g2.setColor(Color.orange);
				g2.setStroke(new BasicStroke(1, BasicStroke.CAP_BUTT,
						BasicStroke.JOIN_BEVEL));

				for (int i = 0; i < branches.size(); i++) {
					Branch branch = (Branch) branches.elementAt(i);
					if (branch != null) {
						g2.setStroke(new BasicStroke(1, BasicStroke.CAP_BUTT,
								BasicStroke.JOIN_BEVEL));

						int numSegments = branch.getNumSegments();

						Vector<Integer> lengthRelevant = branch
						.getSegLengthRelevant();
						for (int j = 0; j < numSegments; j++) {
							int relevancy = lengthRelevant.elementAt(j);
							if (relevancy == RELEVANT)
								g2.setColor(Color.red);
							else if (relevancy == IRRELEVANT)
								g2.setColor(Color.black);
							else
								g2.setColor(Color.lightGray);

							Vector<Point> points = branch
							.getPathSegmentPoints(j);
							int psize = 1;
							if (wizard.smallMarks)
								psize = 1;
							else
								psize = 2;
							if (points != null) {
								Iterator<Point> pit = points.iterator();
								while (pit.hasNext()) {
									Point p = (Point) pit.next();
									g2.fillRect(p.x, p.y, psize, psize);
								}
							}
						}

						/*
						 * // Mark turning points Vector<Point> t =
						 * branch.getTurningPoints(); if (t != null) {
						 * Iterator<Point> it = t.iterator();
						 * g2.setColor(Color.red); while (it.hasNext()) { Point
						 * p = it.next(); g2.fillOval(p.x-2, p.y-2, 5, 5); }
						 * g2.setColor(Color.orange); }
						 */

					}
				}
				g2.setComposite(AlphaComposite.getInstance(
						AlphaComposite.SRC_OVER, 1.0f));
			} else if (branches != null) {
				for (int i = 0; i < branches.size(); i++) // Draw all branches
				{
					Branch branch = (Branch) branches.elementAt(i);
					if (branch != null) {
						TreeNode firstNode = branch.getFirstNode();
						TreeNode secondNode = branch.getSecondNode();
						Point f1 = firstNode.getLocation();
						Point f2 = secondNode.getLocation();

						if (Branch.signalBranch == branch.getId()) {
							if (oi == 8)
								oi = 0;
							g2.setStroke(new BasicStroke(offset[oi++],
									BasicStroke.CAP_BUTT,
									BasicStroke.JOIN_BEVEL));
							g2.setColor(signalColor);
						} else {
							if (wizard.smallMarks)
								g2.setStroke(new BasicStroke(1,
										BasicStroke.CAP_BUTT,
										BasicStroke.JOIN_BEVEL));
							else
								g2.setStroke(new BasicStroke(2,
										BasicStroke.CAP_BUTT,
										BasicStroke.JOIN_BEVEL));
						}

						if (!branch.equals(selectedBranch)) // Branch is not
							// selected
						{
							if (Branch.signalBranch != branch.getId())
								g2.setColor(branchColor);
							else
								g2.setColor(signalColor);

							if (((Wizard.useUserAssignedLengths) && (!branch
									.isUserAssignedLength()))
									|| ((Wizard.useMixedLengths) && (!branch
											.isUserAssignedLength()))) {
								if (wizard.highlightBranchesWithoutLength)
									g2.setColor(branchHighlightedColor);
							}
						} else // Branch is selected
						{
							g2.setColor(branchSelectedColor);
							firstId = firstNode.getId();
							secondId = secondNode.getId();
							TreeNode.setFirstId_Highlighted(firstId); // Avoids
							// that
							// this
							// pair
							// of
							// TreeNodes
							// gets
							// painted
							// over
							// immediately
							TreeNode.setSecondId_Highlighted(secondId);

							g2.setComposite(AlphaComposite.getInstance(
									AlphaComposite.SRC_OVER, 1.0f));
						}
						g2.drawLine(f1.x, f1.y, f2.x, f2.y);
					}
				}
			}
		}

		// Draw nodes
		// Node drawing strategy is cumbersome and can be simplified
		g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
				1.0f));
		nodes = topology.getNodes();
		if (nodes != null) {
			if (!wizard.showTracedPaths) {
				for (int i = 0; i < nodes.size(); i++) {
					TreeNode node = (TreeNode) nodes.elementAt(i);
					if (node != null) {
						if (selectedNode != node) {
							if (node instanceof Tip) {
								g2.setColor(tipColor);
								if (wizard.highlightTipsWithoutName) {
									// If the name of this tip is empty or
									// numeric, highlight this tip
									if ((((Tip) node).getTaxonName() == null)
											|| (((Tip) node).getTaxonName()
													.equals("")))
										g2.setColor(tipHighlightedColor);

									int intValue = -1;
									try {
										intValue = Integer
										.parseInt(((Tip) node)
												.getTaxonName());
									} catch (NumberFormatException e) {
									}
									;
									if (intValue != -1)
										g2.setColor(tipHighlightedColor); // A
									// numeric
									// tip
									// name
									// is
									// not
									// desired
								}
							} else // Node is an inner node
							{
								if (node instanceof InnerNode)
									g2.setColor(nodeColor);
								if (wizard.referenceNodeId == node.getId())
									g2.setColor(referenceNodeColor);
							}
						} else if (selectedNode != null) // Node is selected
						{
							if (node.getId() != wizard.referenceNodeId)
								g2.setColor(selectionColor); // Node is user
							// selected
							else
								g2.setColor(referenceNodeColor);
						}

						if (node.getId() != TreeNode.signalNode) // Node is not
							// highlighted
						{
							if ((wizard.smallMarks) && (node != selectedNode))
								g2.fill(node.getSmallShape());
							else if (node == selectedNode)
								g2.fill(node.getSignalShape());
							else
								g2.fill(node.getShape());
						}

						if ((node instanceof Tip)
								&& (((Tip) node).getTaxonName() != null)) {
							if ((wizard.drawTaxonName)
									|| (node == selectedNode)) {

								int mx = node.getX() - 10;
								int my = node.getY() - 10;
								String text = ((Tip) node).getTaxonName();

								if (textLayout == null) {
									frc = g2.getFontRenderContext();
								}

								if (text.length() != 0) {
									g2.setFont(MainWindow.standardFont12);
									textLayout = new TextLayout(text,
											MainWindow.standardFont12, frc);
									Shape base = textLayout
									.getLogicalHighlightShape(0, text
											.length());
									AffineTransform at = AffineTransform
									.getTranslateInstance(mx, my);
									Shape highlight = at
									.createTransformedShape(base);
									g2.setPaint(Color.white);
									g2.fill(highlight);
									if (selectedNode == node)
										g2.setColor(selectionColor);
									else
										g2.setColor(Color.black);
									textLayout.draw(g2, mx, my);
								}
							}
						}
					}
				}
			}

			// Highlight the nodes of the branch currently selected
			for (int i = 0; i < nodes.size(); i++) {
				TreeNode node = (TreeNode) nodes.elementAt(i);
				int id = node.getId();
				// The node belongs to the branch currently selected
				if ((node != null) && ((id == firstId) || (id == secondId))) {
					if ((TreeNode.signalNode != node.getId())
							&& (node != selectedNode)) {
						g2.setColor(branchSelectedColor);
						if (wizard.smallMarks)
							g2.fill(node.getSmallShape());
						else
							g2.fill(node.getShape());
					}
				}
			}

			// Attenuate the node if it is involved into a tree topology error
			for (int i = 0; i < nodes.size(); i++) {
				TreeNode node = (TreeNode) nodes.elementAt(i);
				if (node != null) {
					if (TreeNode.signalNode == node.getId()) {
						if (selectedNode != node)
							g2.setColor(signalColor);
						else
							g2.setColor(selectionColor);
						g2.fill(node.getSignalShape());
					}
				}
			}

			// Highlight the seed position of the last flood fill
			if ((wizard.floodSeed != null) && (wizard.markFloodSeed)) {
				g2.setColor(new Color(wizard.treeFloodColor));
				g2.drawLine(wizard.floodSeed.x - 5, wizard.floodSeed.y - 5,
						wizard.floodSeed.x + 5, wizard.floodSeed.y + 5);
				g2.drawLine(wizard.floodSeed.x - 5, wizard.floodSeed.y + 5,
						wizard.floodSeed.x + 5, wizard.floodSeed.y - 5);

				if (textLayout == null)
					frc = g2.getFontRenderContext();
				String text = "Flood Seed";
				int mx = wizard.floodSeed.x - 30;
				int my = wizard.floodSeed.y + 18;
				g2.setFont(MainWindow.standardFont12);
				textLayout = new TextLayout(text, MainWindow.standardFont12,
						frc);
				Shape base = textLayout.getLogicalHighlightShape(0, text
						.length());
				AffineTransform at = AffineTransform.getTranslateInstance(mx,
						my);
				Shape highlight = at.createTransformedShape(base);
				g2.setColor(Color.white);
				g2.fill(highlight);
				g2.setColor(new Color(wizard.treeFloodColor));
				textLayout.draw(g2, mx, my);
			}
		} // nodes != null

		// Draw the branch lengths
		if ((branches != null) && (!wizard.useOneNodeMode)
				&& (!wizard.showTracedPaths)) {
			for (int i = 0; i < branches.size(); i++) {
				Branch branch = (Branch) branches.elementAt(i);
				if (branch != null) {
					if ((wizard.drawBranchLength)
							|| (branch.equals(selectedBranch))) {
						// Draw branch length
						TreeNode firstNode = branch.getFirstNode();
						TreeNode secondNode = branch.getSecondNode();
						Point f1 = firstNode.getLocation();
						Point f2 = secondNode.getLocation();
						int x1 = f1.x, y1 = f1.y, x2 = f2.x, y2 = f2.y;

						{
							int mx = (int) ((int) x1 + 0.5 * (x2 - x1)) - 5;
							int my = (int) ((int) y1 + 0.5 * (y2 - y1)) - 5;
							df = NumberUtility.getCurrentNumberFormat();
							String text = df.format(branch.getLength());

							if (textLayout == null) {
								frc = g2.getFontRenderContext();
							}

							if (text.length() != 0) {
								textLayout = new TextLayout(text,
										MainWindow.standardFont10, frc);
								Shape base = textLayout
								.getLogicalHighlightShape(0, text
										.length());
								AffineTransform at = AffineTransform
								.getTranslateInstance(mx, my);
								Shape highlight = at
								.createTransformedShape(base);
								g2.setPaint(Color.white);
								g2.fill(highlight);
								if (!branch.equals(selectedBranch))
									g2.setColor(Color.black);
								else
									g2.setColor(branchSelectedColor);
								textLayout.draw(g2, mx, my);
							}
						}

						g2.setComposite(AlphaComposite.getInstance(
								AlphaComposite.SRC_OVER, 1.0f));
					}
				}
			}
		}

	}

	public void setImage(BufferedImage image) {
		if (protocol != null) {
			protocol.reset();
			protocol.purgeData();
		}

		if (image != null) {
			if (wizard != null)
				wizard.reset();
			if (resultPanel != null)
				resultPanel.reset();

			// Reset everything topology related
			if (topology != null)
				topology.reset();
			NumberUtility.setDefaultNumberFormat();
			nodes = null;
			branches = null;

			// Add a border to the image
			image = imageOperations.addBorderToImage(image);
			// Convert an ARGB image into an RGB image
			image = imageOperations.convertARGBToRGB(image);

			this.image = image;
			g2 = (Graphics2D) image.createGraphics();
			wizard.wholeImage = new Rectangle2D.Float(32, 32,
					image.getWidth() - 64, image.getHeight() - 64);
			g2.setClip(wizard.wholeImage);
			selection = wizard.wholeImage;
			motif = null;

			this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
			magnifier.setImage(image);
			this.setPreferredSize(new Dimension(image.getWidth(), image
					.getHeight()));
			viewport = scrollPane.getViewport();
			viewport.setView(this);
			scrollPane.revalidate();
			scrollPane.repaint();
			scrollPane.requestFocus();

			// Set the stroke that is used for drawing operations
			defaultStroke = new BasicStroke();
			dashedStroke = new BasicStroke(1, BasicStroke.CAP_BUTT,
					BasicStroke.JOIN_BEVEL, 0, new float[] { 12, 3 }, 0);
			customStroke = defaultStroke;
			// Copy the source image into a buffer
			imageBuffer.storeSourceImage(image);
			imageBuffer.reset();

			// If user has adjusted the blend ratio or the pen/rubber sizes,
			// reset them
			if (guiActions != null) {
				guiActions.drawingStrokeSpinner
				.setValue(defaultDrawingStrokeWidth);
				guiActions.eraserStrokeSpinner
				.setValue(defaultEraserStrokeWidth);
				guiActions.getLeftToolBar().repaint();
				guiActions.resetRatioSlider();
				guiActions.toggleBlendControl(wizard.ratioSliderEnabled); // Activate/inactivate
				// the
				// ratio
				// slider
				guiActions.toggleDrawingTools(true);

			}

			// Clear all user created objects that might exist
			userDrawing = null;
			curveHandle = null;
			curveDrawn = false;
			curveHandleDragging = false;
			if (useProgressPane)
				progressPane.stop();

			if (mainWindow != null)
				mainWindow.changeTitle(wizard.imagePath);
		}
	}

	public void updateImage(BufferedImage image) {
		if (image != null) {
			this.image = image;
			wizard.wholeImage = new Rectangle2D.Float(32, 32,
					image.getWidth() - 64, image.getHeight() - 64);
			magnifier.setImage(image);
			this.setPreferredSize(new Dimension(image.getWidth(), image
					.getHeight()));
			viewport = scrollPane.getViewport();
			viewport.setView(this);
			scrollPane.revalidate();
			resultPanel.reset();
			topology.reset();
			NumberUtility.setDefaultNumberFormat();
		}
	}

	public BufferedImage getOverlayImage(boolean[] params) {
		/*
		 * s[0] = showOnlySource.isSelected(); s[1] =
		 * showOnlyCurrent.isSelected(); s[2] = showBlend.isSelected(); s[3] =
		 * showBranchesWithoutLengths.isSelected(); s[4] =
		 * showBranchesWithLengths.isSelected(); s[5] = showNodes.isSelected();
		 * s[6] = showFloodFill.isSelected(); s[7] = showMarking.isSelected();
		 * s[8] = showFloodOrigin.isSelected(); s[9] =
		 * showSpeciesNames.isSelected(); s[10] = showPaths.isSelected();
		 */

		BufferedImage layerImage = new BufferedImage(image.getWidth(), image
				.getHeight(), BufferedImage.TYPE_INT_RGB);
		Graphics g = layerImage.getGraphics();
		if (g == null)
			return null;
		if (layerImage != null)
			g2.setClip(wizard.wholeImage);
		else
			g2.setClip(scrollPane.getViewport().getViewRect());
		Graphics2D g2 = (Graphics2D) g;
		g2.setColor(Color.white);
		g2.fillRect(0, 0, image.getWidth(), image.getHeight());

		g2.setColor(new Color(wizard.transparentShade));
		if (image != null) {
			g2.fillRect(0, 0, image.getWidth(), image.getHeight());

			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
					RenderingHints.VALUE_ANTIALIAS_OFF);
			g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING,
					RenderingHints.VALUE_COLOR_RENDER_QUALITY);
			g2.setRenderingHint(RenderingHints.KEY_RENDERING,
					RenderingHints.VALUE_RENDER_QUALITY);
			g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS,
					RenderingHints.VALUE_FRACTIONALMETRICS_ON);

			if (params[0]) // Draw only source image
			{
				g2.setComposite(AlphaComposite.getInstance(
						AlphaComposite.SRC_OVER, 1.0f));
				g2.drawImage(imageBuffer.getBlendImage(), 0, 0, this);
			} else if (params[1]) // Draw only current image
			{
				g2.setComposite(AlphaComposite.getInstance(
						AlphaComposite.SRC_OVER, 1.0f));
				g2.drawImage(image, 0, 0, this);
			} else if (params[2]) // Blend source image and current image
				// manipulation state
			{
				// Draw current image and the source image in the desired blend
				// ratio
				g2.setComposite(AlphaComposite.getInstance(
						AlphaComposite.SRC_OVER, wizard.transparencyRatio));
				g2.drawImage(image, 0, 0, this);
				g2.setComposite(AlphaComposite.getInstance(
						AlphaComposite.SRC_OVER, 1 - wizard.transparencyRatio));
				// Add the border width to the origin if the image's sizes
				// differ (that means the image has been cropped before)
				g2.drawImage(imageBuffer.getBlendImage(), 0, 0, this);
			}
		}

		// Draw nodes and branches
		g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
				1.0f));
		// g2.setStroke(customStroke);
		if (wizard.smallMarks)
			g2.setStroke(new BasicStroke(1, BasicStroke.CAP_BUTT,
					BasicStroke.JOIN_BEVEL));
		else
			g2.setStroke(new BasicStroke(2, BasicStroke.CAP_BUTT,
					BasicStroke.JOIN_BEVEL));

		if (branches != null) {
			if ((params[3] || params[4])) // Draw branches
			{
				for (int i = 0; i < branches.size(); i++) {
					Branch branch = (Branch) branches.elementAt(i);
					if (branch != null) {
						TreeNode firstNode = branch.getFirstNode();
						TreeNode secondNode = branch.getSecondNode();
						Point f1 = firstNode.getLocation();
						Point f2 = secondNode.getLocation();

						g2.setColor(Color.green);
						g2.drawLine(f1.x, f1.y, f2.x, f2.y);

						if (params[4]) // Draw branch lengths
						{
							int x1 = f1.x, y1 = f1.y, x2 = f2.x, y2 = f2.y;
							if (branch.getLength() != 0.0d) {
								int mx = (int) ((int) x1 + 0.5 * (x2 - x1)) - 5;
								int my = (int) ((int) y1 + 0.5 * (y2 - y1)) - 5;
								df = NumberUtility.getCurrentNumberFormat();
								String text = df.format(branch.getLength());

								if (textLayout == null) {
									frc = g2.getFontRenderContext();
								}

								if (text.length() != 0) {
									textLayout = new TextLayout(text,
											MainWindow.standardFont10, frc);
									Shape base = textLayout
									.getLogicalHighlightShape(0, text
											.length());
									AffineTransform at = AffineTransform
									.getTranslateInstance(mx, my);
									Shape highlight = at
									.createTransformedShape(base);
									g2.setPaint(Color.white);
									g2.fill(highlight);
									if (!branch.equals(selectedBranch))
										g2.setColor(Color.black);
									else
										g2.setColor(branchSelectedColor);
									textLayout.draw(g2, mx, my);
								}
							}
						}
					}
				}
			}
		}

		if (params[10]) // Show paths
		{
			for (int i = 0; i < branches.size(); i++) {
				Branch branch = (Branch) branches.elementAt(i);
				if (branch != null) {
					g2.setStroke(new BasicStroke(1, BasicStroke.CAP_BUTT,
							BasicStroke.JOIN_BEVEL));

					int numSegments = branch.getNumSegments();

					Vector<Integer> lengthRelevant = branch
					.getSegLengthRelevant();
					for (int j = 0; j < numSegments; j++) {
						int relevancy = lengthRelevant.elementAt(j);
						if (relevancy == RELEVANT)
							g2.setColor(Color.red);
						else if (relevancy == IRRELEVANT)
							g2.setColor(Color.black);
						else
							g2.setColor(Color.lightGray);

						Vector<Point> points = branch.getPathSegmentPoints(j);
						if (points != null) {
							Iterator<Point> pit = points.iterator();
							while (pit.hasNext()) {
								Point p = (Point) pit.next();
								if (wizard.smallMarks)
									g2.fillRect(p.x, p.y, 1, 1);
								else
									g2.fillRect(p.x, p.y, 2, 2);
							}
						}
					}
				}
			}
		}

		if (nodes != null) {
			if (params[5]) // Draw nodes
			{
				for (int i = 0; i < nodes.size(); i++) {
					TreeNode node = (TreeNode) nodes.elementAt(i);
					if (node != null) {
						if (node instanceof Tip) {
							g2.setColor(tipColor);
							if (wizard.highlightTipsWithoutName) {
								// If the name of this tip is empty or numeric,
								// highlight this tip
								if ((((Tip) node).getTaxonName() == null)
										|| (((Tip) node).getTaxonName()
												.equals("")))
									g2.setColor(tipHighlightedColor);

								int intValue = -1;
								try {
									intValue = Integer.parseInt(((Tip) node)
											.getTaxonName());
								} catch (NumberFormatException e) {
								}
								;
								if (intValue != -1)
									g2.setColor(tipHighlightedColor); // A
								// numeric
								// tip
								// name
								// is
								// not
								// desired
							}
						} else // Node is an inner node
						{
							if (node instanceof InnerNode)
								g2.setColor(nodeColor);
							if (wizard.referenceNodeId == node.getId())
								g2.setColor(referenceNodeColor);
						}

						if (wizard.smallMarks)
							g2.fill(node.getSmallShape());
						else
							g2.fill(node.getShape());
					}
				}
			}
		}

		if (params[9]) // Draw species names
		{
			for (int i = 0; i < nodes.size(); i++) {
				TreeNode node = (TreeNode) nodes.elementAt(i);
				if ((node instanceof Tip)
						&& (((Tip) node).getTaxonName() != null)) {
					int mx = node.getX() - 10;
					int my = node.getY() - 10;
					String text = ((Tip) node).getTaxonName();

					if (textLayout == null) {
						frc = g2.getFontRenderContext();
					}

					if (text.length() != 0) {
						g2.setFont(MainWindow.standardFont12);
						textLayout = new TextLayout(text,
								MainWindow.standardFont12, frc);
						Shape base = textLayout.getLogicalHighlightShape(0,
								text.length());
						AffineTransform at = AffineTransform
						.getTranslateInstance(mx, my);
						Shape highlight = at.createTransformedShape(base);
						g2.setPaint(Color.white);
						g2.fill(highlight);
						if (selectedNode == node)
							g2.setColor(selectionColor);
						else
							g2.setColor(Color.black);
						textLayout.draw(g2, mx, my);
					}
				}
			}
		}

		if (params[7]) // Draw the user selection
		{
			if (selection != null) {
				g2.setStroke(dashedStroke);
				g2.setColor(Color.red);
				g2.draw(selection);
			}
		}

		if (params[8]) // Show flood origin
		{
			g2.setColor(new Color(wizard.treeFloodColor));
			g2.drawLine(wizard.floodSeed.x - 5, wizard.floodSeed.y - 5,
					wizard.floodSeed.x + 5, wizard.floodSeed.y + 5);
			g2.drawLine(wizard.floodSeed.x - 5, wizard.floodSeed.y + 5,
					wizard.floodSeed.x + 5, wizard.floodSeed.y - 5);
		}

		return layerImage;
	}

	public void issueSnapshot(BufferedImage image) {

		if (protocol != null) {
			protocol.reset();
			protocol.purgeData();
		}

		// Adjust the GUI control elements with respect to the modified
		// parameters
		guiActions.adjustControls();

		this.selection = null;
		this.image = image;
		if (image != null) {
			g2 = (Graphics2D) image.createGraphics();
			wizard.wholeImage = new Rectangle2D.Float(32, 32,
					image.getWidth() - 64, image.getHeight() - 64);
			selection = wizard.wholeImage;
			magnifier.setImage(image);
			this.setPreferredSize(new Dimension(image.getWidth(), image
					.getHeight()));
			viewport.setView(this);
			scrollPane.revalidate();
			mainWindow.changeTitle(wizard.imagePath);
		}
	}

	// Switches the Modes BLACK_PEN, ERASER, RECT_SEL etc.
	// Actions and Modes share the same set of constants
	public void setMode(int m) {
		this.mode = m;
		repaint();
		switchCursor();

		// Set the stroke width
		if ((mode == Activity.ERASER) || (mode == Activity.WHITE_LINE))
			setEraserStrokeWidth(wizard.eraserStrokeWidth);
		else if ((mode == Activity.BLACK_LINE) || (mode == Activity.BLACK_PEN)
				|| (mode == Activity.QUADCURVE))
			setDrawingStrokeWidth(wizard.drawingStrokeWidth);

	}

	public void performAction(int action) {
		boolean proceed = true;
		if (action == Activity.SCALE05X) {
			proceed = showConfirmationDialog("Do nothing", "Scale Image",
			"'Scale 0.5x' cannot be undone. Nodes and branches get lost.\nProceed anyway?");
		} else if (action == Activity.SCALE2X) {
			proceed = showConfirmationDialog("Do nothing", "Scale Image",
			"'Scale 2x' cannot be undone. Nodes and branches get lost.\nProceed anyway?");
		} else if (action == Activity.SUBIMAGE) {
			proceed = showConfirmationDialog("Do nothing", "Crop Image",
			"'Crop' cannot be undone. Nodes and branches get lost.\nProceed anyway?");
		}

		if (proceed) {
			actionPerformer = new Thread(new ActionPerformer(action));
			actionPerformer.start();

			// Display the progress pane only if either a box selection or a
			// line selection with a sensible size is there
			if ((selection instanceof Rectangle2D)
					&& (((Rectangle2D) selection).getWidth() > 1)
					&& (((Rectangle2D) selection).getHeight() > 1)) {
				if (useProgressPane)
					startProgressPane();
			}
		}
	}

	class ActionPerformer implements Runnable {
		int action = 0;
		Rectangle areaOfInfluence = new Rectangle();

		public ActionPerformer(int action) {
			this.action = action;
			lastActionId = this.action;
		};

		public int getActionId() {
			return this.action;
		};

		public void run() {
			// Performs the Actions FILL_SEL, TRIM_SEL, INVERT_IMAGE etc.
			// Actions and modes share the same set of constants
			// Each action ("activity") the image area that has been manipulated
			// by its operation
			try {
				repaint();
				statusBar.reset();
				ip.requestFocus();

				if ((action == Activity.FILL_BLACK)
						|| (action == Activity.FILL_WHITE)) {
					if (selection != null) {
						// Store the action in the activity protocol
						areaOfInfluence = selection.getBounds();
						Rectangle2D rect = protocol.recordActivity(this.action,
								areaOfInfluence);

						// Fill the area under the selection with Color white
						g2 = (Graphics2D) image.getGraphics();
						if (action == Activity.FILL_BLACK)
							g2.setColor(new Color(BIN1));
						else
							g2.setColor(new Color(BIN0));
						g2.fill(rect);
						scrollPane.repaint();
					}
				} else if (action == Activity.CLEAR_IMAGE) {
					// Store the action in the activity protocol
					areaOfInfluence = wizard.wholeImage.getBounds();
					protocol.recordActivity(this.action, areaOfInfluence);
					g2 = (Graphics2D) image.getGraphics();
					g2.setColor(new Color(BIN0));
					g2.fill(wizard.wholeImage);
					scrollPane.repaint();
					magnifier.setImage(image);
				} else if (action == Activity.FLOOD_FILL) // Tree FloodFill
					// operation
				{
					// FloodFill aids a marking task and is excluded from the
					// undo history
					doFloodFill();
					mode = recentMode;
					switchCursor();
				} else if (action == Activity.SUBIMAGE) // "CROP"
				{
					if (selection != null) {
						// Get the area within the selection as a new image
						updateImage(imageOperations.getSubImage(image,
								selection, true));
						imageBuffer.cropBlendImage(selection); // Blend image
						// needs also to
						// be cropped
						wizard.wholeImage = new Rectangle2D.Float(32, 32, image
								.getWidth() - 64, image.getHeight() - 64);
						g2 = (Graphics2D) image.getGraphics();
						g2.setClip(wizard.wholeImage);
						wizard.imageCropped = true;
						selection = wizard.wholeImage;
						magnifier.setImage(image);

						// Remove all nodes and branches as the image has
						// changed
						nodes.removeAllElements();
						branches.removeAllElements();
						topology.reset();
						NumberUtility.setDefaultNumberFormat();

						// Clear Newick String
						resultPanel.reset();

						// Clear Undo history
						protocol.reset();
						protocol.purgeData();

						// Initialize FloodFill location
						wizard.floodSeed = null;
					}
				} else if (action == Activity.GLOBAL_COLORCHANGE) {
					// Modifies either a single color or a set of colors
					// depending on the modi set in the ColorRangeManipulation
					// dialog

					if (wizard.colReplace) // Replace one color or a set of
						// colors with another color
					{
						if (wizard.colExactColor) // Replace one color
						{
							HashSet<Integer> singleColorSet = new HashSet<Integer>();
							singleColorSet.add(wizard.fromColor);
							image = imageOperations.replaceColorSet(image,
									selection, singleColorSet, wizard.toColor);
						} else if (wizard.colSelectionColors) // Replace all
							// colors within
							// the user
							// selection box
						{
							if ((wizard.colorSet != null)
									&& (wizard.colorSet.size() != 0)) {
								image = imageOperations.replaceColorSet(image,
										selection, wizard.colorSet,
										wizard.toColor);
							}
						}
					} else if (wizard.colKeep) // Keep one color or a set of
						// colors, replace all others
						// with another color
					{
						if (wizard.colExactColor) // Keep one color, replace the
							// rest
						{
							HashSet<Integer> singleColorSet = new HashSet<Integer>();
							singleColorSet.add(wizard.fromColor);
							image = imageOperations.keepColorSet(image,
									selection, singleColorSet, wizard.toColor);
						} else if (wizard.colSelectionColors) // Keep colors
							// within the
							// user
							// selection
							// box, replace
							// the rest
						{
							if (wizard.colorSet.size() != 0)
								image = imageOperations.keepColorSet(image,
										selection, wizard.colorSet,
										wizard.toColor);
						}
					}

					g2 = (Graphics2D) image.getGraphics();
					g2.setClip(wizard.wholeImage);
					magnifier.setImage(image);
				} else if (action == Activity.SCALE2X) {
					updateImage(imageOperations.scaleImage2x(image, true));
					BufferedImage newSrcImage = imageOperations.scaleImage2x(
							imageBuffer.getSourceImage(), true);
					imageBuffer.storeSourceImage(newSrcImage);
					imageBuffer.storeBinarizedImage(null);
					wizard.wholeImage = new Rectangle2D.Float(32, 32, image
							.getWidth() - 64, image.getHeight() - 64);
					g2 = (Graphics2D) image.getGraphics();
					g2.setClip(wizard.wholeImage);
					selection = wizard.wholeImage;
					magnifier.setImage(image);

					// Remove all nodes and branches as the image has changed
					nodes.removeAllElements();
					branches.removeAllElements();
					topology.reset();
					NumberUtility.setDefaultNumberFormat();

					// Clear Newick String
					resultPanel.reset();

					// Clear Undo history
					protocol.reset();
					protocol.purgeData();

					// Delete FloodFill location
					wizard.floodSeed = null;

				} else if (action == Activity.SCALE05X) {

					updateImage(imageOperations.scaleImage05x(image, true));
					BufferedImage newSrcImage = imageOperations.scaleImage05x(
							imageBuffer.getSourceImage(), true);
					imageBuffer.storeSourceImage(newSrcImage);
					imageBuffer.storeBinarizedImage(null);
					wizard.wholeImage = new Rectangle2D.Float(32, 32, image
							.getWidth() - 64, image.getHeight() - 64);
					g2 = (Graphics2D) image.getGraphics();
					g2.setClip(wizard.wholeImage);
					selection = wizard.wholeImage;
					magnifier.setImage(image);

					// Remove all nodes and branches as the image has changed
					nodes.removeAllElements();
					branches.removeAllElements();

					topology.reset();
					NumberUtility.setDefaultNumberFormat();

					// Clear Newick String
					resultPanel.reset();

					// Clear Undo history
					protocol.reset();
					protocol.purgeData();

					// Delete FloodFill location
					wizard.floodSeed = null;

				} else if (action == Activity.TRIM) {
					if (selection != null) {
						areaOfInfluence = wizard.wholeImage.getBounds();
						Rectangle2D rect = protocol.recordActivity(this.action,
								areaOfInfluence);

						// Get the area within the selection as a new image
						imageOperations.trimImage(image, selection);
						// Fill the border gray (gray is the transparency color)
						if (wizard != null) {
							Graphics2D g2 = (Graphics2D) image.getGraphics();
							g2.setPaint(new Color(defaultTransparencyShade));
							Area imageArea = new Area(new Rectangle2D.Double(0,
									0, image.getWidth(), image.getHeight()));
							Area trimArea = new Area(wizard.wholeImage
									.getBounds2D());
							imageArea.subtract(trimArea);
							g2.fill(imageArea);
						}

						magnifier.setImage(image);
						scrollPane.revalidate();
						scrollPane.repaint();

						// Remove all nodes and branches as the image has
						// changed
						nodes.removeAllElements();
						branches.removeAllElements();
						topology.reset();
						NumberUtility.setDefaultNumberFormat();

						// Clear Newick String
						resultPanel.reset();

						// Delete FloodFill location
						wizard.floodSeed = null;
					}
				} else if (action == Activity.INVERT) {
					if (selection != null) {
						areaOfInfluence = selection.getBounds();
						Rectangle2D rect = protocol.recordActivity(this.action,
								areaOfInfluence);

						restorePixelColors();
						imageOperations.invertImage(image, rect);
						magnifier.setImage(image);
					} else
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
				} else if (action == Activity.SHARPEN) {
					if (selection != null) {
						image = imageOperations.sharpenUSM(image, selection,
								wizard.usmKernelWidth, wizard.usmFactor);
						magnifier.setImage(image);
					} else {
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
					}
				} else if (action == Activity.BINARIZE) {
					if (selection != null) {
						image = imageOperations.binarizeImage(image, selection,
								wizard.threshold);
						magnifier.setImage(image);

						// If the whole image is binarized, store it in memory
						// for the node detection heuristic
						imageBuffer.storeBinarizedImage(image);
					} else {
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
					}
				} else if (action == Activity.GREYSCALE_CONVERSION) {
					if (selection != null) {
						image = imageOperations.convertToGreyscale(image,
								selection, wizard.greyscaleFactors);
						magnifier.setImage(image);
						imageBuffer.storeBinarizedImage(image);
					} else {
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
					}
				} else if (action == Activity.AUTO_BINARIZE) {
					if (selection != null) {

						areaOfInfluence = selection.getBounds();
						Rectangle2D rect = protocol.recordActivity(this.action,
								areaOfInfluence);

						double factor = 0.8;
						double sigma = 5;
						image = imageOperations.autoGaussBinarization(image,
								rect, sigma, factor);
						magnifier.setImage(image);
						if (selection == wizard.wholeImage)
							imageBuffer.storeBinarizedImage(image);
					} else {
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
					}
				} else if (action == Activity.HISTOGRAM_STRETCH) {
					if (selection != null) {
						areaOfInfluence = selection.getBounds();
						Rectangle2D rect = protocol.recordActivity(this.action,
								areaOfInfluence);

						imageOperations.computeGrayscaleHistogram(image, rect);
						image = imageOperations.stretchHistogram(image, rect);
						magnifier.setImage(image);
					} else {
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
					}
				} else if (action == Activity.DESPECKLE) {
					if (selection != null) {
						image = imageOperations.despeckleImage(image,
								selection, wizard.medianRectWidth);
						magnifier.setImage(image);
					} else {
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
					}
				} else if (action == Activity.BRIGHTNESS) {
					if (selection != null) {
						image = imageOperations.brightenImage(image, selection,
								wizard.contrastFactor, wizard.brightnessOffset);
						magnifier.setImage(image);
					} else {
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
					}
				} else if (action == Activity.MINIMUM_OP) {
					if (selection != null) {
						image = imageOperations.locAdaptMinMax(image,
								selection, wizard.minMaxRectWidth);
						magnifier.setImage(image);
					} else {
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
					}
				} else if (action == Activity.COLOR_QUANTIZATION) {
					image = imageOperations.quantizeColors(image,
							wizard.quantNumColors);
					magnifier.setImage(image);
				} else if (action == Activity.SMOOTH) {
					if (selection != null) {
						image = imageOperations.smoothImage(image, selection,
								wizard.kernelWidth);
						magnifier.setImage(image);
					} else {
						statusBar.showMessage("Select a portion of the image.",
								image, oldMouseCoords);
					}
				} else if (action == Activity.SKELETONIZE) {
					if (selection != null) {
						if (imageOperations.isBinarized(image, selection)) {
							Rectangle areaOfInfluence = selection.getBounds();
							Rectangle2D rect = protocol.recordActivity(
									this.action, areaOfInfluence);

							wizard.isBinarized = true;
							wizard.isSkeletonized = true;
							imageOperations.skeletonizeImage(image, rect);
							viewport = scrollPane.getViewport();
							viewport.setView(ip);
							scrollPane.revalidate();
							imageOperations.delete1PixelBranches(image, rect); // Mandatory:
							// first
							// delete1PixelBranches
							imageOperations.deleteCornerPixels(image, rect); // then
							// deleteCornerPixels
							magnifier.setImage(image);
						} else
							statusBar.showMessage(
									"The image portion is not yet binarized.",
									image, oldMouseCoords);
					} else
						statusBar.showMessage("No image portion selected",
								image, oldMouseCoords);
				} else if (action == Activity.EXTRACT_AREA) {
					if (wizard.floodSeed != null) {
						Rectangle areaOfInfluence = wizard.wholeImage
						.getBounds();
						Rectangle2D rect = protocol.recordActivity(this.action,
								areaOfInfluence);

						int x = wizard.floodSeed.x;
						int y = wizard.floodSeed.y;
						imageOperations.localFloodFill8NB(image, rect, x, y,
								BIN1, wizard.treeFloodColor);
						imageOperations.swapPixelColors(image,
								wizard.wholeImage, BIN1, BIN0); // Set all
						// foreground
						// pixels to
						// background
						// shade, except
						// green ones
						restorePixelColors();
						magnifier.setImage(image);
						scrollPane.repaint();
						wizard.floodedAreaExtracted = true;
					} else
						statusBar
						.showMessage(
								"Cannot extract the foreground that represents the tree: Initiate a Tree FloodFill.",
								image, oldMouseCoords);
				} else if (action == Activity.FIND_NODES) {
					if (wizard.floodSeed != null) {
						protocol.recordActivity(this.action, topology
								.getSerializedTopology());

						int x = wizard.floodSeed.x;
						int y = wizard.floodSeed.y;
						imageOperations.blackenFGPixels(image, BIN0, selection);
						imageOperations.localFloodFill8NB(image, selection, x,
								y, BIN1, wizard.treeFloodColor);

						ip.validate();
						Tip.resetNameCount(); // Reset node instantiation count
						// (problem because of user
						// generated nodes)
						TreeNode.signalNode = -1; // As no topology error is
						// known, no need to
						// highlight a node
						topology.removeAllNodes(); // Remove all except user
						// created objects
						topology.removeAllBranches();
						NumberUtility.setDefaultNumberFormat(); // Return to
						// default
						// number format
						// (no fraction
						// digits)
						Branch.maxFractionDigits = 0;
						topology.collectTips(wizard.treeFloodColor); // Only
						// investigate
						// pixels
						// in
						// treeFloodColor
						topology.collectNodes(wizard.treeFloodColor);
						topology.wipeOutDoublettes(); // Discard
						// program-generated
						// nodes too near to a
						// user generated nodes
						wizard.nodesCollected = true;
						imageOperations.blackenFGPixels(image, BIN0, selection); // Turn
						// the
						// manipulated
						// foreground
						// black
						// again

					} else
						statusBar
						.showMessage(
								"You have not yet informed the program about where the tree is: Initiate a Flood Fill",
								image, oldMouseCoords);
				} else if (action == Activity.FIND_BRANCHES) {
					if (nodes.size() > 1) {
						// Tweak the lookahead distance parameter needed for the
						// path finding algorithm
						if (wizard.userLookaheadDistance == wizard.lookaheadDistance) {
							wizard.lookaheadDistance = Math.min(
									maximumLookaheadDistance, topology
									.getLowestPairwiseDistance());
						} else {
							wizard.lookaheadDistance = wizard.userLookaheadDistance;
						}
						guiActions.lookaheadSpinner
						.setValue(wizard.lookaheadDistance);

						protocol.recordActivity(this.action, topology
								.getSerializedTopology());
						wizard.branchesCollecting = true;
						ip.validate();
						Branch.signalBranch = -1;
						imageOperations.blackenFGPixels(image, BIN0, selection);
						topology.removeAllBranches();
						NumberUtility.setDefaultNumberFormat();
						Branch.maxFractionDigits = 0;

						boolean topologyValid = topology.collectBranches();

						// Method must remain inactivated unless it is clear how
						// Branch.getLength() is used correctly

						wizard.branchesCollecting = false;
						if (topologyValid) {
							topology.transformIntoNewickExpression();
							updateResultFrame();
						} else
							statusBar
							.showMessage(
									"Could not build the topology: Either some nodes are too near, or there are only inner nodes or only tips",
									image, oldMouseCoords);
					} else
						statusBar.showMessage(
								"There must be at least two nodes.", image,
								oldMouseCoords);
				} else if (action == Activity.INSERT_ROOT) {

				} else if (action == Activity.BRANCH_LENGTH) {
					if (useProgressPane)
						progressPane.stop();

					if (selectedBranch != null) {
						// Let the user input the length of this branch
						double length = 1.0d;
						String lengthString;
						boolean keyEntryOK, cancelPressed;

						do {
							keyEntryOK = true;
							cancelPressed = false;
							lengthString = null;

							do {
								try {
									// Here occurs the JAVA error described at
									// http://lists.apple.com/archives/java-dev/2008/Sep/msg00323.html
									lengthString = JOptionPane.showInputDialog(
											ip, "Enter length of this branch:",
											"Manual Branch Length",
											JOptionPane.QUESTION_MESSAGE);
									if (lengthString != null) {
										length = java.lang.Double
										.parseDouble(lengthString);
									} else
										cancelPressed = true;
								} catch (NumberFormatException ex) {
									keyEntryOK = false;
								}
								;
							} while ((length < 0.0d)
									|| (length > java.lang.Double.MAX_VALUE));
						} while ((keyEntryOK == false)
								&& (cancelPressed == false));

						if (keyEntryOK) {
							if (cancelPressed == false) {
								Vector v = new Vector();
								v.add((Integer) selectedBranch.getId());
								v.add((Double) selectedBranch.getLength());

								protocol.recordActivity(this.action, v);

								selectedBranch.setUserAssignedLength(length);
								NumberUtility.setNumFractionDigits(branches);

								ip.repaint();
								topology.redisplayNewickExpression();
							}
						}
					}

				} else if (action == Activity.NAME_TAXON) {
					if (useProgressPane)
						progressPane.stop();

					if ((selectedNode != null) && (selectedNode instanceof Tip)) {
						String taxonName = JOptionPane.showInputDialog(ip,
								"Enter name of this taxon:", "Taxon Name",
								JOptionPane.QUESTION_MESSAGE);

						// Accept the new name only if it is neither null nor a
						// sequence of spaces
						if ((taxonName != null) && (!taxonName.equals(""))
								&& (!taxonName.matches(" +"))) {
							Vector v = new Vector();
							v.add((Integer) selectedNode.getId());
							v.add(((Tip) selectedNode).getTaxonName());
							protocol.recordActivity(this.action, v);
							((Tip) selectedNode).setTaxonName(taxonName);
							topology.redisplayNewickExpression();
						}
					} else
						statusBar.showMessage(
								"There must be an outer node selected.", image,
								oldMouseCoords);
				} else if (action == Activity.ADD_INNERNODE) {
					protocol.recordActivity(this.action, topology
							.getSerializedTopology());
					Point insertionPosition = getInsertionPosition();
					if (insertionPosition != null) {
						topology.addInnerNode(insertionPosition);
					}
				} else if (action == Activity.ADD_TIP) {
					protocol.recordActivity(this.action, topology
							.getSerializedTopology());
					Point insertionPosition = getInsertionPosition();
					if (insertionPosition != null) {
						topology.addTip(insertionPosition);
					}
				} else if (action == Activity.REMOVE_NODE) {

					{
						protocol.recordActivity(this.action, topology
								.getSerializedTopology());
						topology.removeNode(getSelectedNode());

					}

				} else if (action == Activity.REMOVE_BRANCH) {
					protocol.recordActivity(this.action, topology
							.getSerializedTopology());
					topology.removeBranch(getSelectedBranch());
				} else if (action == Activity.REMOVE_SELECTED_NODES) {
					protocol.recordActivity(this.action, topology
							.getSerializedTopology());
					topology.removeNodes(getNodesInSelection());
					if ((topology.getNodes() != null)
							&& (topology.getNodes().size() == 0)) {
						wizard.topologyDeterminationFinished = false;
					}
				} else if (action == Activity.REMOVE_SELECTED_BRANCHES) {
					protocol.recordActivity(this.action, topology
							.getSerializedTopology());
					topology.removeBranches(getBranchesInSelection());
				} else if (action == Activity.GRAB_MOTIF) {
					if (useProgressPane)
						progressPane.stop();
					motif = imageOperations.copySubImage(image, selection);
				} else if (action == Activity.AS_REFERENCE_NODE) {
					if (useProgressPane)
						progressPane.stop();

					if (selectedNode != null) {
						if (selectedNode instanceof InnerNode) {
							// Store the action in the activity protocol
							protocol.recordActivity(this.action,
									wizard.referenceNodeId);

							wizard.referenceNodeId = selectedNode.getId();
							if (TreeNode.signalNode == selectedNode.getId())
								TreeNode.signalNode = -1;
							topology.redisplayNewickExpression();
						} else
							statusBar
							.showMessage(
									"Cannot build up the tree starting from a tip",
									image, oldMouseCoords);
					} else
						statusBar.showMessage(
								"No inner node has been selected so far.",
								image, oldMouseCoords);
				} else if (action == Activity.SCALE_USING_BRANCH_LENGTH_1) {
					if (selectedBranch != null) {
						Wizard.scaleBarLengthInPixels = selectedBranch
						.getComposedLengthInPixels();
						Wizard.manualScaleBarLength = 1.0d;

						// Adjust the number of fractional digits used for
						// displaying all branch lengths
						NumberUtility.setNumFractionDigits(branches);
						NumberUtility
						.setMaxNumFractionDigits(defaultMaxNumFractionDigits);
						repaint();

						// Update the Newick expression
						updateResultFrame();

						if (useProgressPane)
							stopProgressPane();
						actionPerformer = null;
					} else
						statusBar.showMessage(
								"No branch has been selected so far.", image,
								oldMouseCoords);

				} else if (action == Activity.SCALE_USING_SPECIFIED_BRANCH_LENGTH) {
					if (selectedBranch != null) {
						Wizard.scaleBarLengthInPixels = selectedBranch
						.getComposedLengthInPixels();
						Wizard.manualScaleBarLength = 1.0d; // Default

						// Let the user input the length of the scale bar
						double manualLength = 1.0d;
						String lengthString;
						boolean keyEntryOK, cancelPressed;

						do {
							keyEntryOK = true;
							cancelPressed = false;
							lengthString = null;

							do {
								try {
									// Here occurs the JAVA error described at
									// http://lists.apple.com/archives/java-dev/2008/Sep/msg00323.html
									lengthString = JOptionPane
									.showInputDialog(
											ip,
											"Enter branch length:",
											"Scale tree with manual branch length",
											JOptionPane.QUESTION_MESSAGE);
									if (lengthString != null) {
										manualLength = java.lang.Double
										.parseDouble(lengthString);
									} else
										cancelPressed = true;
								} catch (NumberFormatException ex) {
									keyEntryOK = false;
								}
								;
							} while ((manualLength <= 0.0f)
									|| (manualLength > java.lang.Float.MAX_VALUE));
						} while ((keyEntryOK == false)
								&& (cancelPressed == false));

						if (keyEntryOK) {
							if (cancelPressed == false) {
								Wizard.manualScaleBarLength = manualLength;
							}
							;
						}

						// Adjust the number of fractional digits used for
						// displaying all branch lengths
						NumberUtility.setNumFractionDigits(branches);
						NumberUtility
						.setMaxNumFractionDigits(defaultMaxNumFractionDigits);
						repaint();

						// Update the Newick expression
						updateResultFrame();

						if (useProgressPane)
							stopProgressPane();
						actionPerformer = null;
					} else
						statusBar.showMessage(
								"No branch has been selected so far.", image,
								oldMouseCoords);

				} else if (action == Activity.SCALE_BAR_LENGTH) {
					if ((useProgressPane) && (progressPane != null))
						progressPane.stop();

					if ((selection != null) && (selection instanceof Line2D)) {
						Line2D scaleBar = (Line2D) selection;
						Point2D p1 = scaleBar.getP1();
						Point2D p2 = scaleBar.getP2();
						double dx = p1.getX() - p2.getX();
						double dy = p1.getY() - p2.getY();
						Wizard.scaleBarLengthInPixels = (int) Math
						.sqrt((dx * dx) + (dy * dy));

						// Let the user input the length of the scale bar
						double manualScaleBarLength = 1.0d;
						String lengthString;
						boolean keyEntryOK, cancelPressed;

						do {
							keyEntryOK = true;
							cancelPressed = false;
							lengthString = null;

							do {
								try {
									// Here occurs the JAVA error described at
									// http://lists.apple.com/archives/java-dev/2008/Sep/msg00323.html
									lengthString = JOptionPane.showInputDialog(
											ip, "Enter length of scale bar:",
											"Enter Tree Scale",
											JOptionPane.QUESTION_MESSAGE);
									if (lengthString != null) {
										manualScaleBarLength = java.lang.Double
										.parseDouble(lengthString);
									} else
										cancelPressed = true;
								} catch (NumberFormatException ex) {
									keyEntryOK = false;
								}
								;
							} while ((manualScaleBarLength <= 0.0f)
									|| (manualScaleBarLength > java.lang.Float.MAX_VALUE));
						} while ((keyEntryOK == false)
								&& (cancelPressed == false));

						if (keyEntryOK) {
							if (cancelPressed == false) {
								Wizard.manualScaleBarLength = manualScaleBarLength;
							}

						}
					} else
						statusBar
						.showMessage(
								"Need an active line selection to measure a distance.",
								image, oldMouseCoords);
				}

				scrollPane.repaint();

				// Adjust the number of fractional digits used for displaying
				// all branch lengths
				NumberUtility.setNumFractionDigits(branches);
				NumberUtility
				.setMaxNumFractionDigits(defaultMaxNumFractionDigits);
				repaint();

				// Update the Newick expression
				updateResultFrame();

				if (useProgressPane)
					stopProgressPane();
				actionPerformer = null;
			} catch (Exception e) {
				if (useProgressPane)
					stopProgressPane();
				actionPerformer = null;
			} catch (OutOfMemoryError m) {
				if (useProgressPane)
					stopProgressPane();
				actionPerformer = null;
				System.out
				.println("Out of memory error - cannot perform desired operation");
			}
		}
	}

	// ----------------------------Mouse Listener
	// --------------------------------------------------------

	public void mouseClicked(MouseEvent e) {
		try {
			// if (e.getButton() == MouseEvent.BUTTON1)
			if (e.isMetaDown() == false) {
				if (g2 != null) {
					g2.setClip(wizard.wholeImage);

					if (mode == Activity.BLACK_PEN) {
						g2.setStroke(customStroke);
						g2.setColor(new Color(BIN1));
						lineStart.move(e.getX(), e.getY());
						g2.setColor(Color.black);
						g2.drawLine(lineStart.x, lineStart.y, e.getX(), e
								.getY());
						autoSkeletonize(e.getPoint(), image);
						autoFloodFill();

						// Store area (one point)
						drawingPath.moveTo(e.getX(), e.getY());
						drawingPath.closePath();
						Rectangle2D rect = drawingPath.getBounds2D();
						int offset = wizard.drawingStrokeWidth;
						int x = Math.max(0, (int) rect.getX() - 1 - offset);
						int y = Math.max(0, (int) rect.getY() - 1 - offset);
						int w = Math.min(image.getWidth(), (int) rect
								.getWidth()
								+ 2 + 2 * offset);
						int h = Math.min(image.getHeight(), (int) rect
								.getHeight()
								+ 2 + 2 * offset);
						Rectangle areaOfInfluence = new Rectangle(x, y, w, h);
						protocol.recordActivity(mode, areaOfInfluence);
						drawingPath.reset();

					} else if (mode == Activity.ERASER) {
						g2.setStroke(eraserStroke);
						g2.setColor(new Color(BIN0));
						lineStart.move(e.getX(), e.getY());
						g2.drawLine(lineStart.x, lineStart.y, e.getX(), e
								.getY());
						autoSkeletonize(e.getPoint(), image);
						autoFloodFill();

						// Store area (one point)
						drawingPath.moveTo(e.getX(), e.getY());
						drawingPath.closePath();
						Rectangle2D rect = drawingPath.getBounds2D();
						int offset = wizard.eraserStrokeWidth;
						int x = Math.max(0, (int) rect.getX() - 1 - offset);
						int y = Math.max(0, (int) rect.getY() - 1 - offset);
						int w = Math.min(image.getWidth(), (int) rect
								.getWidth()
								+ 2 + 2 * offset);
						int h = Math.min(image.getHeight(), (int) rect
								.getHeight()
								+ 2 + 2 * offset);
						Rectangle areaOfInfluence = new Rectangle(x, y, w, h);
						protocol.recordActivity(mode, areaOfInfluence);
						drawingPath.reset();
					} else if ((mode == Activity.BLACK_LINE)
							|| (mode == Activity.WHITE_LINE)) {
						g2.setStroke(customStroke);
						lineStart.move(e.getX(), e.getY());

						// Store area (one point wide)
						drawingPath.moveTo(e.getX(), e.getY());
						drawingPath.closePath();
						Rectangle2D rect = drawingPath.getBounds2D();
						int offset = wizard.drawingStrokeWidth;
						int x = Math.max(0, (int) rect.getX() - 1 - offset);
						int y = Math.max(0, (int) rect.getY() - 1 - offset);
						int w = Math.min(image.getWidth(), (int) rect
								.getWidth()
								+ 2 + 2 * offset);
						int h = Math.min(image.getHeight(), (int) rect
								.getHeight()
								+ 2 + 2 * offset);
						Rectangle areaOfInfluence = new Rectangle(x, y, w, h);
						protocol.recordActivity(mode, areaOfInfluence);
						drawingPath.reset();

					} else if (mode == Activity.QUADCURVE) {
						if (!curveDrawn) {
							g2.setStroke(customStroke);
							curveStart.move(e.getX(), e.getY()); // Also used as
							// the
							// starting
							// point of
							// this
							// curve
							curveEnd.move(e.getX(), e.getY());
							userDrawing = new QuadCurve2D.Float(e.getX(), e
									.getY(), e.getX(), e.getY(), e.getX(), e
									.getY());
						}
					} else if (mode == Activity.PIPETTE) {
						wizard.lastColorPicked = image.getRGB(e.getX(), e
								.getY());
						Color c = new Color(wizard.lastColorPicked);
						guiActions.handlePickedColor(wizard.lastColorPicked);
						statusBar.showMessage("You picked RGB Color ("
								+ c.getRed() + ", " + c.getGreen() + ", "
								+ c.getBlue() + ") at location (" + e.getX()
								+ ", " + e.getY() + ")", image, oldMouseCoords);
					} else if (mode == Activity.FILL) {
						int x = e.getX();
						int y = e.getY();

						Rectangle areaOfInfluence = wizard.wholeImage
						.getBounds();
						protocol.recordActivity(mode, areaOfInfluence);

						imageOperations.localFloodFill4NB(image,
								wizard.wholeImage, x, y, image.getRGB(x, y),
								wizard.localFillColor);

						magnifier.setImage(image);
						magnifier.repaint();
					} else if (mode == Activity.STENCIL) {
						if (motif != null) {
							// Calculate the affected area
							Rectangle areaOfInfluence = new Rectangle(e.getX(),
									e.getY(), e.getX() + motif.getWidth(), e
									.getY()
									+ motif.getHeight());
							protocol.recordActivity(mode, areaOfInfluence);

							imageOperations.copyIntoImage(image, motif, e
									.getX(), e.getY(), wizard.wholeImage);
							magnifier.setImage(image);
							magnifier.repaint();
						} else
							statusBar.showMessage(
									"There is no motif to paste.", image,
									oldMouseCoords);
					} else if (mode == Activity.RECT_SEL) {
						upperLeft.move(e.getX(), e.getY());
						oldMouseCoords = new Point(e.getX(), e.getY());
						if (lowerRight != null)
							selection = imageOperations.getShape(upperLeft,
									lowerRight);
					} else if (mode == Activity.LINE_SEL) {
						upperLeft.move(e.getX(), e.getY());
						oldMouseCoords = new Point(e.getX(), e.getY());
						if (lowerRight != null)
							selection = new Line2D.Float(upperLeft, lowerRight);
					}
				}
			}
		} catch (Exception ex) {
			if (useProgressPane)
				progressPane.stop();
			actionPerformer = null;
		}
	} // End of actionPerformer

	public void mouseEntered(MouseEvent e) {
		if (g2 != null)
			g2.setClip(wizard.wholeImage);
		if (mainWindow != null)
			mainWindow.setVisible(true);
		switchCursor();
		validate();
	}

	public void mouseExited(MouseEvent e) {
		if (g2 != null)
			g2.setClip(wizard.wholeImage);
		magnifier.clear();
		statusBar.reset();
	}

	public void mousePressed(MouseEvent e) {
		try {
			// if (e.isPopupTrigger())
			if (e.isMetaDown() == true) {
				recentMode = mode;
				mode = Activity.IDLE;
				this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
				popupMenu.show(e.getComponent(), e.getX(), e.getY());
				popupMenuLocation = e.getPoint();
			} else {
				if ((mode == Activity.BLACK_LINE)
						|| (mode == Activity.WHITE_LINE)) // Only used for
					// "New Image"
				{
					if (wizard.blankImage) // This point is the first point the
						// user draws onto a blank image -
						// recognize it
					{
						wizard.floodSeed = e.getPoint();
						wizard.blankImage = false;
					} else
						drawingPath.moveTo(e.getX(), e.getY());
				} else if (mode == Activity.BLACK_PEN) // Only used for
					// "New Image"
				{
					if (wizard.blankImage) // This point is the first point the
						// user draws onto a blank image -
						// recognize it
					{
						wizard.floodSeed = e.getPoint();
						wizard.blankImage = false;

						drawingPath.moveTo(e.getX(), e.getY());
					}
				}
				if (mode == Activity.MOVE_NODE) {
					if (nodes != null) {

						{
							for (int i = 0; i < nodes.size(); i++) {
								TreeNode node = nodes.elementAt(i);
								if (((node != null) && (node.getShape()
										.contains(e.getPoint())))) {
									selectedNode = (TreeNode) nodes
									.elementAt(i);
									wizard.latestTreeLocation = e.getPoint();
									break;
								}
							}
							repaint();
						}

					}
				} else if (mode == Activity.QUADCURVE) {
					recentMode = Activity.QUADCURVE;
					if (curveHandle != null) {
						if ((!curveHandleDragging)
								&& (curveHandle.contains(e.getX(), e.getY()))) {
							curveHandleDragging = true;
							if (wizard.useFancyCursors)
								setCursor(cursors.getHandCursor());
							else
								setCursor(cursors.getCrosshairCursor());
						}
					}
				} else if (mode == Activity.DRAW_BRANCH) {
					if (nodes != null) {
						for (int i = 0; i < nodes.size(); i++) {
							TreeNode node = nodes.elementAt(i);
							if ((node != null)
									&& (node.getShape().contains(e.getPoint()))) {
								branchStartNode = (TreeNode) nodes.elementAt(i);
								branchStartPosition = new Point(branchStartNode
										.getX() + 2, branchStartNode.getY() + 2);
								branchEndPosition = new Point(branchStartNode
										.getX() + 2, branchStartNode.getY() + 2);
								oldMouseCoords = new Point(e.getX(), e.getY());
								branch = new Line2D.Float(branchStartPosition,
										branchEndPosition);
								branchDrawn = false;
								break;
							}
						}
						repaint();
					}
				}
			}

			// if (e.getButton() == MouseEvent.BUTTON1)
			if (e.isMetaDown() == false) {
				// Save the image for Undo functionality
				// Needed for all activities for which is not clear which area
				// they will encompass
				if (g2 != null)
					g2.setClip(wizard.wholeImage);
				if ((mode != Activity.RECT_SEL) && (mode != Activity.LINE_SEL)
						&& (mode != Activity.MOVE_NODE)
						&& (mode != Activity.IDLE) && (mode != Activity.NONE)
						&& (mode != Activity.BLACK_LINE)
						&& (mode != Activity.WHITE_LINE)
						&& (mode != Activity.BINARIZE)
						&& (mode != Activity.PIPETTE)) {
					guiActions.toggleUndoAction(true);
					storeSnapshot();
				}

				if ((mode == Activity.BLACK_LINE)
						|| (mode == Activity.WHITE_LINE))
					storeSnapshot(); // LINE needs extra treatment
			}
		} catch (Exception ex) {
			if (useProgressPane)
				progressPane.stop();
			actionPerformer = null;
		}
	}

	public void mouseReleased(MouseEvent e) {
		try {
			if (g2 != null)
				g2.setClip(wizard.wholeImage);

			if (mode == Activity.RECT_SEL) {
				lowerRight = new Point(e.getX(), e.getY());

				// Fabricate a shape from the selection
				if (upperLeft != null)
					selection = imageOperations.getShape(upperLeft, lowerRight);

				// Case: User selection is trimmed to the image boundaries
				if (wizard.selectionTrimmedToBoundaries) {
					if (upperLeft.x < 32)
						upperLeft.x = 32;
					if (upperLeft.x > image.getWidth() - 32)
						upperLeft.x = image.getWidth() - 32;
					if (upperLeft.y < 32)
						upperLeft.y = 32;
					if (upperLeft.y > image.getHeight() - 32)
						upperLeft.y = image.getHeight() - 32;

					if (lowerRight.x < 32)
						lowerRight.x = 32;
					if (lowerRight.x > image.getWidth() - 32)
						lowerRight.x = image.getWidth() - 32;
					if (lowerRight.y < 32)
						lowerRight.y = 32;
					if (lowerRight.y > image.getHeight() - 32)
						lowerRight.y = image.getHeight() - 32;

					// Modify the shape
					selection = imageOperations.getShape(upperLeft, lowerRight);
				} else // Case: User selection is erased if it is not completely
					// within the image boundaries
				{
					if (!(wizard.wholeImage.contains(selection.getBounds2D()))) {
						selection = null;
						statusBar
						.showMessage(
								"The selection is either not entirely within the image or too small.",
								image, oldMouseCoords);
					} else
						statusBar.reset();
				}
			} else if ((mode == Activity.BLACK_LINE)
					|| (mode == Activity.WHITE_LINE)) {
				g2.setStroke(customStroke);
				g2.setColor(new Color(BIN1));

				// Only accept the line if it lies completely inside the image
				// area
				if (wizard.wholeImage.contains(e.getPoint())
						&& (wizard.wholeImage.contains(new Point(lineStart.x,
								lineStart.y)))) {
					if (wizard.autoClean) // Clean the area around the user
						// drawing (draw the same with shade
						// white, but thicker)
					{
						float width = ((BasicStroke) customStroke)
						.getLineWidth();
						BasicStroke tempStroke = new BasicStroke(width
								+ wizard.autoCleanWidth, BasicStroke.CAP_BUTT,
								BasicStroke.JOIN_BEVEL);
						g2.setStroke(tempStroke);
						if (mode == Activity.BLACK_LINE)
							g2.setColor(new Color(BIN0));
						else
							g2.setColor(new Color(BIN1));
						g2.drawLine(lineStart.x, lineStart.y, e.getX(), e
								.getY());
						g2.setStroke(customStroke);
					}

					// Draw the line with foreground color
					if (mode == Activity.BLACK_LINE)
						g2.setColor(new Color(BIN1));
					else
						g2.setColor(new Color(BIN0));
					g2.drawLine(lineStart.x, lineStart.y, e.getX(), e.getY());
					lineStart = e.getPoint();

					// Store area
					drawingPath.lineTo(e.getX(), e.getY());
					drawingPath.closePath();
					Rectangle2D rect = drawingPath.getBounds2D();
					int offset = wizard.drawingStrokeWidth;
					int x = Math.max(0, (int) rect.getX() - 1 - offset);
					int y = Math.max(0, (int) rect.getY() - 1 - offset);
					int w = Math.min(image.getWidth(), (int) rect.getWidth()
							+ 2 + 2 * offset);
					int h = Math.min(image.getHeight(), (int) rect.getHeight()
							+ 2 + 2 * offset);
					Rectangle areaOfInfluence = new Rectangle(x, y, w, h);
					protocol.recordActivity(mode, areaOfInfluence);
					drawingPath.reset();
				}

				// Deletes the temporary drawing on the content pane's children
				userDrawing = null;
			} else if (mode == Activity.QUADCURVE) {
				curveDrawn = true;

				if (curveEnd != curveStart) {
					g2.setStroke(customStroke);
					g2.setColor(new Color(BIN1));
					if (curveHandleDragging) {
						curveHandleDragging = false;
						fixateUserGeneratedCurve();
					}

					// Only used for "New Image"
					if (wizard.blankImage) // This point is the first point the
						// user draws onto a blank image -
						// recognize it
					{
						wizard.floodSeed = e.getPoint();
						wizard.blankImage = false;
					}
				} else {
					userDrawing = null;
					curveStart = null;
					curveEnd = null;
					curveHandle = null;
				}

				if (wizard.useFancyCursors)
					setCursor(cursors.curve2DCursor);
				else
					setCursor(cursors.getCrosshairCursor());
			} else if (mode == Activity.LINE_SEL) {
				// Fabricate a shape for the selection
				selection = new Line2D.Float(upperLeft, e.getPoint());

				// Do not accept the selection if it is not completely inside
				// the image area
				if (!(wizard.wholeImage.contains(upperLeft) && (wizard.wholeImage
						.contains(e.getPoint())))) {
					selection = null;
					scrollPane.repaint();
					statusBar.showMessage(
							"The selection is not entirely within the image.",
							image, oldMouseCoords);
				} else
					statusBar.reset();
			} else if (mode == Activity.DRAW_BRANCH) {
				if ((nodes != null) && (!branchDrawn)) {
					for (int i = 0; i < nodes.size(); i++) {
						TreeNode node = nodes.elementAt(i);
						if ((node != null)
								&& (node.getShape()).contains(e.getPoint())) {
							if ((branchStartPosition != null)
									&& (branchEndPosition != null)) {
								branchEndNode = (TreeNode) nodes.elementAt(i);
								branchEndPosition.move(e.getX(), e.getY());
								oldMouseCoords = new Point(e.getX(), e.getY());
								branch = null;

								if ((branchEndNode != null)
										&& (branchStartNode != branchEndNode)) {
									// Make sure that the user cannot link two
									// tips
									if (!((branchEndNode instanceof Tip) && (branchStartNode instanceof Tip))) {
										protocol
										.recordActivity(
												Activity.DRAW_BRANCH,
												topology
												.getSerializedTopology());
										Branch newBranch = new Branch(
												branchStartNode, branchEndNode,
												true);
										newBranch.setLengthInPixels(0);
										newBranch.setUserAssignedLength(0);
										newBranch.setUserGenerated(true);
										topology.addBranch(newBranch);
										// As manually drawing a branch is not
										// sensible under normal circumstances,
										// make special provisions
										if (!Wizard.useMixedLengths)
											guiActions.useMixedLengths();
									} else {
										if (protocol.protocolEmpty())
											guiActions.toggleUndoAction(false);
										statusBar
										.showMessage(
												"A branch between tips is not allowed",
												image, oldMouseCoords);
									}
								}
								break;
							} else // The location for the branch end point is
								// invalid - delete the branch
							{
								branch = null;
								repaint();
							}
						} else {
							branch = null;
						}
					}
					repaint();
					branchDrawn = true;
				}

				branchStartNode = null;
				branchEndNode = null;
				branchStartPosition = null;
				branchEndPosition = null;
			} else if (mode == Activity.MOVE_NODE) {

				{
					if (selectedNode != null) {
						int mx = e.getX();
						int my = e.getY();

						if ((wizard.allowNodesAnywhere)
								|| (image.getRGB(mx, my) == BIN1)) {
							// Move the respective node
							topology.moveNode(selectedNode, new Point(mx, my));
						}
					}
				}
			}

			// Perform AutoFloodFill if activated
			if ((wizard.autoFlood)
					&& ((mode == Activity.BLACK_PEN)
							|| (mode == Activity.ERASER)
							|| (mode == Activity.BLACK_LINE) || (mode == Activity.WHITE_LINE)))
				autoFloodFill();
			scrollPane.repaint();

			// A mouse button release marks the termination of certain
			// activities, namely
			// BLACK_PEN, ERASER, LINE and CURVE2D
			// Notify the manipulated image area
			if ((mode == Activity.BLACK_PEN) || (mode == Activity.ERASER)) {
				// Set the bounding box around the recorded path as the
				// influenced image area
				// The bounding box needs to be enlarged to fully encompass the
				// path
				drawingPath.closePath();
				Rectangle2D rect = drawingPath.getBounds2D();
				int offset;
				if (mode == Activity.BLACK_PEN)
					offset = wizard.drawingStrokeWidth;
				else
					offset = wizard.eraserStrokeWidth;

				int x = Math.max(0, (int) rect.getX() - 1 - offset);
				int y = Math.max(0, (int) rect.getY() - 1 - offset);
				int w = Math.min(image.getWidth(), (int) rect.getWidth() + 2
						+ 2 * offset);
				int h = Math.min(image.getHeight(), (int) rect.getHeight() + 2
						+ 2 * offset);
				Rectangle areaOfInfluence = new Rectangle(x, y, w, h);
				protocol.recordActivity(mode, areaOfInfluence);
				drawingPath.reset();
			}
		} catch (Exception ex) {
			if (useProgressPane)
				progressPane.stop();
			actionPerformer = null;
		}
	}

	public void mouseDragged(MouseEvent e) {
		try {
			// Clear the magnifier if the mouse is outside
			if (!wizard.wholeImage.contains(e.getPoint()))
				magnifier.clear();

			// if (e.getButton() == MouseEvent.BUTTON1)
			if (e.isMetaDown() == false) {
				if (g2 != null) {
					g2.setClip(wizard.wholeImage);

					if (mode == Activity.MOVE_NODE) {

						{
							if (selectedNode != null) {
								int mx = e.getX();
								int my = e.getY();
								if (!wizard.nodesStickToTree)
									selectedNode.setLocation(new Point(mx, my)); // Move
								// the
								// node
								// freely
								// around
								// the
								// screen
								else // Move the node only on the foreground
									// (the tree)
								{
									try {
										int x = (int) selectedNode.getX();
										int y = (int) selectedNode.getY();
										int vx = (int) Math.signum(mx - x);
										int vy = (int) Math.signum(my - y);
										boolean step = true;

										do {
											if ((image.getRGB(x + vx, y + vy) == BIN1)
													|| (image.getRGB(x + vx, y
															+ vy) == wizard.treeFloodColor)) {
												x = x + vx;
												y = y + vy;
											} else if ((image.getRGB(x + vx, y) == BIN1)
													|| (image.getRGB(x + vx, y) == wizard.treeFloodColor))
												x = x + vx;
											else if ((image.getRGB(x, y + vy) == BIN1)
													|| (image.getRGB(x, y + vy) == wizard.treeFloodColor))
												y = y + vy;
											else
												step = false;
											selectedNode.setLocation(new Point(
													x, y));
										} while ((x != mx) && (y != my)
												&& (step));
									} catch (Exception ie) {
									}
									;
								}
							}
						}
					} else if (mode == Activity.BLACK_PEN) {
						g2.setStroke(customStroke);
						g2.setColor(Color.black);
						g2.drawLine(lineStart.x, lineStart.y, e.getX(), e
								.getY());
						lineStart.move(e.getX(), e.getY());
						autoSkeletonize(e.getPoint(), image);

						// Prolongue the recorded path between a mouse press and
						// a mouse release
						drawingPath.append(new Line2D.Float(lineStart.x,
								lineStart.y, e.getX(), e.getY()), false);
					} else if (mode == Activity.ERASER) {
						g2.setStroke(eraserStroke);
						g2.setColor(Color.white);
						g2.drawLine(lineStart.x, lineStart.y, e.getX(), e
								.getY());
						lineStart.move(e.getX(), e.getY());
						autoSkeletonize(e.getPoint(), image);

						// Prolongue the recorded path between a mouse press and
						// a mouse release
						drawingPath.append(new Line2D.Float(lineStart.x,
								lineStart.y, e.getX(), e.getY()), false);
					} else if ((mode == Activity.BLACK_LINE)
							|| (mode == Activity.WHITE_LINE)) {
						Point ml = e.getPoint();
						drawingPath.lineTo(e.getX(), e.getY());
						userDrawing = new Line2D.Float(lineStart, ml);
						statusBar.showMessage("Dragging a line from ("
								+ lineStart.x + ", " + lineStart.y + ") to ("
								+ ml.x + ", " + ml.y + ")", image,
								oldMouseCoords);
					} else if (mode == Activity.QUADCURVE) {
						int cx, cy;
						if (!curveDrawn) // User is drawing a curve
						{
							// Nice effect, but not suitable here...
							// cx = (int) ((int) curveStart.x +
							// 0.5*(curveStart.x - e.getX()));
							// cy = (int) ((int) curveStart.y +
							// 0.5*(curveStart.y - e.getY()));

							cx = (int) ((int) curveStart.x + 0.5 * (e.getX() - curveStart.x));
							cy = (int) ((int) curveStart.y + 0.5 * (e.getY() - curveStart.y));
							userDrawing = new QuadCurve2D.Float(curveStart.x,
									curveStart.y, cx, cy, e.getX(), e.getY());
							curveHandle = new Rectangle2D.Float(cx - 2, cy - 2,
									5, 5);
							curveEnd.move(e.getX(), e.getY());
						} else if (curveHandleDragging) // Curve drawing is
							// finished; user moves
							// the handle
						{
							cx = (int) e.getPoint().getX();
							cy = (int) e.getPoint().getY();
							curveHandle = new Rectangle2D.Float(cx - 2, cy - 2,
									5, 5);
							userDrawing = new QuadCurve2D.Float(curveStart.x,
									curveStart.y, cx, cy, curveEnd.x,
									curveEnd.y);
						}
					} else if (mode == Activity.RECT_SEL) {
						selection = imageOperations.getShape(upperLeft,
								new Point(e.getX(), e.getY()));
						// Keep the mouse coordinates
						oldMouseCoords = new Point(e.getX(), e.getY());
					} else if (mode == Activity.LINE_SEL) {
						selection = new Line2D.Float(upperLeft, e.getPoint());
						// Keep the mouse coordinates
						oldMouseCoords = new Point(e.getX(), e.getY());
						int length = (int) upperLeft.distance(e.getPoint());
						statusBar.showMessage(
								"Dragging a line selection from ("
								+ lineStart.x + ", " + lineStart.y
								+ ") to (" + e.getX() + ", " + e.getY()
								+ ") with pixel length " + length,
								image, oldMouseCoords);
					} else if (mode == Activity.DRAW_BRANCH) {
						if (branchEndPosition != null) {
							branchEndPosition.move(e.getX(), e.getY());
							branch = new Line2D.Float(branchStartPosition,
									branchEndPosition);
							selectedNode = null;
							// Signal whether the user moves onto a node while
							// dragging the branch
							if (nodes != null) {
								for (int i = 0; i < nodes.size(); i++) {
									TreeNode node = (TreeNode) nodes
									.elementAt(i);
									if (node.getShape().contains(e.getPoint())) {
										selectedNode = node;
										break;
									}
								}
								repaint();
							}
						}
						oldMouseCoords = new Point(e.getX(), e.getY());
					}

					// If the mouse is dragged towards the viewport boundaries,
					// adjust the view:
					// Translate origin by some amount
					// This is sensible only during dragging related operations,
					// not for manual drawing/erasing in particular
					if ((mode != Activity.BLACK_PEN)
							&& (mode != Activity.ERASER)
							&& (mode != Activity.MOVE_NODE)
							&& (mode != Activity.IDLE)) {
						Point origin = viewport.getViewPosition();
						Dimension extentSize = viewport.getExtentSize();
						if ((e.getX() < origin.x + scrBorderOffset)
								&& (origin.x >= scrOffset))
							origin.x += -scrOffset;
						else if ((e.getY() < origin.y + scrBorderOffset)
								&& (origin.y >= scrOffset))
							origin.y += -scrOffset;
						else if ((e.getX() > viewport.getWidth() + origin.x
								- scrBorderOffset)
								&& (origin.x < image.getWidth()
										- extentSize.getWidth() - scrOffset))
							origin.x += scrOffset;
						else if ((e.getY() > viewport.getHeight() + origin.y
								- scrBorderOffset)
								&& (origin.y < image.getHeight()
										- extentSize.getHeight() - scrOffset))
							origin.y += scrOffset;
						viewport.setViewPosition(origin);
					}
					scrollPane.repaint();
					magnifier.adjust(e.getX(), e.getY());
				}
			}
		} catch (Exception ex) {
			if (useProgressPane)
				progressPane.stop();
			actionPerformer = null;
		}
	}

	public void mouseMoved(MouseEvent e) {
		try {
			if (g2 != null)
				g2.setClip(wizard.wholeImage);
			int mx = e.getX();
			int my = e.getY();
			lineStart = new Point(mx, my);
			if (!curveDrawn)
				curveStart = new Point(mx, my);
			upperLeft = new Point(mx, my);
			oldMouseCoords = new Point(mx, my);
			statusBar.showMessage("", image, oldMouseCoords);
			magnifier.adjust(mx, my);

			// Clear the magnifier if the mouse is outside
			if (!wizard.wholeImage.contains(e.getPoint()))
				magnifier.clear();

			// Signal that the user moves the mouse over a selectable item (a
			// branch or a node)
			if (nodes != null) {
				for (int i = 0; i < nodes.size(); i++) {
					TreeNode node = (TreeNode) nodes.elementAt(i);
					if (node.getShape().contains(e.getPoint())) {
						selectedNode = node;
						if (node instanceof InnerNode) {
							InnerNode innerNode = (InnerNode) node;
							statusBar.showMessage("InnerNode at ("
									+ innerNode.getX() + ", "
									+ innerNode.getY() + "), internal id = "
									+ innerNode.getId(), image, e.getPoint());
						} else if (node instanceof Tip) {
							Tip tip = (Tip) node;
							statusBar.showMessage("Tip with name '"
									+ tip.getTaxonName() + "' at ("
									+ tip.getX() + ", " + tip.getY()
									+ "), internal id = " + tip.getId(), image,
									e.getPoint());
						}
						break;
					}
					repaint();
				}

				if (branches != null) {
					for (int i = 0; i < branches.size(); i++) {
						Branch branch = (Branch) branches.elementAt(i);
						Shape s = g2.getStroke().createStrokedShape(
								branch.getShape());
						if (s.contains(e.getPoint())) {
							prevSelectedBranch = selectedBranch;
							selectedBranch = branch;

							statusBar.showMessage(branch.toString(), image, e
									.getPoint());
							break;
						}
					}
					repaint();
				}
			}
		} catch (Exception ex) {
			if (useProgressPane)
				progressPane.stop();
			actionPerformer = null;
		}
	}

	public void mouseWheelMoved(MouseWheelEvent e) {
		scrollPane.dispatchEvent(e);
		magnifier.adjust(e.getX(), e.getY());
		if ((mode == Activity.STENCIL) && (e.getWhen() > 500))
			repaint(); // Error prone - should be implemented differently
	}

	public void keyPressed(KeyEvent e) {

		if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
			if (useProgressPane)
				progressPane.stop();
			int action = lastActionId;

			Thread.yield();
			actionPerformer = null;
			// The operations with a dialog-box (i.e. Sharpen) must be treated
			// separately as the preview manipulations
			// are not treated by class {protocol} but as a memory snapshot
			if ((action == Activity.BRIGHTNESS)
					|| (action == Activity.DESPECKLE)
					|| (action == Activity.MINIMUM_OP)
					|| (action == Activity.SMOOTH)
					|| (action == Activity.GREYSCALE_CONVERSION)
					|| (action == Activity.BINARIZE)
					|| (action == Activity.COLOR_QUANTIZATION)
					|| (action == Activity.SHARPEN)) {
				restoreSnapshot();
			} else
				protocol.restorePreviousActivity();
		} else if (e.getKeyCode() == KeyEvent.VK_Y) // Currently not used
		{
			new DebugFrame(image, "Current Image");
		}
	}

	public void keyReleased(KeyEvent e) {
	}

	public void keyTyped(KeyEvent e) {
	}

	public void popupMenuCanceled(PopupMenuEvent e) {
		mode = recentMode;
		switchCursor();
	}

	public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
		mode = recentMode;
		switchCursor();
	}

	public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
	}

	// ------------------------------------------------------------------------------------------

	private void autoSkeletonize(Point mouseLocation, BufferedImage image) {
		if ((mouseLocation != null) && (wizard.autoSkeletonize)) {
			int mx = mouseLocation.x;
			int my = mouseLocation.y;
			Shape s = new Rectangle2D.Float(mx - 4, my - 4, 9, 9);

			if (imageOperations.isBinarized(image, s)) {
				statusBar.showMessage("", null, null);
				if (mode == Activity.BLACK_PEN) {
					// Skeletonize what the user is drawing
					// Avoid skeletonizing the boundary around the image
					if ((mx > 36) && (my > 36) && (mx < image.getWidth() - 36)
							&& (my < image.getHeight() - 36)) {
						imageOperations.skeletonizeImage(image, s);
					}
					scrollPane.repaint();
				}
			} else
				statusBar
				.showMessage(
						"Automatic thinning is not possible here: The image area under the mouse is not yet binarized.",
						image, mouseLocation);
		}
	}

	private boolean autoFloodFill() {
		if (wizard.autoFlood) {
			if ((wizard.floodSeed != null) && (selection != null)
					&& (selection.contains(wizard.floodSeed))) {
				int x = wizard.floodSeed.x;
				int y = wizard.floodSeed.y;
				restorePixelColors();
				imageOperations.localFloodFill8NB(image, selection, x, y, BIN1,
						wizard.treeFloodColor);
				magnifier.setImage(image);
				scrollPane.repaint();
				return true;
			}

		}
		return false;
	}

	public void undo() {
		protocol.restorePreviousActivity();
		magnifier.setImage(image);
		repaint();
	}

	public void protocolState(int action) {
		Rectangle areaOfInfluence;
		if (action == Activity.COLOR_QUANTIZATION)
			areaOfInfluence = wizard.wholeImage.getBounds();
		else
			areaOfInfluence = selection.getBounds();

		protocol.recordActivity(action, areaOfInfluence);
	}

	public void storeSnapshot() {
		imageBuffer.storeAsSnapshot(this.image);
		magnifier.setImage(this.image);
		g2 = (Graphics2D) image.getGraphics();
	}

	public void restoreSnapshot() {
		this.image = imageBuffer.copyFromSnapshot();
		this
		.setPreferredSize(new Dimension(image.getWidth(), image
				.getHeight()));
		scrollPane.setViewportView(this);
		scrollPane.repaint();
		magnifier.setImage(this.image);
	}

	public void selectAll() {
		selection = wizard.wholeImage;
		repaint();
	}

	public Point getInsertionPosition() {
		if (popupMenuLocation != null) {
			int px = popupMenuLocation.x;
			int py = popupMenuLocation.y;
			// If the option is set that nodes may be put anywhere, return the
			// current menu position as insertion position
			// Otherwise, if the recent position of the popup menu is a
			// foreground position, return it
			// Otherwise return the first foreground pixel found within a square
			// around this position
			// If no foreground is found there, return the position of the most
			// recent Flood Fill initiation
			// If no Flood Fill has occurred so far, return the position where a
			// node has been modified lately;
			// Otherwise return null
			if (wizard.allowNodesAnywhere)
				return new Point(px, py);
			if ((image.getRGB(px, py) == BIN1)
					|| (image.getRGB(px, py) == wizard.treeFloodColor))
				return new Point(px, py);
			else {
				for (int x = -5; x < 5; x++) {
					for (int y = -5; y < 5; y++) {
						px = popupMenuLocation.x + x;
						py = popupMenuLocation.y + y;
						int c = image.getRGB(px, py);
						if ((c == BIN1) || (c == wizard.treeFloodColor)) {
							wizard.latestTreeLocation = new Point(px, py);
							return new Point(px, py);
						}
					}
				}
			}
		}

		{
			statusBar
			.showMessage(
					"Cannot put a node on a color other than black (foreground).",
					image, oldMouseCoords);
			return null;
		}
	}

	public void doFloodFill() {
		statusBar.showMessage("", image, oldMouseCoords);
		if (selection == null)
			selection = wizard.wholeImage;
		if ((image != null) && (imageOperations.isBinarized(image, selection))) {
			if ((selection != null) && (selection.contains(popupMenuLocation))) {
				restorePixelColors();
				// Get a foreground pixel in the 8-neighborship of the mouse
				// location, preferably the mouse location itself
				Point p = imageOperations.getN8PointWithColor(image,
						popupMenuLocation, 5, BIN1);
				if (p != null) {
					wizard.floodSeed = p;
					wizard.latestTreeLocation = p;
					wizard.floodFillPerformed = true;
					wizard.floodedPixels = imageOperations.localFloodFill8NB(
							image, selection, wizard.floodSeed.x,
							wizard.floodSeed.y, BIN1, wizard.treeFloodColor);
					magnifier.setImage(image);
				} else
					statusBar
					.showMessage(
							"The point you have chosen is a background pixel - a foreground (black) pixel is needed.",
							image, oldMouseCoords);
			} else {
				statusBar.showMessage(
						"The point you have chosen is outside your selection.",
						image, oldMouseCoords);

			}
		} else {
			statusBar
			.showMessage(
					"The selected subimage is not (entirely) binarized. This has to be done first.",
					image, oldMouseCoords);

		}
		repaint();
	}

	public void fixateUserGeneratedCurve() {
		if (recentMode == Activity.QUADCURVE) {
			try {
				if (g2 != null) {
					// Clean the area around the user drawing (draw the same
					// with shade white, but thicker)
					if ((wizard.autoClean) && (userDrawing != null)) {
						float width = ((BasicStroke) customStroke)
						.getLineWidth();
						BasicStroke tempStroke = new BasicStroke(width
								+ wizard.autoCleanWidth, BasicStroke.CAP_BUTT,
								BasicStroke.JOIN_BEVEL);
						g2.setStroke(tempStroke);
						g2.setColor(new Color(BIN0));
						g2.draw(userDrawing);
						g2.setStroke(customStroke);
					}

					if (userDrawing != null) {
						g2.setColor(new Color(BIN1));
						g2.draw(userDrawing);
						autoFloodFill();
						curveHandle = null;
						curveDrawn = false;
						curveHandleDragging = false;
						scrollPane.repaint();

						// Record the activity
						int offset;
						Rectangle rect = userDrawing.getBounds();
						offset = wizard.drawingStrokeWidth;

						int x = Math.max(0, (int) rect.getX() - 1 - offset);
						int y = Math.max(0, (int) rect.getY() - 1 - offset);
						int w = Math.min(image.getWidth(), (int) rect
								.getWidth()
								+ 2 + 2 * offset);
						int h = Math.min(image.getHeight(), (int) rect
								.getHeight()
								+ 2 + 2 * offset);

						Rectangle areaOfInfluence = new Rectangle(x, y, w, h);
						protocol.recordActivity(mode, areaOfInfluence);

						userDrawing = null;
					}
				}
			} catch (Exception e) {
			}
			;
		}
	}

	public boolean showConfirmationDialog(String noText, String yesText,
			String message) {
		JFrame frame = new JFrame();
		frame.setLocation(getWidth() / 2, (int) getHeight() / 2);
		Object[] options = { noText, yesText };
		int n = JOptionPane.showOptionDialog(frame, message, "",
				JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null,
				options, options[0]);

		frame.setVisible(false);
		frame.dispose();

		if (n == JOptionPane.NO_OPTION)
			return true;
		else
			return false;
	}

	public void restorePixelColors() {
		// Discolor all pixels that are colored wizard.treeFloodColor
		if (image != null)
			image = imageOperations.swapPixelColors(image, wizard.wholeImage,
					wizard.treeFloodColor, BIN1);

	}

	public void setEraserStrokeWidth(int width) {
		eraserStroke = new BasicStroke(width);
	}

	public void setDrawingStrokeWidth(int width) {
		customStroke = new BasicStroke(width);
	}

	public void setObjectReferences(MainWindow mw, ImageBuffer ib,
			ImageOperations io, GUIActions ga, TreeTopology tp,
			ActivityProtocol ap) {
		this.imageBuffer = ib;
		this.guiActions = ga;
		this.guiActions = ga;
		this.topology = tp;
		this.protocol = ap;
		this.mainWindow = mw;

		popupMenu = guiActions.getPopupMenu();
		popupMenu.addPopupMenuListener(this);
		// this.setComponentPopupMenu(popupMenu);

		// Upon startup, clear the old protocol session files, if any
		if (Preferences.protocolPath != null) {
			try {
				File[] allFiles = new File(Preferences.protocolPath)
				.listFiles();
				for (int i = 0; i < allFiles.length; i++) {
					File file = (File) allFiles[i];
					file.delete();
				}
			} catch (Exception e) {
				System.out.println("Could not delete the protocol files");
			}
		}

		// Hide or show the Wizard dialog if it is active or hidden by default
		if (!wizard.useWizard) {
			wizard.inactivate();
			mainWindow.swapWizardAndNewickPanels();
			guiActions.toggleWizardOptions(false);
		}
	}

	public void updateResultFrame() {
		if ((resultPanel != null)
				&& (resultPanel.isVisible() && (topology != null))) {
			resultPanel.showNewickString(topology
					.transformIntoNewickExpression());
		}
	}

	public BufferedImage getCurrentImage() {
		return this.image;

	}

	public TreeNode getSelectedNode() {
		return this.selectedNode;
	}

	public Vector<TreeNode> getNodesInSelection() {
		Vector<TreeNode> nodesInSelection = new Vector<TreeNode>();

		// Copy all TreeNode objects into new Vector that are within the current
		// selection
		if (nodes != null) {
			for (int i = 0; i < nodes.size(); i++) {
				TreeNode treeNode = (TreeNode) nodes.elementAt(i);
				if (selection.contains(treeNode.getLocation())) {
					nodesInSelection.add(treeNode);
				}
			}
		} else
			return null;

		return nodesInSelection;
	}

	public Vector<TreeNode> getNodesInSelection(Shape arbitrarySelection) {
		Vector<TreeNode> nodesInSelection = new Vector<TreeNode>();

		// Copy all TreeNode objects into new Vector that are within the current
		// selection
		if (nodes != null) {
			for (int i = 0; i < nodes.size(); i++) {
				TreeNode treeNode = nodes.elementAt(i);
				if (treeNode != null) {
					if (arbitrarySelection.contains(treeNode.getLocation())) {
						nodesInSelection.add(treeNode);
					}
				}
			}
		}
		return nodesInSelection;
	}

	public Branch getSelectedBranch() {
		return selectedBranch;
	}

	public Vector<Branch> getBranchesInSelection() {
		Vector<Branch> branchesInSelection = new Vector<Branch>();

		// Copy all Branch objects into new Vector that are within the current
		// selection
		if (branches != null) {
			for (int i = 0; i < branches.size(); i++) {
				Branch branch = branches.elementAt(i);
				if (branch != null) {
					if ((selection
							.contains(branch.getFirstNode().getLocation()) || (selection
									.contains(branch.getSecondNode().getLocation())))) {
						branchesInSelection.add(branch);
					}
				}
			}
		}
		return branchesInSelection;
	}

	public Vector<Branch> getBranchesInSelection(Shape arbitrarySelection) {
		Vector<Branch> branchesInSelection = new Vector<Branch>();

		// Copy all Branch objects into new Vector that are within the current
		// selection
		for (int i = 0; i < branches.size(); i++) {
			Branch branch = (Branch) branches.elementAt(i);
			if (branch != null) {
				if ((arbitrarySelection.contains(branch.getFirstNode()
						.getLocation()) || (arbitrarySelection.contains(branch
								.getSecondNode().getLocation())))) {
					branchesInSelection.add(branch);
				}
			}
		}
		return branchesInSelection;
	}

	public HashSet<Integer> getColorsInSelection() {
		HashSet<Integer> colorsInSelection = imageOperations
		.collectSelectedColors(image, selection);
		if (colorsInSelection.size() > defaultMaxNoSelectionColors) // Number of
			// colors
			// higher
			// than
			// allowed
		{
			statusBar.showMessage("No colors grabbed: Found "
					+ colorsInSelection.size()
					+ " colors, allowed is a maximum of "
					+ defaultMaxNoSelectionColors, image, oldMouseCoords);
			colorsInSelection = new HashSet<Integer>();
		} else {
			wizard.colNumSelectionColors = colorsInSelection.size();
			statusBar.showMessage("Grabbed " + colorsInSelection.size()
					+ " colors", image, oldMouseCoords);
		}

		return colorsInSelection;
	}

	public void switchCursor() {
		if (wizard.useFancyCursors) {
			if (mode == Activity.BLACK_PEN)
				setCursor(cursors.getPencilCursor());
			else if (mode == Activity.BLACK_LINE)
				setCursor(cursors.getBlackLineCursor());
			else if (mode == Activity.WHITE_LINE)
				setCursor(cursors.getWhiteLineCursor());
			else if (mode == Activity.RECT_SEL)
				setCursor(cursors.getBoxSelCursor());
			else if (mode == Activity.LINE_SEL)
				setCursor(cursors.getLineSelCursor());
			else if ((mode == Activity.ERASER) || (mode == Activity.WHITE_LINE))
				setCursor(cursors.getRubberCursor());
			else if (mode == Activity.MOVE_NODE)
				setCursor(cursors.getHandCursor());
			else if ((mode == Activity.QUADCURVE) && (!curveDrawn))
				setCursor(cursors.getCurve2DCursor());
			else if ((mode == Activity.FILL))
				setCursor(cursors.getFillCursor());
			else if ((mode == Activity.PIPETTE))
				setCursor(cursors.getPipetteCursor());
			else if ((mode == Activity.DRAW_BRANCH))
				setCursor(cursors.getDragCursor());
			else if ((mode == Activity.STENCIL))
				setCursor(cursors.getStencilCursor());
			else
				setCursor(cursors.getPanelCursor());
		} else
			setCursor(cursors.getCrosshairCursor());
	}

	public Shape getCurrentSelection() {
		return this.selection;
	}

	public void resetSelection() {
		selection = wizard.wholeImage;
		this.repaint();
	}

	public int getRecentMode() {
		return this.recentMode;
	};

	public int getMode() {
		return this.mode;
	};

	public BufferedImage getMotif() {
		return this.motif;
	};

	public void startProgressPane() {
		Thread worker = new Thread() {
			public void run() {
				progressPane.setText("Press Escape to abort");
				progressPane.start();
			}
		};
		SwingUtilities.invokeLater(worker);
	}

	public void stopProgressPane() {
		Thread worker = new Thread() {
			public void run() {
				progressPane.setText("");
				progressPane.stop();
			}
		};
		SwingUtilities.invokeLater(worker);
	}

	public void setViewportPosition(Point p) {
		this.scrollPane.getViewport().setViewPosition(p);
		scrollPane.revalidate();
		scrollPane.repaint();
		scrollPane.requestFocus();

	}

	public Point getViewportPosition() {
		return this.scrollPane.getViewport().getViewPosition();
	}

	public Dimension getPreferredSize() {
		if (image == null) {
			return new Dimension(320, 480);
		} else {
			return super.getPreferredSize();
		}
	}

	class ViewPositionSetter implements Runnable {
		JViewport vp;
		Point p;

		public ViewPositionSetter(JViewport vp, Point p) {
			this.vp = vp;
			this.p = p;
		}

		public void run() {
			vp.setViewPosition(p);
		}
	}
}