/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class IllustrationDialog extends JDialog {
	private static final long serialVersionUID = 1L;
	protected JButton done = new JButton("Done");
	protected JRadioButton showFloodFill, showOnlySource, showOnlyCurrent,
			showBlend, showNoBranches, showBranchesWithLengths,
			showBranchesWithoutLengths;
	protected JCheckBox showPaths, showNodes, showMarking, showFloodOrigin,
			showSpeciesNames;
	public boolean[] s = new boolean[12];

	public IllustrationDialog() {
		this("", null, true);
	}

	public IllustrationDialog(String title, java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		this.setLayout(new BorderLayout(2, 2));
		this.setTitle(title);
		this.setResizable(false);
		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		this.setAlwaysOnTop(true);
		JPanel jpButtons = new JPanel();
		jpButtons.add(done);

		showNoBranches = new JRadioButton("No Branches");
		showBranchesWithoutLengths = new JRadioButton(
				"Branches without lengths");
		showBranchesWithLengths = new JRadioButton("Branches with lengths");
		showNodes = new JCheckBox("Inner nodes and tips");
		showOnlySource = new JRadioButton("Source image");
		showBlend = new JRadioButton("Source and current image");
		showOnlyCurrent = new JRadioButton("Current image");
		showFloodFill = new JRadioButton("Flooded foreground");
		showMarking = new JCheckBox("Current marking");
		showFloodOrigin = new JCheckBox("TreeFlood seed");
		showSpeciesNames = new JCheckBox("Species names");
		showPaths = new JCheckBox("Paths segments");

		ButtonGroup bg = new ButtonGroup();
		bg.add(showOnlySource);
		bg.add(showBlend);
		bg.add(showOnlyCurrent);
		showBlend.setSelected(true);
		ButtonGroup bg2 = new ButtonGroup();
		bg2.add(showBranchesWithoutLengths);
		bg2.add(showBranchesWithLengths);
		bg2.add(showNoBranches);
		showNoBranches.setSelected(true);

		done.addActionListener(iListener);

		JPanel jpGeneral = new JPanel();
		jpGeneral.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 10));
		jpGeneral.setPreferredSize(new Dimension(215, 370));
		jpGeneral.setBorder(BorderFactory
				.createTitledBorder("Select Image Contents"));
		jpGeneral.add(showOnlySource);
		jpGeneral.add(showOnlyCurrent);
		jpGeneral.add(showBlend);
		jpGeneral.add(showNoBranches);
		jpGeneral.add(showBranchesWithoutLengths);
		jpGeneral.add(showBranchesWithLengths);
		jpGeneral.add(showNodes);
		jpGeneral.add(showSpeciesNames);
		jpGeneral.add(showMarking);

		jpGeneral.add(showPaths);

		getContentPane().add(jpButtons, BorderLayout.SOUTH);
		getContentPane().add(jpGeneral, BorderLayout.CENTER);

		pack();
	}

	ActionListener iListener = new ActionListener() {

		public void actionPerformed(ActionEvent e) {
			String c = e.getActionCommand();
			if (c == "Done") {
				s[0] = showOnlySource.isSelected();
				s[1] = showOnlyCurrent.isSelected();
				s[2] = showBlend.isSelected();
				s[3] = showBranchesWithoutLengths.isSelected();
				s[4] = showBranchesWithLengths.isSelected();
				s[5] = showNodes.isSelected();
				s[6] = showFloodFill.isSelected();
				s[7] = showMarking.isSelected();
				s[8] = showFloodOrigin.isSelected();
				s[9] = showSpeciesNames.isSelected();
				s[10] = showPaths.isSelected();
				s[11] = showNoBranches.isSelected();

				setVisible(false);
			} else if (c == "Source image") {
				showOnlySource.setSelected(!showOnlySource.isSelected());
				showBlend.setSelected(!showOnlySource.isSelected());
				showOnlyCurrent.setSelected(!showOnlySource.isSelected());
			} else if (c == "Current image") {
				showOnlyCurrent.setSelected(!showOnlyCurrent.isSelected());
				showBlend.setSelected(!showOnlyCurrent.isSelected());
				showOnlySource.setSelected(!showOnlyCurrent.isSelected());
			} else if (c == "Source and current image") {
				showBlend.setSelected(!showBlend.isSelected());
				showOnlyCurrent.setSelected(!showBlend.isSelected());
				showOnlySource.setSelected(!showBlend.isSelected());
			} else if (c == "Branches without lengths") {
				showBranchesWithoutLengths
						.setSelected(!showBranchesWithoutLengths.isSelected());
				showBranchesWithLengths.setSelected(!showBranchesWithoutLengths
						.isSelected());
				showNoBranches.setSelected(!showBranchesWithoutLengths
						.isSelected());
			} else if (c == "Branches with lengths") {
				showBranchesWithLengths.setSelected(!showBranchesWithLengths
						.isSelected());
				showBranchesWithoutLengths.setSelected(!showBranchesWithLengths
						.isSelected());
				showNoBranches.setSelected(!showBranchesWithLengths
						.isSelected());
			} else if (c == "No branches") {
				showNoBranches.setSelected(!showNoBranches.isSelected());
				showBranchesWithLengths.setSelected(!showNoBranches
						.isSelected());
				showBranchesWithoutLengths.setSelected(!showNoBranches
						.isSelected());
			} else if (c == "Inner nodes and tips")
				showNodes.setSelected(!showNodes.isSelected());
			else if (c == "Flooded foreground")
				showFloodFill.setSelected(!showFloodFill.isSelected());
			else if (c == "Current marking")
				showMarking.setSelected(!showMarking.isSelected());
			else if (c == "TreeFlood seed")
				showFloodOrigin.setSelected(!showFloodOrigin.isSelected());
			else if (c == "Species names")
				showSpeciesNames.setSelected(!showSpeciesNames.isSelected());
			else if (c == "Paths segments")
				showPaths.setSelected(!showPaths.isSelected());
		}
	};
}
