/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Dimension;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Toolkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import TreeSnatcher.Core.Activity;
import TreeSnatcher.Core.Constants;
import TreeSnatcher.Core.MainWindow;
import TreeSnatcher.Core.TreeTopology;
import TreeSnatcher.Utils.FileOperations;
import TreeSnatcher.Utils.NumberUtility;
import TreeSnatcher.GUI.IllustrationDialog;
import TreeSnatcher.GUI.LinksPanel;

public class GUIActions implements Constants, ChangeListener {
	private JRadioButtonMenuItem mRect;
	private JRadioButtonMenuItem mLine;
	private JRadioButtonMenuItem mPoly;
	private JRadioButtonMenuItem mChooseNode;
	private JRadioButtonMenuItem mDraw;
	private JRadioButtonMenuItem mDrawQuadCurve;
	private JRadioButtonMenuItem mErase;
	private JRadioButtonMenuItem mDrawBlackLine;
	private JRadioButtonMenuItem mDrawWhiteLine;
	private JRadioButtonMenuItem mDragBranch;
	private JRadioButtonMenuItem mPipette;
	private JRadioButtonMenuItem mLocalFill;

	private JRadioButtonMenuItem mUseUserAssignedLengths;
	private JRadioButtonMenuItem mUseCalculatedLengths;
	private JRadioButtonMenuItem mUseMixedLengths;

	private JRadioButtonMenuItem mShowAllBranches;
	private JRadioButtonMenuItem mOneNodeMode;
	private JRadioButtonMenuItem mShowPreciseBranches;

	private JRadioButtonMenuItem mTopologyRect;
	private JRadioButtonMenuItem mTopologyFree;
	private JRadioButtonMenuItem mTopologyPolar;

	private JCheckBoxMenuItem mAutoSkeletonize;
	private JCheckBoxMenuItem mAutoClean;
	private JCheckBoxMenuItem mAutoFlood;
	private JCheckBoxMenuItem mUseWizard;
	private JCheckBoxMenuItem mSmallMarks;
	private JCheckBoxMenuItem mMarkFloodSeed;
	private JCheckBoxMenuItem mFGColorInMagnifier;
	private JCheckBoxMenuItem mSrcInMagnifier;
	private JCheckBoxMenuItem mSuppressTinyBranches;
	private JCheckBoxMenuItem mUseFancyCursors;
	private JCheckBoxMenuItem mNodesStickToTree;
	private JCheckBoxMenuItem mDiscardUserObjects;
	private JCheckBoxMenuItem mAllowNodesAnywhere;
	private JCheckBoxMenuItem mDrawBranchLength;
	private JCheckBoxMenuItem mDrawTaxonName;
	private JCheckBoxMenuItem mHighlightBranchesWithoutLength;
	private JCheckBoxMenuItem mHighlightTipsWithoutName;
	private JCheckBoxMenuItem mColoredNewickExpression;
	private JCheckBoxMenuItem mUseElaboratePathFinding;

	private JMenuItem mGreyscaleConversion;
	private JMenuItem mMinMax;
	private JMenuItem mFillDialog;
	private JMenuItem mBrightness;
	private JMenuItem mBinarize;
	private JMenuItem mAutoBin;
	private JMenuItem mSkeletonize;
	private JMenuItem mSmooth;
	private JMenuItem mSharpen;
	private JMenuItem mDespeckle;
	private JMenuItem mColorQuant;
	private JMenuItem mFGColorMagnifier;
	private JMenuItem mExtractArea;
	private JMenuItem mDetectNodes;
	private JMenuItem mDetectBranches;

	private JMenuItem mRemoveNode;
	private JMenuItem mFloodFill;
	private JMenuItem mClearImage;
	private JMenuItem mTrim;
	private JMenuItem mSubimage;
	private JMenuItem mInvert;
	private JMenuItem mScaleImage2x;
	private JMenuItem mScaleImage05x;
	private JMenuItem mHistogramStretch;
	private JMenuItem mNameTaxon;
	private JMenuItem mAsReferenceNode;
	private JMenuItem mInputBranchLength;
	private JMenuItem mRemoveBranch;
	private JMenuItem mRemoveNodes;
	private JMenuItem mRemoveBranches;
	private JMenuItem mEnterScaleBarLength;
	private JMenuItem mShowPhylipExpression;
	private JMenuItem mIncludeBranchLengths;
	private JMenuItem mFillBlack;
	private JMenuItem mFillWhite;
	private JMenuItem mSet1ToScaleTree;
	private JMenuItem mUseToScaleTree;

	// private JMenuItem mInsertRoot;

	private JMenuItem mShowReadme;
	private JMenuItem mShowTutorials;

	// Toolbar Items
	private JRadioButton tRect;
	private JRadioButton tLine;
	private JRadioButton tPoly;
	private JRadioButton tChooseNode;
	private JRadioButton tDraw;
	private JRadioButton tErase;
	private JRadioButton tDrawBlackLine;
	private JRadioButton tDrawWhiteLine;
	private JRadioButton tDrawQuadCurve;
	private JRadioButton tPipette;
	private JRadioButton tLocalFill;
	private JRadioButton tStencil;
	private JRadioButton tTopologyFree;
	private JRadioButton tTopologyPolar;
	private JRadioButton tTopologyRect;

	private JRadioButton tDragBranch;
	private JToggleButton tAutoSkeletonize;
	private JToggleButton tAutoClean;
	private JToggleButton tAutoFlood;
	private JToggleButton tUseWizard;
	private JToggleButton tMarkFloodSeed;
	private JToggleButton tSmallMarks;
	private JToggleButton tSrcInMagnifier;
	private JToggleButton tFGColorInMagnifier;
	private JToggleButton tHighlightTipsWithoutName;
	private JToggleButton tHighlightBranchesWithoutLength;
	private JButton tShowPhylipExpression;
	private JButton tAutoBin;
	private JButton tGreyscaleConversion;
	private JButton tBinarize;
	private JButton tSmooth;
	private JButton tSharpen;
	private JButton tMinMax;
	private JButton tFillDialog;

	private JButton tFGColorMagnifier;
	private JButton tDetectNodes;
	private JButton tDetectBranches;
	private JButton tClearImage;

	private JButton tDespeckle;
	private JButton tSkeletonize;
	private JButton tFillBlack;
	private JButton tFillWhite;
	private JButton tInvert;
	private JButton tAllSelection;
	private JButton tFloodFill;
	private JButton tNewImage;
	private JButton tOpenImage;
	private JButton tOpenSnapshot;

	private JButton tSaveIllustration;
	private JButton tSaveSnapshot;
	private JButton tSaveNewick;
	private JButton tBrightness;
	private JButton tExtractArea;

	private JButton tEnterScaleBarLength;

	private JButton tGrabMotif;
	private JButton tUndo;

	// Popup Menu items
	private JRadioButtonMenuItem pRect;
	private JRadioButtonMenuItem pLineSel;

	private JRadioButtonMenuItem pChooseNode;
	private JRadioButtonMenuItem pDraw;
	private JRadioButtonMenuItem pDrawQuadCurve;
	private JRadioButtonMenuItem pErase;
	private JRadioButtonMenuItem pDrawBlackLine;
	private JRadioButtonMenuItem pDrawWhiteLine;
	private JRadioButtonMenuItem pPipette;
	private JRadioButtonMenuItem pLocalFill;
	private JRadioButtonMenuItem pDragBranch;
	private JCheckBoxMenuItem pAutoClean;
	private JCheckBoxMenuItem pShowAllBranches;
	private JCheckBoxMenuItem pOneNodeMode;
	private JCheckBoxMenuItem pShowPreciseBranches;
	private JMenuItem pDetectNodes;
	private JMenuItem pDetectBranches;
	private JMenuItem pAddInnerNode;
	private JMenuItem pAddTip;
	private JMenuItem pRemoveNode;
	private JMenuItem pRemoveNodes;
	private JMenuItem pRemoveBranch;
	private JMenuItem pRemoveBranches;
	private JMenuItem pFloodFill;
	private JMenuItem pExtractArea;
	private JMenuItem pNameTaxon;
	private JMenuItem pAsReferenceNode;
	private JMenuItem pInputBranchLength;
	private JMenuItem pEnterScaleBarLength;
	private JMenuItem pUndo;
	private JMenuItem pSet1ToScaleTree;
	private JMenuItem pUseToScaleTree;
	// private JMenuItem pInsertRoot;

	private GUIAction rectSelection;
	private GUIAction lineSelection;
	private GUIAction allSelection;
	private GUIAction polySelection;
	private GUIAction chooseNode;
	private GUIAction draw;
	private GUIAction drawBlackLine;
	private GUIAction drawWhiteLine;
	private GUIAction erase;
	private GUIAction undo;
	private GUIAction autoSkeletonize;
	private GUIAction greyscaleConversion;
	private GUIAction fillDialog;
	private GUIAction binarize;
	private GUIAction newImage;
	private GUIAction openImage;
	private GUIAction openSnapshot;
	private GUIAction saveImage;
	private GUIAction saveIllustration;
	private GUIAction saveNewick;
	private GUIAction saveSnapshot;
	private GUIAction trim;
	private GUIAction useWizard;
	private GUIAction smallMarks;
	private GUIAction markFloodSeed;
	private GUIAction fill_white;
	private GUIAction fill_black;
	private GUIAction pipette;
	private GUIAction stencil;
	private GUIAction localFill;
	private GUIAction subimage;
	private GUIAction invert;
	private GUIAction skeletonize;
	private GUIAction autoBin;
	private GUIAction smooth;
	private GUIAction despeckle;
	private GUIAction minMax;
	private GUIAction colorQuant;
	private GUIAction srcInMagnifier;
	private GUIAction sharpen;
	private GUIAction floodFill;
	private GUIAction suppressTinyBranches;
	private GUIAction fgColMagnifier;
	private GUIAction fgColorInMagnifier;
	private GUIAction brightness;
	private GUIAction histogramStretch;
	private GUIAction autoClean;
	private GUIAction autoFlood;
	private GUIAction extractArea;
	private GUIAction fancyCursors;
	private GUIAction detectNodes;
	private GUIAction detectBranches;
	private GUIAction nodesStickToTree;
	private GUIAction addInnerNode;
	private GUIAction addTip;
	private GUIAction removeNode;
	private GUIAction removeNodes;
	private GUIAction discardUserObjects;
	private GUIAction drawQuadCurve;
	private GUIAction dragBranch;
	private GUIAction drawBranchLength;
	private GUIAction drawTaxonName;
	private GUIAction clearImage;
	private GUIAction scaleImage2x;
	private GUIAction scaleImage05x;
	private GUIAction inputBranchLength;
	private GUIAction nameTaxon;
	private GUIAction asReferenceNode;
	private GUIAction highlightTipsWithoutName;
	private GUIAction highlightBranchesWithoutLength;
	private GUIAction removeBranch;
	private GUIAction removeBranches;
	private GUIAction enterScaleBarLength;
	private GUIAction showPhylipExpression;
	private GUIAction showColorBeneathMouse;
	private GUIAction grabMotif;
	private GUIAction allowNodesAnywhere;
	private GUIAction includeBranchLengths;
	private GUIAction useUserAssignedLengths;
	private GUIAction useCalculatedLengths;
	private GUIAction useMixedLengths;
	private GUIAction coloredNewickExpression;
	private GUIAction oneNodeMode;
	private GUIAction showPreciseBranches;
	private GUIAction showAllBranches;
	private GUIAction Set1ToScaleTree;
	private GUIAction useToScaleTree;
	private GUIAction topologyRect;
	private GUIAction topologyFree;
	private GUIAction topologyPolar;
	private GUIAction useElaboratePathFinding;
	private GUIAction showReadme;
	private GUIAction showTutorials;
	private GUIAction suggestLookahead;
	private GUIAction insertRoot;

	private MainWindow owner;
	protected JSlider ratioSlider;
	protected Wizard wizard;
	private ImagePanel imagePanel;
	private FileOperations fileOp;
	private Magnifier magnifier;
	private Thread taskThread;
	private TreeTopology topology;
	private JToolBar toolbar;
	private JToolBar sliderbar;
	protected JSpinner drawingStrokeSpinner;
	protected JSpinner eraserStrokeSpinner;
	protected JSpinner lookaheadSpinner;
	private JPopupMenu popupMenu;
	protected FillDialog colorManipDialog;
	protected ColorBox colorBox;
	protected JPanel sliderPanel;
	protected int modeBeforeFillDialog;
	private JColorChooser colorChooser;
	private JDialog cDialog;
	private JMenuBar menuBar;
	private IllustrationDialog illustrationDialog;

	public GUIActions(final MainWindow owner, final ImagePanel imagePanel,
			final ImageBuffer imageBuffer, final Magnifier magnifier,
			final FileOperations fileOp, final Wizard wizard) {
		this.owner = owner;
		this.imagePanel = imagePanel;
		this.magnifier = magnifier;
		this.fileOp = fileOp;
		this.wizard = wizard;

		makeActions();
		buildMenu();
		buildPopupMenu();
		buildLeftToolbar();
		buildRightToolbar();

		saveNewick.setEnabled(true);
		undo.setEnabled(false);
		fgColMagnifier.setEnabled(false);

		// Set all tool tips
		newImage.putValue(Action.SHORT_DESCRIPTION,
				"Create a new image and sketch your own tree");
		openImage.putValue(Action.SHORT_DESCRIPTION, "Open an existing image");
		openSnapshot.putValue(Action.SHORT_DESCRIPTION,
				"Restore a snapshot of a work in progress");
		saveImage.putValue(Action.SHORT_DESCRIPTION, "Save current image");
		saveIllustration.putValue(Action.SHORT_DESCRIPTION,
				"Save current image overlayed with topology");
		saveSnapshot.putValue(Action.SHORT_DESCRIPTION,
				"Save a snapshot of the current work in progress");
		saveNewick.putValue(Action.SHORT_DESCRIPTION,
				"Save resulting Newick expression");

		rectSelection.putValue(Action.SHORT_DESCRIPTION,
				"Use a rectangle for selection operations");
		lineSelection.putValue(Action.SHORT_DESCRIPTION,
				"Use a line for selection operations");
		allSelection.putValue(Action.SHORT_DESCRIPTION,
				"Select the entire image");
		polySelection.putValue(Action.SHORT_DESCRIPTION,
				"Use a polygon for selection operations");

		draw.putValue(Action.SHORT_DESCRIPTION,
				"Freehand Drawing (Foreground Shade Black)");
		drawBlackLine.putValue(Action.SHORT_DESCRIPTION, "Draw a black line");
		drawWhiteLine.putValue(Action.SHORT_DESCRIPTION, "Draw a white line");
		drawQuadCurve.putValue(Action.SHORT_DESCRIPTION,
				"Quadratic Curve Drawing");
		stencil.putValue(Action.SHORT_DESCRIPTION,
				"Print the stored motif at the mouse position");
		erase.putValue(Action.SHORT_DESCRIPTION,
				"Freehand Drawing (Background Shade White)");
		fill_black.putValue(Action.SHORT_DESCRIPTION,
				"Fills black the selected image area");
		fill_white.putValue(Action.SHORT_DESCRIPTION,
				"Fills white the selected image area");
		localFill.putValue(Action.SHORT_DESCRIPTION,
				"Fills the area beneath the mouse cursor with the fill color");

		subimage.putValue(Action.SHORT_DESCRIPTION,
				"Get a new image from the selected subimage");
		trim.putValue(Action.SHORT_DESCRIPTION,
				"Fills white the area outside the selection");
		invert.putValue(Action.SHORT_DESCRIPTION, "Inverts the image");
		binarize.putValue(Action.SHORT_DESCRIPTION,
				"Manually binarizes the image using a global threshold");
		greyscaleConversion
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Manually converts a color image in a greyscale image using three weight factors");
		autoBin
				.putValue(Action.SHORT_DESCRIPTION,
						"Binarizes the image using a Gauss Filter to calculate a local threshold");
		despeckle
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Manually despeckles the whole image/the selected image area using a Median Filter");
		minMax
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Manually smoothes the image while preserving edge slopes using a Minimum Filter");
		smooth.putValue(Action.SHORT_DESCRIPTION,
				"Smoothes the image using a Gauss Filter");
		sharpen.putValue(Action.SHORT_DESCRIPTION,
				"Manually sharpens the image using a USM-Filter");
		brightness.putValue(Action.SHORT_DESCRIPTION,
				"Manually brightens/darkens the image");
		skeletonize
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Thins the image; requires a binarized area, black tree (foreground), white background");
		chooseNode.putValue(Action.SHORT_DESCRIPTION,
				"Lets the user select a node or a branch to manipulate");
		autoSkeletonize
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Thins freehand drawings with the pencil; works on a binarized image on white background, but not near the image border");
		autoFlood
				.putValue(
						Action.SHORT_DESCRIPTION,
						"After a drawing operation, floods the foreground starting from where the user has initiated the last Flood Fill");
		floodFill
				.putValue(Action.SHORT_DESCRIPTION,
						"Fills the foreground around the mouse location with a distinctive color");
		pipette.putValue(Action.SHORT_DESCRIPTION,
				"Stores the color beneath the mouse cursor as fill color");
		useWizard.putValue(Action.SHORT_DESCRIPTION,
				"Activates/deactivates the Wizard Dialog");
		smallMarks.putValue(Action.SHORT_DESCRIPTION,
				"Displays either normally sized or small nodes and branches");
		markFloodSeed
				.putValue(Action.SHORT_DESCRIPTION,
						"Marks the initiation point of the most recent FloodFill operation");
		autoClean
				.putValue(Action.SHORT_DESCRIPTION,
						"Surrounds lines and curves the user draws with a white border");
		srcInMagnifier
				.putValue(Action.SHORT_DESCRIPTION,
						"Blends/does not blend source image and current image in the magnifier");
		fgColorInMagnifier
				.putValue(Action.SHORT_DESCRIPTION,
						"Paints the foreground pixels using a signal color in the magnifier");
		fgColMagnifier
				.putValue(Action.SHORT_DESCRIPTION,
						"Sets the color in which the foreground is shown in the magnifier");
		extractArea
				.putValue(Action.SHORT_DESCRIPTION,
						"Visually isolates the flooded area as the tree topology to be analyzed");
		fancyCursors.putValue(Action.SHORT_DESCRIPTION,
				"Enables/disables the use of custom mouse cursors");
		suppressTinyBranches
				.putValue(
						Action.SHORT_DESCRIPTION,
						"If active, TreeSnatcher suppresss branches that are shorter than length that can be specified");
		detectNodes.putValue(Action.SHORT_DESCRIPTION,
				"Locate tips and inner nodes of the tree depicted");
		detectBranches.putValue(Action.SHORT_DESCRIPTION,
				"Calculates the branches of the tree depicted");
		nodesStickToTree
				.putValue(
						Action.SHORT_DESCRIPTION,
						"If activated, tree nodes can be moved only on the foreground color black (should be the tree)");
		addInnerNode.putValue(Action.SHORT_DESCRIPTION,
				"Add an inner node to the tree");
		addTip.putValue(Action.SHORT_DESCRIPTION, "Add a tip to the tree");
		removeNode.putValue(Action.SHORT_DESCRIPTION,
				"Removes the currently selected node");
		removeNodes.putValue(Action.SHORT_DESCRIPTION,
				"Removes all nodes within the selection");
		discardUserObjects.putValue(Action.SHORT_DESCRIPTION,
				"Determines whether user generated objects can be deleted");
		dragBranch.putValue(Action.SHORT_DESCRIPTION,
				"Drag a branch between two nodes");
		drawBranchLength.putValue(Action.SHORT_DESCRIPTION,
				"If selected, draw the length along each branch");
		drawTaxonName.putValue(Action.SHORT_DESCRIPTION,
				"If selected, draw the Taxon name at each tip");
		clearImage
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Clears the image; useful if you desire to edit a newly recognized topology isolated from the foreground");
		scaleImage2x.putValue(Action.SHORT_DESCRIPTION,
				"Scales the whole image by a factor of two");
		scaleImage05x.putValue(Action.SHORT_DESCRIPTION,
				"Scales the whole image by a factor of 1/2");
		inputBranchLength.putValue(Action.SHORT_DESCRIPTION,
				"Input the branch length");
		nameTaxon.putValue(Action.SHORT_DESCRIPTION,
				"Specify a taxon name for a tip");
		asReferenceNode
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Specify the node starting from which the Newick expression is recursively built");
		highlightBranchesWithoutLength
				.putValue(
						Action.SHORT_DESCRIPTION,
						"If selected, highlights all branches for which the user has not yet specified a length");
		highlightTipsWithoutName
				.putValue(Action.SHORT_DESCRIPTION,
						"If selected, highlights all tips for which no taxon name is specified yet");
		removeBranch.putValue(Action.SHORT_DESCRIPTION,
				"Removes the currently selected branch");
		removeBranches.putValue(Action.SHORT_DESCRIPTION,
				"Removes all branches within the selection");
		enterScaleBarLength
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Use the Line Selection tool to mark a line on the tree that has a known length in tree units");
		showPhylipExpression.putValue(Action.SHORT_DESCRIPTION,
				"Show the Newick expression window");
		oneNodeMode.putValue(Action.SHORT_DESCRIPTION,
				"Display all branches/only those linked to the selected node");
		histogramStretch.putValue(Action.SHORT_DESCRIPTION,
				"Performs a histogram stretch on the greyscale image");
		fillDialog.putValue(Action.SHORT_DESCRIPTION, "Opens the Fill Dialog");
		showColorBeneathMouse.putValue(Action.SHORT_DESCRIPTION,
				"Displays the color in the image at the mouse position");
		grabMotif
				.putValue(Action.SHORT_DESCRIPTION,
						"Grabs the image section within the selection box for Stencil or Color Dialog");
		colorQuant.putValue(Action.SHORT_DESCRIPTION,
				"Reduces the number of colors in the image");
		allowNodesAnywhere.putValue(Action.SHORT_DESCRIPTION,
				"Allows the user to put nodes anywhere he likes");
		includeBranchLengths
				.putValue(Action.SHORT_DESCRIPTION,
						"Displays or omits branch lengths in the Newick expression ('Scaled tree')");
		useUserAssignedLengths.putValue(Action.SHORT_DESCRIPTION,
				"Uses and displays typed-in branch lengths");
		useCalculatedLengths.putValue(Action.SHORT_DESCRIPTION,
				"Uses and displays calculated branch lengths");
		useMixedLengths.putValue(Action.SHORT_DESCRIPTION,
				"Uses and displays calculated and typed-in branch lengths");
		coloredNewickExpression
				.putValue(Action.SHORT_DESCRIPTION,
						"Uses distinct colors for names and branch lengths in the Newick String");
		showPreciseBranches
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Shows path segments relevant for the branch length colored in red, others in black");
		showAllBranches.putValue(Action.SHORT_DESCRIPTION,
				"Shows all logical branches");
		oneNodeMode
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Shows the paths the program found between the currently selected node and neighboring nodes");
		Set1ToScaleTree
				.putValue(
						Action.SHORT_DESCRIPTION,
						"If executed on the selected branch, the tree is scaled based on the respective calculated branch length in pixels: The length becomes 1.0");
		useToScaleTree
				.putValue(
						Action.SHORT_DESCRIPTION,
						"If executed on the selected branch, the tree is scaled based on the respective calculated branch length in pixels: The length can be typed in");
		topologyFree
				.putValue(
						Action.SHORT_DESCRIPTION,
						"The tree topology is not constrained; any branch length is the full branch from node to node");
		topologyRect
				.putValue(
						Action.SHORT_DESCRIPTION,
						"The tree is rectangular; any branch length is the sum of the straight/horizontal branch segments; does not work for very small branches or 'round bends'");
		topologyPolar
				.putValue(
						Action.SHORT_DESCRIPTION,
						"The tree has a radial shape, any branch length is the sum of the straight/horizontal branch segments");
		useElaboratePathFinding
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Turn on for topologies with fuzzy node placement, off for topologies with very small branches. You may also select the look-ahead distance which indicates the shortest distance between two nodes in the image");
		showReadme.putValue(Action.SHORT_DESCRIPTION, "Don't know.");
		showTutorials
				.putValue(Action.SHORT_DESCRIPTION,
						"Displays a page with hyperlinks to the TreeSnatcher Plus tutorials");
		suggestLookahead
				.putValue(Action.SHORT_DESCRIPTION,
						"Calculates and sets a look-ahead distance based on the densest pair of nodes");
		insertRoot
				.putValue(
						Action.SHORT_DESCRIPTION,
						"Inserts the root in the middle of the selected branch and modifies the topology accordingly.");
	}

	public void setObjectReferences(ImagePanel ip, FileOperations fo,
			TreeTopology to) {
		this.imagePanel = ip;
		this.fileOp = fo;
		this.topology = to;
	}

	private void makeActions() {
		newImage = new GUIAction("New Image");
		openImage = new GUIAction("Open Image");

		// KeyStroke openKey = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE,
		// KeyEvent.CTRL_MASK);
		// openImage.putValue(Action.ACCELERATOR_KEY, openKey);
		// openImage.putValue(Action.MNEMONIC_KEY, new Integer(KeyEvent.VK_E));
		openSnapshot = new GUIAction("Open Snapshot");
		saveImage = new GUIAction("Save Image");
		saveIllustration = new GUIAction("Save Image");
		saveNewick = new GUIAction("Save Newick");
		saveSnapshot = new GUIAction("Save Snapshot");
		rectSelection = new GUIAction("Box Selection");
		lineSelection = new GUIAction("Line Selection");
		allSelection = new GUIAction("Whole Image");
		polySelection = new GUIAction("Polygonal");
		chooseNode = new GUIAction("Move Node");
		fill_black = new GUIAction("Fill Selection Black");
		fill_white = new GUIAction("Fill Selection White");
		localFill = new GUIAction("Fill");
		pipette = new GUIAction("Pipette");
		subimage = new GUIAction("Crop");
		trim = new GUIAction("Trim");
		draw = new GUIAction("Pencil");
		erase = new GUIAction("Rubber");
		drawBlackLine = new GUIAction("Black Line");
		drawWhiteLine = new GUIAction("White Line");
		drawQuadCurve = new GUIAction("Curve");
		stencil = new GUIAction("Stencil");
		invert = new GUIAction("Invert");
		despeckle = new GUIAction("Despeckle");
		autoBin = new GUIAction("Local Threshold");
		minMax = new GUIAction("Minimum");
		colorQuant = new GUIAction("Color Quantization");
		binarize = new GUIAction("Global Threshold");
		fillDialog = new GUIAction("Fill Dialog");
		greyscaleConversion = new GUIAction("Greyscale Conversion");
		smooth = new GUIAction("Smooth");
		skeletonize = new GUIAction("Thin");
		sharpen = new GUIAction("Sharpen");
		brightness = new GUIAction("Brightness");
		autoSkeletonize = new GUIAction("Thin freehand drawings");
		autoClean = new GUIAction("Mask user drawings");
		autoFlood = new GUIAction("Flood user drawings");
		floodFill = new GUIAction("Flood Foreground");
		useWizard = new GUIAction("Use Wizard");
		smallMarks = new GUIAction("Small Nodes and Branches");
		markFloodSeed = new GUIAction("Mark TreeFlood Seed");
		fgColorInMagnifier = new GUIAction("Highlight Foreground");
		srcInMagnifier = new GUIAction("Show Source Image");
		fgColMagnifier = new GUIAction("Set Foreground Color");
		undo = new GUIAction("Undo");

		extractArea = new GUIAction("Extract Foreground");
		fancyCursors = new GUIAction("Use Fancy Cursors");
		suppressTinyBranches = new GUIAction("Suppress Tiny Branches");
		detectNodes = new GUIAction("Locate Nodes");
		detectBranches = new GUIAction("Calculate Branches");
		nodesStickToTree = new GUIAction("Nodes Stick to Foreground");
		addInnerNode = new GUIAction("Add Inner Node");
		addTip = new GUIAction("Add Tip");
		removeNode = new GUIAction("Remove Node");
		removeNodes = new GUIAction("Remove Nodes in Selection");
		removeBranch = new GUIAction("Remove Branch");
		removeBranches = new GUIAction("Remove Branches in Selection");
		discardUserObjects = new GUIAction("May Discard User Generated Objects");
		dragBranch = new GUIAction("Drag Branch");
		drawBranchLength = new GUIAction("Draw Branch Lengths");
		drawTaxonName = new GUIAction("Draw Taxon Names");
		clearImage = new GUIAction("Clear All");
		scaleImage2x = new GUIAction("Double Size");
		scaleImage05x = new GUIAction("Half Size");
		inputBranchLength = new GUIAction("Input User Branch Length");
		nameTaxon = new GUIAction("Name Taxon");
		asReferenceNode = new GUIAction("Use Node as Origin");
		highlightBranchesWithoutLength = new GUIAction(
				"Highlight branches without user length");
		highlightTipsWithoutName = new GUIAction(
				"Highlight tips without user name");
		enterScaleBarLength = new GUIAction("Get Scale Bar Length");
		showPhylipExpression = new GUIAction("Toggle Newick View");
		histogramStretch = new GUIAction("Histogram Stretch");
		showColorBeneathMouse = new GUIAction("Show Color Value Beneath Mouse");
		grabMotif = new GUIAction("Grab Motif");
		allowNodesAnywhere = new GUIAction("Allow to Set Nodes Anywhere");
		includeBranchLengths = new GUIAction("Newick Expression With Lengths");
		useUserAssignedLengths = new GUIAction("Use User Assigned Lengths");
		useCalculatedLengths = new GUIAction("Use Calculated Lengths");
		useMixedLengths = new GUIAction("Use Mixed Lengths");
		coloredNewickExpression = new GUIAction("Shaded Newick String");
		oneNodeMode = new GUIAction("Check Linked Branches");
		showPreciseBranches = new GUIAction("Show Branch Length Composition");
		showAllBranches = new GUIAction("Show All Branches");
		Set1ToScaleTree = new GUIAction("Use Length 1.0 to Scale Tree");
		useToScaleTree = new GUIAction("Use Length to Scale Tree");
		topologyFree = new GUIAction("Freeform");
		topologyRect = new GUIAction("Rectangular");
		topologyPolar = new GUIAction("Polar");
		useElaboratePathFinding = new GUIAction("Use Elaborate Path Finding");
		showReadme = new GUIAction("Display Readme");
		showTutorials = new GUIAction("Show tutorials");
		suggestLookahead = new GUIAction("Suggest look-ahead distance");
		insertRoot = new GUIAction("Insert Root");
	}

	public void toggleUndoAction(boolean b) {
		undo.setEnabled(b);
	}

	public void stateChanged(ChangeEvent e) {
		if (e.getSource() == ratioSlider) {
			float transRatio = ratioSlider.getValue();
			wizard.transparencyRatio = transRatio / 10;
			wizard.ratioSliderValue = ratioSlider.getValue();
			imagePanel.repaint();
		}
	}

	private void buildMenu() {
		// Menu
		menuBar = new JMenuBar();
		JMenu fileMenu = new JMenu("File");
		JMenu editMenu = new JMenu("Edit");
		JMenu imageMenu = new JMenu("Image");
		JMenu processMenu = new JMenu("Process");
		JMenu recognitionMenu = new JMenu("Recognition");
		JMenu specialMenu = new JMenu("Settings");
		JMenu helpMenu = new JMenu("Help");
		JMenu magnifierMenu = new JMenu("Magnifier Settings");
		JMenu recentlyUsedMenu = new JMenu("Recently Used");

		mRect = new JRadioButtonMenuItem(rectSelection);
		mLine = new JRadioButtonMenuItem(lineSelection);
		mPoly = new JRadioButtonMenuItem(polySelection);
		mDragBranch = new JRadioButtonMenuItem(dragBranch);
		mChooseNode = new JRadioButtonMenuItem(chooseNode);
		mLocalFill = new JRadioButtonMenuItem(localFill);
		mChooseNode.setSelected(false);
		mDraw = new JRadioButtonMenuItem(draw);
		mDrawBlackLine = new JRadioButtonMenuItem(drawBlackLine);
		mDrawWhiteLine = new JRadioButtonMenuItem(drawWhiteLine);
		mDrawQuadCurve = new JRadioButtonMenuItem(drawQuadCurve);
		mErase = new JRadioButtonMenuItem(erase);
		mPipette = new JRadioButtonMenuItem(pipette);
		mLocalFill = new JRadioButtonMenuItem(localFill);
		mBinarize = new JMenuItem(binarize);
		mFillDialog = new JMenuItem(fillDialog);
		mGreyscaleConversion = new JMenuItem(greyscaleConversion);
		mSmooth = new JMenuItem(smooth);
		mSharpen = new JMenuItem(sharpen);
		mBrightness = new JMenuItem(brightness);
		mDespeckle = new JMenuItem(despeckle);
		mColorQuant = new JMenuItem(colorQuant);
		mMinMax = new JMenuItem(minMax);
		mAutoSkeletonize = new JCheckBoxMenuItem(autoSkeletonize);
		mAutoSkeletonize.setSelected(true);
		mFloodFill = new JMenuItem(floodFill);
		mUseWizard = new JCheckBoxMenuItem(useWizard);
		mUseWizard.setSelected(wizard.useWizard);
		mSmallMarks = new JCheckBoxMenuItem(smallMarks);
		mSmallMarks.setSelected(false);
		mMarkFloodSeed = new JCheckBoxMenuItem(markFloodSeed);
		mMarkFloodSeed.setSelected(wizard.markFloodSeed);
		mAutoClean = new JCheckBoxMenuItem(autoClean);
		mAutoClean.setSelected(false);
		mAutoFlood = new JCheckBoxMenuItem(autoFlood);
		mAutoFlood.setSelected(true);
		mSrcInMagnifier = new JCheckBoxMenuItem(srcInMagnifier);
		mFGColorMagnifier = new JMenuItem(fgColMagnifier);
		mFGColorInMagnifier = new JCheckBoxMenuItem(fgColorInMagnifier);
		mExtractArea = new JMenuItem(extractArea);
		mUseFancyCursors = new JCheckBoxMenuItem(fancyCursors);
		mUseFancyCursors.setSelected(true);
		mAllowNodesAnywhere = new JCheckBoxMenuItem(allowNodesAnywhere);
		mSuppressTinyBranches = new JCheckBoxMenuItem(suppressTinyBranches);
		mSuppressTinyBranches.setSelected(true);
		mNodesStickToTree = new JCheckBoxMenuItem(nodesStickToTree);
		mNodesStickToTree.setSelected(true);
		mDetectNodes = new JMenuItem(detectNodes);
		mDetectBranches = new JMenuItem(detectBranches);

		mRemoveNode = new JMenuItem(removeNode);
		mRemoveNodes = new JMenuItem(removeNodes);
		mRemoveBranch = new JMenuItem(removeBranch);
		mRemoveBranches = new JMenuItem(removeBranches);
		mDiscardUserObjects = new JCheckBoxMenuItem(discardUserObjects);
		mDrawBranchLength = new JCheckBoxMenuItem(drawBranchLength);
		mAllowNodesAnywhere = new JCheckBoxMenuItem(allowNodesAnywhere);
		mAllowNodesAnywhere.setSelected(false);
		mIncludeBranchLengths = new JCheckBoxMenuItem(includeBranchLengths);
		mIncludeBranchLengths.setSelected(wizard.includeBranchLengths);
		mDrawBranchLength.setSelected(false);
		mDrawTaxonName = new JCheckBoxMenuItem(drawTaxonName);
		mDrawTaxonName.setSelected(true);
		mClearImage = new JMenuItem(clearImage);
		mFillBlack = new JMenuItem(fill_black);
		mFillWhite = new JMenuItem(fill_white);
		mInvert = new JMenuItem(invert);
		mTrim = new JMenuItem(trim);
		mSubimage = new JMenuItem(subimage);
		mScaleImage2x = new JMenuItem(scaleImage2x);
		mScaleImage05x = new JMenuItem(scaleImage05x);
		mNameTaxon = new JMenuItem(nameTaxon);
		mAsReferenceNode = new JMenuItem(asReferenceNode);
		mInputBranchLength = new JMenuItem(inputBranchLength);
		mHighlightBranchesWithoutLength = new JCheckBoxMenuItem(
				highlightBranchesWithoutLength);
		mHighlightTipsWithoutName = new JCheckBoxMenuItem(
				highlightTipsWithoutName);
		mEnterScaleBarLength = new JMenuItem(enterScaleBarLength);
		mShowPhylipExpression = new JMenuItem(showPhylipExpression);
		mColoredNewickExpression = new JCheckBoxMenuItem(
				coloredNewickExpression);
		mColoredNewickExpression.setSelected(wizard.colorNewickString);

		mTopologyFree = new JRadioButtonMenuItem(topologyFree);
		mTopologyRect = new JRadioButtonMenuItem(topologyRect);
		mTopologyPolar = new JRadioButtonMenuItem(topologyPolar);

		mUseElaboratePathFinding = new JCheckBoxMenuItem(
				useElaboratePathFinding);
		mUseElaboratePathFinding.setSelected(wizard.useElaboratePathFinding);

		mShowReadme = new JMenuItem(showReadme);
		mShowTutorials = new JMenuItem(showTutorials);

		ButtonGroup tsbg = new ButtonGroup();
		tsbg.add(mTopologyFree);
		tsbg.add(mTopologyRect);
		tsbg.add(mTopologyPolar);
		if (wizard.topologyType == FREE)
			mTopologyFree.setSelected(true);
		else if (wizard.topologyType == RECTANGULAR)
			mTopologyRect.setSelected(true);
		else if (wizard.topologyType == POLAR)
			mTopologyPolar.setSelected(true);

		mShowAllBranches = new JRadioButtonMenuItem(showAllBranches);
		mShowAllBranches.setSelected(wizard.showAllBranches);
		mOneNodeMode = new JRadioButtonMenuItem(oneNodeMode);
		mShowPreciseBranches = new JRadioButtonMenuItem(showPreciseBranches);

		mHistogramStretch = new JMenuItem(histogramStretch);
		mUseUserAssignedLengths = new JRadioButtonMenuItem(
				useUserAssignedLengths);
		mUseUserAssignedLengths.setSelected(Wizard.useUserAssignedLengths);
		mUseCalculatedLengths = new JRadioButtonMenuItem(useCalculatedLengths);
		mUseCalculatedLengths.setSelected(Wizard.useCalculatedLengths);
		mUseMixedLengths = new JRadioButtonMenuItem(useMixedLengths);
		mUseMixedLengths.setSelected(Wizard.useMixedLengths);
		mAutoBin = new JMenuItem(autoBin);
		mSkeletonize = new JMenuItem(skeletonize);
		mSet1ToScaleTree = new JMenuItem(Set1ToScaleTree);
		mUseToScaleTree = new JMenuItem(useToScaleTree);
		// mSuggestLookahead = new JMenuItem(suggestLookahead);
		// mInsertRoot = new JMenuItem(insertRoot);

		ButtonGroup msbg = new ButtonGroup();
		msbg.add(mRect);
		msbg.add(mLine);
		msbg.add(mChooseNode);
		msbg.add(mDragBranch);
		msbg.add(mDraw);
		msbg.add(mDrawBlackLine);
		msbg.add(mDrawWhiteLine);
		msbg.add(mDrawQuadCurve);
		msbg.add(mErase);
		msbg.add(mPipette);
		msbg.add(mLocalFill);

		ButtonGroup lbg = new ButtonGroup();
		lbg.add(mUseUserAssignedLengths);
		lbg.add(mUseCalculatedLengths);
		lbg.add(mUseMixedLengths);

		ButtonGroup mbg = new ButtonGroup();
		mbg.add(mShowAllBranches);
		mbg.add(mShowPreciseBranches);
		mbg.add(mOneNodeMode);

		// Add all menu items to the menues
		fileMenu.add(openImage);
		// fileMenu.add(recentlyUsedMenu);
		fileMenu.add(openSnapshot);
		fileMenu.add(newImage);
		fileMenu.add(saveIllustration);
		fileMenu.add(saveSnapshot);
		fileMenu.add(saveNewick);

		editMenu.add(undo);

		editMenu.addSeparator();
		editMenu.add(mDraw);
		editMenu.add(mDrawBlackLine);
		editMenu.add(mDrawWhiteLine);
		editMenu.add(mDrawQuadCurve);
		editMenu.add(mErase);
		editMenu.addSeparator();
		editMenu.add(mFillDialog);
		editMenu.add(mFillBlack);
		editMenu.add(mFillWhite);
		editMenu.add(mLocalFill);
		editMenu.add(mClearImage);
		editMenu.add(mPipette);
		editMenu.addSeparator();
		editMenu.add(allSelection);
		editMenu.add(mRect);
		editMenu.add(mLine);

		imageMenu.add(mTrim);
		imageMenu.add(mSubimage);
		imageMenu.add(mInvert);
		imageMenu.add(mScaleImage2x);
		imageMenu.add(mScaleImage05x);
		imageMenu.addSeparator();
		imageMenu.add(mHistogramStretch);
		imageMenu.add(mColorQuant);
		imageMenu.add(mGreyscaleConversion);

		processMenu.add(mBrightness);
		processMenu.add(mSmooth);
		processMenu.add(mSharpen);
		processMenu.add(mDespeckle);
		processMenu.add(mMinMax);
		processMenu.addSeparator();
		processMenu.add(mAutoBin);
		processMenu.add(mBinarize);
		processMenu.addSeparator();
		processMenu.add(mSkeletonize);

		recognitionMenu.add(mFloodFill);
		recognitionMenu.add(mExtractArea);
		recognitionMenu.addSeparator();
		recognitionMenu.add(mDetectNodes);
		recognitionMenu.add(mDetectBranches);
		recognitionMenu.addSeparator();
		recognitionMenu.add(mChooseNode);
		recognitionMenu.add(mDragBranch);
		recognitionMenu.addSeparator();
		recognitionMenu.add(mNameTaxon);
		recognitionMenu.add(mAsReferenceNode);
		// recognitionMenu.add(mInsertRoot);
		recognitionMenu.add(mInputBranchLength);
		recognitionMenu.add(mEnterScaleBarLength);
		recognitionMenu.add(mSet1ToScaleTree);
		recognitionMenu.add(mUseToScaleTree);
		recognitionMenu.addSeparator();
		recognitionMenu.add(mTopologyFree);
		recognitionMenu.add(mTopologyRect);
		// recognitionMenu.add(mTopologyPolar);
		recognitionMenu.addSeparator();
		recognitionMenu.add(mRemoveNode);
		recognitionMenu.add(mRemoveNodes);
		recognitionMenu.add(mRemoveBranch);
		recognitionMenu.add(mRemoveBranches);
		recognitionMenu.addSeparator();
		recognitionMenu.add(mShowPhylipExpression);
		recognitionMenu.addSeparator();
		recognitionMenu.add(mUseElaboratePathFinding);
		recognitionMenu.add(suggestLookahead);

		specialMenu.add(magnifierMenu);

		specialMenu.add(mUseFancyCursors);
		specialMenu.add(mMarkFloodSeed);
		specialMenu.addSeparator();
		specialMenu.add(mAutoSkeletonize);
		specialMenu.add(mAutoClean);
		specialMenu.add(mAutoFlood);
		specialMenu.addSeparator();
		specialMenu.add(mDrawBranchLength);
		specialMenu.add(mDrawTaxonName);
		specialMenu.add(mSmallMarks);
		specialMenu.addSeparator();
		specialMenu.add(mHighlightBranchesWithoutLength);
		mHighlightBranchesWithoutLength.setSelected(false);
		specialMenu.add(mHighlightTipsWithoutName);
		mHighlightTipsWithoutName.setSelected(false);

		specialMenu.addSeparator();
		specialMenu.add(mIncludeBranchLengths);
		specialMenu.add(mUseUserAssignedLengths);
		mUseUserAssignedLengths.setSelected(false);
		specialMenu.add(mUseCalculatedLengths);
		mUseCalculatedLengths.setSelected(true);
		specialMenu.add(mUseMixedLengths);
		mUseMixedLengths.setSelected(false);
		specialMenu.add(mColoredNewickExpression);
		specialMenu.addSeparator();

		specialMenu.add(mShowAllBranches);
		specialMenu.add(mOneNodeMode);
		specialMenu.add(mShowPreciseBranches);

		magnifierMenu.add(mSrcInMagnifier);
		magnifierMenu.add(mFGColorInMagnifier);
		magnifierMenu.add(mFGColorMagnifier);

		helpMenu.addSeparator();
		helpMenu.add(mShowReadme);
		helpMenu.add(mShowTutorials);

		// Add all menus to the menu bar and add it to MainWindow
		menuBar.add(fileMenu);
		menuBar.add(editMenu);
		menuBar.add(imageMenu);
		menuBar.add(processMenu);
		menuBar.add(recognitionMenu);
		menuBar.add(specialMenu);
		menuBar.add(helpMenu);

		owner.setJMenuBar(menuBar);
	}

	private void buildPopupMenu() {
		popupMenu = new JPopupMenu();
		popupMenu.setBorderPainted(true);
		popupMenu.setBorder(BorderFactory.createEtchedBorder());
		pUndo = new JMenuItem(undo);
		pRect = new JRadioButtonMenuItem(rectSelection);
		pLineSel = new JRadioButtonMenuItem(lineSelection);
		pDraw = new JRadioButtonMenuItem(draw);
		pDrawBlackLine = new JRadioButtonMenuItem(drawBlackLine);
		pDrawWhiteLine = new JRadioButtonMenuItem(drawWhiteLine);
		pDrawQuadCurve = new JRadioButtonMenuItem(drawQuadCurve);
		pErase = new JRadioButtonMenuItem(erase);
		pPipette = new JRadioButtonMenuItem(pipette);
		pLocalFill = new JRadioButtonMenuItem(localFill);
		pChooseNode = new JRadioButtonMenuItem(chooseNode);
		pDragBranch = new JRadioButtonMenuItem(dragBranch);
		pDetectNodes = new JMenuItem(detectNodes);
		pDetectBranches = new JMenuItem(detectBranches);
		pAutoClean = new JCheckBoxMenuItem(autoClean);
		pAddInnerNode = new JMenuItem(addInnerNode);
		pAddTip = new JMenuItem(addTip);
		pNameTaxon = new JMenuItem(nameTaxon);
		pAsReferenceNode = new JMenuItem(asReferenceNode);
		pInputBranchLength = new JMenuItem(inputBranchLength);
		pRemoveNode = new JMenuItem(removeNode);
		pRemoveNodes = new JMenuItem(removeNodes);
		pRemoveBranch = new JMenuItem(removeBranch);
		pRemoveBranches = new JMenuItem(removeBranches);
		pFloodFill = new JMenuItem(floodFill);
		pExtractArea = new JMenuItem(extractArea);
		pDetectNodes = new JMenuItem(detectNodes);
		pEnterScaleBarLength = new JMenuItem(enterScaleBarLength);
		pShowAllBranches = new JCheckBoxMenuItem(showAllBranches);
		pShowAllBranches.setSelected(wizard.showAllBranches);
		pOneNodeMode = new JCheckBoxMenuItem(oneNodeMode);
		pShowPreciseBranches = new JCheckBoxMenuItem(showPreciseBranches);
		pSet1ToScaleTree = new JMenuItem(Set1ToScaleTree);
		pUseToScaleTree = new JMenuItem(useToScaleTree);
		// pInsertRoot = new JMenuItem(insertRoot);

		ButtonGroup bg = new ButtonGroup();
		bg.add(pRect);
		bg.add(pDraw);
		bg.add(pDrawBlackLine);
		bg.add(pDrawWhiteLine);
		bg.add(pDrawQuadCurve);
		bg.add(pErase);
		bg.add(pPipette);
		bg.add(pChooseNode);
		bg.add(pDragBranch);
		bg.add(pLocalFill);
		bg.add(pLineSel);

		ButtonGroup vbg = new ButtonGroup();
		vbg.add(pOneNodeMode);
		vbg.add(pShowAllBranches);
		vbg.add(pShowPreciseBranches);

		popupMenu.add(pUndo);
		popupMenu.addSeparator();
		popupMenu.add(pRect);
		popupMenu.add(pLineSel);
		popupMenu.add(pDraw);
		popupMenu.add(pErase);
		popupMenu.add(pDrawBlackLine);
		popupMenu.add(pDrawWhiteLine);
		popupMenu.add(pPipette);
		popupMenu.add(pLocalFill);
		popupMenu.addSeparator();
		popupMenu.add(pNameTaxon);
		popupMenu.add(pAsReferenceNode);
		// popupMenu.add(pInsertRoot);
		popupMenu.add(pInputBranchLength);
		popupMenu.add(pEnterScaleBarLength);
		popupMenu.add(pSet1ToScaleTree);
		popupMenu.add(pUseToScaleTree);
		popupMenu.addSeparator();
		popupMenu.add(pFloodFill);
		popupMenu.add(pExtractArea);
		popupMenu.addSeparator();
		popupMenu.add(pDetectNodes);
		popupMenu.add(pDetectBranches);
		popupMenu.addSeparator();
		popupMenu.add(pChooseNode);
		popupMenu.add(pAddInnerNode);
		popupMenu.add(pAddTip);
		popupMenu.add(pDragBranch);
		popupMenu.addSeparator();
		popupMenu.add(pRemoveNode);
		popupMenu.add(pRemoveNodes);
		popupMenu.add(pRemoveBranch);
		popupMenu.add(pRemoveBranches);
		popupMenu.addSeparator();
		popupMenu.add(pShowAllBranches);
		popupMenu.add(pOneNodeMode);
		popupMenu.add(pShowPreciseBranches);
	}

	private void buildLeftToolbar() {
		int tWidth = 220;
		toolbar = new JToolBar();
		toolbar.setRollover(true);
		toolbar.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 4));
		toolbar.setPreferredSize(new Dimension(tWidth, 740));

		toolbar.setMinimumSize(toolbar.getPreferredSize());
		toolbar.setRollover(true);
		toolbar.setFloatable(false);
		toolbar.setOrientation(JToolBar.VERTICAL);
		owner.getContentPane().add(toolbar, BorderLayout.WEST);

		// Place color chooser and color dialog (Button "Color Dialog")
		colorChooser = new JColorChooser(Color.black);
		cDialog = new JDialog();
		colorManipDialog = new FillDialog("Color Range Manipulation", owner,
				true);
		colorManipDialog
				.setLocation((int) (Toolkit.getDefaultToolkit().getScreenSize()
						.getWidth() / 2 - colorManipDialog.getWidth() / 2), 30);
		colorManipDialog.setVisible(false);

		tNewImage = new JButton(newImage);
		tOpenImage = new JButton(openImage);
		tOpenSnapshot = new JButton(openSnapshot);

		tSaveIllustration = new JButton(saveIllustration);
		tSaveSnapshot = new JButton(saveSnapshot);
		tSaveNewick = new JButton(saveNewick);
		tRect = new JRadioButton(rectSelection);
		tLine = new JRadioButton(lineSelection);
		tChooseNode = new JRadioButton(chooseNode);
		tChooseNode.setSelected(false);
		tDragBranch = new JRadioButton(dragBranch);
		tDragBranch.setSelected(false);
		tPoly = new JRadioButton(polySelection);
		tDraw = new JRadioButton(draw);
		tDrawBlackLine = new JRadioButton(drawBlackLine);
		tDrawWhiteLine = new JRadioButton(drawWhiteLine);
		tDrawQuadCurve = new JRadioButton(drawQuadCurve);
		tPipette = new JRadioButton(pipette);
		tLocalFill = new JRadioButton(localFill);
		tErase = new JRadioButton(erase);
		tStencil = new JRadioButton(stencil);
		tTopologyFree = new JRadioButton(topologyFree);
		tTopologyRect = new JRadioButton(topologyRect);
		tTopologyPolar = new JRadioButton(topologyPolar);

		ButtonGroup topg = new ButtonGroup();
		topg.add(tTopologyFree);
		topg.add(tTopologyRect);
		topg.add(tTopologyPolar);
		if (wizard.topologyType == FREE)
			tTopologyFree.setSelected(true);
		else if (wizard.topologyType == RECTANGULAR)
			tTopologyRect.setSelected(true);
		else if (wizard.topologyType == POLAR)
			tTopologyPolar.setSelected(true);

		tFloodFill = new JButton(floodFill);
		tUndo = new JButton(undo);
		tUndo.setForeground(Color.red);

		ButtonGroup tsbg = new ButtonGroup();
		tsbg.add(tRect);
		tsbg.add(tLine);
		tsbg.add(tChooseNode);
		tsbg.add(tDragBranch);
		tsbg.add(tDraw);
		tsbg.add(tDrawBlackLine);
		tsbg.add(tDrawWhiteLine);
		tsbg.add(tDrawQuadCurve);
		tsbg.add(tErase);
		tsbg.add(tPipette);
		tsbg.add(tLocalFill);
		tsbg.add(tStencil);

		tAllSelection = new JButton(allSelection);
		tInvert = new JButton(invert);
		tFillBlack = new JButton(fill_black);
		tFillWhite = new JButton(fill_white);
		tClearImage = new JButton(clearImage);

		tAutoBin = new JButton(autoBin);
		tBinarize = new JButton(binarize);
		tGreyscaleConversion = new JButton(greyscaleConversion);
		tBrightness = new JButton(brightness);
		tSmooth = new JButton(smooth);
		tSharpen = new JButton(sharpen);
		tDespeckle = new JButton(despeckle);
		tMinMax = new JButton(minMax);
		tFillDialog = new JButton(fillDialog);
		tSkeletonize = new JButton(skeletonize);
		tGrabMotif = new JButton(grabMotif);
		tAutoSkeletonize = new JToggleButton(autoSkeletonize);
		tAutoSkeletonize.setSelected(true);
		tUseWizard = new JToggleButton(useWizard);
		tUseWizard.setSelected(wizard.useWizard);
		tAutoClean = new JToggleButton(autoClean);
		tAutoClean.setSelected(false);
		tAutoFlood = new JToggleButton(autoFlood);
		tAutoFlood.setSelected(true);
		tSrcInMagnifier = new JToggleButton(srcInMagnifier);
		tSrcInMagnifier.setSelected(false);
		tFGColorMagnifier = new JButton(fgColMagnifier);
		tFGColorInMagnifier = new JToggleButton(fgColorInMagnifier);
		tExtractArea = new JButton(extractArea);
		tDetectNodes = new JButton(detectNodes);
		tDetectBranches = new JButton(detectBranches);

		tEnterScaleBarLength = new JButton(enterScaleBarLength);
		tShowPhylipExpression = new JButton(showPhylipExpression);

		// Add all controls to the toolbar
		toolbar.add(magnifier);
		toolbar.addSeparator();

		JPanel ioPanel = new JPanel();
		ioPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 2));

		ioPanel.setPreferredSize(new Dimension(tWidth - 16, 92));
		Border border = BorderFactory.createEtchedBorder();
		TitledBorder titledBorder = BorderFactory.createTitledBorder(border,
				"File Operations");
		titledBorder.setTitleJustification(TitledBorder.LEFT);
		ioPanel.setBorder(titledBorder);
		ioPanel.add(tOpenImage);
		ioPanel.add(tOpenSnapshot);
		ioPanel.add(Box.createRigidArea(new Dimension(0, 2)));
		ioPanel.add(tSaveIllustration);
		ioPanel.add(tSaveSnapshot);
		ioPanel.add(Box.createRigidArea(new Dimension(0, 2)));
		ioPanel.add(tNewImage);
		ioPanel.add(tSaveNewick);
		ioPanel.add(Box.createRigidArea(new Dimension(0, 2)));
		toolbar.add(ioPanel);

		JPanel modesPanel = new JPanel();
		modesPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 2));

		modesPanel.setPreferredSize(new Dimension(tWidth - 16, 150));
		border = BorderFactory.createEtchedBorder();
		titledBorder = BorderFactory.createTitledBorder(border,
				"Selection Tools");
		titledBorder.setTitleJustification(TitledBorder.LEFT);
		modesPanel.setBorder(titledBorder);
		modesPanel.add(tAllSelection);
		modesPanel.add(tGrabMotif);
		modesPanel.add(tRect);
		modesPanel.add(tLine);
		modesPanel.add(tChooseNode);
		modesPanel.add(tDragBranch);
		modesPanel.add(tFloodFill);
		toolbar.add(modesPanel);

		JPanel drawingToolsPanel = new JPanel();
		drawingToolsPanel.setLayout(new BorderLayout());
		drawingToolsPanel.setPreferredSize(new Dimension(tWidth - 16, 220));

		JPanel toolsPanel = new JPanel();
		toolsPanel.setLayout(new BoxLayout(toolsPanel, BoxLayout.Y_AXIS));
		toolsPanel.setSize(new Dimension(tWidth - 16, 182));
		JPanel drawPanel = new JPanel(new FlowLayout());
		GridLayout gLayout = new GridLayout(4, 2);
		gLayout.setHgap(2);
		gLayout.setVgap(2);
		drawPanel.setLayout(gLayout);

		drawPanel.add(tDraw);
		drawPanel.add(tErase);
		drawPanel.add(tDrawBlackLine);
		drawPanel.add(tDrawWhiteLine);
		drawPanel.add(tDrawQuadCurve);
		drawPanel.add(tPipette);
		drawPanel.add(tLocalFill);
		drawPanel.add(tStencil);
		toolsPanel.add(drawPanel);

		JPanel colorsPanel = new JPanel(new FlowLayout(FlowLayout.LEFT, 6, 8));
		colorsPanel.setPreferredSize(new Dimension(tWidth - 16, 30));
		JLabel textLabel = new JLabel("Color");
		colorsPanel.add(textLabel, FlowLayout.LEFT);
		colorBox = new ColorBox();
		colorsPanel.add(colorBox);
		colorsPanel.add(tFillDialog);
		toolsPanel.add(colorsPanel);

		drawingToolsPanel.add(toolsPanel, BorderLayout.NORTH);
		JPanel strokePanel = new JPanel();
		strokePanel.setLayout(new FlowLayout(FlowLayout.LEFT, 4, 4));
		strokePanel.setMaximumSize(new Dimension(tWidth - 16, 210));
		strokePanel.setPreferredSize(new Dimension(tWidth - 16, 210));

		JLabel drawingStrokeLabel = new JLabel("Pencil Width");
		drawingStrokeLabel.setPreferredSize(new Dimension(90, 20));
		strokePanel.add(drawingStrokeLabel);
		drawingStrokeSpinner = new JSpinner();
		drawingStrokeSpinner.setMaximumSize(new Dimension(40, 20));
		SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 30, 1);
		drawingStrokeSpinner.setModel(model);
		drawingStrokeSpinner.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				wizard.drawingStrokeWidth = (Integer) ((SpinnerNumberModel) drawingStrokeSpinner
						.getModel()).getValue();
				// Deselect automatic thinning as it is only sensible when using
				// stroke width 1
				if (wizard.drawingStrokeWidth != 1) {
					wizard.autoSkeletonize = false;
					tAutoSkeletonize.setSelected(false);
					mAutoSkeletonize.setSelected(false);
				}
				imagePanel.setDrawingStrokeWidth(wizard.drawingStrokeWidth);
			}
		});
		strokePanel.add(drawingStrokeSpinner);

		JLabel eraserStrokeLabel = new JLabel("Rubber Width");
		eraserStrokeLabel.setPreferredSize(new Dimension(90, 20));
		strokePanel.add(eraserStrokeLabel);
		eraserStrokeSpinner = new JSpinner();
		eraserStrokeSpinner.setMaximumSize(new Dimension(40, 20));
		SpinnerNumberModel model2 = new SpinnerNumberModel(
				wizard.eraserStrokeWidth, 1, 30, 1);
		eraserStrokeSpinner.setModel(model2);
		eraserStrokeSpinner.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				wizard.eraserStrokeWidth = (Integer) ((SpinnerNumberModel) eraserStrokeSpinner
						.getModel()).getValue();
				imagePanel.setEraserStrokeWidth(wizard.eraserStrokeWidth);
			}
		});
		strokePanel.add(eraserStrokeSpinner);

		JPanel autoPanel = new JPanel();
		strokePanel.add(autoPanel);
		drawingToolsPanel.add(strokePanel, BorderLayout.CENTER);
		border = BorderFactory.createEtchedBorder();
		titledBorder = BorderFactory
				.createTitledBorder(border, "Drawing Tools");
		titledBorder.setTitleJustification(TitledBorder.LEFT);
		drawingToolsPanel.setBorder(titledBorder);
		toolbar.add(drawingToolsPanel);
	}

	private void buildRightToolbar() {
		// Build a toolbar
		sliderbar = new JToolBar();
		sliderbar.setPreferredSize(new Dimension(186, 700));
		sliderbar.setMinimumSize(sliderbar.getPreferredSize());
		sliderbar.setLayout(new FlowLayout(FlowLayout.LEFT));
		sliderbar.setRollover(true);
		sliderbar.setFloatable(false);
		sliderbar.setOrientation(JToolBar.VERTICAL);
		// Add a mouse wheel listener to the right toolbar for blend ratio
		// manipulation
		sliderbar.addMouseWheelListener(new MouseWheelListener() {
			public void mouseWheelMoved(MouseWheelEvent e) {
				if (ratioSlider.isEnabled()) {
					int rotation = e.getWheelRotation();
					int value = Math.max(0, Math.min(ratioSlider.getValue()
							+ rotation, 10));
					ratioSlider.setValue(value);
					wizard.ratioSliderValue = value;
				}

			}
		});
		owner.getContentPane().add(sliderbar, BorderLayout.EAST);

		// Create a panel with a JSlider
		ratioSlider = new JSlider(JSlider.HORIZONTAL, 0, 10, 1);
		ratioSlider.setMajorTickSpacing(1);
		ratioSlider.setPaintTicks(true);
		ratioSlider.addChangeListener(this);
		ratioSlider.setValue(10);
		ratioSlider.setVisible(true);
		// Create the label table
		Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
		labelTable.put(0, new JLabel("Original"));
		labelTable.put(5, new JLabel("1:1"));
		labelTable.put(10, new JLabel("This"));
		ratioSlider.setLabelTable(labelTable);
		ratioSlider.setPreferredSize(new Dimension(70, 50));
		ratioSlider.setPaintLabels(true);
		wizard.ratioSliderValue = ratioSlider.getValue();
		sliderPanel = new JPanel(new BorderLayout());
		sliderPanel.setPreferredSize(new Dimension(170, 78));
		sliderPanel.add(ratioSlider, BorderLayout.CENTER);
		Border border = BorderFactory.createEtchedBorder();
		TitledBorder titledBorder = BorderFactory.createTitledBorder(border,
				"Blend Ratio");
		titledBorder.setTitleJustification(TitledBorder.LEFT);
		sliderPanel.setBorder(titledBorder);
		sliderbar.add(sliderPanel);

		JPanel magnifierPanel = new JPanel();
		magnifierPanel
				.setLayout(new BoxLayout(magnifierPanel, BoxLayout.Y_AXIS));
		magnifierPanel.setPreferredSize(new Dimension(170, 104));
		magnifierPanel.add(tSrcInMagnifier);
		magnifierPanel.add(tFGColorInMagnifier);
		magnifierPanel.add(tFGColorMagnifier);
		border = BorderFactory.createEtchedBorder();
		titledBorder = BorderFactory.createTitledBorder(border, "Magnifier");
		titledBorder.setTitleJustification(TitledBorder.LEFT);
		magnifierPanel.setBorder(titledBorder);

		JPanel preprocessingPanel = new JPanel();
		preprocessingPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 2));
		preprocessingPanel.setPreferredSize(new Dimension(170, 151));
		border = BorderFactory.createEtchedBorder();
		titledBorder = BorderFactory.createTitledBorder(border,
				"Preprocessing Tools");
		titledBorder.setTitleJustification(TitledBorder.LEFT);
		preprocessingPanel.setBorder(titledBorder);
		preprocessingPanel.add(tGreyscaleConversion);
		preprocessingPanel.add(tBinarize);
		preprocessingPanel.add(tInvert);
		preprocessingPanel.add(tAutoBin);
		preprocessingPanel.add(tSmooth);
		preprocessingPanel.add(tSharpen);
		preprocessingPanel.add(tDespeckle);
		preprocessingPanel.add(tMinMax);
		preprocessingPanel.add(tBrightness);
		preprocessingPanel.add(tSkeletonize);
		sliderbar.add(preprocessingPanel);

		JPanel recognitionPanel = new JPanel();
		recognitionPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 2));
		recognitionPanel.setPreferredSize(new Dimension(170, 131));
		border = BorderFactory.createEtchedBorder();
		titledBorder = BorderFactory.createTitledBorder(border,
				"Recognition Tools");
		titledBorder.setTitleJustification(TitledBorder.LEFT);
		recognitionPanel.setBorder(titledBorder);
		recognitionPanel.add(tFloodFill);
		recognitionPanel.add(tExtractArea);
		recognitionPanel.add(tDetectNodes);
		recognitionPanel.add(tDetectBranches);
		recognitionPanel.add(tEnterScaleBarLength);
		sliderbar.add(recognitionPanel);

		JPanel topologyPanel = new JPanel();
		topologyPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 2));
		topologyPanel.setPreferredSize(new Dimension(170, 80));
		border = BorderFactory.createEtchedBorder();
		titledBorder = BorderFactory.createTitledBorder(border, "Tree Type");
		titledBorder.setTitleJustification(TitledBorder.LEFT);
		topologyPanel.setBorder(titledBorder);
		topologyPanel.add(tTopologyFree);
		topologyPanel.add(tTopologyRect);
		// topologyPanel.add(tTopologyPolar);
		sliderbar.add(topologyPanel);

		JPanel switchesPanel = new JPanel();
		switchesPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 0));
		switchesPanel.setPreferredSize(new Dimension(170, 116));
		border = BorderFactory.createEtchedBorder();
		titledBorder = BorderFactory.createTitledBorder(border, "Settings");
		titledBorder.setTitleJustification(TitledBorder.LEFT);
		switchesPanel.setBorder(titledBorder);
		switchesPanel.add(tAutoClean);
		switchesPanel.add(tAutoSkeletonize);
		switchesPanel.add(tAutoFlood);
		sliderbar.add(switchesPanel);

		JPanel strokePanel = new JPanel();
		strokePanel.setMaximumSize(new Dimension(160, 210));
		strokePanel.setPreferredSize(new Dimension(160, 210));

		JLabel lookaheadLabel = new JLabel("Look-ahead dist.");
		sliderbar.add(lookaheadLabel);
		lookaheadSpinner = new JSpinner();
		lookaheadSpinner.setMaximumSize(new Dimension(40, 20));
		SpinnerNumberModel model = new SpinnerNumberModel(1, 1,
				maximumLookaheadDistance, 1);
		lookaheadSpinner.setModel(model);
		lookaheadSpinner.setEnabled(wizard.useElaboratePathFinding);
		lookaheadSpinner.setValue(wizard.lookaheadDistance);
		lookaheadSpinner.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				int value = (Integer) ((SpinnerNumberModel) lookaheadSpinner
						.getModel()).getValue();
				// If the user modified the proposed lookaheadDistance, go on
				// with this,
				// use the proposed/calculated otherwise
				if (value == wizard.userLookaheadDistance)
					wizard.lookaheadDistance = value;
				else
					wizard.lookaheadDistance = wizard.userLookaheadDistance;
				wizard.userLookaheadDistance = value;

				// Display small marks if the node distances are low, large
				// marks otherwise
				if (wizard.lookaheadDistance < 8) {
					mSmallMarks.setSelected(true);
					wizard.smallMarks = true;
				} else {
					mSmallMarks.setSelected(false);
					wizard.smallMarks = false;
				}
			}
		});

		sliderbar.add(lookaheadSpinner);
		sliderbar.add(tShowPhylipExpression);
		sliderbar.add(tUndo);
	}

	// **** Dialogs Definition ****

	public class FillDialog extends JDialog implements WindowListener {
		private static final long serialVersionUID = 1L;
		private JButton preview = new JButton("Preview");
		private JButton accept = new JButton("Accept");
		private JButton revert = new JButton("Cancel");
		private JButton grabColors = new JButton(
				"Grab Colors from Box Selection");
		private JButton selectFillColor = new JButton(
				"Select Arbitrary Fill Color");
		private JPanel upperPanel, lowerPanel;
		private JTextArea textArea = new JTextArea();
		private JRadioButton replace;
		private JRadioButton keep;
		private JRadioButton singleColor;
		private JRadioButton colorRange;
		private JRadioButton selectedColors;
		protected ColorButton rangeButton1, singleButton, fillButton;
		protected JLabel pointsLabel, with, rest;
		private boolean singleActive = false, fillActive = false;
		private boolean manipulated = false;

		public FillDialog() {
			this("", null, true);
		};

		public FillDialog(String title, java.awt.Frame parent, boolean modal) {
			this.setTitle(title);
			this.setResizable(false);
			this.setAlwaysOnTop(true);
			this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
			this.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
			this.addWindowListener(this);
			replace = new JRadioButton("Replace");
			replace.setSelected(true);
			keep = new JRadioButton("Keep");
			keep.setSelected(false);
			singleColor = new JRadioButton("Exact Color");
			singleColor.setSelected(true);
			colorRange = new JRadioButton("Hue");
			colorRange.setSelected(false);
			selectedColors = new JRadioButton("Colors From Selection");
			selectedColors.setSelected(false);
			JPanel jpButtons = new JPanel();
			jpButtons.add(accept);
			jpButtons.add(preview);
			jpButtons.add(revert);

			ButtonGroup g1 = new ButtonGroup();
			g1.add(replace);
			g1.add(keep);
			ButtonGroup g2 = new ButtonGroup();
			g2.add(singleColor);
			g2.add(selectedColors);

			upperPanel = new JPanel(new FlowLayout(FlowLayout.LEADING));

			// Color replacement mode
			JPanel panel1 = new JPanel(new BorderLayout());
			panel1.add(replace, BorderLayout.NORTH);
			panel1.add(keep, BorderLayout.SOUTH);

			// Color range selection
			JPanel panel2 = new JPanel(new BorderLayout());
			panel2.add(singleColor, BorderLayout.CENTER);
			panel2.add(selectedColors, BorderLayout.SOUTH);

			// Colors
			JPanel panel3 = new JPanel();
			panel3.setLayout(new FlowLayout());
			rangeButton1 = new ColorButton();
			rangeButton1.setColor(new Color(wizard.fromColor));

			singleButton = new ColorButton();
			singleButton.setColor(new Color(wizard.fromColor));

			panel3.add(rangeButton1);
			pointsLabel = new JLabel("");
			pointsLabel.setVisible(false);
			panel3.add(pointsLabel);
			panel3.add(singleButton);
			singleButton.setVisible(true);
			rangeButton1.setVisible(false);

			// "With"/"Rest"
			JPanel panel4 = new JPanel();
			with = new JLabel("with");
			rest = new JLabel("Replace other colors with");
			panel4.add(with);
			with.setEnabled(true);
			panel4.add(rest);
			rest.setVisible(false);
			fillButton = new ColorButton();
			fillButton.setColor(new Color(wizard.toColor));
			panel4.add(fillButton);

			upperPanel.add(panel1);
			upperPanel.add(panel2);
			upperPanel.add(panel3);
			upperPanel.add(panel4);

			lowerPanel = new JPanel(new FlowLayout(FlowLayout.LEADING));

			JPanel grabButtonPanel = new JPanel(new BorderLayout());
			grabButtonPanel.add(grabColors, BorderLayout.EAST);
			lowerPanel.add(grabButtonPanel);
			lowerPanel.add(selectFillColor);
			grabColors.setVisible(false);

			JPanel jpGeneral = new JPanel();
			jpGeneral.setLayout(new BorderLayout());
			jpGeneral.setBorder(BorderFactory
					.createTitledBorder("Select Parameters, Pick Colors"));

			JPanel textPanel = new JPanel();
			textPanel.add(textArea);
			textPanel.setSize(this.getWidth() - 20, 30);
			jpGeneral.add(upperPanel, BorderLayout.NORTH);
			jpGeneral.add(lowerPanel, BorderLayout.CENTER);
			jpGeneral.add(textPanel, BorderLayout.SOUTH);
			textArea.setSize(this.getWidth() - 24, 24);
			textArea.doLayout();
			textArea.setEditable(false);
			textArea
					.setText("To pick a color, click into a square, then into the image");
			getContentPane().add(jpButtons, BorderLayout.SOUTH);
			getContentPane().add(jpGeneral, BorderLayout.CENTER);
			pack();
			setSize(520, 220);
			setLocation(owner.getWidth() / 2 - this.getWidth() / 2, 30);

			// --- Initialize all button listeners ---

			// Preview the action the user has selected
			preview.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					imagePanel.performAction(Activity.GLOBAL_COLORCHANGE);
					manipulated = true;
				}
			});

			accept.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.setMode(modeBeforeFillDialog);
					if (manipulated)
						imagePanel.protocolState(Activity.GLOBAL_COLORCHANGE); // Accept
					// current
					// state
					// as
					// new
					// image
					cDialog.setVisible(false); // Hide color chooser
					colorManipDialog.setVisible(false);
					owner.setVisible(true);
					manipulated = false;
				}
			});

			revert.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					manipulated = false;
					owner.setVisible(true);
					setVisible(false);
				}
			});

			replace.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.colReplace = true;
					wizard.colKeep = false;

					with.setVisible(true);
					rest.setVisible(false);
				}
			});

			keep.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.colKeep = true;
					wizard.colReplace = false;

					with.setVisible(false);
					rest.setVisible(true);
				}
			});

			singleColor.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.colExactColor = true;
					wizard.colSelectionColors = false;

					pointsLabel.setVisible(false);
					rangeButton1.setVisible(false);
					grabColors.setVisible(false);
					singleButton.setVisible(true);
					singleActive = false;
					fillActive = false;
					singleActive = false;
				}
			});

			selectedColors.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.colSelectionColors = true;
					wizard.colExactColor = false;

					pointsLabel.setVisible(true);
					rangeButton1.setVisible(false);
					singleButton.setVisible(false);
					grabColors.setVisible(true);
					fillActive = false;
					singleActive = false;

				}
			});

			grabColors.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					// Collect a set of all colors in the user selection box
					wizard.colorSet = imagePanel.getColorsInSelection();
					textArea
							.setText("Number of colors to be replaced or kept: "
									+ wizard.colorSet.size());
					imagePanel.resetSelection(); // Make the selection encompass
					// the whole image without
					// its border
				}
			});

			// Button for the selection of a single color
			singleButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.setMode(Activity.PIPETTE);
					owner.setVisible(true);
					singleActive = true;
					fillActive = false;
				}
			});

			fillButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					// Temporarily change the mode
					imagePanel.setMode(Activity.PIPETTE);
					owner.setVisible(true);
					toolbar.repaint();

					fillActive = true;
					singleActive = false;
				}
			});

			selectFillColor.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					fillActive = true;
					singleActive = false;

					colorChooser.getSelectionModel().addChangeListener(
							new ChangeListener() {
								public void stateChanged(ChangeEvent e) {
									Color newFillColor = colorChooser
											.getColor();
									if (newFillColor != null)
										consumePickedColor(newFillColor
												.getRGB());
								}
							});

					cDialog.add(colorChooser);
					cDialog.pack();
					cDialog.setLocation(owner.getWidth() / 2
							- cDialog.getWidth() / 2, 300);
					cDialog.setVisible(true);
					cDialog.setAlwaysOnTop(true);
				}
			});

		}

		// Assign the color the user has recently picked from the image
		// Un-Changing the fill color is not supported by Undo
		public void consumePickedColor(int col) {
			Color color = new Color(col);
			if (fillActive) // The color other colors are replaced with
			{
				fillButton.setColor(color);
				fillButton.repaint();
				wizard.toColor = col;
			} else if (singleActive) // Single Color button
			{
				singleButton.setColor(color);
				singleButton.repaint();
				wizard.fromColor = col;
			} else
				wizard.toColor = col; // No color chooser button in the dialog
			// has been selected
		}

		public Dimension getPreferredSize() {
			return new Dimension(520, 220);
		}

		// Window Listener Classes
		public void windowActivated(WindowEvent e) {
		}

		public void windowClosed(WindowEvent e) {
		}

		public void windowDeactivated(WindowEvent e) {
		}

		public void windowDeiconified(WindowEvent e) {
		}

		public void windowIconified(WindowEvent e) {
		}

		public void windowOpened(WindowEvent e) {
		}

		public void windowClosing(WindowEvent e) {
			imagePanel.setMode(modeBeforeFillDialog);
		}
	}

	class ThresholdDialog extends ControlsDialog {
		private static final long serialVersionUID = 1L;
		protected JSlider thresholdSlider;

		public ThresholdDialog(String title, final MainWindow owner,
				boolean modal) {
			super(title, owner, modal);
			thresholdSlider = new JSlider(JSlider.HORIZONTAL, 0, 255, 190);
			thresholdSlider.setPaintLabels(true);
			thresholdSlider.createStandardLabels(255, 0);
			thresholdSlider.setMajorTickSpacing(255);
			thresholdSlider.setVisible(true);
			thresholdSlider.setPreferredSize(new Dimension(140, 50));
			thresholdSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!thresholdSlider.getValueIsAdjusting()) {
						wizard.threshold = thresholdSlider.getValue();
					}
				}
			});

			accept.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (manipulated)
						imagePanel.protocolState(Activity.BINARIZE); // Accept
					// the
					// modified
					// image
					// as
					// the
					// new
					// image
					setVisible(false);
				}
			});

			preview.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					imagePanel.performAction(Activity.BINARIZE);
					manipulated = true;
				}
			});

			revert.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.threshold = defaultThreshold;
					thresholdSlider.setValue(wizard.threshold);
					imagePanel.restoreSnapshot();
					manipulated = false;
					setVisible(false);
				}
			});

			slidersPanel.add(thresholdSlider);
			labelsPanel.add(new JLabel("Threshold"));
			pack();
		}

		public JSlider getThresholdSlider() {
			return thresholdSlider;
		};
	}

	class SmoothDialog extends ControlsDialog {
		private static final long serialVersionUID = 1L;
		protected JSlider kernelSlider;

		public SmoothDialog(String title, final MainWindow owner, boolean modal) {
			super(title, owner, modal);
			kernelSlider = new JSlider(JSlider.HORIZONTAL, 1, 5,
					wizard.kernelWidth);
			kernelSlider.setMajorTickSpacing(1);
			kernelSlider.setPreferredSize(new Dimension(140, 50));
			kernelSlider.setSnapToTicks(true);
			kernelSlider.setPaintTicks(true);
			Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(1, new JLabel("1"));
			labelTable.put(5, new JLabel("5"));
			kernelSlider.setLabelTable(labelTable);
			kernelSlider.setPaintLabels(true);
			kernelSlider.setValue(wizard.kernelWidth);
			kernelSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!kernelSlider.getValueIsAdjusting()) {
						wizard.kernelWidth = kernelSlider.getValue();
					}
				}
			});

			accept.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (manipulated)
						imagePanel.protocolState(Activity.SMOOTH);
					setVisible(false);
				}
			});

			preview.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					imagePanel.performAction(Activity.SMOOTH);
					manipulated = true;
				}
			});

			revert.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.kernelWidth = defaultKernelWidth;
					kernelSlider.setValue(defaultKernelWidth);
					imagePanel.restoreSnapshot();
					manipulated = false;
					setVisible(false);
				}
			});

			slidersPanel.add(kernelSlider);
			labelsPanel.add(new JLabel("Kernel Width"));
			pack();
		}

		public JSlider getKernelSlider() {
			return kernelSlider;
		};
	}

	class DenoiseDialog extends ControlsDialog {
		private static final long serialVersionUID = 1L;
		protected JSlider denoiseSlider;

		public DenoiseDialog(String title, final MainWindow owner, boolean modal) {
			super(title, owner, modal);
			denoiseSlider = new JSlider(JSlider.HORIZONTAL, 3, 10,
					wizard.medianRectWidth);
			denoiseSlider.setMajorTickSpacing(1);
			denoiseSlider.setPreferredSize(new Dimension(140, 50));
			denoiseSlider.setSnapToTicks(true);
			denoiseSlider.setPaintTicks(true);
			Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(3, new JLabel("3"));
			labelTable.put(10, new JLabel("10"));
			denoiseSlider.setLabelTable(labelTable);
			denoiseSlider.setPaintLabels(true);
			denoiseSlider.setValue(wizard.medianRectWidth);
			denoiseSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!denoiseSlider.getValueIsAdjusting()) {
						wizard.medianRectWidth = denoiseSlider.getValue();
					}
				}
			});

			accept.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (manipulated)
						imagePanel.protocolState(Activity.DESPECKLE);
					setVisible(false);
				}
			});

			preview.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					imagePanel.performAction(Activity.DESPECKLE);
					manipulated = true;
				}
			});

			revert.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.medianRectWidth = defaultMedianRectWidth;
					denoiseSlider.setValue(wizard.medianRectWidth);
					imagePanel.restoreSnapshot();
					manipulated = false;
					setVisible(false);
				}
			});

			slidersPanel.add(denoiseSlider);
			labelsPanel.add(new JLabel("Box Width"));
			pack();
		}

		public JSlider getDenoiseSlider() {
			return denoiseSlider;
		};

		public Dimension getPreferredSize() {
			return new Dimension(290, 200);
		};
	}

	class MinMaxDialog extends ControlsDialog {
		private static final long serialVersionUID = 1L;
		protected JSlider minMaxSlider;

		public MinMaxDialog(String title, final MainWindow owner, boolean modal) {
			super(title, owner, modal);

			minMaxSlider = new JSlider(JSlider.HORIZONTAL, 3, 10,
					wizard.minMaxRectWidth);
			minMaxSlider.setMajorTickSpacing(1);
			minMaxSlider.setPreferredSize(new Dimension(140, 50));
			minMaxSlider.setSnapToTicks(true);
			minMaxSlider.setPaintTicks(true);
			Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(3, new JLabel("3"));
			labelTable.put(10, new JLabel("10"));
			minMaxSlider.setLabelTable(labelTable);
			minMaxSlider.setPaintLabels(true);
			minMaxSlider.setValue(wizard.minMaxRectWidth);
			minMaxSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!minMaxSlider.getValueIsAdjusting()) {
						wizard.minMaxRectWidth = minMaxSlider.getValue();
					}
				}
			});

			accept.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (manipulated)
						imagePanel.protocolState(Activity.MINIMUM_OP);
					setVisible(false);
				}
			});

			preview.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					imagePanel.performAction(Activity.MINIMUM_OP);
					manipulated = true;
				}
			});

			revert.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.minMaxRectWidth = defaultMinMaxRectWidth;
					minMaxSlider.setValue(wizard.minMaxRectWidth);
					imagePanel.restoreSnapshot();
					manipulated = false;
					setVisible(false);
				}
			});

			slidersPanel.add(minMaxSlider);
			labelsPanel.add(new JLabel("Box Width"));
			pack();
		}

		public JSlider getMinMaxSlider() {
			return minMaxSlider;
		};

		public Dimension getPreferredSize() {
			return new Dimension(290, 200);
		};
	}

	class ColorQuantDialog extends ControlsDialog {
		private static final long serialVersionUID = 1L;
		protected JSpinner colQuantSpinner;

		public ColorQuantDialog(String title, final MainWindow owner,
				boolean modal) {
			super(title, owner, modal);
			String[] colorNumbers = { "3", "4", "5", "6", "7", "8", "9", "10",
					"16", "20", "32", "50", "64", "100", "128", "256", "512",
					"1000", "1024", "2048", "4096", "8192", "16384", "32768",
					"65536" };
			final SpinnerListModel colModel = new SpinnerListModel(colorNumbers);
			colQuantSpinner = new JSpinner(colModel);
			colQuantSpinner.setValue("" + defaultQuantNumColors);
			colQuantSpinner.setPreferredSize(new Dimension(74, 24));
			colQuantSpinner.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					String s = (String) ((SpinnerListModel) colQuantSpinner
							.getModel()).getValue();
					wizard.quantNumColors = Integer.parseInt(s);
				}
			});

			accept.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (manipulated)
						imagePanel.protocolState(Activity.COLOR_QUANTIZATION);
					setVisible(false);
				}
			});

			preview.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					imagePanel.performAction(Activity.COLOR_QUANTIZATION);
					manipulated = true;
				}
			});

			revert.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.quantNumColors = defaultQuantNumColors;
					colQuantSpinner.setValue("" + defaultQuantNumColors);
					imagePanel.restoreSnapshot();
					manipulated = false;
					setVisible(false);
				}
			});

			slidersPanel.add(colQuantSpinner);
			slidersPanel.add(new JLabel("New Number of Colors"));
			pack();
		}

		public JSpinner getSpinner() {
			return colQuantSpinner;
		};

		public Dimension getPreferredSize() {
			return new Dimension(310, 132);
		};
	}

	class SharpenDialog extends ControlsDialog {
		private static final long serialVersionUID = 1L;
		protected JSlider sharpenSlider;
		protected JSlider factorSlider;

		public SharpenDialog(String title, final MainWindow owner, boolean modal) {
			super(title, owner, modal);

			sharpenSlider = new JSlider(JSlider.HORIZONTAL, 1, 25,
					wizard.usmKernelWidth);
			sharpenSlider.setMajorTickSpacing(5);
			sharpenSlider.setPaintTicks(true);
			sharpenSlider.setPreferredSize(new Dimension(190, 50));
			Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(1, new JLabel("1"));
			labelTable.put(25, new JLabel("25"));
			sharpenSlider.setLabelTable(labelTable);
			sharpenSlider.setPaintLabels(true);
			sharpenSlider.setValue(wizard.usmKernelWidth);
			sharpenSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!sharpenSlider.getValueIsAdjusting()) {
						wizard.usmKernelWidth = sharpenSlider.getValue();
					}
				}
			});

			factorSlider = new JSlider(JSlider.HORIZONTAL, 1, 50,
					(int) wizard.usmFactor * 10);
			factorSlider.setMajorTickSpacing(10);
			factorSlider.setPaintTicks(true);
			factorSlider.setPreferredSize(new Dimension(200, 50));
			labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(1, new JLabel(".1x"));
			labelTable.put(10, new JLabel("1x"));
			labelTable.put(20, new JLabel("2x"));
			labelTable.put(30, new JLabel("3x"));
			labelTable.put(40, new JLabel("4x"));
			labelTable.put(50, new JLabel("5x"));
			factorSlider.setLabelTable(labelTable);
			factorSlider.setPaintLabels(true);
			factorSlider.setValue((int) wizard.usmFactor * 10);
			factorSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!factorSlider.getValueIsAdjusting()) {
						wizard.usmFactor = factorSlider.getValue() / 10;
					}
				}
			});

			accept.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (manipulated)
						imagePanel.protocolState(Activity.SHARPEN);
					setVisible(false);
				}
			});

			preview.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					imagePanel.performAction(Activity.SHARPEN);
					manipulated = true;
				}
			});

			revert.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.usmKernelWidth = defaultUSMKernelWidth;
					wizard.usmFactor = defaultUSMFactor;
					sharpenSlider.setValue(wizard.usmKernelWidth);
					factorSlider.setValue((int) wizard.usmFactor * 10);
					imagePanel.restoreSnapshot();
					manipulated = false;
					setVisible(false);
				}
			});

			slidersPanel.add(sharpenSlider);
			slidersPanel.add(factorSlider);
			labelsPanel.add(new JLabel("Gauss Kernel Width"),
					BorderLayout.NORTH);
			labelsPanel.add(new JLabel("Amplification"), BorderLayout.CENTER);
			pack();
		}

		public JSlider getSharpenSlider() {
			return sharpenSlider;
		};

		public JSlider getFactorSlider() {
			return factorSlider;
		};

		public Dimension getPreferredSize() {
			return new Dimension(340, 220);
		};
	}

	class BrightnessDialog extends ControlsDialog {
		private static final long serialVersionUID = 1L;
		protected JSlider brightnessSlider;
		protected JSlider factorSlider;

		public BrightnessDialog(String title, final MainWindow owner,
				boolean modal) {
			super(title, owner, modal);
			brightnessSlider = new JSlider(JSlider.HORIZONTAL, 0, 255,
					wizard.brightnessOffset + 127);
			brightnessSlider.setMajorTickSpacing(25);
			brightnessSlider.setPaintTicks(true);
			brightnessSlider.setPreferredSize(new Dimension(170, 50));
			Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(0, new JLabel("-127"));
			labelTable.put(125, new JLabel("0"));
			labelTable.put(255, new JLabel("+127"));
			brightnessSlider.setLabelTable(labelTable);
			brightnessSlider.setPaintLabels(true);
			brightnessSlider.setValue(wizard.brightnessOffset + 127);
			brightnessSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!brightnessSlider.getValueIsAdjusting()) {
						wizard.brightnessOffset = brightnessSlider.getValue() - 127;
					}
				}
			});

			factorSlider = new JSlider(JSlider.HORIZONTAL, 1, 20, (int) Math
					.max(1, wizard.contrastFactor * 10));
			factorSlider.setMajorTickSpacing(25);
			factorSlider.setPaintTicks(true);
			factorSlider.setPreferredSize(new Dimension(170, 50));
			labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(1, new JLabel("0.1x"));
			labelTable.put(10, new JLabel("1x"));
			labelTable.put(20, new JLabel("2x"));
			factorSlider.setLabelTable(labelTable);
			factorSlider.setPaintLabels(true);
			factorSlider.setValue((int) wizard.contrastFactor * 10);
			factorSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!factorSlider.getValueIsAdjusting()) {
						wizard.contrastFactor = 0.1 * (factorSlider.getValue());
					}
				}
			});

			accept.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (manipulated)
						imagePanel.protocolState(Activity.BRIGHTNESS);
					setVisible(false);
				}
			});

			preview.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					imagePanel.performAction(Activity.BRIGHTNESS);
					manipulated = true;
				}
			});

			revert.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.brightnessOffset = defaultBrightnessOffset;
					wizard.contrastFactor = defaultContrastFactor;
					brightnessSlider.setValue(wizard.brightnessOffset + 127);
					factorSlider.setValue((int) wizard.contrastFactor * 10);
					imagePanel.restoreSnapshot();
					manipulated = false;
					setVisible(false);
				}
			});

			slidersPanel.add(brightnessSlider);
			slidersPanel.add(factorSlider);
			labelsPanel.add(new JLabel("Offset"), BorderLayout.NORTH);
			labelsPanel.add(new JLabel("Factor"), BorderLayout.CENTER);
			pack();
		}

		public JSlider getBrighnessSlider() {
			return brightnessSlider;
		};

		public JSlider getFactorSlider() {
			return factorSlider;
		};

		public Dimension getPreferredSize() {
			return new Dimension(280, 220);
		};
	}

	class GreyscaleConversionDialog extends ControlsDialog {
		private static final long serialVersionUID = 1L;
		protected JSlider factors1Slider;
		protected JSlider factors2Slider;
		protected JSlider factors3Slider;
		protected JTextField sum, result;

		public GreyscaleConversionDialog(String title, final MainWindow owner,
				boolean modal) {
			super(title, owner, modal);
			result = new JTextField("Contrast ");
			sum = new JTextField("Sum(Factors) = 1.0  ");

			factors1Slider = new JSlider(JSlider.HORIZONTAL, 1, 100,
					(int) (100 * wizard.greyscaleFactors[0]));
			factors1Slider.setMajorTickSpacing(25);
			factors1Slider.setPaintTicks(true);
			factors1Slider.setPreferredSize(new Dimension(170, 50));
			Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(1, new JLabel("0.01"));
			labelTable.put(100, new JLabel("1.0"));
			factors1Slider.setLabelTable(labelTable);
			factors1Slider.setPaintLabels(true);
			factors1Slider.setValue((int) (100 * wizard.greyscaleFactors[0]));
			factors1Slider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!factors1Slider.getValueIsAdjusting()) {
						wizard.greyscaleFactors[0] = 0.01 * factors1Slider
								.getValue();
						calculateContrastChange();
					}
				}
			});

			factors2Slider = new JSlider(JSlider.HORIZONTAL, 1, 100,
					(int) (100 * wizard.greyscaleFactors[1]));
			factors2Slider.setMajorTickSpacing(25);
			factors2Slider.setPaintTicks(true);
			factors2Slider.setPreferredSize(new Dimension(170, 50));
			labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(1, new JLabel("0.01"));
			labelTable.put(100, new JLabel("1.0"));
			factors2Slider.setLabelTable(labelTable);
			factors2Slider.setPaintLabels(true);
			factors2Slider.setValue((int) (100 * wizard.greyscaleFactors[1]));
			factors2Slider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!factors2Slider.getValueIsAdjusting()) {
						wizard.greyscaleFactors[1] = 0.01 * (factors2Slider
								.getValue());
						calculateContrastChange();
					}
				}
			});

			factors3Slider = new JSlider(JSlider.HORIZONTAL, 1, 100,
					(int) (100 * wizard.greyscaleFactors[2]));
			factors3Slider.setMajorTickSpacing(25);
			factors3Slider.setPaintTicks(true);
			factors3Slider.setPreferredSize(new Dimension(170, 50));
			labelTable = new Hashtable<Integer, JLabel>();
			labelTable.put(1, new JLabel("0.01"));
			labelTable.put(100, new JLabel("1.0"));
			factors3Slider.setLabelTable(labelTable);
			factors3Slider.setPaintLabels(true);
			factors3Slider.setValue((int) (100 * wizard.greyscaleFactors[2]));
			factors3Slider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (!factors3Slider.getValueIsAdjusting()) {
						wizard.greyscaleFactors[2] = 0.01 * (factors3Slider
								.getValue());
						calculateContrastChange();
					}
				}
			});

			accept.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (manipulated)
						imagePanel.protocolState(Activity.GREYSCALE_CONVERSION);
					setVisible(false);
				}
			});

			preview.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					imagePanel.restoreSnapshot();
					imagePanel.performAction(Activity.GREYSCALE_CONVERSION);
					manipulated = true;
				}
			});

			revert.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					wizard.greyscaleFactors = defaultGreyscaleFactors;
					factors1Slider
							.setValue((int) (100 * wizard.greyscaleFactors[0]));
					factors2Slider
							.setValue((int) (100 * wizard.greyscaleFactors[1]));
					factors3Slider
							.setValue((int) (100 * wizard.greyscaleFactors[2]));
					imagePanel.restoreSnapshot();
					manipulated = false;
					setVisible(false);
				}
			});

			slidersPanel.add(factors1Slider);
			slidersPanel.add(factors2Slider);
			slidersPanel.add(factors3Slider);
			labelsPanel.setLayout(new BoxLayout(labelsPanel, BoxLayout.Y_AXIS));
			labelsPanel.add(Box.createRigidArea(new Dimension(0, 8)));
			labelsPanel.add(new JLabel("Factor(Red)"));
			labelsPanel.add(Box.createRigidArea(new Dimension(0, 40)));
			labelsPanel.add(new JLabel("Factor(Green)"));
			labelsPanel.add(Box.createRigidArea(new Dimension(0, 40)));
			labelsPanel.add(new JLabel("Factor(Blue)"));
			slidersPanel.add(sum);
			slidersPanel.add(result);
			pack();
		}

		// **** End of Dialogs Definition ****

		private void calculateContrastChange() {
			double change = Math
					.round((wizard.greyscaleFactors[0]
							+ wizard.greyscaleFactors[1] + wizard.greyscaleFactors[2]) * 100.) / 100.;
			if (Math.abs(change - 1.0) < 0.01) {
				result.setText("Contrast ");
				sum.setText("Sum(factors) = " + change);
				return;
			}

			if (change < 1.0)
				result.setText("Contrast -");
			else if (change > 1.0)
				result.setText("Contrast +");
			sum.setText("Sum(Factors) = " + change);
		}

		public JSlider getFactors1Slider() {
			return factors1Slider;
		};

		public JSlider getFactors2Slider() {
			return factors2Slider;
		};

		public JSlider getFactors3Slider() {
			return factors3Slider;
		};

		public Dimension getPreferredSize() {
			return new Dimension(300, 340);
		};
	}

	public void execute(ActionEvent e) {
		try {
			final String name = e.getActionCommand();
			Object source = e.getSource();

			// If a flood fill operation has taken place before, reset the image
			if (wizard.floodFillPerformed) {
				imagePanel.restorePixelColors();
				wizard.floodFillPerformed = false;
			}

			if (name.equals("Open Image")) {
				imagePanel.setImage(fileOp.showOpenFileDialog());
				toggleBlendControl(true);
				owner.setVisible(true);
			} else if (name.equals("Open Snapshot")) {
				fileOp.showOpenSnapshotDialog();
				imagePanel.repaint();
				toggleBlendControl(wizard.ratioSliderEnabled); // Activate/inactivate
				// the ratio
				// slider

				owner.setVisible(true);
			} else if (name.equals("New Image")) {
				BufferedImage image = fileOp.showNewFileDialog();
				if (image != null) {
					imagePanel.setImage(image);
					toggleBlendControl(false);
					// toggleDrawingTools(true);
					// toggleBranchTools(true);
					owner.setVisible(true);
					drawingStrokeSpinner.setValue(defaultDrawingStrokeWidth);
					eraserStrokeSpinner.setValue(defaultEraserStrokeWidth);
					getLeftToolBar().repaint();
				}
			}

			else if (name.equals("Save Image")) {
				illustrationDialog = new IllustrationDialog("Image Layers",
						owner, true);
				illustrationDialog.setVisible(true);
				boolean[] params = illustrationDialog.s;
				fileOp.showSaveIllustrationDialog(params);
				owner.setVisible(true);
			} else if (name.equals("Save Snapshot")) {
				fileOp.showSaveSnapshotDialog();
				owner.setVisible(true);
			} else if (name.equals("Save Newick")) {
				fileOp.showSaveNewickDialog(topology.getNewickExpression());
				owner.setVisible(true);
			} else if (name.equals("Box Selection")) {
				imagePanel.setMode(Activity.RECT_SEL); // Let the user draw a
				// rectangular selection
				if (mRect != null) {
					mRect.setSelected(true);
				}
				;
				if (tRect != null) {
					tRect.setSelected(true);
				}
				;
				if (pRect != null) {
					pRect.setSelected(true);
				}
				;
			} else if (name.equals("Line Selection")) {
				imagePanel.setMode(Activity.LINE_SEL); // Let the user draw a
				// rectangular selection

				if (source instanceof JRadioButton) {
					if (mLine != null) {
						mLine.setSelected(true);
					}
					;
				} else if (source instanceof JRadioButtonMenuItem) {
					if (tLine != null) {
						tLine.setSelected(true);
					}
				}
			} else if (name.equals("Whole Image")) {
				imagePanel.selectAll();
			} else if (name.equals("Grab Motif")) {
				imagePanel.performAction(Activity.GRAB_MOTIF);
			} else if (name.equals("Polygonal")) // Not currently used
			{
				imagePanel.setMode(Activity.POLY_SEL); // Let the user draw a
				// polygonal selection

				if (e.getSource() instanceof JRadioButton) {
					if (mPoly != null) {
						mPoly.setSelected(true);
					}

				} else if (e.getSource() instanceof JRadioButtonMenuItem) {
					if (tPoly != null) {
						tPoly.setSelected(true);
					}
				}
			} else if (name.equals("Move Node")) {
				imagePanel.setMode(Activity.MOVE_NODE);
				if (mChooseNode != null) {
					mChooseNode.setSelected(true);
				}
				if (tChooseNode != null) {
					tChooseNode.setSelected(true);
				}
				if (pChooseNode != null) {
					pChooseNode.setSelected(true);
				}
				toolbar.revalidate();
			} else if (name.equals("Remove Node")) {
				imagePanel.performAction(Activity.REMOVE_NODE);
			} else if (name.equals("Remove Nodes in Selection")) {
				imagePanel.performAction(Activity.REMOVE_SELECTED_NODES);
			} else if (name.equals("Remove Branch")) {
				imagePanel.performAction(Activity.REMOVE_BRANCH);
			} else if (name.equals("Remove Branches in Selection")) {
				imagePanel.performAction(Activity.REMOVE_SELECTED_BRANCHES);
			} else if (name.equals("Add Inner Node")) {
				imagePanel.performAction(Activity.ADD_INNERNODE);
			} else if (name.equals("Add Tip")) {
				imagePanel.performAction(Activity.ADD_TIP);
			} else if (name.equals("Fill Selection Black")) {
				imagePanel.performAction(Activity.FILL_BLACK); // Let the user
				// fill an
				// existing
				// selection
				// with Color
				// white
			} else if (name.equals("Fill Selection White")) {
				imagePanel.performAction(Activity.FILL_WHITE);
			} else if (name.equals("Clear All")) {
				imagePanel.performAction(Activity.CLEAR_IMAGE);

			} else if (name.equals("Crop")) {
				imagePanel.performAction(Activity.SUBIMAGE); // Let the user
				// crop the
				// image using
				// an existing
				// selection
			} else if (name.equals("Trim")) {
				imagePanel.performAction(Activity.TRIM); // Let the user trim
				// the image using
				// an existing
				// selection
			} else if (name.equals("Pencil")) {
				imagePanel.setMode(Activity.BLACK_PEN);
				if (mDraw != null) {
					mDraw.setSelected(true);
				}
				if (tDraw != null) {
					tDraw.setSelected(true);
				}
				if (pDraw != null) {
					pDraw.setSelected(true);
				}
				toolbar.revalidate();
			} else if (name.equals("Black Line")) {
				imagePanel.setMode(Activity.BLACK_LINE);
				if (mDrawBlackLine != null) {
					mDrawBlackLine.setSelected(true);
				}
				if (tDrawBlackLine != null) {
					tDrawBlackLine.setSelected(true);
				}
				if (pDrawBlackLine != null) {
					pDrawBlackLine.setSelected(true);
				}
			} else if (name.equals("White Line")) {
				imagePanel.setMode(Activity.WHITE_LINE);
				if (mDrawWhiteLine != null) {
					mDrawWhiteLine.setSelected(true);
				}
				if (tDrawWhiteLine != null) {
					tDrawWhiteLine.setSelected(true);
				}
				if (pDrawWhiteLine != null) {
					pDrawWhiteLine.setSelected(true);
				}
			} else if (name.equals("Curve")) {
				imagePanel.setMode(Activity.QUADCURVE);
				if (mDrawQuadCurve != null) {
					mDrawQuadCurve.setSelected(true);
				}
				if (tDrawQuadCurve != null) {
					tDrawQuadCurve.setSelected(true);
				}
				if (pDrawQuadCurve != null) {
					pDrawQuadCurve.setSelected(true);
				}
				toolbar.revalidate();
			} else if (name.equals("Rubber")) {
				imagePanel.setMode(Activity.ERASER); // Let the user draw onto
				// the image with white
				// ink ("erase")
				if (mErase != null) {
					mErase.setSelected(true);
				}
				if (tErase != null) {
					tErase.setSelected(true);
				}
				if (pErase != null) {
					pErase.setSelected(true);
				}
				toolbar.revalidate();
			} else if (name.equals("Pipette")) {
				imagePanel.setMode(Activity.PIPETTE); // Let the user select
				// either the color
				// beneath the cursor or
				// those in the
				// selection box
				if (mPipette != null) {
					mPipette.setSelected(true);
				}
				if (tPipette != null) {
					tPipette.setSelected(true);
				}
				if (pPipette != null) {
					pPipette.setSelected(true);
				}
				;

				toolbar.revalidate();
			} else if (name.equals("Fill")) {
				imagePanel.setMode(Activity.FILL);

				wizard.colReplace = true;
				wizard.colKeep = false;
				wizard.colExactColor = true;
				wizard.colSelectionColors = false;

				if (mLocalFill != null) {
					mLocalFill.setSelected(true);
				}
				if (tLocalFill != null) {
					tLocalFill.setSelected(true);
				}
				if (pLocalFill != null) {
					pLocalFill.setSelected(true);
				}
				;
				toolbar.revalidate();
			} else if (name.equals("Stencil")) {
				imagePanel.setMode(Activity.STENCIL);
			} else if (name.equals("Invert")) {
				imagePanel.performAction(Activity.INVERT);
			} else if (name.equals("Histogram Stretch")) {
				imagePanel.performAction(Activity.HISTOGRAM_STRETCH);
			} else if (name.equals("Double Size")) {
				imagePanel.performAction(Activity.SCALE2X);
			} else if (name.equals("Half Size")) {
				imagePanel.performAction(Activity.SCALE05X);
			} else if (name.equals("Local Threshold")) {
				imagePanel.performAction(Activity.AUTO_BINARIZE);
			} else if (name.equals("Despeckle")) {
				imagePanel.storeSnapshot();
				DenoiseDialog denoiseDialog = new DenoiseDialog(
						"Median Filter", owner, true);
				denoiseDialog.setVisible(true);
			} else if (name.equals("Brightness")) {
				imagePanel.storeSnapshot();
				BrightnessDialog brightnessDialog = new BrightnessDialog(
						"Brightening/Darkening", owner, true);
				brightnessDialog.setVisible(true);
			} else if (name.equals("Fill Dialog")) {
				imagePanel.storeSnapshot();
				modeBeforeFillDialog = imagePanel.getMode(); // Store the
				// current mode
				imagePanel.setMode(Activity.PIPETTE); // Temporarily change the
				// mode

				colorManipDialog.invalidate();
				colorManipDialog.setVisible(true);
			} else if (name.equals("Greyscale Conversion")) {
				imagePanel.storeSnapshot();
				GreyscaleConversionDialog greyscaleDialog = new GreyscaleConversionDialog(
						"RGB to Greyscale-RGB", owner, true);
				greyscaleDialog.setVisible(true);
			} else if (name.equals("Minimum")) {
				imagePanel.storeSnapshot();
				MinMaxDialog minMaxDialog = new MinMaxDialog(
						"Adapt. Minimum Filter", owner, true);
				minMaxDialog.setVisible(true);
			} else if (name.equals("Color Quantization")) {
				imagePanel.storeSnapshot();
				ColorQuantDialog colorQuantDialog = new ColorQuantDialog(
						"Reduce the Number of Colors", owner, true);
				colorQuantDialog.setVisible(true);
			} else if (name.equals("Global Threshold")) {
				imagePanel.storeSnapshot(); // Snapshot of the image
				ThresholdDialog thresholdDialog = new ThresholdDialog(
						"Global Threshold", owner, true);
				thresholdDialog.setVisible(true);
			} else if (name.equals("Smooth")) {
				imagePanel.storeSnapshot();
				SmoothDialog smoothDialog = new SmoothDialog("Gauss Filter",
						owner, true);
				smoothDialog.setVisible(true);
			} else if (name.equals("Thin")) {
				imagePanel.performAction(Activity.SKELETONIZE);
			} else if (name.equals("Sharpen")) {
				imagePanel.storeSnapshot();
				SharpenDialog sharpenDialog = new SharpenDialog(
						"Unsharp Masking-Filter", owner, true);
				sharpenDialog.setVisible(true);
			} else if (name.equals("Thin freehand drawings")) {
				wizard.autoSkeletonize = !wizard.autoSkeletonize;
				if (wizard.autoSkeletonize) {
					wizard.drawingStrokeWidth = 1;
					drawingStrokeSpinner.setValue(wizard.drawingStrokeWidth);

				}
				if (e.getSource() instanceof JToggleButton) {
					if (mAutoSkeletonize != null) {
						mAutoSkeletonize.setSelected(wizard.autoSkeletonize);
					}
				} else if (e.getSource() instanceof JCheckBoxMenuItem) {
					if (tAutoSkeletonize != null) {
						tAutoSkeletonize.setSelected(wizard.autoSkeletonize);
					}
				}
			} else if (name.equals("Flood user drawings")) {
				wizard.autoFlood = !wizard.autoFlood;
				if (e.getSource() instanceof JToggleButton) {
					if (mAutoFlood != null) {
						mAutoFlood.setSelected(wizard.autoFlood);
					}
				} else if (e.getSource() instanceof JCheckBoxMenuItem) {
					if (tAutoFlood != null) {
						tAutoFlood.setSelected(wizard.autoFlood);
					}
				}
			} else if (name.equals("Mask user drawings")) {
				wizard.autoClean = !wizard.autoClean;
				if (mAutoClean != null) {
					mAutoClean.setSelected(wizard.autoClean);
				}
				if (tAutoClean != null) {
					tAutoClean.setSelected(wizard.autoClean);
				}
				if (pAutoClean != null) {
					pAutoClean.setSelected(wizard.autoClean);
				}
			} else if (name.equals("Flood Foreground")) {
				imagePanel.performAction(Activity.FLOOD_FILL);
			} else if (name.equals("Drag Branch")) {
				imagePanel.setMode(Activity.DRAW_BRANCH);
				if (mDragBranch != null) {
					mDragBranch.setSelected(true);
				}
				if (tDragBranch != null) {
					tDragBranch.setSelected(true);
				}
				if (pDragBranch != null) {
					pDragBranch.setSelected(true);
				}
			} else if (name.equals("Use Wizard")) {
				wizard.useWizard = !wizard.useWizard;
				if (wizard.useWizard == false)
					wizard.inactivate();
				else
					wizard.reactivate();

				if (e.getSource() instanceof JToggleButton) {
					if (mUseWizard != null) {
						mUseWizard.setSelected(wizard.useWizard);
					}
				} else if (e.getSource() instanceof JCheckBoxMenuItem) {
					if (tUseWizard != null) {
						tUseWizard.setSelected(wizard.useWizard);
					}
				}
			} else if (name.equals("Mark TreeFlood Seed")) {
				wizard.markFloodSeed = !wizard.markFloodSeed;
				imagePanel.repaint();

				if (e.getSource() instanceof JToggleButton) {
					if (mMarkFloodSeed != null) {
						mMarkFloodSeed.setSelected(wizard.markFloodSeed);
					}
				}
			} else if (name.equals("Small Nodes and Branches")) {
				wizard.smallMarks = !wizard.smallMarks;

				if (e.getSource() instanceof JToggleButton) {
					if (mSmallMarks != null) {
						mSmallMarks.setSelected(wizard.smallMarks);
					}
				}
			} else if (name.equals("Draw Branch Lengths")) {
				wizard.drawBranchLength = !wizard.drawBranchLength;
			} else if (name.equals("Use User Assigned Lengths")) {
				Wizard.useUserAssignedLengths = true;
				Wizard.useCalculatedLengths = false;
				Wizard.useMixedLengths = false;
				mUseUserAssignedLengths.setSelected(true);
				NumberUtility.setNumFractionDigits(topology.getBranches());
				imagePanel.updateResultFrame();
			} else if (name.equals("Use Calculated Lengths")) {
				Wizard.useUserAssignedLengths = false;
				Wizard.useCalculatedLengths = true;
				Wizard.useMixedLengths = false;
				mUseCalculatedLengths.setSelected(true);
				NumberUtility.setNumFractionDigits(topology.getBranches());
				imagePanel.updateResultFrame();
			} else if (name.equals("Use Mixed Lengths")) {
				Wizard.useUserAssignedLengths = false;
				Wizard.useCalculatedLengths = false;
				Wizard.useMixedLengths = true;
				mUseMixedLengths.setSelected(true);
				NumberUtility.setNumFractionDigits(topology.getBranches());
				imagePanel.updateResultFrame();
			} else if (name.equals("Draw Taxon Names")) {
				wizard.drawTaxonName = !wizard.drawTaxonName;
			} else if (name.equals("Show Color Value Beneath Mouse")) {
				wizard.showColorBeneathMouse = !wizard.showColorBeneathMouse;
			} else if (name.equals("Use Fancy Cursors")) {
				wizard.useFancyCursors = !wizard.useFancyCursors;
				imagePanel.switchCursor();

				if (e.getSource() instanceof JToggleButton) {
					if (mUseFancyCursors != null) {
						mUseFancyCursors.setSelected(wizard.useFancyCursors);
					}
				}
			} else if (name.equals("Suppress Tiny Branches")) {
				wizard.suppressTinyBranches = !wizard.suppressTinyBranches;

				if (e.getSource() instanceof JToggleButton) {
					if (mSuppressTinyBranches != null) {
						mSuppressTinyBranches
								.setSelected(wizard.suppressTinyBranches);
					}
				}
			} else if (name.equals("Shaded Newick String")) {
				wizard.colorNewickString = !wizard.colorNewickString;
				imagePanel.updateResultFrame();
			} else if (name.equals("Highlight Foreground")) {
				wizard.highlightFGColorInMagnifier = !wizard.highlightFGColorInMagnifier;
				fgColMagnifier.setEnabled(wizard.highlightFGColorInMagnifier);

				if (e.getSource() instanceof JToggleButton) {
					if (mFGColorInMagnifier != null) {
						mFGColorInMagnifier
								.setSelected(wizard.highlightFGColorInMagnifier);
					}
				} else if (e.getSource() instanceof JCheckBoxMenuItem) {
					if (tFGColorInMagnifier != null) {
						tFGColorInMagnifier
								.setSelected(wizard.highlightFGColorInMagnifier);
					}
				}
			} else if (name.equals("Show Source Image")) {
				wizard.showSourceImageInMagnifier = !wizard.showSourceImageInMagnifier;

				mSrcInMagnifier.setSelected(wizard.showSourceImageInMagnifier);
				tSrcInMagnifier.setSelected(wizard.showSourceImageInMagnifier);
			} else if (name.equals("Set Foreground Color")) {
				Color newFGColor = JColorChooser.showDialog(owner,
						"Choose Foreground Color", Color.black);
				if (newFGColor != null)
					wizard.fgColorMagnifier = newFGColor.getRGB();
				wizard.highlightFGColorInMagnifier = true;
			} else if (name.equals("Undo")) {
				imagePanel.undo();
			} else if (name.equals("Extract Foreground")) {
				imagePanel.performAction(Activity.EXTRACT_AREA);
			} else if (name.equals("Locate Nodes")) {
				imagePanel.performAction(Activity.FIND_NODES);

				mChooseNode.setSelected(true);
				tChooseNode.setSelected(true);
				imagePanel.setMode(Activity.MOVE_NODE);
				imagePanel.switchCursor();
			} else if (name.equals("Calculate Branches")) {
				// Deactivate OneNode-Mode
				wizard.useOneNodeMode = false;
				mOneNodeMode.setSelected(false);
				pOneNodeMode.setSelected(false);

				// Display small marks if the node distances are low, large
				// marks otherwise
				if (wizard.lookaheadDistance < 8) {
					mSmallMarks.setSelected(true);
					wizard.smallMarks = true;
				} else {
					mSmallMarks.setSelected(false);
					wizard.smallMarks = false;
				}

				imagePanel.performAction(Activity.FIND_BRANCHES);
				mChooseNode.setSelected(true);
				tChooseNode.setSelected(true);
				imagePanel.setMode(Activity.MOVE_NODE);
				imagePanel.switchCursor();
			} else if (name.equals("Nodes Stick to Foreground")) {
				wizard.nodesStickToTree = !wizard.nodesStickToTree;

				if (e.getSource() instanceof JToggleButton) {
					if (mNodesStickToTree != null) {
						mNodesStickToTree.setSelected(wizard.nodesStickToTree);
					}
				}
			} else if (name.equals("Allow to Set Nodes Anywhere")) {
				wizard.allowNodesAnywhere = !wizard.allowNodesAnywhere;

				if (e.getSource() instanceof JToggleButton) {
					if (mAllowNodesAnywhere != null) {
						mAllowNodesAnywhere
								.setSelected(wizard.allowNodesAnywhere);
					}
				}
			} else if (name.equals("Newick Expression With Lengths")) {
				wizard.includeBranchLengths = !wizard.includeBranchLengths;

				if (e.getSource() instanceof JToggleButton) {
					if (mIncludeBranchLengths != null) {
						mIncludeBranchLengths
								.setSelected(wizard.includeBranchLengths);
					}
				}

				imagePanel.updateResultFrame();

			} else if (name.equals("Freeform")) {
				wizard.topologyType = FREE;
				mTopologyFree.setSelected(!mTopologyFree.isSelected());
				tTopologyFree.setSelected(mTopologyFree.isSelected());
			} else if (name.equals("Rectangular")) {
				wizard.topologyType = RECTANGULAR;
				mTopologyRect.setSelected(!mTopologyRect.isSelected());
				tTopologyRect.setSelected(mTopologyRect.isSelected());
			} else if (name.equals("Polar")) {
				wizard.topologyType = POLAR;
				mTopologyPolar.setSelected(!mTopologyPolar.isSelected());
				tTopologyPolar.setSelected(mTopologyPolar.isSelected());
			} else if (name.equals("May Discard User Generated Objects")) {
				wizard.mayDiscardUserGeneratedObjects = !wizard.mayDiscardUserGeneratedObjects;
			} else if (name.equals("Input User Branch Length")) {
				imagePanel.performAction(Activity.BRANCH_LENGTH);
			} else if (name.equals("Name Taxon")) {
				imagePanel.performAction(Activity.NAME_TAXON);
			} else if (name.equals("Use Node as Origin")) {
				imagePanel.performAction(Activity.AS_REFERENCE_NODE);
			} else if (name.equals("Highlight branches without user length")) {
				wizard.highlightBranchesWithoutLength = !wizard.highlightBranchesWithoutLength;
				imagePanel.repaint();
			} else if (name.equals("Highlight tips without user name")) {
				wizard.highlightTipsWithoutName = !wizard.highlightTipsWithoutName;
				imagePanel.repaint();
			} else if (name.equals("Get Scale Bar Length")) {
				imagePanel.performAction(Activity.SCALE_BAR_LENGTH);
			} else if (name.equals("Use Length 1.0 to Scale Tree")) {
				imagePanel.performAction(Activity.SCALE_USING_BRANCH_LENGTH_1);
			} else if (name.equals("Use Length to Scale Tree")) {
				imagePanel
						.performAction(Activity.SCALE_USING_SPECIFIED_BRANCH_LENGTH);
			} else if (name.equals("Toggle Newick View")) {
				wizard.showResultFrame = !wizard.showResultFrame;
				owner.swapWizardAndNewickPanels();
				imagePanel.updateResultFrame();
			} else if (name.equals("Show All Branches")) {
				wizard.showAllBranches = true;
				mShowAllBranches.setSelected(true);
				pShowAllBranches.setSelected(true);
				wizard.useOneNodeMode = false;
				wizard.showTracedPaths = false;
				imagePanel.revalidate();
			} else if (name.equals("Check Linked Branches")) {
				wizard.useOneNodeMode = true;
				mOneNodeMode.setSelected(true);
				pOneNodeMode.setSelected(true);
				wizard.showAllBranches = false;
				wizard.showTracedPaths = false;
				imagePanel.revalidate();
			} else if (name.equals("Show Branch Length Composition")) {
				wizard.showTracedPaths = true;
				mShowPreciseBranches.setSelected(true);
				pShowPreciseBranches.setSelected(true);
				wizard.useOneNodeMode = false;
				wizard.showAllBranches = false;
				imagePanel.revalidate();
			} else if (name.equals("Use Elaborate Path Finding")) {
				wizard.useElaboratePathFinding = !wizard.useElaboratePathFinding;

				{
					if (mUseElaboratePathFinding != null) {
						mUseElaboratePathFinding
								.setSelected(wizard.useElaboratePathFinding);
						lookaheadSpinner
								.setEnabled(wizard.useElaboratePathFinding);
					}
					imagePanel.revalidate();
				}
			} else if (name.equals("Suggest look-ahead distance")) {
				wizard.lookaheadDistance = topology.getLowestPairwiseDistance();
				wizard.userLookaheadDistance = wizard.lookaheadDistance;
				lookaheadSpinner.setValue(wizard.lookaheadDistance);
			} else if (name.equals("Insert Root")) {

				imagePanel.performAction(Activity.INSERT_ROOT);
			} else if (name.equals("Display Readme")) {
				new ReadMePanel();
			} else if (name.equals("Show tutorials")) {
				new LinksPanel();
			}

			owner.setVisible(true); // Ensure that the main window is active and
			// its menu bar shown
		} catch (Exception ex) {
		}
		;
	}

	class GUIAction extends AbstractAction implements Runnable {
		private static final long serialVersionUID = 1L;
		String name;
		ActionEvent ev;

		GUIAction(String name) {
			super(name);
			this.name = name;
		}

		public void actionPerformed(ActionEvent e) {
			this.ev = e;
			if (taskThread != null)
				return;
			taskThread = new Thread((Runnable) this);
			taskThread.start();
		}

		public void run() {
			execute(ev);
			taskThread = null;
		}

	}

	class ColorBox extends JLabel {
		private static final long serialVersionUID = 1L;

		public ColorBox() {
			this.setColor(wizard.localFillColor); // Default color is white
		}

		protected Graphics2D g2;
		private int fillColor;

		public void paintComponent(Graphics g) {
			super.paintComponent(g);
			Graphics2D g2 = (Graphics2D) g;
			Rectangle2D rect = new Rectangle2D.Float(0, 0, 12, 12);
			g2.setColor(new Color(fillColor));
			g2.fill(rect);
			g2.setColor(Color.black);
			g2.draw(rect);
		}

		public void setColor(int c) {
			this.fillColor = c;
			this.repaint();
		};

		public Dimension getPreferredSize() {
			return new Dimension(13, 13);
		};
	}

	class SimpleButton extends JButton {
		private static final long serialVersionUID = 1L;
		String text;

		public SimpleButton(String s) {
			text = s;
		}

		private Graphics2D g2;

		public void paintComponent(Graphics g) {
			super.paintComponent(g);
			g2 = (Graphics2D) g;
			Rectangle2D rect = new Rectangle2D.Float(0, 0, 24, 14);
			g2.setColor(Color.gray.darker().darker());
			g2.draw(rect);
			g2.drawString(text, 2, 11);
		}

		public Dimension getPreferredSize() {
			return new Dimension(25, 15);
		};
	}

	public void handlePickedColor(int col) {
		// If the color dialog box is instantiated, let it consume the picked
		// color
		// Otherwise make the fill color the picked color
		if ((colorManipDialog != null) && (colorManipDialog.isVisible()))
			colorManipDialog.consumePickedColor(col);
		else {
			colorBox.setColor(wizard.lastColorPicked);
			wizard.localFillColor = wizard.lastColorPicked;
		}
		;
	}

	public JToolBar getLeftToolBar() {
		return this.toolbar;
	};

	public JToolBar getRightToolBar() {
		return this.sliderbar;
	};

	public JPopupMenu getPopupMenu() {
		return this.popupMenu;
	};

	public void resetRatioSlider() {
		ratioSlider.setValue(10);
		imagePanel.repaint();
	};

	public void toggleBlendControl(boolean b) {
		ratioSlider.setEnabled(b);
		wizard.ratioSliderEnabled = b;
	}

	public void useMixedLengths() {
		Wizard.useUserAssignedLengths = false;
		Wizard.useCalculatedLengths = false;
		Wizard.useMixedLengths = true;
		mUseMixedLengths.setSelected(true);

		wizard.drawBranchLength = true;
		mDrawBranchLength.setSelected(true);

		wizard.highlightBranchesWithoutLength = true;
		mHighlightBranchesWithoutLength.setSelected(true);

		NumberUtility.setNumFractionDigits(topology.getBranches());
		imagePanel.updateResultFrame();
	}

	public void toggleBranchTools(boolean b) {
		pDragBranch.setEnabled(b);
		mDragBranch.setEnabled(b);
		tDragBranch.setEnabled(b);
		pRemoveBranch.setEnabled(b);
		mRemoveBranch.setEnabled(b);
		pRemoveBranches.setEnabled(b);
		mRemoveBranches.setEnabled(b);
	}

	public void toggleWizardOptions(boolean b) {
		useWizard.setEnabled(b);
		mUseWizard.setVisible(b);
		mUseWizard.setEnabled(b);
		tUseWizard.setVisible(b);
		tUseWizard.setEnabled(b);
	}

	public void toggleDrawingTools(boolean b) {

		pPipette.setEnabled(b);
		mPipette.setEnabled(b);
		tPipette.setEnabled(b);
		tStencil.setEnabled(b);
		pLocalFill.setEnabled(b);
		mLocalFill.setEnabled(b);
		tLocalFill.setEnabled(b);
		mGreyscaleConversion.setEnabled(b);
		tGreyscaleConversion.setEnabled(b);
		mMinMax.setEnabled(b);
		tMinMax.setEnabled(b);
		mFillDialog.setEnabled(b);
		tFillDialog.setEnabled(b);
		mBrightness.setEnabled(b);
		tBrightness.setEnabled(b);
		mBinarize.setEnabled(b);
		tBinarize.setEnabled(b);
		mSmooth.setEnabled(b);
		tSmooth.setEnabled(b);
		mSharpen.setEnabled(b);
		tSharpen.setEnabled(b);
		mDespeckle.setEnabled(b);
		tDespeckle.setEnabled(b);
		mColorQuant.setEnabled(b);
		mClearImage.setEnabled(b);
		tClearImage.setEnabled(b);
		mScaleImage2x.setEnabled(b);
		mScaleImage05x.setEnabled(b);
		mHistogramStretch.setEnabled(b);
		tInvert.setEnabled(b);
		mInvert.setEnabled(b);
		mTrim.setEnabled(b);
		mSubimage.setEnabled(b);
		tAutoBin.setEnabled(b);
		mAutoBin.setEnabled(b);
		tGrabMotif.setEnabled(b);
		tSkeletonize.setEnabled(b);
		mSkeletonize.setEnabled(b);
		mFillBlack.setEnabled(b);
		tFillBlack.setEnabled(b);
		mFillWhite.setEnabled(b);
		tFillWhite.setEnabled(b);
	}

	public void adjustControls() // Adjust the controls after the recovery of a
	// Snapshot/for NewImage
	{
		try {
			if (mUseWizard != null)
				mUseWizard.setSelected(wizard.useWizard);
			if (tUseWizard != null)
				tUseWizard.setSelected(wizard.useWizard);
			if (owner != null)
				owner.swapWizardAndNewickPanels();

			if (mMarkFloodSeed != null)
				mMarkFloodSeed.setSelected(wizard.markFloodSeed);
			if (tMarkFloodSeed != null)
				tMarkFloodSeed.setSelected(wizard.markFloodSeed);

			if (mSmallMarks != null)
				mSmallMarks.setSelected(wizard.smallMarks);
			if (tSmallMarks != null)
				tSmallMarks.setSelected(wizard.smallMarks);

			if (mAutoSkeletonize != null)
				mAutoSkeletonize.setSelected(wizard.autoSkeletonize);
			if (tAutoSkeletonize != null)
				tAutoSkeletonize.setSelected(wizard.autoSkeletonize);

			if (mAutoFlood != null)
				mAutoFlood.setSelected(wizard.autoFlood);
			if (tAutoFlood != null)
				tAutoFlood.setSelected(wizard.autoFlood);

			if (mAutoClean != null)
				mAutoClean.setSelected(wizard.autoClean);
			if (tAutoClean != null)
				tAutoClean.setSelected(wizard.autoClean);
			if (pAutoClean != null)
				pAutoClean.setSelected(wizard.autoClean);

			if (mSrcInMagnifier != null)
				mSrcInMagnifier.setSelected(wizard.showSourceImageInMagnifier);
			if (tSrcInMagnifier != null)
				tSrcInMagnifier.setSelected(wizard.showSourceImageInMagnifier);

			if (mFGColorInMagnifier != null)
				mFGColorInMagnifier
						.setSelected(wizard.highlightFGColorInMagnifier);
			if (tFGColorInMagnifier != null)
				tFGColorInMagnifier
						.setSelected(wizard.highlightFGColorInMagnifier);

			if (mUseFancyCursors != null)
				mUseFancyCursors.setSelected(wizard.useFancyCursors);
			if (mUseElaboratePathFinding != null) {
				mUseElaboratePathFinding
						.setSelected(wizard.useElaboratePathFinding);
				if (lookaheadSpinner != null)
					lookaheadSpinner.setEnabled(wizard.useElaboratePathFinding);
			}

			if (mOneNodeMode != null)
				mOneNodeMode.setSelected(wizard.useOneNodeMode);
			if (pOneNodeMode != null)
				pOneNodeMode.setSelected(wizard.useOneNodeMode);

			if (mShowPreciseBranches != null)
				mShowPreciseBranches.setSelected(wizard.showTracedPaths);
			if (pShowPreciseBranches != null)
				pShowPreciseBranches.setSelected(wizard.showTracedPaths);

			if (mShowAllBranches != null)
				mShowAllBranches.setSelected(wizard.showAllBranches);
			if (pShowAllBranches != null)
				pShowAllBranches.setSelected(wizard.showAllBranches);

			if (mSuppressTinyBranches != null)
				mSuppressTinyBranches.setSelected(wizard.suppressTinyBranches);

			if (mNodesStickToTree != null)
				mNodesStickToTree.setSelected(wizard.nodesStickToTree);

			if (mDiscardUserObjects != null)
				mDiscardUserObjects
						.setSelected(wizard.mayDiscardUserGeneratedObjects);

			if (mDrawBranchLength != null)
				mDrawBranchLength.setSelected(wizard.drawBranchLength);

			if (mDrawTaxonName != null)
				mDrawTaxonName.setSelected(wizard.drawTaxonName);

			if (mHighlightBranchesWithoutLength != null)
				mHighlightBranchesWithoutLength
						.setSelected(wizard.highlightBranchesWithoutLength);
			if (tHighlightBranchesWithoutLength != null)
				tHighlightBranchesWithoutLength
						.setSelected(wizard.highlightBranchesWithoutLength);

			if (mHighlightTipsWithoutName != null)
				mHighlightTipsWithoutName
						.setSelected(wizard.highlightTipsWithoutName);
			if (tHighlightTipsWithoutName != null)
				tHighlightTipsWithoutName
						.setSelected(wizard.highlightTipsWithoutName);

			if (mUseMixedLengths != null)
				mUseMixedLengths.setSelected(Wizard.useMixedLengths);
			if (mUseUserAssignedLengths != null)
				mUseUserAssignedLengths
						.setSelected(Wizard.useUserAssignedLengths);
			if (mUseCalculatedLengths != null)
				mUseCalculatedLengths.setSelected(Wizard.useCalculatedLengths);

			if (mColoredNewickExpression != null)
				mColoredNewickExpression.setSelected(wizard.colorNewickString);

			if (mIncludeBranchLengths != null)
				mIncludeBranchLengths.setSelected(wizard.includeBranchLengths);

			if (mTopologyFree != null)
				mTopologyFree.setSelected(wizard.topologyType == FREE);
			if (mTopologyRect != null)
				mTopologyRect.setSelected(wizard.topologyType == RECTANGULAR);
			if (mTopologyPolar != null)
				mTopologyPolar.setSelected(wizard.topologyType == POLAR);
			if (tTopologyFree != null)
				tTopologyFree.setSelected(wizard.topologyType == FREE);
			if (tTopologyRect != null)
				tTopologyRect.setSelected(wizard.topologyType == RECTANGULAR);
			if (tTopologyPolar != null)
				tTopologyPolar.setSelected(wizard.topologyType == POLAR);

			if (drawingStrokeSpinner != null)
				drawingStrokeSpinner.setValue(wizard.drawingStrokeWidth);
			if (eraserStrokeSpinner != null)
				eraserStrokeSpinner.setValue(wizard.eraserStrokeWidth);
			if (lookaheadSpinner != null)
				lookaheadSpinner.setValue(wizard.lookaheadDistance);
			if (ratioSlider != null)
				ratioSlider.setValue(wizard.ratioSliderValue);

			if (imagePanel != null) {
				imagePanel.updateResultFrame();
				imagePanel.repaint();
			}

		} catch (NullPointerException e) {
		}

	}

}
