/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;

public class FancyCursors {
	Wizard wizard;
	Cursor panelCursor;
	Cursor pencilCursor;
	Cursor rubberCursor;
	Cursor defaultCursor;
	Cursor crosshairCursor;
	Cursor handCursor;
	Cursor pipetteCursor;
	Cursor fillCursor;
	Cursor blackLineCursor;
	Cursor whiteLineCursor;
	Cursor curve2DCursor;
	Cursor boxSelCursor;
	Cursor lineSelCursor;
	Cursor dragCursor;
	Cursor stencilCursor;

	public FancyCursors(Wizard wiz) {
		this.wizard = wiz;
		Toolkit toolkit = Toolkit.getDefaultToolkit();
		Image cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/MetricsCursor.GIF"));
		Point cursorHotSpot = new Point(11, 11);
		panelCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Standard");

		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/BoxSelCursor.GIF"));
		cursorHotSpot = new Point(22, 12);
		boxSelCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Box");

		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/LineSelCursor.GIF"));
		cursorHotSpot = new Point(22, 12);
		lineSelCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Box");

		cursorHotSpot = new Point(7, 22);
		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/PencilCursor.GIF"));
		pencilCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Pencil");

		cursorHotSpot = new Point(7, 22);
		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/BlackLineCursor.GIF"));
		blackLineCursor = toolkit.createCustomCursor(cursorImage,
				cursorHotSpot, "BlackLine");

		cursorHotSpot = new Point(7, 22);
		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/WhiteLineCursor.GIF"));
		whiteLineCursor = toolkit.createCustomCursor(cursorImage,
				cursorHotSpot, "WhiteLine");

		cursorHotSpot = new Point(7, 22);
		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/Curve2DCursor.GIF"));
		curve2DCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Curve2D");

		cursorHotSpot = new Point(4, 21);
		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/RubberCursor.GIF"));
		rubberCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Rubber");

		cursorHotSpot = new Point(1, 22);
		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/PipetteCursor.GIF"));
		pipetteCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Pipette");

		cursorHotSpot = new Point(4, 19);
		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/FillCursor.GIF"));
		fillCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Fill");

		cursorHotSpot = new Point(22, 11);
		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/DragCursor.GIF"));
		dragCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Drag");

		cursorHotSpot = new Point(1, 1);
		cursorImage = toolkit.getImage(FancyCursors.class
				.getResource("/Cursors/StencilCursor.GIF"));
		stencilCursor = toolkit.createCustomCursor(cursorImage, cursorHotSpot,
				"Stencil");
	}

	public Cursor getPanelCursor() {
		return this.panelCursor;
	}

	public Cursor getBoxSelCursor() {
		return this.boxSelCursor;
	}

	public Cursor getLineSelCursor() {
		return this.lineSelCursor;
	}

	public Cursor getPencilCursor() {
		return this.pencilCursor;
	}

	public Cursor getBlackLineCursor() {
		return this.blackLineCursor;
	}

	public Cursor getWhiteLineCursor() {
		return this.whiteLineCursor;
	}

	public Cursor getCurve2DCursor() {
		return this.curve2DCursor;
	}

	public Cursor getRubberCursor() {
		return this.rubberCursor;
	}

	public Cursor getPipetteCursor() {
		return this.pipetteCursor;
	}

	public Cursor getFillCursor() {
		return this.fillCursor;
	}

	public Cursor getDragCursor() {
		return this.dragCursor;
	}

	public Cursor getStencilCursor() {
		return this.stencilCursor;
	}

	public Cursor getDefaultCursor() {
		return new Cursor(Cursor.DEFAULT_CURSOR);
	}

	public Cursor getHandCursor() {
		return new Cursor(Cursor.HAND_CURSOR);
	}

	public Cursor getCrosshairCursor() {
		return new Cursor(Cursor.CROSSHAIR_CURSOR);
	}

	public Cursor getWaitCursor() {
		return new Cursor(Cursor.WAIT_CURSOR);
	}
}
