/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ControlsDialog extends JDialog {
	private static final long serialVersionUID = 1L;
	protected JButton accept = new JButton("Accept");
	protected JButton revert = new JButton("Cancel");
	protected JButton preview = new JButton("Preview");
	protected JPanel slidersPanel;
	protected JPanel labelsPanel;
	protected boolean manipulated;

	public ControlsDialog() {
		this("", null, true);
	}

	public ControlsDialog(String title, java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		this.setTitle(title);
		this.setResizable(false);
		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE); // Not the
		// most
		// elegant
		// solution,
		// better
		// hide the
		// buttons
		this.setAlwaysOnTop(true);
		JPanel jpButtons = new JPanel();
		jpButtons.add(accept);
		jpButtons.add(preview);
		jpButtons.add(revert);

		slidersPanel = new JPanel();
		labelsPanel = new JPanel();
		labelsPanel.setLayout(new BorderLayout());
		JPanel jpGeneral = new JPanel();
		jpGeneral.setLayout(new BorderLayout());
		jpGeneral.setBorder(BorderFactory
				.createTitledBorder("Select Parameters"));
		jpGeneral.add(labelsPanel, BorderLayout.WEST);
		jpGeneral.add(slidersPanel, BorderLayout.CENTER);

		getContentPane().add(jpButtons, BorderLayout.SOUTH);
		getContentPane().add(jpGeneral, BorderLayout.CENTER);

		manipulated = false; // No image manipulation has occurred
	}

	public JPanel getSlidersPanel() {
		return this.slidersPanel;
	};

	public JPanel getLabelsPanel() {
		return this.labelsPanel;
	}

}
