
package TreeSnatcher.GUI;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.Color;
import java.awt.Font;

// Modified from
// http://www.java-tips.org/java-se-tips/javax.swing/how-to-add-colored-text-to-the-document.html
public class ColorPane extends JTextPane {
	private static final long serialVersionUID = 1L;

	public ColorPane() {
		this.setFont(new Font("Sans Serif", Font.PLAIN, 16));
	}

	public void appendNaive(Color c, String s) // naive implementation
	{
		// bad: instantiates a new AttributeSet object on each call
		SimpleAttributeSet aset = new SimpleAttributeSet();
		StyleConstants.setForeground(aset, c);

		int len = getText().length();
		setCaretPosition(len); // place caret at the end (with no selection)
		setCharacterAttributes(aset, false);
		replaceSelection(s); // there is no selection, so inserts at caret
	}

	public void append(Color c, String s) // better implementation--uses
											// StyleContext
	{
		StyleContext sc = StyleContext.getDefaultStyleContext();
		AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY,
				StyleConstants.Foreground, c);

		int len = getDocument().getLength(); // same value as
												// getText().length();
		setCaretPosition(len); // place caret at the end (with no selection)
		setCharacterAttributes(aset, false);
		replaceSelection(s); // there is no selection, so inserts at caret
	}
}