/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.GUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import javax.swing.JButton;

public class ColorButton extends JButton {
	private static final long serialVersionUID = 1L;
	private Color fillColor;
	private Dimension d = new Dimension(22, 22);

	public ColorButton() {
		super();
		this.setMinimumSize(d);
		this.setPreferredSize(d);
		this.setSize(d);
		this.fillColor = Color.white;
	}

	public ColorButton(Color color) {
		new ColorButton();
		this.fillColor = color;
	}

	public void paintChildren(Graphics g) {
		super.paintChildren(g);
		Graphics2D g2 = (Graphics2D) g;
		Rectangle2D rect = new Rectangle2D.Float(3, 3, 16, 16);
		g2.setColor(fillColor);
		g2.fill(rect);
	}

	public void setColor(Color color) {
		this.fillColor = color;
	};

	public Color getColor() {
		return this.fillColor;
	};

	public Dimension getPreferredSize() {
		return d;
	};
}
