// Modified source code from the Apple Developer Connection:

/*

 File:    AboutBox.java

 Abstract:  MRJ About box.  Note modal workaround in constructor for Mac OS X 10.0.x

 Version:  1.3.2

  Copyright 2005 Apple Computer, Inc. All rights reserved.

 IMPORTANT:  This Apple software is supplied to 
 you by Apple Computer, Inc. ("Apple") in 
 consideration of your agreement to the following 
 terms, and your use, installation, modification 
 or redistribution of this Apple software 
 constitutes acceptance of these terms.  If you do 
 not agree with these terms, please do not use, 
 install, modify or redistribute this Apple 
 software.

 In consideration of your agreement to abide by 
 the following terms, and subject to these terms, 
 Apple grants you a personal, non-exclusive 
 license, under Apple's copyrights in this 
 original Apple software (the "Apple Software"), 
 to use, reproduce, modify and redistribute the 
 Apple Software, with or without modifications, in 
 source and/or binary forms; provided that if you 
 redistribute the Apple Software in its entirety 
 and without modifications, you must retain this 
 notice and the following text and disclaimers in 
 all such redistributions of the Apple Software. 
 Neither the name, trademarks, service marks or 
 logos of Apple Computer, Inc. may be used to 
 endorse or promote products derived from the 
 Apple Software without specific prior written 
 permission from Apple.  Except as expressly 
 stated in this notice, no other rights or 
 licenses, express or implied, are granted by 
 Apple herein, including but not limited to any 
 patent rights that may be infringed by your 
 derivative works or by other works in which the 
 Apple Software may be incorporated.

 The Apple Software is provided by Apple on an "AS 
 IS" basis.  APPLE MAKES NO WARRANTIES, EXPRESS OR 
 IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED 
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY 
 AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING 
 THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE 
 OR IN COMBINATION WITH YOUR PRODUCTS.

 IN NO EVENT SHALL APPLE BE LIABLE FOR ANY 
 SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL 
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
 OF USE, DATA, OR PROFITS; OR BUSINESS 
 INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, 
 REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION OF 
 THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER 
 UNDER THEORY OF CONTRACT, TORT (INCLUDING 
 NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN 
 IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF 
 SUCH DAMAGE.

 package apple.dts.samplecode.swaplaf;
 */

package TreeSnatcher.GUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import TreeSnatcher.Core.MainWindow;

public class AboutBox extends JDialog implements ActionListener {
	private static final long serialVersionUID = 1L;
	protected JButton okButton;
	protected JLabel title, disclaimer, support;

	public AboutBox(JFrame parent) {
		super(parent); // By default the box is non-modal
		setResizable(false);
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		int w = (int) screen.getWidth();
		int h = (int) screen.getHeight();

		// Workaround for modal about box bug in MacOS X 10.0.x
		// regardless of mrj.version (3.0/3.1/DP1-2)
		String version = System.getProperty("os.version");
		if (version != null && !version.startsWith("10.0"))
			setModal(true);

		this.setFont(new Font("SansSerif", Font.BOLD, 14));

		String text = "<HTML><br><CENTER><h1><B>TreeSnatcher Plus</B></h1><P><P>Created by Thomas Laubach";
		text = text + "<br><P>Institute of Bioinformatics";
		text = text
				+ "<br>Heinrich-Heine-University Duesseldorf, Germany</P></CENTER></HTML>";

		String text2 = "<HTML><P><br>Supported by";
		text2 = text2
				+ "<br>Martin J. Lercher, Heinrich-Heine-University Duesseldorf";
		text2 = text2
				+ "<br>Arndt von Haeseler, Center for Integrative Bioinformatics Vienna (CIBIV)";
		text2 = text2
				+ "<br><br>I wish to thank many people for exchanging ideas and for advice";
		text2 = text2 + "<br>(please see tsReadme.txt).</P>";
		text2 = text2
				+ "<P><br>This program is inspired from <b>TreeThief by Andrew Rambaut</b>.<P>";
		text2 = text2
				+ "<P>Some mouse cursors are modified from those used in the GIMP";
		text2 = text2 + "<br>package (http://www.gimp.org). ";
		text2 = text2 + "The icon was modified from";
		text2 = text2
				+ "<br>http://www.ukgermanconnection.org/kids/...forest.jpg.<P>";
		text2 = text2
				+ "<P>For questions, suggestions, bug reports, or the source code,";
		text2 = text2
				+ "<br>please mail to <i>laubach@cs.uni-duesseldorf.de</i></P>";
		text2 = text2
				+ "<P><br>This work is published under the GNU General Public License.<P></HTML>";

		title = new JLabel(MainWindow.tsIcon128, JLabel.CENTER);
		title.setText(text);
		title.setHorizontalAlignment(JLabel.CENTER);
		title.setPreferredSize(new Dimension(480, 150));

		support = new JLabel();
		support.setHorizontalAlignment(JLabel.CENTER);
		support.setText(text2);
		support.setPreferredSize(new Dimension(500, 430));
		support.setVerticalTextPosition(JLabel.TOP);
		support.setVerticalAlignment(JLabel.TOP);
		support.setHorizontalTextPosition(JLabel.CENTER);
		support.setBackground(new Color(220, 220, 220));
		support.setOpaque(true);

		FlowLayout fLayout = new FlowLayout();
		fLayout.setAlignment(FlowLayout.CENTER);
		fLayout.setHgap(20);
		fLayout.setVgap(20);
		JPanel textPanel = new JPanel(fLayout);

		textPanel.add(title);
		textPanel.add(support, JPanel.CENTER_ALIGNMENT);

		this.add(textPanel, BorderLayout.NORTH);

		okButton = new JButton("OK");
		JPanel buttonPanel = new JPanel(new FlowLayout(FlowLayout.CENTER, 15,
				15));
		buttonPanel.add(okButton);
		okButton.addActionListener(this);
		this.add(buttonPanel, BorderLayout.SOUTH);
		this.setUndecorated(true);
		this.setPreferredSize(new Dimension(500, 530));
		this.pack();
		this.setLocation(w / 2 - this.getWidth() / 2, h / 2 - this.getHeight()
				/ 2);
	}

	public void actionPerformed(ActionEvent newEvent) {
		setVisible(false);
	}
}
