/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.Core;

import java.awt.Point;

public class Tip extends TreeNode {
	private static final long serialVersionUID = 1L;
	private String taxonName = "";
	public static int nameCnt;

	public Tip(Point p) {
		super(p);
		taxonName = new Integer(nameCnt++).toString();
	}

	public Tip(int x, int y) {
		super(x, y);
		taxonName = new Integer(nameCnt++).toString();
	}

	public Tip(Point p, boolean b) {
		super(p, b);
		taxonName = new Integer(nameCnt++).toString();
	}

	public Tip(int x, int y, boolean b) {
		super(x, y, b);
		taxonName = new Integer(nameCnt++).toString();
	}

	public void setTaxonName(String name) {
		this.taxonName = name;
	};

	public static void resetNameCount() {
		nameCnt = 1;
	};

	public String getTaxonName() {
		if (this.taxonName == "")
			return null;
		else
			return this.taxonName;
	}
}
