/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.Core;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;

import javax.swing.ImageIcon;

public interface Constants {
	final int defaultThreshold = 190;
	final int defaultKernelWidth = 1;
	final int defaultMedianRectWidth = 3;
	final int defaultMinMaxRectWidth = 3;
	final int defaultMinRegionSize = 200;
	final int defaultUSMKernelWidth = 1;
	final int defaultBrightnessOffset = 0;
	final int defaultDrawingStrokeWidth = 1;
	final int defaultEraserStrokeWidth = 1;
	final int defaultAutoCleanWidth = 4;
	final int defaultColorDistance = 100;
	final int defaultQuantNumColors = 256;
	final int defaultTransparencyShade = Color.gray.brighter().getRGB();
	final int defaultMaxNoSelectionColors = 1000;
	final int defaultSmallNodeRadius = 5;
	final int defaultReferenceNodeRadius = 7;
	final int defaultTinyBranchLength = 3; // Any branch that is shorter than
											// this number in pixels is to be
											// erased from the topology

	final int scrBorderOffset = 60;
	final int scrOffset = 15;

	final int defaultMinNumFractionDigits = 1;
	final int defaultMaxNumFractionDigits = 4;
	final int defaultLookaheadDistance = 7;
	final int maximumLookaheadDistance = 50;

	final double defaultUSMFactor = 1.0; // Amplification Factor
	final double[] defaultGreyscaleFactors = { 0.2125, 0.7154, 0.072 };
	final double defaultContrastFactor = 1.0;
	final double defaultBranchLength = 0.0d;

	// Colors
	final int BIN1 = Color.black.getRGB();
	final int BIN0 = Color.white.getRGB();
	final Color nodeColor = new Color(30, 50, 230);
	final Color tipHighlightedColor = Color.magenta;
	final Color tipColor = new Color(30, 230, 50);
	final Color branchHighlightedColor = Color.orange;
	final Color branchColor = new Color(30, 230, 50);
	final Color selectionColor = Color.red;
	final Color branchSelectedColor = Color.red;
	final Color referenceNodeColor = new Color(250, 215, 0);
	final Color signalColor = Color.magenta;
	final Color defaultPathColor = new Color(0, 255, 0);
	final Color defaultNewickColor = new Color(0, 15, 65);
	final Color defaultNewickLengthsColor = new Color(145, 145, 145);

	Toolkit toolkit = Toolkit.getDefaultToolkit();
	public static final ImageIcon tsIcon32 = new ImageIcon(toolkit
			.getImage(Image.class.getResource("/Icons/wood32.png")));
	public static final ImageIcon tsIcon64 = new ImageIcon(toolkit
			.getImage(Image.class.getResource("/Icons/wood64.png")));
	public static final ImageIcon tsIcon128 = new ImageIcon(toolkit
			.getImage(Image.class.getResource("/Icons/wood128.png")));
	public static final ImageIcon tsIcon256 = new ImageIcon(toolkit
			.getImage(Image.class.getResource("/Icons/wood256.png")));

	// TreeNode Flags
	final int UNTOUCHED = 0;
	final int UNDERWAY = 1;
	final int FINISHED = 2;

	// Topology types
	final int FREE = 0;
	final int RECTANGULAR = 1;
	final int POLAR = 2;

	// Branch segment length relevance
	final int NOT_DETERMINED = 0;
	final int RELEVANT = 1;
	final int IRRELEVANT = 2;
}
