/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.Core;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

import TreeSnatcher.GUI.ImagePanel;
import TreeSnatcher.GUI.Wizard;
import TreeSnatcher.Core.TreeTopology;

// Not currently used: Represents constraints imposed on the activities and modes in TreeSnatcher 
public class ActivityConstraints {
	private ImagePanel imagePanel;
	private TreeTopology topology;
	private Wizard wizard;

	public ActivityConstraints(ImagePanel imagePanel, TreeTopology topology,
			Wizard wizard) {
		this.imagePanel = imagePanel;
		this.topology = topology;
		this.wizard = wizard;
	}

	public int getConstrainingActivity(int activity) {
		// Returns the activity that must precede the very activity
		// For graphical operations keep in mind that the image area manipulated
		// by the
		// new activity must be contained in or equal to that of foregone
		// activity
		// NO_CONSTRAINT means that the activity is not constrained by another
		// activity
		// However, there are actions that are constrained by more complex
		// causes:
		// For instance, DRAW_BRANCH requires that there are at least two nodes
		// in the topology
		// Those constraints are checked by {checkConstraint()}

		switch (activity) {
		case Activity.FILL_BLACK:
			return Activity.NONE;
		case Activity.FILL_WHITE:
			return Activity.NONE;
		case Activity.BLACK_PEN:
			return Activity.NONE;
		case Activity.ERASER:
			return Activity.NONE;
		case Activity.QUADCURVE:
			return Activity.NONE;
		case Activity.BLACK_LINE:
			return Activity.NONE;
		case Activity.WHITE_LINE:
			return Activity.NONE;
		case Activity.SUBIMAGE:
			return Activity.NONE;
		case Activity.RECT_SEL:
			return Activity.NONE;
		case Activity.LINE_SEL:
			return Activity.NONE;
		case Activity.ALL_SEL:
			return Activity.NONE;
		case Activity.POLY_SEL:
			return Activity.NONE;
		case Activity.MOVE_NODE:
			return Activity.NONE;
		case Activity.DRAW_BRANCH:
			return Activity.NONE;
		case Activity.CLEAR_IMAGE:
			return Activity.NONE;
		case Activity.INVERT:
			return Activity.NONE;
		case Activity.EXTRACT_AREA:
			return Activity.FLOOD_FILL;
		case Activity.REMOVE_OBJECT:
			return Activity.NONE;
		case Activity.BRANCH_LENGTH:
			return Activity.NONE;
		case Activity.NAME_TAXON:
			return Activity.NONE;
		case Activity.AS_REFERENCE_NODE:
			return Activity.NONE;
		case Activity.SCALE_BAR_LENGTH:
			return Activity.NONE;
		case Activity.PIPETTE:
			return Activity.NONE;
		case Activity.GRAB_MOTIF:
			return Activity.NONE;
		case Activity.STENCIL:
			return Activity.GRAB_MOTIF;
		case Activity.BINARIZE:
			return Activity.NONE;
		case Activity.AUTO_BINARIZE:
			return Activity.GREYSCALE_CONVERSION;
		case Activity.SMOOTH:
			return Activity.NONE;
		case Activity.SHARPEN:
			return Activity.NONE;
		case Activity.DESPECKLE:
			return Activity.NONE;
		case Activity.BRIGHTNESS:
			return Activity.NONE;
		case Activity.MINIMUM_OP:
			return Activity.NONE;
		case Activity.SKELETONIZE:
			return Activity.BINARIZE;
		case Activity.FIND_NODES:
			return Activity.FLOOD_FILL;
		case Activity.FIND_BRANCHES:
			return Activity.NONE; // It is sufficient if user created nodes are
									// there
		case Activity.FLOOD_FILL:
			return Activity.SKELETONIZE;
		case Activity.SCALE2X:
			return Activity.NONE;
		case Activity.SCALE05X:
			return Activity.NONE;
		case Activity.GREYSCALE_CONVERSION:
			return Activity.NONE;
		case Activity.HISTOGRAM_STRETCH:
			return Activity.GREYSCALE_CONVERSION;
		case Activity.TRIM:
			return Activity.NONE;
		case Activity.FILL:
			return Activity.NONE;
		case Activity.GLOBAL_COLORCHANGE:
			return Activity.NONE;
		case Activity.COLOR_QUANTIZATION:
			return Activity.NONE;
		}
		return Activity.NONE;
	}

	public boolean checkConstraint(int activity) {
		Shape selection = imagePanel.getCurrentSelection();

		switch (activity) {
		case Activity.ERASER:
			return true;
		case Activity.BLACK_PEN:
			return true;
		case Activity.BLACK_LINE:
			return true;
		case Activity.WHITE_LINE:
			return true;
		case Activity.QUADCURVE:
			return true;
		case Activity.RECT_SEL:
			return true;
		case Activity.LINE_SEL:
			return true;
		case Activity.ALL_SEL:
			return true;
		case Activity.POLY_SEL:
			return true;
		case Activity.PIPETTE:
			return true;
		case Activity.CLEAR_IMAGE:
			return true;
		case Activity.REMOVE_OBJECT:
			return true; // Not used
		case Activity.BINARY_CORRECTION:
			return true; // Not used

		case Activity.INVERT:
			if ((selection != null) && (selection instanceof Rectangle2D))
				return true;
		case Activity.MOVE_NODE:
			if ((topology.getNodes() != null)
					|| (topology.getBranches() != null))
				return true;
		case Activity.DRAW_BRANCH:
			if (topology.getNodes().size() >= 2)
				return true;
		case Activity.EXTRACT_AREA:
			if (wizard.floodedPixels > 0)
				return true;
		case Activity.FIND_BRANCHES:
			if ((topology.getNodes().size() > 1)
					&& ((activityPerformed(Activity.BINARIZE, selection)) || (activityPerformed(
							Activity.AUTO_BINARIZE, selection))))
				return true;
		case Activity.SCALE_BAR_LENGTH:
			if ((selection != null) && (selection instanceof Line2D))
				return true;
		case Activity.TRIM:
			if ((selection != null) && (selection instanceof Rectangle2D))
				return true;
		case Activity.GRAB_MOTIF:
			if ((selection != null) && (selection instanceof Rectangle2D))
				return true;
		case Activity.SUBIMAGE:
			if ((selection != null) && (selection instanceof Rectangle2D))
				return true;
		case Activity.BRANCH_LENGTH:
			if (topology.getBranches().size() > 0)
				return true;
		case Activity.NAME_TAXON:
			if (topology.getNodes().size() > 0)
				return true;
		case Activity.AS_REFERENCE_NODE:
			if (topology.getNodes().size() > 0)
				return true;
		case Activity.STENCIL:
			if (imagePanel.getMotif() != null)
				return true;

		case Activity.FILL_BLACK:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.FILL_WHITE:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.BINARIZE:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.AUTO_BINARIZE:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.SMOOTH:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.SHARPEN:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.DESPECKLE:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.BRIGHTNESS:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.MINIMUM_OP:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.SKELETONIZE:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.FIND_NODES:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.FLOOD_FILL:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.SCALE2X:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.SCALE05X:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.GREYSCALE_CONVERSION:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.HISTOGRAM_STRETCH:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.FILL:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.GLOBAL_COLORCHANGE:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		case Activity.COLOR_QUANTIZATION:
			if (activityPerformed(getConstrainingActivity(activity), selection))
				return true;
		}
		return false;
	}

	// Check the activity history whether the area within the selection has been
	// manipulated
	// during the specified activity
	private boolean activityPerformed(int activity, Shape selection) {
		// All activities treated here require the existence of a rectangular
		// user selection
		if (!(selection instanceof Rectangle2D))
			return false;
		else {

		}
		return true;
	}
}