/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package TreeSnatcher.Core;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;

// Activity encapsulates one activity and its area of influence
public class Activity {
	public static final int NONE = -1;
	public static final int IDLE = 0;
	public static final int ERASER = 1;
	public static final int BLACK_PEN = 2;
	public static final int BLACK_LINE = 3;
	public static final int QUADCURVE = 4;
	public static final int FILL_BLACK = 5;
	public static final int FILL_WHITE = 6;
	public static final int TRIM = 7;
	public static final int SUBIMAGE = 8;
	public static final int RECT_SEL = 9;
	public static final int LINE_SEL = 10;
	public static final int ALL_SEL = 11;
	public static final int POLY_SEL = 12;
	public static final int INVERT = 13;
	public static final int BINARIZE = 14;
	public static final int AUTO_BINARIZE = 15;
	public static final int SMOOTH = 16;
	public static final int SHARPEN = 17;
	public static final int DESPECKLE = 18;
	public static final int BRIGHTNESS = 19;
	public static final int MINIMUM_OP = 20;
	public static final int BINARY_CORRECTION = 21;
	public static final int SKELETONIZE = 22;
	public static final int MOVE_NODE = 23;
	public static final int DRAW_BRANCH = 24;
	public static final int EXTRACT_AREA = 26;
	public static final int FIND_NODES = 27;
	public static final int FIND_BRANCHES = 28;
	public static final int REMOVE_OBJECT = 29;
	public static final int CLEAR_IMAGE = 30;
	public static final int FLOOD_FILL = 31;
	public static final int BRANCH_LENGTH = 32;
	public static final int NAME_TAXON = 33;
	public static final int AS_REFERENCE_NODE = 34;
	public static final int SCALE_BAR_LENGTH = 35;
	public static final int SCALE2X = 36;
	public static final int SCALE05X = 37;
	public static final int GREYSCALE_CONVERSION = 38;
	public static final int HISTOGRAM_STRETCH = 39;
	public static final int PIPETTE = 40;
	public static final int FILL = 41;
	public static final int GLOBAL_COLORCHANGE = 42;
	public static final int COLOR_QUANTIZATION = 43;
	public static final int GRAB_MOTIF = 44;
	public static final int STENCIL = 45;
	public static final int ADD_INNERNODE = 46;
	public static final int ADD_TIP = 47;
	public static final int REMOVE_NODE = 48;
	public static final int REMOVE_SELECTED_NODES = 49;
	public static final int REMOVE_SELECTED_BRANCHES = 50;
	public static final int REMOVE_BRANCH = 51;
	public static final int ADD_BRANCH = 52;
	public static final int SCALE_USING_BRANCH_LENGTH_1 = 53;
	public static final int SCALE_USING_SPECIFIED_BRANCH_LENGTH = 54;
	public static final int WHITE_LINE = 55;
	public static final int INSERT_ROOT = 56;

	static final HashMap<Integer, String> description = new HashMap<Integer, String>();

	private Rectangle2D manipulatedArea; // Wwill be added as soon as the
											// activity is performed
	private int id; // One of the activity constants above
	private String filename;
	private Object wrappedObj;

	static // Not currently used
	{
		if (description == null) {
			description.put(IDLE, "No activity");
			description
					.put(ERASER, "Freehand Drawing (Background Shade White)");
			description.put(BLACK_PEN,
					"Freehand Drawing (Foreground Shade Black)");
			description.put(BLACK_LINE, "Black line drawing");
			description.put(WHITE_LINE, "White line drawing");
			description.put(QUADCURVE, "Cubic curve drawing");
			description.put(FILL_BLACK,
					"Blackens the image area within the selection box");
			description.put(FILL_WHITE,
					"Whitens image area within the selection box");
			description.put(TRIM, "Whitens the area outside the selection box");
			description
					.put(SUBIMAGE,
							"Builds a new image from the image portion within the selection box");
			description
					.put(RECT_SEL,
							"Allows the user to drag a selection box (a.k.a. Rubber Band)");
			description
					.put(
							LINE_SEL,
							"Allows the user to drag a line selection (used for the determination of a known length in the tree)");
			description.put(ALL_SEL, "Unused");
			description.put(POLY_SEL, "Unused");
			description.put(INVERT, "Inverts the colors of an image portion");
			description.put(BINARIZE,
					"Binarizes the entire image/parameter dialog");
			description.put(AUTO_BINARIZE,
					"Automatically binarizes an image portion");
			description
					.put(SMOOTH,
							"Smoothes the image using a Gauss characteristic/parameter dialog");
			description
					.put(SHARPEN,
							"Sharpens the image using the Universal-Unsharp-Masking technique");
			description.put(DESPECKLE, "");
			description
					.put(BRIGHTNESS,
							"Adjusts the brightness and the contrast of an image portion");
			description
					.put(
							MINIMUM_OP,
							"Manually smoothes the image while preserving edge slopes using a Minimum Filter");
			description
					.put(SKELETONIZE,
							"Thins an image portion that must have been binarized before");
			description.put(MOVE_NODE,
					"Allows the user to modify either a node or a branch");
			description.put(DRAW_BRANCH,
					"Allows the user to drag a branch between two nodes");
			description
					.put(EXTRACT_AREA,
							"Whitens anything but the flooded image foreground (i.e. the blue pixels)");
			description
					.put(FIND_NODES,
							"Tries to detect the inner and outer nodes of the tree depicted.");
			description.put(FIND_BRANCHES,
					"Tries to detect the branches of the tree depicted.");
			description
					.put(REMOVE_OBJECT,
							"Lets the user remove a node or a branch from the topology");
			description.put(CLEAR_IMAGE, "Whitens the whole image");
			description.put(FLOOD_FILL, "");
			description
					.put(BRANCH_LENGTH,
							"Lets the user first click on a branch and then type in its length");
			description
					.put(NAME_TAXON,
							"Lets the user first click on an outer node and then type in its name");
			description
					.put(
							AS_REFERENCE_NODE,
							"Lets the user click on a node in order to designate it as the root of the tree");
			description
					.put(
							SCALE_BAR_LENGTH,
							"Takes the length of the line selection as the unit to which all lengths in the tree refer");
			description
					.put(SCALE2X, "Scales the entire image by a factor of 2");
			description.put(SCALE05X,
					"Scales the entire image by a factor of 0.5");
			description
					.put(GREYSCALE_CONVERSION,
							"Converts the colors of an image portion to greyscale using a parameter dialog");
			description.put(HISTOGRAM_STRETCH,
					"Performs a histogram stretch on a greyscale image");
			description
					.put(
							PIPETTE,
							"Uses the color beneath the mouse cursor as the color used in the FILL operation");
			description
					.put(
							FILL,
							"Fills the area beneath the mouse cursor with the fill color determined by the PIPETTE operation");
			description.put(GLOBAL_COLORCHANGE,
					"This operation is used by the color fill dialog.");
			description
					.put(
							COLOR_QUANTIZATION,
							"Reduces the number of colors used in the entire image. Its outcome is not always intuitive.");
			description
					.put(GRAB_MOTIF,
							"Lets the user grab an image portion as a motif used by the STENCIL operation");
			description
					.put(
							STENCIL,
							"Prints the motif determined by the STENCIL operation at the mouse location within the image");
		}
	}

	// Constructs an activity that is built from its id and the image area
	// that is manipulated by the activity
	public Activity(int activityId, Rectangle2D rect, String filename) {
		this.id = activityId;
		this.manipulatedArea = rect;
		this.filename = filename;
	}

	public Activity(int activityId, Object o) {
		this.id = activityId;
		this.wrappedObj = o;
	}

	public String getFilename() {
		return this.filename;
	};

	public int getId() {
		return this.id;
	};

	public Rectangle2D getManipulatedArea() {
		return this.manipulatedArea;
	};

	public String getDescription() {
		return description.get(id);
	};

	public Object getWrappedObject() {
		return wrappedObj;
	};

	public String toString() {
		String s;
		if (manipulatedArea != null) {
			s = "Activity " + id + " covered area " + manipulatedArea.getX()
					+ ", " + manipulatedArea.getY() + " with width "
					+ manipulatedArea.getWidth() + ", and height "
					+ manipulatedArea.getHeight();
		} else {
			s = "Activity " + id + " stored object " + wrappedObj;
		}
		return s;
	}
}
