/*
    TreeSnatcher Plus - A Phylogenetic Tree Capturing Tool
    Copyright (C) 2010 Thomas Laubach

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.UIManager;
import TreeSnatcher.Core.MainWindow;
import TreeSnatcher.Utils.ImageLoader;

public class TreeSnatcher {
	private String path = null;
	private BufferedImage srcImage;
	private static TreeSnatcher instance = new TreeSnatcher();

	private TreeSnatcher() {
		// MacOSX specifi stuff
		System.setProperty("apple.laf.useScreenMenuBar", "true");
		System.setProperty("com.apple.mrj.application.apple.menu.about.name",
				"TreeSnatcher Plus");
	}

	public static TreeSnatcher getInstance() {
		return instance;
	}

	private void processArguments(String[] arguments) {
		// If the class is executed from command line, a path to an image file
		// should be provided as parameter
		// If executed by double-clicking its icon, the class displays an empty
		// image
		if (arguments.length > 0) {
			String currentDir = System.getProperty("user.dir");
			this.path = currentDir + File.separator + "TreeSnatcher"
					+ File.separator;
			File inputFile = new File(path + arguments[0]);
			inputFile = inputFile.getAbsoluteFile();
			if (inputFile.exists()) {
				srcImage = ImageLoader.getImage(path + arguments[0]);
			} else {
				inputFile = null;
				// File or directory does not exist
				System.err
						.println("\nArgument must be a path to an image file, or the file does not exist");
				System.exit(1);
			}
		}
	}

	private void showMainWindow() {
		MainWindow mainView = new MainWindow(srcImage, path);
		mainView.setVisible(true);
	}

	public static void main(String[] args) {
		// Get a singleton of the TreeSnatcher class
		final TreeSnatcher ts = TreeSnatcher.getInstance();

		if (ts != null) {
			// Process the command line argument(s), if any
			ts.processArguments(args);
			// Let the application's main window take over control
			javax.swing.SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					Font font = new Font("SansSerif", Font.PLAIN, 12);
					UIManager.put("RadioButton.font", font);
					UIManager.put("Label.font", font);
					ts.showMainWindow();
				}
			});
		}
	}

}
