/*
 * Score.cpp
 *
 *  Created on: Jul 5, 2011
 *      Author: fritz
 */

#include "SWCPU.h"

int SWCPUCor::CalcScores_SW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results) {


	char const * ref1 = refSeqList[0];
	char const * rea1 = qrySeqList[0];

	short curr_max=0;//[step_count];
	memset(local_mat_line, 0, mem_matrix * sizeof(short));


	for (int i = 0; i <read_length;i++){// read_length; i++) {
		short left_cell =0;
		for (int j = 0; j < corr_length-1; j++) {
			local_mat_line[j]+= scores[trans[(*rea1)]][trans[ref1[j]]];
			left_cell = max(left_cell + gap_read, 0);
			left_cell = max(left_cell, local_mat_line[j]);
			short k = local_mat_line[j+1] + gap_ref;
			left_cell = max(left_cell, k);
			curr_max = max(curr_max, left_cell);
			local_mat_line[j] = left_cell;

		}
		ref1++;
		rea1++;
	}

	results[0] = (float)curr_max;

	return batchSize;

}

int SWCPUCor::CalcScores_NW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results) {


	char const * ref1 = refSeqList[0];
	char const * rea1 = qrySeqList[0];

//	short curr_max=0;//[step_count];
	memset(local_mat_line, 0, mem_matrix * sizeof(short));
	local_mat_line[corr_length-1]=short_min-gap_read;

	for (int i = 0; i <read_length;i++){// read_length; i++) {
		short left_cell =short_min-gap_ref;

		for (int j = 0; j < corr_length-1; j++) {
			local_mat_line[j]+= scores[trans[(*rea1)]][trans[ref1[j]]];
			left_cell = max(left_cell + gap_read, 0);
			left_cell = max(left_cell, local_mat_line[j]);
			short k = local_mat_line[j+1] + gap_ref;
			left_cell = max(left_cell, k);

			local_mat_line[j] = left_cell;

		}
		ref1++;
		rea1++;
	}

	results[0]=short_min;
	for(int i=0;i<corr_length-1;i++){
		if(local_mat_line[i]>results[0]){
			results[0]=local_mat_line[i];
		}
	}


	return batchSize;
}

void SWCPUCor::SW_Score( char const * refSeqList,  char const * qrySeqList, short *& result) {

	memset(local_mat_line,0,corr_length*sizeof(short));
	char const * scaff = refSeqList;
	char const * read = qrySeqList;

	//Init matrix lines
	char * matrix_pointer  = mat_pointer;

	//Init matrix lines
	for (short i = 0; i < corr_length; ++i) {
		local_mat_line[i] = 0;
		matrix_pointer[i] = CIGAR_STOP;
	}
	matrix_pointer[corr_length] = CIGAR_STOP;

	short curr_max = -1;
	short read_index = 0;

	for (char read_char_cache; (read_char_cache = *read) != line_end; ++read) {
		char read_char_cache = *read;
		matrix_pointer += (corr_length + 1) ;
		short left_cell = 0;
		matrix_pointer[0] = CIGAR_STOP;
		for (short ref_index = 0; ref_index < corr_length - 1; ++ref_index) {

			//init values
			left_cell += gap_ref;
			short diag_cell = local_mat_line[ref_index];

			int pointer = CIGAR_X;
			if (read_char_cache == scaff[ref_index]) {

				diag_cell += mat;

				pointer = CIGAR_EQ;
			} else if (read_char_cache != 'N' && read_char_cache != line_end) {
				diag_cell += mis;
			}



			short up_cell = local_mat_line[ref_index + 1] + gap_read;

			//find max
			short max_cell = 0;
			max_cell = max(left_cell, max_cell);
			max_cell = max(diag_cell, max_cell);
			max_cell = max(up_cell, max_cell);


			if (max_cell == up_cell && max_cell != (local_mat_line[ref_index] + mis)) {
				//pointer = 2;
				pointer = CIGAR_I;
			} else if (max_cell == left_cell && max_cell != (local_mat_line[ref_index] + mis)) {
				//pointer = 1;
				pointer = CIGAR_D;
			} else if (max_cell > 0 && (max_cell == diag_cell ||
					(max_cell == local_mat_line[ref_index] + mis || max_cell == local_mat_line[ref_index] + mat))) {
				//pointer = 4;
			} else {
				pointer = CIGAR_STOP;
			}

			matrix_pointer[(ref_index + 1)] = pointer;


			if (max_cell > curr_max) {
				curr_max = max_cell;
				result[1] = ref_index;
				result[0] = read_index;
				result[3]=curr_max;

			}
			left_cell = max_cell;
			local_mat_line[ref_index] = max_cell;
		}
		matrix_pointer[corr_length] = CIGAR_STOP;
		scaff ++;
		read_index += 1;
	}
	result[2] = (read_index - result[0] )- 1;
	if (read_index == 0) {
		result[0] = result[1] =2;
	}
}



void SWCPUCor::NW_Score( char const * scaff,  char const * read, short *& result) {
	memset(local_mat_line,0,corr_length*sizeof(short));
	char * matrix_pointer  = mat_pointer;
	//Init mat_pointer lines
	for (short i = 0; i < corr_length; ++i) {
		local_mat_line[i] = 0;
		matrix_pointer[i] = CIGAR_STOP;
	}
	matrix_pointer[corr_length] = CIGAR_STOP;

	local_mat_line[(corr_length-1)] = short_min-gap_read;


	short read_index = 0;

	for (char read_char_cache; (read_char_cache = *read) != line_end; ++read) {
		matrix_pointer += (corr_length + 1) ;
		short left_cell = short_min-gap_ref;
		matrix_pointer[0] = CIGAR_STOP;
		for (short ref_index = 0; ref_index < corr_length - 1; ++ref_index) {

			//init values
			left_cell += gap_ref;
			short diag_cell = local_mat_line[ref_index];

			int pointer = CIGAR_X;
			if (read_char_cache == scaff[ref_index]) {

				diag_cell += mat;

				pointer = CIGAR_EQ;
			} else if (read_char_cache != 'N' && read_char_cache != line_end) {
				diag_cell += mis;
			}

			short up_cell = local_mat_line[ref_index + 1] + gap_read;

			//find max
			short max_cell = 0;
			max_cell = max(left_cell, max_cell);
			max_cell = max(diag_cell, max_cell);
			max_cell = max(up_cell, max_cell);


			if (max_cell == up_cell && max_cell != (local_mat_line[ref_index] + mis)) {
				pointer = CIGAR_I;
			} else if (max_cell == left_cell && max_cell != (local_mat_line[ref_index] + mis)) {
				pointer = CIGAR_D;
			} else if (max_cell == diag_cell ||
					(max_cell == local_mat_line[ref_index] + mis || max_cell == local_mat_line[ref_index] + mat)) {
			} else {
				pointer = CIGAR_STOP;
			}

			matrix_pointer[(ref_index + 1)] = pointer;
			left_cell = max_cell;
			local_mat_line[ref_index] = max_cell;
		}
		matrix_pointer[corr_length] = CIGAR_STOP;
		scaff ++;
		read_index += 1;

	}
	result[3]=short_min;
	result[0] = read_index-1;
	for(int i=0;i<corr_length;i++){
		if(local_mat_line[i]>result[3]){
			result[3]=local_mat_line[i];
			result[1]=i;
		}
	}

	result[2] = read_index - result[0] - 1;
	if (read_index == 0) {
		result[0] = result[1] =2;
	}
}

