/*
 * SWCPU.h
 *
 *  Created on: Jun 15, 2011
 *      Author: fritz
 */

#ifndef SWCPU_H_
#define SWCPU_H_
/*
 * SWCuda.h
 *
 *  Created on: Jan 10, 2011
 *      Author: fritz
 */


#undef module_name
#define module_name "CPUFullKernel"
#define pRef pBuffer1
#define pQry pBuffer2

#include "IAlignment.h"
#include "ILog.h"
#include "IConfig.h"

#include <iostream>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "NGMSSE.h"

using std::endl;
using std::cout;
using std::max;
struct cudaDeviceProp;

#define CIGAR_STOP 10
#define short_min -16000
#define result_number 4
#define line_end '\0'
#define ref_position 0
#define qstart 1
#define qend 2
#define alignment_offset 3
#define param_best_read_index 0
#define param_best_ref_index 1


#define CIGAR_M 0
#define CIGAR_I 1
#define CIGAR_D 2
#define CIGAR_N 3
#define CIGAR_S 4
#define CIGAR_H 5
#define CIGAR_P 6
#define CIGAR_EQ 7
#define CIGAR_X 8

const char trans[256] = {
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 0, 4, 1, 4, 4, 4, 2, 4, 4, 4, 4, 4, 4, 5, 4,
		4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 0, 4, 1, 4, 4, 4, 2, 4, 4, 4, 4, 4, 4, 5, 4,
		4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
	};

class SWCPUCor: public IAlignment {
public:
	SWCPUCor(int gpu_id);
	~SWCPUCor();
	int GetScoreBatchSize();
	int GetAlignBatchSize();
	int BatchScore(int const mode, int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results,void * extData);
	int BatchAlign(int const mode, int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * const results,void * extData);

private:

	SSEAligner * sse;

	bool cigar;
	short scores[6][6];
	bool type;
	short mat;
	short mis;
	short gap_read;
	short gap_ref;
	//meta info
	unsigned int batch_size; //effictive thread number that is started per call


	int alignment_length;
	int read_length; //Read Size
	int corr_length;//Corridor Size
	int ref_length; //Reference Size

//	int* matrix;
	short * result;
	char * mat_pointer;
	short* local_mat_line;


	long mem_matrix;

	void Allocate();

	void FreeMem();

	unsigned int calc_batchsize(long mem_per_thread);
	//  Other:

	void SetForScoreing();
	void SetForBacktracking();

	int CalcScores_SW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results);
	int CalcScores_NW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results);

	void computeCigarMD(Align & result, int const gpuCigarOffset, short const * const gpuCigar, char const * const refSeq);
	void SW_Score( char const * scaff,  char const * read, short *& result);
	void Backtracking_CIGAR(char const * scaff, char const * read, short *& result, short *& alignments);
	void Backtracking( char const * scaff, char const * read,  short *& result,char *& alignments);

	void NW_Score( char const * scaff,  char const * read, short *& result);
	void NWBacktracking( char const * scaff, char const * read,  short *& result,char *& alignments) ;
	int Calc_Alignment_SW_cigar(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results);
	int Calc_Alignment_SW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results);
	int Calc_Alignment_NW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results);
	int Calc_Alignment_NW_cigar(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results);

};


#endif /* SWCPU_H_ */
