/*
 * SWCPU.cpp
 *
 *  Created on: Jun 15, 2011
 *      Author: fritz
 */

#include "SWCPU.h"

// Logging:
ILog * _log = 0;

#ifdef _WIN32
#define dllexport  __declspec(dllexport)
#else
#define dllexport
#endif

extern "C" dllexport int Cookie() {
	return 0x10201130;
}

extern "C" dllexport void SetLog(ILog * log) {
	_log = log;
}

IConfig * _config = 0;
extern "C" dllexport void SetConfig(IConfig * config) {
	_config = config;
}

extern "C" dllexport IAlignment * CreateAlignment(int const gpu_id) {
	return new SWCPUCor(gpu_id);
}

extern "C" dllexport void ExternalDeleteString(char* mem) {
	delete[] mem;
}

extern "C" dllexport void DeleteAlignment(SWCPUCor* instance) {
	delete instance;
}

void SWCPUCor::Allocate() {
	local_mat_line = new short[corr_length];
}

void SWCPUCor::FreeMem() {
	if (!type) {
		delete[] mat_pointer;
		delete[] result;
	}
	delete[] local_mat_line;
}

SWCPUCor::SWCPUCor(int gpu_id) {

	sse = new SSEAligner();

	read_length = Config.GetInt("qry_max_len"); //Read Size
	corr_length = Config.GetInt("corridor") + 1;//Corridor Size
	ref_length = read_length + corr_length; //Reference Size

	cigar = bool(((gpu_id >> 8) & 0xFF) == 1);

	batch_size = 4096;

	mat = Config.GetFloat("score_match");
	mis = Config.GetFloat("score_mismatch");
	gap_read = Config.GetFloat("score_gap_read");
	gap_ref = Config.GetFloat("score_gap_ref");

	type = true;
	short temp[6][6] = { mat, mis, mis, mis, 0, mis, mis, mat, mis, mis, 0,
			mis, mis, mis, mat, mis, 0, mis, mis, mis, mis, mat, 0, mis, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, mat };

	memcpy(scores, temp, 6 * 6 * sizeof(short));
	alignment_length = (corr_length + read_length + 1);

	SetForScoreing();
}

SWCPUCor::~SWCPUCor() {
	FreeMem();
}

//SETTER:


void SWCPUCor::SetForScoreing() {
	if (!type) {
		FreeMem();
	}
	mem_matrix = corr_length;
	type = true;

	Allocate();
}

void SWCPUCor::SetForBacktracking() {

	if (type) {
		FreeMem();
	}
	type = false;

	mem_matrix = (Config.GetInt("corridor") + 2)
			* (Config.GetInt("qry_max_len") + 1);
	result = new short[result_number];
	mat_pointer = new char[mem_matrix];

	Allocate();
}

//====================== Backtracking ============================


int SWCPUCor::Calc_Alignment_SW(int const batchSize,
		char const * const * const refSeqList,
		char const * const * const qrySeqList, Align * results) {

	char * alignments = new char[alignment_length * 2];
	for(int i = 0; i < batchSize; ++i) {

		memset(mat_pointer, CIGAR_STOP, mem_matrix * sizeof(char));

		SW_Score(refSeqList[i], qrySeqList[i], result);


		memset(alignments, '\0', alignment_length * 2 * sizeof(char));
		Backtracking(refSeqList[i], qrySeqList[i], result, alignments);

		float total = 0.0f;
		float match = 0.0f;
		char * read = results[i].pQry;
		char * ref = results[i].pRef;

		int index = 0;
		for (int t = result[3] + 1; t < alignment_length; ++t) {
			ref[index] = alignments[t];
			read[index] = alignments[t + alignment_length];

			if (read[index] != ' ' && read[index] != '-') {
				total++;
			}
			if (read[index] != ' ' && read[index] == ref[index]) {
				match++;
			}
			index += 1;
		}

		results[i].PositionOffset = result[0];
		results[i].QStart = result[1];
		results[i].QEnd = result[2];
		results[i].Identity = match / total;
	}
	delete[] alignments;
	return batchSize;
}

int SWCPUCor::Calc_Alignment_NW(int const batchSize,
		char const * const * const refSeqList,
		char const * const * const qrySeqList, Align * results) {

	cout << "NW align" << endl;
	memset(mat_pointer, CIGAR_STOP, mem_matrix * sizeof(char));

	NW_Score(refSeqList[0], qrySeqList[0], result);

	char * alignments = new char[alignment_length * 2];
	NWBacktracking(refSeqList[0], qrySeqList[0], result, alignments);

	float total = 0.0f;
	float match = 0.0f;
	char * read = results[0].pQry;
	char * ref = results[0].pRef;

	int index = 0;
	for (int t = result[3] + 1; t < alignment_length; ++t) {
		ref[index] = alignments[t];
		read[index] = alignments[t + alignment_length];

		if (read[index] != ' ' && read[index] != '-') {
			total++;
		}
		if (read[index] != ' ' && read[index] == ref[index]) {
			match++;
		}
		index += 1;
	}

	results[0].PositionOffset = result[0];
	results[0].QStart = result[1];
	results[0].QEnd = result[2];
	results[0].Identity = match / total;

	delete[] alignments;
	return batchSize;
}

int SWCPUCor::GetScoreBatchSize() {
	return sse->GetScoreBatchSize();
}
int SWCPUCor::GetAlignBatchSize() {
	return batch_size;
}

int SWCPUCor::BatchAlign(int const mode, int const batchSize,
		char const * const * const refSeqList,
		char const * const * const qrySeqList, Align * const results,
		void * extData) {
	if (batchSize <= 0) {
		Log.Warning("Align for batchSize <= 0");
		return 0;
	}

	if (type) {
		SetForBacktracking();
	}

	switch (mode & 0xFF) {
	case 0:
		return Calc_Alignment_SW(batchSize, refSeqList, qrySeqList, results);
	case 1:
		//return CalcScores_NW(batchSize, refSeqList, qrySeqList, results);
	default:
		Log.Error("Unsupported alignment mode %i", mode);
		return 0;
	}
}

int SWCPUCor::BatchScore(int const mode, int const batchSize,
		char const * const * const refSeqList,
		char const * const * const qrySeqList, float * const results,
		void * extData) {
	if (batchSize <= 0) {
		Log.Warning("Score for batchSize <= 0");
		return 0;
	}

	if (!type) {
		SetForScoreing();
	}
	switch (mode & 0xFF) {
	case 0:
		//return CalcScores_SW(batchSize, refSeqList, qrySeqList, results);
		return sse->BatchScore(mode, batchSize, refSeqList, qrySeqList,
				results, 0);
	case 1:
		return CalcScores_NW(batchSize, refSeqList, qrySeqList, results);
	default:
		Log.Error("Unsupported alignment mode %i", mode & 0xFF);
		return 0;
	}
}

