/*
 * Alignment.cpp
 *
 *  Created on: Jul 5, 2011
 *      Author: fritz
 */

#include "SWCPU.h"
void SWCPUCor::Backtracking( char const * scaff, char const * read,  short *& result,char *& alignments) {

	char * matrix_pointer= mat_pointer;
	//Index index;
	short best_read_index = result[0];
	short best_ref_index = result[1];
	if (best_read_index > 0) {
		matrix_pointer += (((corr_length + 1) * (best_read_index + 1)));

		short abs_ref_index = best_ref_index + best_read_index;
		short alignment_index =alignment_length - 2;

		alignments[alignment_length-1] = '\0';
		alignments[alignment_length-1 + alignment_length] = '\0';

		int pointer = CIGAR_STOP;
		while ((pointer = matrix_pointer[(best_ref_index + 1)]) != CIGAR_STOP) {
			if (pointer == CIGAR_X || pointer == CIGAR_EQ) {
				alignments[alignment_index] = scaff[abs_ref_index--];
				alignments[alignment_index + alignment_length] = read[best_read_index];
				matrix_pointer -= ((corr_length + 1));
				best_read_index -= 1;
			} else if (pointer == CIGAR_I) {
				alignments[alignment_index] = '-';
				alignments[alignment_index + alignment_length] = read[best_read_index];
				matrix_pointer -= ((corr_length + 1));
				best_read_index -= 1;
				best_ref_index += 1;
			} else{
				alignments[alignment_index] = scaff[abs_ref_index--];
				alignments[alignment_index + alignment_length] = '-';
				best_ref_index -= 1;
			}
			alignment_index -= 1;
		}
		result[0] = abs_ref_index + 1;
		result[1] = best_read_index + 1;
		result[3] = alignment_index;
	}

}


void SWCPUCor::NWBacktracking( char const * scaff, char const * read,  short *& result,char *& alignments) {

	char * matrix_pointer= mat_pointer;
	//Index index;
	short best_read_index = result[0];
	short best_ref_index = result[1];
	if (best_read_index > 0) {
		matrix_pointer += (((corr_length + 1) * (best_read_index + 1)));

		short abs_ref_index = best_ref_index + best_read_index;
		short alignment_index =alignment_length - 2;

		alignments[alignment_length-1] = '\0';
		alignments[alignment_length-1 + alignment_length] = '\0';

		int pointer = CIGAR_STOP;
		while ((pointer =  matrix_pointer[best_ref_index + best_read_index*ref_length]) != CIGAR_STOP ||( best_ref_index>=0 && best_read_index>=0)) {

			if (pointer == CIGAR_X || pointer == CIGAR_EQ) {
				alignments[alignment_index] = scaff[abs_ref_index--];
				alignments[alignment_index + alignment_length] = read[best_read_index];
				matrix_pointer -= ((corr_length + 1));
				best_read_index -= 1;
			} else if (pointer == CIGAR_I) {
				alignments[alignment_index] = '-';
				alignments[alignment_index + alignment_length] = read[best_read_index];
				matrix_pointer -= ((corr_length + 1));
				best_read_index -= 1;
				best_ref_index += 1;
			} else{
				alignments[alignment_index] = scaff[abs_ref_index--];
				alignments[alignment_index + alignment_length] = '-';
				best_ref_index -= 1;
			}
			alignment_index -= 1;
		}
		result[0] = abs_ref_index + 1;
		result[1] = best_read_index + 1;
		result[3] = alignment_index;
	}

}

