/*
 * Log.cpp
 *
 *  Created on: Mar 31, 2011
 *      Author: philipp_
 */
#include <stdio.h>
#include <stdarg.h>

#include "SimpleLog.h"

void LogToConsole(int lvl, char const * const title, char const * const s, va_list args)
	{
		if (title != 0)
		{
			printf("[%s] ", title);
		}

		if (args != 0)
			vprintf(s, args);
		else
			printf("%s", s);

		printf("\n");
	}

void SimpleLog::_Message(int lvl, char const * const title, char const * const s,
		...) const {
	va_list args;
	va_start(args, s);
	LogToConsole(lvl, title, s, args);
	va_end(args);
}

