/*
 * SimpleConfig.h
 *
 *  Created on: Mar 31, 2011
 *      Author: philipp_
 */

#ifndef SIMPLECONFIG_H_
#define SIMPLECONFIG_H_

#include "IConfig.h"

enum DEVICE_TYPE {
	GPU = 0, CPU = 1
};

class SimpleConfig: public IConfig {

public:
	float gap_read;
	float gap_ref;
	float match;
	float mismatch;

	int corridor;
	int read_size;
	//int ref_size;
	int cores;
	//DEVICE_TYPE device;

	char const * GetString(char const * const name) const;
	int GetInt(char const * const name) const;
	int GetInt(char const * const name, int min, int max) const;
	int GetParameter(char const * const name) const;
	float GetFloat(char const * const name) const;
	float GetFloat(char const * const name, float min, float max) const;

	int GetIntArray(char const * const name, int * pData, int len) const;
	int GetFloatArray(char const * const name, float * pData, int len) const;
	int GetDoubleArray(char const * const name, double * pData, int len) const;

	bool Exists(char const * const name) const;
	bool HasArray(char const * const name) const;

	SimpleConfig() {
		gap_read = -7;
		gap_ref = -7;
		match = 4;
		mismatch = -2;

		corridor = 10;
		read_size = 72;
		cores = 1;
	}

};

#undef Config

#endif /* SIMPLECONFIG_H_ */
