/*
 * extern.cpp
 *
 *  Created on: Jul 28, 2011
 *      Author: fritz
 */

#include "SwAlignment.cu"
#include "Cigar.cu"
#include "SWCuda.h"

#include "BS_mapping.h"


// Logging:
ILog * _log = 0;

#ifdef _WIN32
#define dllexport  __declspec(dllexport)
#else
#define dllexport
#endif

extern "C" dllexport int Cookie() {
	return 0x10201011;
}

extern "C" dllexport void SetLog(ILog * log) {
	_log = log;
}

IConfig * _config = 0;
extern "C" dllexport void SetConfig(IConfig * config) {
	_config = config;
}

extern "C" dllexport IAlignment * CreateAlignment(int const mode) {

	if(mode & 0x10000){
		return new BSCuda(mode);
	}else{
		return new SWCuda(mode);
	}
}

extern "C" dllexport void ExternalDeleteString(char* mem) {
	delete[] mem;
}

extern "C" dllexport void DeleteAlignment(Alignment* instance) {

	 instance->thread_exit();
}
