/*
 * SWCuda.h
 *
 *  Created on: Jan 10, 2011
 *      Author: fritz
 */


#undef module_name
#define module_name "CUDAKernel"

#ifndef KERNEL_H_
#define KERNEL_H_

#define pRef pBuffer1
#define pQry pBuffer2

#include "Aligment.cuh"



//#include "Timer.h"
using std::endl;
using std::cout;
struct cudaDeviceProp;

class SWCuda: public Alignment {
public:
	SWCuda(int gpu_id);
	virtual ~SWCuda();
	int GetScoreBatchSize();
	int GetAlignBatchSize();
	int BatchScore(int const mode, int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results,void * extData);
	int BatchAlign(int const mode, int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * const results,void * extData);
	void changeScoringMat(char * name);
	void threadExit();
private:
	//cpu variables

	void Allocate_Scoring();
	void Allocate_Alginment();
	void Set_Meme_Scoring();
	void Set_Meme_Alginment();


	void FreeMem();

	void SetMemResult(int number);

//	//  Other:
//
	void SetForScoreing();
	void SetForBacktracking();

	int CalcScores_SW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results);
	int CalcScores_NW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results);

	int Calc_Alignment_SW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results);
	int Calc_Alignment_SW_cigar(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results);

	int Calc_Alignment_NW_cigar(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results);
	int Calc_Alignment_NW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results);

	void computeCigarMD(Align & result, int const gpuCigarOffset, short const * const gpuCigar, char const * const refSeq);
	void process_alignment( Align *& results,int number,int alignmenlength);
};

#endif /* KERNEL_H_ */
