///*
// * BS_mapping.h
// *
// *  Created on: Jul 26, 2011
// *      Author: fritz
// */

#ifndef BS_MAPPING_H_
#define BS_MAPPING_H_

#define pRef pBuffer1
#define pQry pBuffer2

#include "Aligment.cuh"

//#include "Timer.h"
using std::endl;
using std::cout;
struct cudaDeviceProp;

class BSCuda: public Alignment {

public:
	BSCuda(int gpu_id);
	virtual ~BSCuda();
	int GetScoreBatchSize();
	int GetAlignBatchSize();
	int BatchScore(int const mode, int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results,void * extData);
	int BatchAlign(int const mode, int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * const results,void * extData);
	void changeScoringMat(char * name);
	void threadExit();
private:

	long mem_ext;

	cudaArray* cu_array;
	char * ext_gpu;

	void Allocate_Scoring();
	void Allocate_Alginment();
	void Set_Meme_Scoring();
	void Set_Meme_Alginment();
	void FreeMem();
	void SetMemResult(int number);

//	//  Other:
//
	void SetForScoreing();
	void SetForBacktracking();

	int CalcScores_SW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results,char * extData);
	int CalcScores_NW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, float * const results,char * extData);

	int Calc_Alignment_SW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results,char * extData);
	int Calc_Alignment_SW_cigar(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results,char * extData);

	int Calc_Alignment_NW_cigar(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results,char * extData);
	int Calc_Alignment_NW(int const batchSize, char const * const * const refSeqList, char const * const * const qrySeqList, Align * results,char * extData);

	void computeCigarMD(Align & result, int const gpuCigarOffset, short const * const gpuCigar, char const * const refSeq);
	void process_alignment( Align *& results,int number,int alignmenlength);
};


#endif /* BS_MAPPING_H_ */
