/*
 * Alingment.h
 *
 *  Created on: Jul 28, 2011
 *      Author: fritz
 */

#ifndef ALINGMENT_H_
#define ALINGMENT_H_

#define short_min -16000
#define result_number 4
#define line_end '\0'
#define ref_position 0
#define qstart 1
#define qend 2
#define alignment_offset 3
#define param_best_read_index 0
#define param_best_ref_index 1


#define CIGAR_M 0
#define CIGAR_I 1
#define CIGAR_D 2
#define CIGAR_N 3
#define CIGAR_S 4
#define CIGAR_H 5
#define CIGAR_P 6
#define CIGAR_EQ 7
#define CIGAR_X 8
#define CIGAR_STOP 10






#include "IAlignment.h"
#include "ILog.h"
#include "IConfig.h"
#include <iostream>

#define pRef pBuffer1
#define pQry pBuffer2

//#include "Defines.cuh"

class Alignment: public IAlignment {

protected:

	cudaStream_t stream[2];

	bool type; //true == score false == backtracking
	bool cigar; //true == cigar false == normal backtracking;

	short read_length;
	short ref_length;
	short corridor_length;
	short alignment_length;

	//meta info
	int score_batch_size;
	int align_batch_size;
	int block_size_align;
	int block_size_score;


	unsigned int step_count;
	int batch_size; //effictive thread number that is started per call
	unsigned int threads; // number of threads per block
	unsigned int blocks; //number of blocks per Execution dependend on the memory requirements and the GPU
	unsigned int shared_mem; // dependend on the kernel


	//copies of data on the CPU

	char * scaff_cpu;
	char * reads_cpu;

	//needed for backtracking:
	short * results_cigar_cpu;
	char * results_Alignment_cpu;
	short * pos_cpu;

	long mem_reads;
	long mem_scaff;
	long mem_result;
	long mem_matrix;
	long mem_parameters;
	long mem_scores;
	//needed for backtracking:
	long mem_pos;
	long mem_result_cigar;

	//gpu variables
	char * scaff_dest_gpu;
	char * scaffold_gpu; // all references
	char * reads_gpu; //all reads
	char * matrix_gpu; // matrix that is needed
	float * results_gpu; //resulting scores
	char * results_Alignment_gpu;
	short * results_cigar_gpu;
	short * pos_gpu;

	cudaDeviceProp * deviceProp;

//	void CopytoDeviceAsync(cudaStream_t streams);
	void copy(char const * const * const refs, int const alignment_number);
	//gpu functions
	void checkCUDAError(const char *msg);

	void CopyfromDevice(float * results,int number);
	void CopyfromDevice_Alignemt();

	int cudaDevCount();
	void computeCigarMD(Align & result, int const gpuCigarOffset, short const * const gpuCigar, char const * const refSeq);

	//cpu function:
	void Prepare(char const * const * const sorce,char * dest, int size, int alignment_number);
	int getThreadPerMulti(int id);
	unsigned int calc_batchsize(long mem_per_thread);


public:

	void thread_exit();

	virtual ~Alignment();
	Alignment(int gpu_id);
	virtual int GetScoreBatchSize() = 0;
	virtual int GetAlignBatchSize() = 0;

	virtual int BatchScore(
		int const mode,
		int const batchSize,
		char const * const * const refSeqList,
		char const * const * const qrySeqList,
		float * const results,
		void * extData) = 0;

	virtual int BatchAlign(
		int const mode,
		int const batchSize,
		char const * const * const refSeqList,
		char const * const * const qrySeqList,
		Align * const results,
		void * extData) = 0;

};


#endif /* ALINGMENT_H_ */
