/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.util.io;

import at.cibiv.util.io.ByteArrayUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RandomAccessReader {
    private ByteBuffer buf;
    private FileInputStream fin;
    private FileChannel fc;

    public RandomAccessReader(int maxLength) {
        this.buf = ByteBuffer.allocate(maxLength);
    }

    public void init(File fileName) throws FileNotFoundException {
        this.fin = new FileInputStream(fileName);
        this.fc = this.fin.getChannel();
    }

    public void close() throws IOException {
        this.fin.close();
    }

    public byte[] read(long filePos, int length) throws IOException {
        this.buf.clear();
        if (length < this.buf.capacity()) {
            if (this.fc.read(this.buf, filePos) == -1) {
                throw new IOException("Couldn't read at position " + filePos + ".");
            }
            return ByteArrayUtils.copy(this.buf.array(), 0, length);
        }
        throw new IOException("Length " + length + " exceeds buffer size " + this.buf.capacity() + ".");
    }

    public byte[] adaptivRead(long filePos, int length) throws IOException {
        if (this.buf.capacity() <= length) {
            this.buf = ByteBuffer.allocate(length);
        } else {
            this.buf.clear();
        }
        if (length <= this.buf.capacity()) {
            if (this.fc.read(this.buf, filePos) == -1) {
                throw new IOException("Couldn't read at position " + filePos + ".");
            }
            return ByteArrayUtils.copy(this.buf.array(), 0, length);
        }
        throw new IOException("Length " + length + " exceeds buffer size " + this.buf.capacity() + ".");
    }

    public byte[] readWithoutNewLine(long filePos, int length) throws IOException {
        this.buf.clear();
        if (length < this.buf.capacity()) {
            if (this.fc.read(this.buf, filePos) == -1) {
                throw new IOException("Couldn't read at position " + filePos + ".");
            }
            return ByteArrayUtils.copyWithoutNewLine(this.buf.array(), 0, length);
        }
        throw new IOException("Length " + length + " exceeds buffer size " + this.buf.capacity() + ".");
    }
}

