/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.util.io;

import at.cibiv.util.exceptions.DataConversionException;
import at.cibiv.util.exceptions.DataFormatException;
import at.cibiv.util.exceptions.ParserException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class Parser {
    protected boolean cancled = false;

    public void parse(File fileName, int buffSize) throws IOException {
        try {
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(fileName));
            byte[] cbuf = new byte[buffSize];
            int read = 0;
            int offset = 0;
            int size = buffSize;
            int lastN = 0;
            while ((read += reader.read(cbuf, offset, size)) == buffSize) {
                lastN = this.splitLine(cbuf, read);
                if (lastN != 0) {
                    if (lastN < read) {
                        System.arraycopy(cbuf, lastN, cbuf, 0, read - lastN);
                    }
                    offset = buffSize - lastN;
                    size = buffSize - offset;
                    read = offset;
                    continue;
                }
                throw new DataFormatException("Line too long. Line length must not exceed " + buffSize + ".");
            }
            if (read > 0 && read > (lastN = this.splitLine(cbuf, read))) {
                this.parseLine(cbuf, lastN, read);
            }
            reader.close();
        }
        catch (FileNotFoundException ex) {
            throw new ParserException(ex);
        }
        catch (IOException ex) {
            throw new ParserException(ex);
        }
        catch (NumberFormatException ex) {
            throw new ParserException(ex);
        }
        this.postprocess();
    }

    private int splitLine(byte[] cbuf, int read) throws IOException {
        int lastN = 0;
        int i = 0;
        while (i < read) {
            if (cbuf[i] == 10) {
                this.parseLine(cbuf, lastN, i);
                lastN = i + 1;
            }
            ++i;
        }
        return lastN;
    }

    private void parseFC(File fileName, int buffSize) throws IOException {
        long bpos = 0L;
        int buflen = -1;
        int processed = -1;
        FileInputStream fin = new FileInputStream(fileName);
        FileChannel fc = fin.getChannel();
        ByteBuffer buf = ByteBuffer.allocate(buffSize);
        while ((buflen = fc.read(buf, bpos)) != -1) {
            processed = this.splitLine(buf.array(), buflen);
            if (processed > 0) {
                bpos += (long)processed;
                buf.clear();
                continue;
            }
            this.parseLine(buf.array(), 0, buflen);
            break;
        }
        this.postprocess();
    }

    protected abstract void parseLine(byte[] var1, int var2, int var3) throws IOException;

    protected void postprocess() throws DataConversionException {
    }

    public static enum Direction {
        backward,
        forward;

    }
}

