/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class GenomeMapper {
    private long start = 0L;
    private long position = 0L;
    private long buflen = 0L;
    private long fileLength = -1L;
    private MappedByteBuffer buf = null;
    private FileChannel fc = null;
    private String header = "";
    protected final int MAX_BUF_SIZE;

    public String getHeader() {
        return this.header;
    }

    public GenomeMapper(int buffSize) {
        this.MAX_BUF_SIZE = buffSize;
    }

    public char get(long index) throws Exception {
        if ((index += this.start) >= this.position + this.buflen || index < this.position) {
            throw new Exception("Index " + index + " out of bounds.");
        }
        return (char)this.buf.get((int)(index - this.position));
    }

    public byte[] copy(long index, int length) throws Exception {
        byte[] data = new byte[length];
        int pos = 0;
        int i = 0;
        while (i < length) {
            data[pos++] = (byte)this.get(index + (long)i);
            ++i;
        }
        return data;
    }

    /*
     * Unable to fully structure code
     */
    public void init(File fileName) throws Exception {
        fin = new FileInputStream(fileName);
        this.fc = fin.getChannel();
        this.fileLength = this.fc.size();
        start = 0L;
        ** GOTO lbl10
        {
            this.header = String.valueOf(this.header) + this.get(start);
            ++start;
            do {
                if (start < this.getBuflen() && this.get(start) != '\n') continue block0;
lbl10:
                // 2 sources

            } while (this.mapNext(start) && this.get(start) != '\n');
        }
        this.start = start + 1L;
    }

    public void close() throws IOException {
        this.fc.close();
    }

    public boolean mapNext(long position) throws IOException {
        boolean valid;
        boolean bl = valid = (position += this.start) < this.fileLength;
        if (valid) {
            this.position = position;
            this.buflen = Math.min((long)this.MAX_BUF_SIZE, this.fileLength - position);
            this.buf = this.fc.map(FileChannel.MapMode.READ_ONLY, position, this.buflen);
        }
        return valid;
    }

    public long getBuflen() {
        return this.position + this.buflen - this.start;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public long getStartPosition() {
        return this.position;
    }
}

