/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.util.io;

import java.io.IOException;

public final class ByteString
implements Comparable<ByteString> {
    private byte[] data;
    private int length = 0;

    public int length() {
        return this.length;
    }

    public int capacity() {
        return this.data.length;
    }

    public static ByteString allocate(int size) {
        return new ByteString(size);
    }

    public static ByteString copy(byte[] bytes, int offset, int length) {
        return new ByteString(bytes, offset, length);
    }

    public static ByteString copy(ByteString bs) {
        return new ByteString(bs.getBytes(), 0, bs.length());
    }

    protected ByteString(int length) {
        this.data = new byte[length];
    }

    protected ByteString(byte[] bytes, int offset, int length) {
        this.set(bytes, offset, length);
    }

    public void set(ByteString read) {
        this.set(read.getBytes(), 0, read.length());
    }

    public void set(byte[] array, int offset, int length) {
        this.length = length;
        this.checkLength(length);
        System.arraycopy(array, offset, this.data, 0, length);
    }

    public void append(byte[] array, int offset, int length) {
        this.checkLength(this.length + length);
        System.arraycopy(array, offset, this.data, this.length, length);
        this.length += length;
    }

    public void append(byte b) {
        this.checkLength(this.length + 1);
        this.data[this.length++] = b;
    }

    public void reset() {
        this.length = 0;
    }

    private void checkLength(int length) {
        if (this.data == null || length > this.capacity()) {
            this.data = new byte[length];
        }
    }

    public boolean equals(Object other) {
        ByteString o = (ByteString)other;
        if (this.length != o.length) {
            return false;
        }
        int i = 0;
        int len = this.length;
        while (i < len) {
            if (this.data[i] != o.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void replaceCharAt(int index, byte b) throws IOException {
        if (index >= this.length) {
            throw new IOException("Index (" + index + ") out of bounds. Length: " + this.length);
        }
        this.data[index] = b;
    }

    public void removeCharAt(int index) {
        int i = index;
        while (i < this.length - 1) {
            this.data[i] = this.data[i + 1];
            ++i;
        }
        --this.length;
    }

    public void insertCharAt(int index, byte b) throws IOException {
        if (index >= this.length) {
            throw new IOException("Index (" + index + ") out of bounds. Length: " + this.length);
        }
        this.checkLength(this.length + 1);
        int i = this.length - 1;
        while (i <= index) {
            this.data[i + 1] = this.data[i];
            ++i;
        }
        this.replaceCharAt(index, b);
        ++this.length;
    }

    public byte charAt(int index) throws IOException {
        if (index >= this.length) {
            throw new IOException("Index (" + index + ") out of bounds. Length: " + this.length);
        }
        return this.data[index];
    }

    public void removeChars(int count) {
        int i = 0;
        while (i < this.length - count) {
            this.data[i] = this.data[i + count];
            ++i;
        }
        this.length -= count;
    }

    public void removeCharsReverse(int count) {
        this.length -= count;
    }

    public int hashCode() {
        int h = 31;
        int i = 0;
        while (i < this.length) {
            h ^= (h << 5) + (h >> 2) + this.data[i];
            ++i;
        }
        return h;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public String toString() {
        return new String(this.data, 0, this.length);
    }

    @Override
    public int compareTo(ByteString o) {
        int max = Math.min(this.length, o.length) - 1;
        int i = 0;
        while (this.data[i] == o.data[i]) {
            if (i == max) {
                if (this.length == o.length) {
                    return 0;
                }
                return this.length > o.length ? 1 : -1;
            }
            ++i;
        }
        return this.data[i] - o.data[i];
    }
}

