/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.util.io;

import java.nio.MappedByteBuffer;

public class ByteArrayUtils {
    public static int find(byte[] cbuf, int start, int end, byte[] nameStr) {
        int pos = -1;
        int i = start;
        while (i < end) {
            if (ByteArrayUtils.strncmp(cbuf, i, nameStr)) {
                pos = i + nameStr.length;
                break;
            }
            ++i;
        }
        return pos;
    }

    public static boolean strncmp(byte[] cbuf, int startPos, byte[] toCompare) {
        boolean equal;
        boolean bl = equal = cbuf.length > startPos + toCompare.length;
        if (equal) {
            int i = 0;
            while (i < toCompare.length && (equal = equal && cbuf[i + startPos] == toCompare[i])) {
                ++i;
            }
        }
        return equal;
    }

    public static long atol(byte[] cbuf, int startPos, int endPos) {
        int i = startPos;
        long value = 0L;
        long sign = 1L;
        if (cbuf[i] == 45) {
            ++i;
            sign = -1L;
        }
        while (i < endPos && (char)cbuf[i] >= '0' && (char)cbuf[i] <= '9') {
            value = value * 10L + (long)(cbuf[i] - 48);
            ++i;
        }
        return sign * value;
    }

    public static byte[] copy(byte[] cbuf, int offset, int length) {
        byte[] temp = new byte[length];
        System.arraycopy(cbuf, offset, temp, 0, length);
        return temp;
    }

    public static float atof(byte[] cbuf, int startPos, int endPos) {
        int j = startPos;
        float a = 0.0f;
        int e = 0;
        int c = 0;
        while (j < endPos && ByteArrayUtils.isdigit(c = cbuf[j++])) {
            a = a * 10.0f + (float)(c - 48);
        }
        if (c == 46) {
            while ((c = cbuf[j++]) != 0 && ByteArrayUtils.isdigit(c)) {
                a = a * 10.0f + (float)(c - 48);
                --e;
            }
        }
        if (c == 101 || c == 69) {
            int sign = 1;
            int i = 0;
            if ((c = cbuf[j++]) == 43) {
                c = cbuf[j++];
            } else if (c == 45) {
                c = cbuf[j++];
                sign = -1;
            }
            while (ByteArrayUtils.isdigit(c)) {
                i = i * 10 + (c - 48);
                c = cbuf[j++];
            }
            e += i * sign;
        }
        while (e > 0) {
            a = (float)((double)a * 10.0);
            --e;
        }
        while (e < 0) {
            a = (float)((double)a * 0.1);
            ++e;
        }
        return a;
    }

    public static int atoi(byte[] cbuf, int startPos, int endPos) {
        int i = startPos;
        int value = 0;
        int sign = 1;
        if (cbuf[i] == 45) {
            ++i;
            sign = -1;
        }
        while (i < endPos && (char)cbuf[i] >= '0' && (char)cbuf[i] <= '9') {
            value = value * 10 + (cbuf[i] - 48);
            ++i;
        }
        return sign * value;
    }

    public static boolean isdigit(int c) {
        return (char)c >= '0' && (char)c <= '9';
    }

    public static int findNext(byte[] cbuf, int pos, int end, char c) {
        int i = pos;
        while (i < end) {
            if ((char)cbuf[i] == c) {
                return i;
            }
            ++i;
        }
        return end;
    }

    public static byte[] copyWithoutNewLine(byte[] array, int offset, int length) {
        int nlCount = ByteArrayUtils.count(array, offset, length, '\n');
        byte[] data = new byte[length - (nlCount += ByteArrayUtils.count(array, offset, length, '*'))];
        int pos = 0;
        int i = 0;
        while (i < length) {
            if ((char)array[offset + i] != '\n' && (char)array[offset + i] != '*') {
                data[pos++] = array[offset + i];
            }
            ++i;
        }
        return data;
    }

    public static int count(byte[] array, int offset, int length, char c) {
        int count = 0;
        int i = 0;
        while (i < length) {
            if ((char)array[offset + i] == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int atoi(MappedByteBuffer buf, int startPos, int endPos) {
        int i = startPos;
        int value = 0;
        int sign = 1;
        if (buf.get(i) == 45) {
            ++i;
            sign = -1;
        }
        while (i < endPos && (char)buf.get(i) >= '0' && (char)buf.get(i) <= '9') {
            value = value * 10 + (buf.get(i) - 48);
            ++i;
        }
        return sign * value;
    }
}

