/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class VersionHelper {
    public static String getVersionfinal(Class classe) {
        String version = null;
        String shortClassName = classe.getName().substring(classe.getName().lastIndexOf(".") + 1);
        try {
            ClassLoader cl = classe.getClassLoader();
            String threadContexteClass = classe.getName().replace('.', '/');
            URL url = cl.getResource(String.valueOf(threadContexteClass) + ".class");
            if (url == null) {
                version = "no manifest found.";
            } else {
                String path = url.getPath();
                String jarExt = ".jar";
                int index = path.indexOf(jarExt);
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                if (index != -1) {
                    String jarPath = path.substring(0, index + jarExt.length());
                    JarFile jarFile = new JarFile(new File(new URI(jarPath)));
                    JarEntry entry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
                    version = sdf.format(new Date(entry.getTime()));
                    jarFile.close();
                } else {
                    File file = new File(path);
                    version = sdf.format(new Date(file.lastModified()));
                }
            }
        }
        catch (Exception e) {
            version = String.valueOf(shortClassName) + ": " + e.toString();
        }
        return version;
    }
}

