/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.util;

import at.cibiv.util.exceptions.MissingDataException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyLogger {
    private Properties properties = new Properties();
    private static PropertyLogger propertyLogger;
    private String PROP_REFERENCELENGTH = "referenceLength";
    private String PROP_READNUMBER = "readNumber";
    private String PROP_MUTATIONRATE = "mutationRate";
    private String PROP_READERROR = "readError";
    private String PROP_READERRORMODEL = "readsErrorModel";
    private String PROP_INSERTSIZEMIN = "insertSizeMin";
    private String PROP_INSERTSIZEMAX = "insertSizeMax";
    private String PROP_DENOVOREADSINT = "denovoReadsInt";
    private String PROP_REFMUTSEQ = "refMutSeq";
    private String PROP_REFMUTSEQINT = "refMutSeqInt";
    private String PROP_REFREADS = "refReads";
    private String PROP_REFREADSMATE = "refReadsMate";
    private String PROP_REFREADSINT = "refReadsInt";
    private String PROP_COVERAGE = "coverage";
    private int readErrorModel;
    private long referenceLength;
    private int readNumber;
    private double mutationRate;
    private double readError;
    private int insertSizeMin;
    private int insertSizeMax;
    private String basePath;
    private String denovoReadsInt;
    private String refMutSeq;
    private String refMutSeqInt;
    private String refReads;
    private String refReadsMate = "";
    private String refReadsInt;
    private String coverage;

    private PropertyLogger() {
    }

    public static PropertyLogger getInstance() {
        if (propertyLogger == null) {
            propertyLogger = new PropertyLogger();
        }
        return propertyLogger;
    }

    public void init(String path) {
        this.basePath = path;
    }

    public void logReferenceLength(long referenceLength) {
        this.referenceLength = referenceLength;
    }

    public void logReadNumber(int readNumber) {
        this.readNumber = readNumber;
    }

    public void logInsertSizeMin(int insertSize) {
        this.insertSizeMin = insertSize;
    }

    public void logInsertSizeMax(int insertSize) {
        this.insertSizeMax = insertSize;
    }

    public void logMutationRate(double mutationRate) {
        this.mutationRate = mutationRate;
    }

    public void logReadError(double readError) {
        this.readError = readError;
    }

    public void logReadErrorModel(int readsErrorModel) {
        this.readErrorModel = readsErrorModel;
    }

    public void logDenovoReadsIntPath(File path) {
        this.denovoReadsInt = path.getName();
    }

    public void logRefMutSeqPath(File path) {
        this.refMutSeq = path.getName();
    }

    public void logRefMutSeqIntPath(File path) {
        this.refMutSeqInt = path.getName();
    }

    public void logRefReadsPath(File path) {
        this.refReads = path.getName();
    }

    public void logRefReadsMatePath(File path) {
        this.refReadsMate = path.getName();
    }

    public void logRefReadsIntPath(File path) {
        this.refReadsInt = path.getName();
    }

    public void logCoveragePath(File path) {
        this.coverage = path.getName();
    }

    public void readLog(File fileName) throws MissingDataException, FileNotFoundException {
        this.basePath = String.valueOf(fileName.getParent()) + File.separator;
        BufferedInputStream stream = null;
        this.properties = new Properties();
        stream = new BufferedInputStream(new FileInputStream(fileName));
        try {
            try {
                this.properties.load(stream);
            }
            catch (Exception e) {
                throw new MissingDataException("Log file does not exist.");
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error reading log file.");
            }
        }
    }

    public void writeLog(File logFile) {
        block12: {
            FileOutputStream propOutFile = null;
            try {
                try {
                    propOutFile = new FileOutputStream(logFile);
                    String str = "Log for Super Seth Simulation run with the following parameters:";
                    this.properties.setProperty(this.PROP_MUTATIONRATE, String.valueOf(this.mutationRate));
                    this.properties.setProperty(this.PROP_READERROR, String.valueOf(this.readError));
                    this.properties.setProperty(this.PROP_READNUMBER, String.valueOf(this.readNumber));
                    this.properties.setProperty(this.PROP_REFERENCELENGTH, Long.valueOf(this.referenceLength).toString());
                    this.properties.setProperty(this.PROP_READERRORMODEL, String.valueOf(this.readErrorModel));
                    this.properties.setProperty(this.PROP_INSERTSIZEMIN, String.valueOf(this.insertSizeMin));
                    this.properties.setProperty(this.PROP_INSERTSIZEMAX, String.valueOf(this.insertSizeMax));
                    this.properties.setProperty(this.PROP_DENOVOREADSINT, this.denovoReadsInt);
                    this.properties.setProperty(this.PROP_REFMUTSEQ, this.refMutSeq);
                    this.properties.setProperty(this.PROP_REFMUTSEQINT, this.refMutSeqInt);
                    this.properties.setProperty(this.PROP_REFREADS, this.refReads);
                    this.properties.setProperty(this.PROP_REFREADSMATE, this.refReadsMate);
                    this.properties.setProperty(this.PROP_REFREADSINT, this.refReadsInt);
                    this.properties.setProperty(this.PROP_COVERAGE, this.coverage);
                    this.properties.store(propOutFile, str);
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error writing to log file");
                    if (propOutFile == null) break block12;
                    try {
                        propOutFile.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error writing to log file");
                    }
                }
            }
            finally {
                if (propOutFile != null) {
                    try {
                        propOutFile.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error writing to log file");
                    }
                }
            }
        }
    }

    public long getIndelFlag() {
        long size = this.getReferenceLength();
        return (size + 10L) * -1L;
    }

    public int getReadErrorModel() {
        return Integer.parseInt(this.properties.getProperty(this.PROP_READERRORMODEL));
    }

    public long getReferenceLength() {
        return Long.valueOf(this.properties.getProperty(this.PROP_REFERENCELENGTH));
    }

    public int getReadNumber() {
        return Integer.valueOf(this.properties.getProperty(this.PROP_READNUMBER));
    }

    public int getInsertSizeMin() {
        return Integer.valueOf(this.properties.getProperty(this.PROP_INSERTSIZEMIN));
    }

    public int getInsertSizeMax() {
        return Integer.valueOf(this.properties.getProperty(this.PROP_INSERTSIZEMAX));
    }

    public double getMutationRate() {
        return Double.valueOf(this.properties.getProperty(this.PROP_MUTATIONRATE));
    }

    public double getReadError() {
        return Double.valueOf(this.properties.getProperty(this.PROP_READERROR));
    }

    public String getDenovoReadsIntPath() {
        return String.valueOf(this.basePath) + this.properties.getProperty(this.PROP_DENOVOREADSINT);
    }

    public String getRefMutSeqPath() {
        return String.valueOf(this.basePath) + this.properties.getProperty(this.PROP_REFMUTSEQ);
    }

    public String getRefMutSeqIntPath() {
        return String.valueOf(this.basePath) + this.properties.getProperty(this.PROP_REFMUTSEQINT);
    }

    public String getRefReadsPath() {
        return String.valueOf(this.basePath) + this.properties.getProperty(this.PROP_REFREADS);
    }

    public String getRefReadsMatePath() {
        return String.valueOf(this.basePath) + this.properties.getProperty(this.PROP_REFREADSMATE);
    }

    public String getRefReadsIntPath() {
        return String.valueOf(this.basePath) + this.properties.getProperty(this.PROP_REFREADSINT);
    }

    public String getCoveragePath() {
        return String.valueOf(this.basePath) + this.properties.getProperty(this.PROP_COVERAGE);
    }
}

