/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class EvaluationList<T>
implements Iterable<T> {
    private T[] list;

    public EvaluationList(int count) {
        this.list = new Object[count];
    }

    public void addResult(int id, Mate mate, T object) {
        if (!this.contains(id, mate)) {
            this.set(id, mate, object);
        }
    }

    public boolean contains(int id, Mate mate) {
        return this.get(id, mate) != null;
    }

    public int size() {
        int count = 0;
        int i = 0;
        while (i < this.list.length) {
            if (this.list[i] != null) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int capacity() {
        return this.list.length;
    }

    private void set(int id, Mate mate, T object) {
        this.list[this.computeId((int)id, (Mate)mate)] = object;
    }

    public T get(int id, Mate mate) {
        return this.list[this.computeId(id, mate)];
    }

    private int computeId(int id, Mate mate) {
        int uniqueId = -1;
        switch (mate) {
            case first: {
                uniqueId = id * 2;
                break;
            }
            case second: {
                uniqueId = id * 2 + 1;
                break;
            }
            case no_pairs: {
                uniqueId = id;
            }
        }
        if (uniqueId > this.list.length) {
            throw new IndexOutOfBoundsException("Index " + id + " is out of bounds. Arraylength: " + this.list.length);
        }
        return uniqueId;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<T>(this.list);
    }

    public class ArrayIterator<E>
    implements Iterator<E> {
        private E[] array;
        private int pos = 0;

        public ArrayIterator(E[] anArray) {
            this.array = anArray;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        @Override
        public E next() throws NoSuchElementException {
            if (this.hasNext()) {
                return this.array[this.pos++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Mate {
        first,
        second,
        no_pairs;

    }
}

