/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.super_seth.io;

import at.cibiv.util.io.Parser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.LongBuffer;

public class OutputWriter {
    private File file;
    private BufferedWriter writer = null;
    private final int lineLength = 80;
    private int linePos = 0;
    private boolean format;

    public OutputWriter(File file, boolean format) {
        this.file = file;
        this.format = format;
    }

    public void init() throws IOException {
        this.writer = new BufferedWriter(new FileWriter(this.file));
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(char value) throws IOException {
        this.writer.write(value);
        if (this.format && ++this.linePos == 80) {
            this.linePos = 0;
            this.newLine();
        }
    }

    public void newLine() throws IOException {
        this.writer.newLine();
    }

    public void write(String line) throws IOException {
        this.writer.write(line);
    }

    public void write(long position) throws IOException {
        this.writer.write(Long.toString(position));
        this.writer.write(44);
    }

    public void write(byte[] bytes) throws IOException {
        int i = 0;
        while (i < bytes.length) {
            this.write((char)bytes[i]);
            ++i;
        }
    }

    public void writeReadSeq(CharBuffer readSequence) throws IOException {
        int i = 0;
        while (i < readSequence.position()) {
            this.write(readSequence.get(i));
            ++i;
        }
    }

    public void writeLongSeq(LongBuffer refReadInt, Parser.Direction direction) throws IOException {
        if (direction == Parser.Direction.forward) {
            int i = 0;
            while (i < refReadInt.position()) {
                this.write(refReadInt.get(i));
                ++i;
            }
        } else {
            int i = refReadInt.position() - 1;
            while (i >= 0) {
                this.write(refReadInt.get(i));
                --i;
            }
        }
    }
}

