/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.super_seth.io;

import at.cibiv.util.io.GenomeMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MutatedGenomeMapper
extends GenomeMapper {
    private File posFileName = null;
    private FileChannel posFc = null;
    private long[] posArray = null;
    private long longPosition = 0L;

    public MutatedGenomeMapper(File posFileName, int buffSize) {
        super(buffSize);
        this.posFileName = posFileName;
    }

    @Override
    public void init(File fileName) throws Exception {
        super.init(fileName);
        FileInputStream fin = new FileInputStream(this.posFileName);
        this.posFc = fin.getChannel();
        this.posArray = new long[this.MAX_BUF_SIZE];
    }

    @Override
    public boolean mapNext(long position) throws IOException {
        if (this.posArray != null) {
            this.fillPosArray(position);
        }
        return super.mapNext(position);
    }

    public long getLong(long index) {
        return this.posArray[(int)(index - this.longPosition)];
    }

    private void fillPosArray(long position) throws IOException {
        this.longPosition = position;
        ByteBuffer buf = ByteBuffer.allocate(this.MAX_BUF_SIZE);
        int buflen = -1;
        long bpos = 0L;
        long currentPos = 0L;
        int posArrayIndex = 0;
        while ((buflen = this.posFc.read(buf, bpos)) != -1 && posArrayIndex < this.posArray.length) {
            int longStart = 0;
            int longEnd = 0;
            int i = 0;
            while (i < buflen && posArrayIndex < this.posArray.length) {
                if (buf.get(i) != 10) {
                    if (buf.get(i) == 44) {
                        if (++currentPos > position) {
                            this.posArray[posArrayIndex++] = this.atoi(buf.array(), longStart);
                        }
                        longEnd = longStart = longEnd + 1;
                    } else {
                        ++longEnd;
                    }
                }
                ++i;
            }
            bpos += (long)longStart;
            buf.clear();
        }
    }

    protected long atoi(byte[] cbuf, int startPos) {
        int i = startPos;
        long value = 0L;
        int sign = 1;
        if (cbuf[i] == 45) {
            ++i;
            sign = -1;
        }
        while ((char)cbuf[i] >= '0' && (char)cbuf[i] <= '9') {
            value = value * 10L + (long)(cbuf[i] - 48);
            ++i;
        }
        return (long)sign * value;
    }
}

