/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.super_seth.io;

import at.cibiv.super_seth.util.PropertyReader;
import at.cibiv.util.ComparablePair;
import at.cibiv.util.Pair;
import at.cibiv.util.exceptions.DataConversionException;
import at.cibiv.util.io.ByteArrayUtils;
import at.cibiv.util.io.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilePositionParser
extends Parser {
    private List<ComparablePair<Integer, Pair<Long, Integer>>> readList = new ArrayList<ComparablePair<Integer, Pair<Long, Integer>>>();
    private long filePosition = 0L;
    private int currentId = -1;
    private long currentFilePos = 0L;

    public List<ComparablePair<Integer, Pair<Long, Integer>>> getReadList() {
        return this.readList;
    }

    @Override
    protected void parseLine(byte[] cbuf, int start, int end) throws DataConversionException {
        if ((char)cbuf[start] == '@') {
            int newId = ByteArrayUtils.atoi(cbuf, start + 1, end);
            if (this.currentId >= 0 && (this.currentId != newId - 1 || (double)(this.filePosition - this.currentFilePos) > (double)PropertyReader.getInstance().getMaxBuffSize() * 0.8)) {
                this.readList.add(new ComparablePair<Integer, Pair<Long, Integer>>(this.currentId, new Pair<Long, Integer>(this.currentFilePos, (int)(this.filePosition - this.currentFilePos))));
                this.currentFilePos = this.filePosition;
            }
            this.currentId = newId;
        }
        this.filePosition += (long)(end - start + 1);
    }

    @Override
    protected void postprocess() throws DataConversionException {
        if (this.currentId >= 0) {
            this.readList.add(new ComparablePair<Integer, Pair<Long, Integer>>(this.currentId, new Pair<Long, Integer>(this.currentFilePos, (int)(this.filePosition - this.currentFilePos))));
        }
        Collections.sort(this.readList);
    }
}

