/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.super_seth.data;

import at.cibiv.util.EvaluationList;
import at.cibiv.util.io.Parser;
import java.util.Comparator;

public class ReadPosition
implements Comparable<ReadPosition> {
    private Parser.Direction direction;
    private int id;
    private int length;
    private EvaluationList.Mate mate;
    private long readPosition;
    public static Comparator<ReadPosition> sortById = new Comparator<ReadPosition>(){

        @Override
        public int compare(ReadPosition o1, ReadPosition o2) {
            return o1.getId() - o2.getId();
        }
    };

    public ReadPosition(long readPosition, int length, Parser.Direction direction, EvaluationList.Mate mate) {
        this.readPosition = readPosition;
        this.direction = direction;
        this.length = length;
        this.mate = mate;
    }

    @Override
    public int compareTo(ReadPosition o) {
        return (int)(this.getOrderingPosition() - o.getOrderingPosition());
    }

    public Parser.Direction getDirection() {
        return this.direction;
    }

    public int getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public EvaluationList.Mate getMate() {
        return this.mate;
    }

    public long getOrderingPosition() {
        long pos = this.readPosition;
        if (this.direction == Parser.Direction.forward) {
            pos += (long)this.length;
        }
        return pos;
    }

    public long getReadPosition() {
        return this.readPosition;
    }

    public void setDirection(Parser.Direction direction) {
        this.direction = direction;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setReadPosition(long readPosition) {
        this.readPosition = readPosition;
    }

    public String toString() {
        return "Id: " + this.id + " Position: " + this.readPosition + " Length: " + this.length + " Direction: " + this.direction.toString() + " Endposition: " + this.getOrderingPosition() + " Mate: " + this.mate.toString();
    }
}

