/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.super_seth;

import at.cibiv.super_seth.Mutator;
import at.cibiv.super_seth.data.ReadPosition;
import at.cibiv.super_seth.io.FilePositionParser;
import at.cibiv.super_seth.io.MutatedGenomeMapper;
import at.cibiv.super_seth.io.OutputWriter;
import at.cibiv.super_seth.util.PropertyReader;
import at.cibiv.util.ComparablePair;
import at.cibiv.util.EvaluationList;
import at.cibiv.util.Pair;
import at.cibiv.util.PropertyLogger;
import at.cibiv.util.exceptions.OutputException;
import at.cibiv.util.io.ByteArrayUtils;
import at.cibiv.util.io.GenomeMapper;
import at.cibiv.util.io.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestGenerator {
    private static final int MAX_N_COUNT = 2;
    private Mutator mutator = new Mutator();
    private CharBuffer readSequence = CharBuffer.allocate(1);
    private LongBuffer refReadInt = LongBuffer.allocate(1);
    private LongBuffer denovoReadInt = LongBuffer.allocate(1);
    private int readMismatches = 0;
    private int readIndels = 0;
    private PropertyLogger logger = PropertyLogger.getInstance();
    final boolean allowReverse = false;

    public void generateTest(int readLength, int coverage, File refSeq) throws Exception {
        System.out.println("Mutating reference sequence...");
        File tempMutSeqInt = new File(String.valueOf(this.logger.getRefMutSeqIntPath()) + "_temp");
        long fileLength = this.mutator.getSeqLength(refSeq);
        System.out.println("Sequence length: " + fileLength);
        long insertFlag = (fileLength + 10L) * -1L;
        long genomeLength = -1L;
        Pair<Long, Long> lengthResults = this.mutator.mutateSequenceUniformly(refSeq, new File(this.logger.getRefMutSeqPath()), tempMutSeqInt, fileLength, true);
        if (insertFlag != lengthResults.getFirst()) {
            throw new OutputException("Indel flags corrupt.");
        }
        genomeLength = lengthResults.getSecond();
        System.out.println("Filtering insert positions...");
        this.replaceMutatedRefInsertFlags(new File(this.logger.getRefMutSeqIntPath()), tempMutSeqInt, insertFlag, genomeLength);
        PropertyLogger.getInstance().logReferenceLength(genomeLength);
        System.out.println("Generating reads...");
        int readNumber = this.generateReads(genomeLength, readLength, coverage);
        PropertyLogger.getInstance().logReadNumber(readNumber);
    }

    private int generateReads(long genomeLength, int readLength, int coverage) throws Exception {
        int readCount = 0;
        this.readSequence = CharBuffer.allocate(readLength * 2);
        this.refReadInt = LongBuffer.allocate(readLength * 2);
        this.denovoReadInt = LongBuffer.allocate(readLength * 2);
        File refMutSeq = new File(this.logger.getRefMutSeqPath());
        File refMutSeqInt = new File(this.logger.getRefMutSeqIntPath());
        int readNumber = Math.round((float)genomeLength * 1.0f / (float)readLength * (float)coverage * 1.0f);
        System.out.println("Reads required: " + readNumber);
        List<ReadPosition> readPositions = this.createReadPositions(new GenomeMapper(PropertyReader.getInstance().getMaxBuffSize()), refMutSeq, genomeLength, readLength, readNumber);
        System.out.println("Reads created: " + readPositions.size());
        MutatedGenomeMapper mutatedGenome = new MutatedGenomeMapper(refMutSeqInt, PropertyReader.getInstance().getMaxBuffSize());
        OutputWriter readWriterFirst = new OutputWriter(new File(this.logger.getRefReadsPath()), false);
        OutputWriter readWriterSecond = null;
        if (this.logger.getInsertSizeMax() > 0) {
            readWriterSecond = new OutputWriter(new File(this.logger.getRefReadsMatePath()), false);
        }
        OutputWriter readIntWriter = new OutputWriter(new File(this.logger.getRefReadsIntPath()), false);
        OutputWriter denovoReadIntWriter = new OutputWriter(new File(this.logger.getDenovoReadsIntPath()), false);
        OutputWriter covWriter = new OutputWriter(new File(this.logger.getCoveragePath()), false);
        readWriterFirst.init();
        if (readWriterSecond != null) {
            readWriterSecond.init();
        }
        readIntWriter.init();
        denovoReadIntWriter.init();
        covWriter.init();
        mutatedGenome.init(refMutSeq);
        IntBuffer cov = IntBuffer.allocate(PropertyReader.getInstance().getMaxBuffSize());
        System.out.println("Writing reads...");
        long mappingOffset = 0L;
        mutatedGenome.mapNext(mappingOffset);
        for (ReadPosition readPosition : readPositions) {
            OutputWriter readWriter = readPosition.getMate() == EvaluationList.Mate.first ? readWriterFirst : readWriterSecond;
            long startPosition = readPosition.getOrderingPosition() - (long)readLength;
            if (readPosition.getOrderingPosition() >= mutatedGenome.getBuflen()) {
                this.writeCoverage(covWriter, cov, startPosition, mappingOffset);
                mappingOffset = startPosition;
                mutatedGenome.mapNext(mappingOffset);
            }
            this.writeRead(mutatedGenome, readPosition, readLength, genomeLength, readWriter, readIntWriter, denovoReadIntWriter);
            this.updateCoverage(cov, startPosition, mappingOffset, readLength);
            this.printProgress(readCount++, readPositions.size());
        }
        System.out.println(String.valueOf(this.readMismatches + this.readIndels) + " mutations occured (" + this.readMismatches + " mismatches, " + this.readIndels + " indels).");
        this.writeCoverage(covWriter, cov, genomeLength, mappingOffset);
        readIntWriter.close();
        denovoReadIntWriter.close();
        readWriterFirst.close();
        if (readWriterSecond != null) {
            readWriterSecond.close();
        }
        mutatedGenome.close();
        covWriter.close();
        return readCount;
    }

    private List<ReadPosition> createReadPositions(GenomeMapper genome, File refMutSeq, long genomeLength, int readLength, int readNumber) throws Exception {
        genome.init(refMutSeq);
        ArrayList<ReadPosition> readPositions = new ArrayList<ReadPosition>(readNumber);
        while (readPositions.size() < readNumber) {
            ArrayList<ReadPosition> tempReadPositions = new ArrayList<ReadPosition>((int)Math.ceil((double)(readNumber - readPositions.size()) / 2.0));
            int i = 0;
            while (i < (int)Math.ceil((double)(readNumber - readPositions.size()) / 2.0)) {
                Parser.Direction tempDirection = Parser.Direction.forward;
                long tempPosition = Math.abs(Mutator.rand.nextLong()) % (genomeLength - (long)readLength);
                tempReadPositions.add(new ReadPosition(tempPosition, readLength, tempDirection, EvaluationList.Mate.first));
                ++i;
            }
            ArrayList<ReadPosition> validReadPositions = new ArrayList<ReadPosition>(readNumber - readPositions.size());
            this.removeMultipleNReads(genome, readLength, readNumber, readPositions.size(), validReadPositions, tempReadPositions);
            int i2 = readPositions.size();
            int j = 0;
            while (j < validReadPositions.size()) {
                ((ReadPosition)validReadPositions.get(j)).setId(i2++);
                readPositions.add((ReadPosition)validReadPositions.get(j));
                ++j;
            }
        }
        genome.close();
        Collections.sort(readPositions);
        return readPositions;
    }

    private int removeMultipleNReads(GenomeMapper genome, int readLength, int readNumber, int readCount, List<ReadPosition> readPositions, List<ReadPosition> tempReadPositions) throws IOException, Exception {
        Collections.sort(tempReadPositions);
        genome.mapNext(0L);
        int j = 0;
        while (j < tempReadPositions.size()) {
            long startPosition = tempReadPositions.get(j).getReadPosition();
            long orderPosition = tempReadPositions.get(j).getOrderingPosition();
            Parser.Direction direction = tempReadPositions.get(j).getDirection();
            if (orderPosition >= genome.getBuflen() && !genome.mapNext(orderPosition - (long)readLength)) {
                throw new IOException("Couldn't map to position " + (orderPosition - (long)readLength));
            }
            if (this.checkNCount(genome, readLength, startPosition, direction) < 2) {
                ++readCount;
                readPositions.add(tempReadPositions.get(j));
            }
            this.printProgress(readNumber, readCount, j);
            ++j;
        }
        return readCount;
    }

    private void printProgress(int readNumber, int readCount, int j) {
        if (j % 1000 == 0 && j > 0) {
            System.out.print("Progress: " + Math.round((float)readCount * 100.0f / (float)readNumber) + "%\r");
        }
    }

    private int checkNCount(GenomeMapper genome, int readLength, long startPosition, Parser.Direction direction) throws Exception {
        int nCount = 0;
        int i = 0;
        while (Math.abs(i) < readLength) {
            if (genome.get(startPosition + (long)i) == 'N' && ++nCount == 2) break;
            int n = i = direction == Parser.Direction.forward ? i + 1 : i - 1;
        }
        return nCount;
    }

    private int writeRead(MutatedGenomeMapper genome, ReadPosition readPosition, int readLength, long genomeLength, OutputWriter readWriter, OutputWriter readIntWriter, OutputWriter denovoReadIntWriter) throws Exception {
        Parser.Direction direction = readPosition.getDirection();
        String currentID = String.valueOf(readPosition.getId());
        if (this.logger.getInsertSizeMax() > 0) {
            currentID = String.valueOf(currentID) + "/" + (readPosition.getMate() == EvaluationList.Mate.first ? "1" : "2");
        }
        readWriter.write("@" + currentID);
        readWriter.newLine();
        readIntWriter.write("@" + currentID + (direction == Parser.Direction.forward ? " +" : " -"));
        denovoReadIntWriter.write("@" + currentID + (direction == Parser.Direction.forward ? " +" : " -"));
        readIntWriter.newLine();
        denovoReadIntWriter.newLine();
        this.readSequence.clear();
        this.refReadInt.clear();
        this.denovoReadInt.clear();
        Pair<Integer, Pair<Integer, Integer>> result = this.mutator.mutateRead(genome, readPosition, readLength, genomeLength, this.readSequence, this.refReadInt, this.denovoReadInt);
        readLength = result.getFirst();
        this.readMismatches += result.getSecond().getFirst().intValue();
        this.readIndels += result.getSecond().getSecond().intValue();
        readWriter.writeReadSeq(this.readSequence);
        readIntWriter.writeLongSeq(this.refReadInt, direction);
        denovoReadIntWriter.writeLongSeq(this.denovoReadInt, direction);
        readWriter.newLine();
        readIntWriter.newLine();
        denovoReadIntWriter.newLine();
        readWriter.write('+');
        readWriter.newLine();
        int i = 0;
        while (i < readLength) {
            readWriter.write(':');
            ++i;
        }
        readWriter.newLine();
        currentID = String.valueOf(currentID) + 1;
        return 1;
    }

    public void sortFile(String refReadsPath) throws IOException {
        File refReadsFile = new File(refReadsPath);
        File refReadsFileTemp = new File(String.valueOf(refReadsPath) + "_temp");
        MappedByteBuffer buf = null;
        FileChannel fc = null;
        FileInputStream fin = new FileInputStream(refReadsFile);
        fc = fin.getChannel();
        int fileLength = (int)fc.size();
        buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
        ArrayList<ComparablePair<Integer, Integer>> reads = new ArrayList<ComparablePair<Integer, Integer>>();
        int i = 0;
        while (i < fileLength) {
            if ((char)buf.get(i) == '@') {
                int n = ByteArrayUtils.atoi(buf, i + 1, fileLength);
                reads.add(new ComparablePair<Integer, Integer>(n, i));
            }
            ++i;
        }
        Collections.sort(reads);
        OutputWriter writer = new OutputWriter(refReadsFileTemp, false);
        writer.init();
        for (ComparablePair comparablePair : reads) {
            int i2 = (Integer)comparablePair.getSecond();
            do {
                writer.write((char)buf.get(i2));
            } while (++i2 < fileLength && (char)buf.get(i2) != '@');
            this.printProgress((Integer)comparablePair.getFirst(), reads.size());
        }
        writer.close();
        fc.close();
        refReadsFileTemp.renameTo(refReadsFile);
    }

    public void sortFile_old(String refReadsPath) throws IOException {
        File refReadsFile = new File(refReadsPath);
        File refReadsFileTemp = new File(String.valueOf(refReadsPath) + "_temp");
        FilePositionParser parser = new FilePositionParser();
        parser.parse(new File(refReadsPath), PropertyReader.getInstance().getMaxBuffSize());
        OutputWriter writer = new OutputWriter(refReadsFileTemp, false);
        writer.init();
        MappedByteBuffer buf = null;
        FileChannel fc = null;
        FileInputStream fin = new FileInputStream(refReadsFile);
        fc = fin.getChannel();
        long fileLength = fc.size();
        buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fileLength);
        for (ComparablePair<Integer, Pair<Long, Integer>> read : parser.getReadList()) {
            long i = 0L;
            while (i < (long)((Integer)((Pair)read.getSecond()).getSecond()).intValue()) {
                writer.write((char)buf.get((int)((Long)((Pair)read.getSecond()).getFirst() + i)));
                ++i;
            }
            this.printProgress((Integer)read.getFirst(), parser.getReadList().size());
        }
        writer.close();
        fc.close();
    }

    private void writeCoverage(OutputWriter covWriter, IntBuffer cov, long startPosition, long mappingOffset) throws IOException {
        int i = 0;
        i = 0;
        while ((long)i < startPosition - mappingOffset) {
            if (i < cov.capacity()) {
                covWriter.write(cov.get(i));
                covWriter.newLine();
            } else {
                covWriter.write(0L);
                covWriter.newLine();
            }
            ++i;
        }
        cov.position(Math.min(i, cov.capacity()));
        cov.compact();
        i = cov.position();
        while (i < cov.capacity()) {
            cov.put(i, 0);
            ++i;
        }
    }

    private void updateCoverage(IntBuffer cov, long startPosition, long mappingOffset, int readLength) {
        int i = (int)(startPosition - mappingOffset);
        while ((long)i < startPosition + (long)readLength - mappingOffset) {
            cov.put(i, cov.get(i) + 1);
            ++i;
        }
    }

    private void replaceMutatedRefInsertFlags(File refMutSeqInt, File tempMutSeqInt, long insertFlag, long genomeLength) throws IOException {
        OutputWriter readIntWriter = new OutputWriter(refMutSeqInt, false);
        readIntWriter.init();
        ByteBuffer buf = ByteBuffer.allocate(PropertyReader.getInstance().getMaxBuffSize());
        FileInputStream fin = new FileInputStream(tempMutSeqInt);
        FileChannel refFc = fin.getChannel();
        int buflen = -1;
        long bpos = 0L;
        while ((buflen = refFc.read(buf, bpos)) != -1) {
            int longStart = 0;
            int longEnd = 0;
            int i = 0;
            while (i < buflen) {
                if (buf.get(i) == 44) {
                    long index = ByteArrayUtils.atoi(buf.array(), longStart, buflen);
                    if (index != insertFlag) {
                        readIntWriter.write(index);
                    } else {
                        readIntWriter.write((genomeLength + 10L) * -1L);
                    }
                    longEnd = longStart = longEnd + 1;
                } else {
                    ++longEnd;
                }
                ++i;
            }
            bpos += (long)longStart;
            buf.clear();
        }
        tempMutSeqInt.delete();
        refFc.close();
        readIntWriter.close();
    }

    private void printProgress(int currentID, int count) {
        if (currentID % 1000 == 0 && currentID > 0) {
            System.out.print("Progress: " + Math.round((float)currentID * 100.0f / (float)count) + "%\r");
        }
    }
}

