/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.super_seth;

import at.cibiv.super_seth.data.ReadPosition;
import at.cibiv.super_seth.io.MutatedGenomeMapper;
import at.cibiv.super_seth.io.OutputWriter;
import at.cibiv.super_seth.util.PropertyReader;
import at.cibiv.util.Pair;
import at.cibiv.util.PropertyLogger;
import at.cibiv.util.io.GenomeMapper;
import at.cibiv.util.io.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.Random;

public class Mutator {
    public static final double mismatchRatio = 0.91;
    public static Random rand = new Random();

    public static char complement(char base) {
        switch (base) {
            case 'a': {
                return 't';
            }
            case 'c': {
                return 'g';
            }
            case 'g': {
                return 'c';
            }
            case 't': {
                return 'a';
            }
            case 'A': {
                return 'T';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'T': {
                return 'A';
            }
        }
        return base;
    }

    public char randomNucleotide() {
        int value = rand.nextInt(4);
        switch (value) {
            case 0: {
                return 'A';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'G';
            }
            case 3: {
                return 'T';
            }
        }
        return 'N';
    }

    public char randomTransition(char orig) {
        int value = rand.nextInt(3);
        if (orig == 'A' || orig == 'a') {
            switch (value) {
                case 0: {
                    return 'C';
                }
                case 1: {
                    return 'G';
                }
                case 2: {
                    return 'T';
                }
            }
        } else if (orig == 'C' || orig == 'c') {
            switch (value) {
                case 0: {
                    return 'A';
                }
                case 1: {
                    return 'G';
                }
                case 2: {
                    return 'T';
                }
            }
        } else if (orig == 'G' || orig == 'g') {
            switch (value) {
                case 0: {
                    return 'A';
                }
                case 1: {
                    return 'C';
                }
                case 2: {
                    return 'T';
                }
            }
        } else if (orig == 'T' || orig == 't') {
            switch (value) {
                case 0: {
                    return 'A';
                }
                case 1: {
                    return 'C';
                }
                case 2: {
                    return 'G';
                }
            }
        }
        return 'N';
    }

    private double checkRepeatPowerup(double slidingMutationRate, MutatedGenomeMapper genome, long startPosition, long pos) throws Exception {
        double powerup = slidingMutationRate;
        while (pos > startPosition && genome.get(pos) == genome.get(pos - 1L) && powerup <= 0.05) {
            powerup += 0.01;
            --pos;
        }
        return powerup;
    }

    public long getSeqLength(File refFile) throws IOException {
        long length = 0L;
        int seqNr = 1;
        BufferedReader reader = new BufferedReader(new FileReader(refFile));
        String line = null;
        int curSeq = 0;
        while ((line = reader.readLine()) != null && curSeq <= seqNr) {
            if (line.length() <= 0) continue;
            if (line.charAt(0) == '>') {
                ++curSeq;
                continue;
            }
            if (seqNr != curSeq) continue;
            length += (long)line.length();
        }
        reader.close();
        return length;
    }

    public Pair<Integer, Pair<Integer, Integer>> mutateRead(MutatedGenomeMapper genome, ReadPosition readPositiond, int readLength, long genomeLength, CharBuffer readSequence, LongBuffer refReadInt, LongBuffer denovoReadInt) throws IOException, Exception {
        double slidingMutationRate;
        long startPosition = readPositiond.getReadPosition();
        Parser.Direction direction = readPositiond.getDirection();
        int actualReadLength = 0;
        int mismatchCounter = 0;
        int indelCounter = 0;
        double slidingIndelRate = slidingMutationRate = PropertyLogger.getInstance().getReadError();
        int model = 0;
        int pos = 0;
        int threeQuarters = readLength * 3 / 4;
        if (threeQuarters < 3) {
            threeQuarters = readLength;
        }
        double multiplier = Math.pow(5.0, 1.0f / (float)(readLength - Math.abs(pos)));
        while (Math.abs(pos) < readLength) {
            double p = rand.nextDouble();
            boolean repeat = false;
            if (Math.abs(pos) >= threeQuarters && model == 1) {
                slidingMutationRate *= multiplier;
            }
            if ((slidingIndelRate = model == 2 ? this.checkRepeatPowerup(slidingMutationRate, genome, startPosition, startPosition + (long)pos) : slidingMutationRate) != slidingMutationRate) {
                repeat = true;
            }
            if (p <= slidingIndelRate) {
                p = rand.nextDouble();
                if (p <= 0.91 && !repeat) {
                    ++mismatchCounter;
                    readSequence.put(this.randomTransition(this.getBase(genome.get(startPosition + (long)pos), direction)));
                    refReadInt.put(Math.abs(genome.getLong(startPosition + (long)pos)) * -1L);
                    denovoReadInt.put((startPosition + (long)pos) * -1L);
                    ++actualReadLength;
                } else {
                    ++indelCounter;
                    if (rand.nextBoolean()) {
                        if (repeat) {
                            readSequence.put(this.getBase(genome.get(startPosition + (long)pos - 1L), direction));
                        } else {
                            readSequence.put(this.randomNucleotide());
                        }
                        refReadInt.put((genomeLength + 10L) * -1L);
                        denovoReadInt.put((genomeLength + 10L) * -1L);
                        readSequence.put(this.getBase(genome.get(startPosition + (long)pos), direction));
                        refReadInt.put(genome.getLong(startPosition + (long)pos));
                        denovoReadInt.put(startPosition + (long)pos);
                        actualReadLength += 2;
                    }
                }
            } else {
                readSequence.put(this.getBase(genome.get(startPosition + (long)pos), direction));
                refReadInt.put(genome.getLong(startPosition + (long)pos));
                denovoReadInt.put(startPosition + (long)pos);
                ++actualReadLength;
            }
            int n = pos = readPositiond.getDirection() == Parser.Direction.forward ? pos + 1 : pos - 1;
        }
        return new Pair<Integer, Pair<Integer, Integer>>(actualReadLength, new Pair<Integer, Integer>(mismatchCounter, indelCounter));
    }

    private char getBase(char base, Parser.Direction direction) {
        return direction == Parser.Direction.backward ? Mutator.complement(base) : base;
    }

    /*
     * Unable to fully structure code
     */
    public final Pair<Long, Long> mutateSequenceUniformly(File refSeq, File refMutSeq, File refMutSeqInt, long fileLength, boolean print) throws Exception {
        mismatchCounter = 0;
        indelCounter = 0;
        insertFlag = -1L;
        mutatedGenomeLength = 0L;
        mutatedGenomePosition = 0L;
        mutRateGenome = PropertyLogger.getInstance().getMutationRate();
        genome = new GenomeMapper(PropertyReader.getInstance().getMaxBuffSize());
        mutatedGenome = new OutputWriter(refMutSeq, false);
        mutatedGenomeInt = new OutputWriter(refMutSeqInt, false);
        try {
            insertFlag = (fileLength + 10L) * -1L;
            mutatedGenome.init();
            mutatedGenomeInt.init();
            genome.init(refSeq);
            position = 0L;
            mutatedGenome.write(genome.getHeader());
            mutatedGenome.newLine();
            ** GOTO lbl49
            {
                if (genome.get(position) == '>') {
                    throw new Exception("Multi fasta files not supported as input.");
                }
                if (genome.get(position) != '\n') {
                    p = Mutator.rand.nextDouble();
                    if (p <= mutRateGenome) {
                        p = Mutator.rand.nextDouble();
                        if (p <= 0.91) {
                            ++mismatchCounter;
                            base = genome.get(position);
                            mutatedGenome.write(this.randomTransition(base));
                            mutatedGenomeInt.write(mutatedGenomePosition * -1L);
                            ++mutatedGenomeLength;
                        } else {
                            ++indelCounter;
                            if (Mutator.rand.nextBoolean()) {
                                mutatedGenome.write(this.randomNucleotide());
                                mutatedGenomeInt.write(insertFlag);
                                mutatedGenome.write(genome.get(position));
                                mutatedGenomeInt.write(mutatedGenomePosition);
                                mutatedGenomeLength += 2L;
                            }
                        }
                    } else {
                        mutatedGenome.write(genome.get(position));
                        mutatedGenomeInt.write(mutatedGenomePosition);
                        ++mutatedGenomeLength;
                    }
                    if (position % 100000L == 0L && position > 0L) {
                        System.out.print("Progress: " + Math.round((float)position * 100.0f / (float)fileLength) + "%\r");
                    }
                    ++mutatedGenomePosition;
                }
                ++position;
                do {
                    if (position < genome.getBuflen()) continue block3;
lbl49:
                    // 2 sources

                } while (genome.mapNext(position));
            }
        }
        finally {
            genome.close();
            mutatedGenome.close();
            mutatedGenomeInt.close();
        }
        if (print) {
            System.out.print(String.valueOf(mismatchCounter + indelCounter) + " mutations occurred.");
            System.out.print(" (" + mismatchCounter + " mismatches, " + indelCounter + " indels)");
            System.out.println();
        }
        return new Pair<Long, Long>(insertFlag, mutatedGenomeLength);
    }
}

