/*
 * Decompiled with CFR 0.152.
 */
package at.cibiv.super_seth;

import at.cibiv.super_seth.TestGenerator;
import at.cibiv.super_seth.util.PropertyReader;
import at.cibiv.util.PropertyLogger;
import at.cibiv.util.VersionHelper;
import java.io.File;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;

public class Main {
    public static final String version = "1.0";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        System.out.println("\nNext Generation Sequencing Simulation 1.0 (" + VersionHelper.getVersionfinal(TestGenerator.class) + ")");
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec<Double> mutationRatePar = optionParser.accepts("m", "Mutation rate").withOptionalArg().ofType(Double.class).defaultsTo(0.01, (Double[])new Double[0]);
        ArgumentAcceptingOptionSpec<Double> readErrorPar = optionParser.accepts("r", "Read error").withOptionalArg().ofType(Double.class).defaultsTo(0.02, (Double[])new Double[0]);
        ArgumentAcceptingOptionSpec<File> inputFilePar = optionParser.accepts("i", "Reference Sequence").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> outputFolderPar = optionParser.accepts("o", "Output folder").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<Integer> readLengthPar = optionParser.accepts("l", "Read length").withRequiredArg().ofType(Integer.class).defaultsTo(72, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> coveragePar = optionParser.accepts("c", "Coverage").withRequiredArg().ofType(Integer.class).defaultsTo(15, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<String> outputPrefixPar = optionParser.accepts("n", "Prefix for output files").withOptionalArg().ofType(String.class).defaultsTo("<name of input file>", (String[])new String[0]);
        OptionSpecBuilder help = optionParser.acceptsAll(Arrays.asList("?", "h", "help"), "Show help");
        try {
            OptionSet options = optionParser.parse(args);
            if (!options.has(help) && options.hasArgument(inputFilePar) && options.valueOf(inputFilePar).exists() && (Integer)readLengthPar.value(options) > 0 && (Integer)coveragePar.value(options) > 0 && options.hasArgument(outputFolderPar)) {
                File inputFile = options.valueOf(inputFilePar);
                File outputFolder = options.valueOf(outputFolderPar);
                if (!outputFolder.exists()) {
                    outputFolder.mkdir();
                }
                String outputPrefix = String.valueOf(File.separator) + (options.has(outputPrefixPar) ? options.valueOf(outputPrefixPar) : inputFile.getName()) + "_";
                File refSeq = options.valueOf(inputFilePar);
                File refMutSeq = new File(String.valueOf(outputFolder.getAbsolutePath()) + outputPrefix + "RefMutSeq");
                File refMutSeqInt = new File(String.valueOf(outputFolder.getAbsolutePath()) + outputPrefix + "RefMutSeqInt");
                File refReads = new File(String.valueOf(outputFolder.getAbsolutePath()) + outputPrefix + "RefReads");
                File refReadsInt = new File(String.valueOf(outputFolder.getAbsolutePath()) + outputPrefix + "RefReadsInt");
                File denovoReadsInt = new File(String.valueOf(outputFolder.getAbsolutePath()) + outputPrefix + "DenovoReadsInt");
                File coverageFile = new File(String.valueOf(outputFolder.getAbsolutePath()) + outputPrefix + "Coverage");
                File logFile = new File(String.valueOf(outputFolder.getAbsolutePath()) + outputPrefix + "log");
                if (options.valueOf(mutationRatePar) < 0.0 || options.valueOf(mutationRatePar) > 1.0) {
                    throw new Exception("Mutation rate must be between 0.0 and 1.0.");
                }
                if (options.valueOf(readErrorPar) < 0.0 || options.valueOf(readErrorPar) > 1.0) {
                    throw new Exception("Read error must be between 0.0 and 1.0.");
                }
                double mutRateGenome = options.valueOf(mutationRatePar);
                double mutRateReads = options.valueOf(readErrorPar);
                if (PropertyReader.getInstance().getMaxBuffSize() <= 2 * options.valueOf(readLengthPar)) throw new Exception("Read length must not exceed maxBuffSize. Please change the config file.");
                System.out.println("----------------------");
                System.out.println("Starting up simulation");
                System.out.println("----------------------\n");
                TestGenerator generator = new TestGenerator();
                PropertyLogger logger = PropertyLogger.getInstance();
                logger.init(String.valueOf(outputFolder.getAbsolutePath()) + File.separator);
                logger.logMutationRate(mutRateGenome);
                logger.logReadError(mutRateReads);
                logger.logDenovoReadsIntPath(denovoReadsInt);
                logger.logRefMutSeqIntPath(refMutSeqInt);
                logger.logRefMutSeqPath(refMutSeq);
                logger.logRefReadsIntPath(refReadsInt);
                logger.logRefReadsPath(refReads);
                logger.logCoveragePath(coverageFile);
                PropertyLogger.getInstance().writeLog(logFile);
                generator.generateTest(options.valueOf(readLengthPar), options.valueOf(coveragePar), refSeq);
                System.out.println("Sorting sequences...");
                generator.sortFile(logger.getRefReadsPath());
                System.out.println("\nDone.");
                PropertyLogger.getInstance().writeLog(logFile);
                System.out.println("\n-----------------");
                System.out.println("End of simulation");
                System.out.println("-----------------");
                return;
            } else {
                if (options.valueOf(inputFilePar) == null || options.valueOf(inputFilePar).exists()) {
                    System.err.println("Invalid Arguments!\n");
                } else {
                    System.err.println("File not found! " + options.valueOf(inputFilePar).getPath() + " does not exist!\n");
                }
                optionParser.printHelpOn(System.err);
            }
            return;
        }
        catch (Exception ex) {
            System.err.println("ERROR: " + ex.getMessage());
        }
    }
}

