/***************************************************************************
 *   Copyright (C) 2010 by Minh Anh Thi Nguyen, Tanja Gesell and Arndt von Haeseler   *
 *   minh.anh.nguyen@univie.ac.at, tanja.gesell@univie.ac.at, arndt.von.haeseler@univie.ac.at   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "node.h"

Node::Node()
{
	id = -1;
	seqID = -1;	
}

Node::Node(int aid)
{
	id = aid;
	seqID = -1;	
}

Node::Node(int aid, int aname) {
	id = aid;
	name = "";
	name += aname;
	seqID = -1;	
}

Node::Node(int aid, const char *aname) {
	id = aid;
	name = aname;
	seqID = -1;	
}

bool Node::isLeaf()
{
	return neighbors.size() <= 1;
}

Node::~Node()
{
	NeighborVec::reverse_iterator it;
	for (it = neighbors.rbegin(); it != neighbors.rend(); it++)
		delete (*it);
	neighbors.clear();	
}

int Node::degree()
{
	return neighbors.size();
}

Neighbor *Node::findNeighbor(Node *node) {
	for (NeighborVec::iterator it = neighbors.begin(); it != neighbors.end(); it ++)
		if ((*it)->node == node)
			return (*it);
	cout << "ERROR : Could not find neighbors of node " << node->id << endl;
	assert(0);
	return NULL;
}

NeighborVec::iterator Node::findNeighborIt(Node *node) {
	for (NeighborVec::iterator it = neighbors.begin(); it != neighbors.end(); it ++)
		if ((*it)->node == node)
			return it;
	assert(0);
	return neighbors.end();
}

void Node::replaceNeighbor(Node* node, Node *newnode, double newlen)
{
	for (NeighborVec::iterator it = neighbors.begin(); it != neighbors.end(); it ++)
		if ((*it)->node == node)
		{
			(*it)->node = newnode;
			(*it)->length = newlen;
		}
}


